@extends('core/base::layouts.master')
@section('content')
    <div class="flexbox-grid">
        <div class="flexbox-content">
            <div class="body">
                <div class="box-wrap-emptyTmpl text-center col-12">
                    <h1 class="mt20 mb20 ws-nm font-size-emptyDisplayTmpl">{{ trans('plugins/ecommerce::order.manage_orders') }}</h1>
                    <p class="text-info-displayTmpl">{{ trans('plugins/ecommerce::order.incomplete_orders_intro_description') }}</p>
                    <div class="empty-displayTmpl-pdtop">
                        <div class="empty-displayTmpl-image">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" viewBox="0 0 468 270" enable-background="new 0 0 468 270" xml:space="preserve"><g><g><path fill="#D3DCE6" d="M223.559,106.077c-0.149,0-0.3-0.033-0.442-0.105l-4.082-2.041c-0.968-0.484-1.498-1.527-1.319-2.595    c0.178-1.068,1.018-1.881,2.091-2.023c0.189-0.025,0.341-0.161,0.388-0.347c0.047-0.185-0.023-0.377-0.178-0.489l-1.5-1.086    c-0.976-0.707-1.382-1.952-1.012-3.099c0.37-1.147,1.428-1.917,2.632-1.917c0.305,0,0.585-0.179,0.712-0.457    c0.128-0.278,0.082-0.607-0.117-0.839l-1.184-1.383c-0.694-0.811-0.827-1.948-0.34-2.897c0.486-0.949,1.485-1.508,2.549-1.41    c0.202,0.014,0.407-0.066,0.538-0.225c0.132-0.159,0.178-0.372,0.122-0.571l-0.551-1.985c-0.257-0.925,0.057-1.916,0.799-2.523    c0.742-0.608,1.773-0.72,2.628-0.284c0.137,0.069,0.296,0.062,0.426-0.016c0.129-0.079,0.209-0.222,0.209-0.373v-1.403    c0-1.04,0.664-1.953,1.652-2.271c0.989-0.32,2.06,0.034,2.666,0.879c0.09,0.125,0.244,0.187,0.397,0.16    c0.152-0.028,0.275-0.142,0.316-0.291l0.338-1.261c0.292-1.09,1.2-1.903,2.315-2.071c1.119-0.168,2.223,0.34,2.823,1.294    c0.175,0.278,0.491,0.428,0.81,0.394c0.319-0.033,0.599-0.25,0.711-0.551c0.386-1.036,1.307-1.752,2.404-1.87    c1.099-0.12,2.148,0.387,2.744,1.316c0.232,0.364,0.645,0.57,1.077,0.564c0.433-0.017,0.828-0.264,1.031-0.646l1.067-1.991    c0.508-0.953,1.53-1.512,2.611-1.431c1.076,0.083,2.004,0.796,2.361,1.817c0.102,0.288,0.365,0.484,0.67,0.497    c0.304,0.019,0.584-0.159,0.709-0.439l0.585-1.305c0.381-0.852,1.194-1.452,2.118-1.566c0.923-0.114,1.86,0.271,2.435,1.005    c0.171,0.217,0.453,0.311,0.723,0.244c0.268-0.069,0.47-0.291,0.515-0.564l0.097-0.585c0.12-0.731,0.621-1.353,1.309-1.624    c0.69-0.27,1.478-0.158,2.064,0.293c0.047,0.036,0.114,0.037,0.162-0.004c0.046-0.04,0.058-0.108,0.028-0.162l-1.154-2.077    c-0.371-0.666-0.348-1.482,0.058-2.128c0.406-0.646,1.135-1.023,1.89-0.971c0.046,0,0.087-0.025,0.103-0.068    c0.015-0.044-0.001-0.093-0.038-0.119l-0.261-0.182c-0.928-0.65-1.389-1.788-1.177-2.9c0.213-1.112,1.061-1.999,2.161-2.259    c0.282-0.066,0.498-0.292,0.552-0.575c0.054-0.284-0.063-0.574-0.298-0.739c-0.858-0.602-1.296-1.658-1.117-2.692    c0.179-1.033,0.948-1.88,1.957-2.157l0.251-0.069c0.105-0.028,0.18-0.114,0.196-0.218c0.016-0.106-0.032-0.21-0.122-0.267    c-0.809-0.51-1.209-1.48-0.995-2.412c0.214-0.933,0.996-1.63,1.947-1.735l1.573-0.174c-0.212-0.905,0.139-1.838,0.888-2.318    c0.748-0.48,1.741-0.409,2.414,0.174c0.106,0.092,0.255,0.12,0.391,0.075c0.135-0.047,0.235-0.162,0.262-0.302l0.471-2.41    c0.165-0.838,0.807-1.504,1.638-1.696c0.832-0.192,1.701,0.124,2.215,0.806c0.037,0.048,0.109,0.068,0.154,0.071    c0.062-0.004,0.116-0.037,0.147-0.089c0.515-0.882,1.511-1.404,2.519-1.326c1.015,0.075,1.917,0.734,2.297,1.68l1.184,2.948    c0.204,0.508-0.042,1.087-0.55,1.291c-0.507,0.205-1.084-0.042-1.289-0.551l-1.184-2.948c-0.102-0.252-0.333-0.421-0.603-0.442    c-0.266-0.016-0.528,0.117-0.662,0.348c-0.366,0.627-1.017,1.027-1.742,1.069c-0.722,0.036-1.415-0.278-1.853-0.857    c-0.044-0.057-0.118-0.085-0.187-0.067c-0.07,0.016-0.124,0.072-0.137,0.143l-0.471,2.411c-0.164,0.833-0.762,1.521-1.562,1.797    c-0.801,0.276-1.694,0.103-2.334-0.45c0.101,0.616,0.005,1.232-0.328,1.73c-0.333,0.497-0.865,0.82-1.46,0.885l-1.573,0.174    c-0.113,0.012-0.206,0.095-0.231,0.206c-0.025,0.111,0.022,0.226,0.118,0.287c0.756,0.475,1.16,1.354,1.028,2.238    c-0.13,0.883-0.771,1.606-1.632,1.842l-0.25,0.069c-0.274,0.075-0.481,0.303-0.53,0.582c-0.048,0.279,0.07,0.564,0.301,0.726    c0.874,0.613,1.309,1.688,1.108,2.738c-0.201,1.05-1.003,1.888-2.043,2.134c-0.342,0.081-0.604,0.356-0.67,0.701    c-0.066,0.345,0.076,0.698,0.364,0.899l0.261,0.183c0.763,0.535,1.08,1.52,0.775,2.397c-0.305,0.88-1.169,1.471-2.095,1.398    c-0.045-0.006-0.073,0.016-0.093,0.048c-0.019,0.032-0.02,0.071-0.003,0.103l1.156,2.079c0.483,0.874,0.287,1.979-0.469,2.63    c-0.756,0.652-1.878,0.682-2.666,0.072c-0.036-0.028-0.084-0.034-0.126-0.018c-0.043,0.016-0.073,0.054-0.08,0.099l-0.096,0.584    c-0.171,1.05-0.948,1.9-1.978,2.165c-1.027,0.265-2.117-0.103-2.775-0.94c-0.15-0.191-0.396-0.289-0.634-0.261    c-0.241,0.03-0.452,0.186-0.552,0.408l-0.585,1.304c-0.459,1.026-1.491,1.656-2.6,1.609c-1.121-0.047-2.085-0.763-2.457-1.822    c-0.098-0.279-0.35-0.473-0.644-0.495c-0.291-0.02-0.571,0.129-0.711,0.389l-1.067,1.991c-0.534,0.999-1.569,1.647-2.701,1.691    c-1.165,0.051-2.213-0.521-2.824-1.476c-0.188-0.292-0.513-0.446-0.864-0.414c-0.346,0.037-0.635,0.263-0.756,0.589    c-0.372,1.003-1.301,1.723-2.366,1.833c-1.081,0.111-2.112-0.391-2.691-1.311c-0.18-0.287-0.512-0.44-0.849-0.389    c-0.335,0.051-0.608,0.295-0.696,0.623l-0.338,1.262c-0.238,0.886-0.973,1.565-1.874,1.729c-0.903,0.163-1.829-0.209-2.363-0.956    c-0.101-0.142-0.283-0.202-0.448-0.147c-0.166,0.054-0.278,0.207-0.278,0.382v1.403c0,0.836-0.442,1.627-1.154,2.065    c-0.712,0.438-1.618,0.473-2.362,0.094c-0.154-0.079-0.34-0.058-0.474,0.051c-0.134,0.11-0.19,0.288-0.144,0.456l0.551,1.985    c0.229,0.826,0.04,1.713-0.508,2.372c-0.546,0.658-1.381,1.009-2.235,0.933c-0.258-0.02-0.497,0.111-0.614,0.34    c-0.118,0.229-0.085,0.503,0.082,0.699l1.184,1.382c0.701,0.819,0.863,1.981,0.413,2.961c-0.449,0.979-1.436,1.612-2.513,1.612    c-0.341,0-0.641,0.218-0.746,0.543c-0.106,0.326,0.01,0.678,0.287,0.879l1.5,1.086c0.817,0.591,1.186,1.605,0.939,2.584    c-0.246,0.978-1.051,1.696-2.05,1.829c-0.204,0.027-0.363,0.181-0.396,0.383c-0.034,0.203,0.067,0.4,0.25,0.492l4.082,2.041    c0.49,0.245,0.689,0.841,0.444,1.331C224.274,105.876,223.923,106.077,223.559,106.077z"></path></g><g><path fill="#D3DCE6" d="M241.623,101.669c-0.274,0-0.496-0.222-0.496-0.496c0-0.735-0.597-1.332-1.331-1.332    s-1.33,0.598-1.33,1.332c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496c0-0.735-0.596-1.332-1.33-1.332    c-0.734,0-1.331,0.598-1.331,1.332c0,0.274-0.221,0.496-0.495,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-0.735-0.597-1.332-1.331-1.332s-1.331,0.598-1.331,1.332c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496    c0-1.282,1.042-2.325,2.322-2.325c0.741,0,1.401,0.348,1.826,0.891c0.425-0.542,1.086-0.891,1.826-0.891    c0.741,0,1.401,0.348,1.826,0.89c0.425-0.542,1.085-0.89,1.826-0.89c1.281,0,2.322,1.043,2.322,2.325    C242.118,101.447,241.897,101.669,241.623,101.669z"></path></g><g><path fill="#D3DCE6" d="M245.275,107.907c-0.274,0-0.496-0.222-0.496-0.496c0-0.734-0.597-1.332-1.331-1.332    c-0.734,0-1.33,0.598-1.33,1.332c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-0.734-0.597-1.332-1.331-1.332s-1.33,0.598-1.33,1.332c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-1.282,1.042-2.324,2.321-2.324c0.741,0,1.401,0.348,1.827,0.89c0.425-0.542,1.085-0.89,1.826-0.89    c1.281,0,2.322,1.042,2.322,2.324C245.771,107.685,245.549,107.907,245.275,107.907z"></path></g><g><path fill="#D3DCE6" d="M276.862,54.238c-0.274,0-0.496-0.222-0.496-0.496c0-0.735-0.597-1.332-1.331-1.332    s-1.33,0.598-1.33,1.332c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-0.735-0.597-1.332-1.331-1.332    s-1.33,0.598-1.33,1.332c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-1.282,1.042-2.325,2.321-2.325    c0.741,0,1.401,0.348,1.827,0.891c0.425-0.542,1.085-0.891,1.826-0.891c1.281,0,2.322,1.043,2.322,2.325    C277.358,54.016,277.136,54.238,276.862,54.238z"></path></g><g><path fill="#D3DCE6" d="M429.216,239.951c-0.321,0-0.636-0.156-0.827-0.444c-0.303-0.457-0.178-1.073,0.278-1.375l2.782-1.847    c0.167-0.111,0.248-0.309,0.207-0.505c-0.041-0.195-0.194-0.345-0.391-0.38c-0.955-0.171-1.694-0.932-1.837-1.895    c-0.141-0.963,0.345-1.907,1.211-2.349c0.049-0.025,0.076-0.079,0.067-0.134c-0.01-0.056-0.054-0.098-0.109-0.105    c-0.922-0.107-1.677-0.823-1.834-1.74c-0.157-0.919,0.318-1.845,1.152-2.254l0.479-0.235c0.111-0.054,0.175-0.174,0.158-0.297    c-0.018-0.124-0.112-0.221-0.235-0.241c-1.068-0.183-1.918-0.983-2.166-2.038c-0.247-1.057,0.158-2.153,1.032-2.792l0.833-0.61    c0.192-0.141,0.28-0.382,0.224-0.615c-0.056-0.232-0.245-0.405-0.481-0.442c-1.074-0.166-1.93-0.995-2.132-2.066    c-0.201-1.07,0.295-2.156,1.235-2.702l0.712-0.415c0.134-0.078,0.204-0.23,0.176-0.381c-0.028-0.15-0.148-0.268-0.299-0.294    c-1.007-0.165-1.785-0.954-1.938-1.964c-0.155-1.008,0.353-1.994,1.266-2.452c0.307-0.155,0.49-0.477,0.467-0.82    c-0.024-0.344-0.251-0.637-0.577-0.746c-1.151-0.39-1.958-1.424-2.058-2.634s0.528-2.363,1.599-2.935l0.463-0.246    c0.271-0.145,0.427-0.448,0.388-0.753c-0.039-0.305-0.265-0.558-0.563-0.63c-1.061-0.257-1.865-1.118-2.049-2.193    c-0.184-1.075,0.287-2.155,1.199-2.751c0.384-0.25,0.572-0.718,0.469-1.164c-0.105-0.448-0.479-0.785-0.934-0.839l-0.94-0.113    c-0.737-0.089-1.368-0.572-1.647-1.261c-0.278-0.693-0.158-1.479,0.312-2.056l0.778-0.955c0.299-0.365,0.344-0.868,0.115-1.28    c-0.228-0.415-0.677-0.643-1.145-0.584c-1.136,0.142-2.272-0.351-2.942-1.294c-0.669-0.943-0.766-2.171-0.253-3.206l0.217-0.438    c0.171-0.347,0.11-0.773-0.154-1.059c-0.262-0.284-0.683-0.378-1.042-0.234c-1.023,0.408-2.175,0.215-3.009-0.51    c-0.832-0.726-1.184-1.843-0.918-2.916c0.12-0.483-0.055-0.924-0.419-1.157c-0.366-0.233-0.838-0.207-1.176,0.061    c-0.832,0.664-1.964,0.838-2.954,0.452c-0.989-0.385-1.708-1.278-1.872-2.33c-0.116-0.745-0.656-1.368-1.377-1.587    c-0.72-0.217-1.517-0.003-2.026,0.553l-1.992,2.169c-0.371,0.405-0.997,0.43-1.401,0.059c-0.403-0.371-0.43-0.999-0.059-1.403    l1.992-2.169c1.022-1.113,2.614-1.549,4.061-1.11c1.444,0.438,2.528,1.687,2.761,3.18c0.055,0.355,0.297,0.656,0.632,0.787    c0.336,0.129,0.718,0.072,0.997-0.152c1.001-0.801,2.401-0.876,3.483-0.183c1.08,0.694,1.599,1.998,1.29,3.245    c-0.102,0.409,0.012,0.769,0.279,1.002c0.269,0.233,0.64,0.296,0.97,0.165c1.119-0.451,2.418-0.155,3.236,0.73    c0.817,0.886,1.007,2.207,0.473,3.288l-0.218,0.439c-0.187,0.378-0.152,0.828,0.094,1.174c0.246,0.346,0.661,0.525,1.078,0.474    c1.281-0.159,2.504,0.463,3.127,1.593c0.624,1.126,0.5,2.501-0.316,3.498l-0.777,0.955l0.977,0.203    c1.28,0.154,2.336,1.103,2.627,2.36c0.293,1.256-0.236,2.573-1.316,3.278c-0.25,0.163-0.379,0.458-0.328,0.752    c0.05,0.294,0.27,0.528,0.56,0.599c1.094,0.263,1.924,1.191,2.067,2.31c0.142,1.117-0.43,2.224-1.421,2.754l-0.464,0.247    c-0.373,0.2-0.591,0.599-0.557,1.02c0.035,0.423,0.316,0.781,0.715,0.917c1.086,0.365,1.84,1.342,1.921,2.488    c0.081,1.145-0.529,2.218-1.554,2.733c-0.141,0.071-0.221,0.223-0.197,0.379c0.024,0.157,0.144,0.279,0.3,0.304    c0.974,0.161,1.748,0.922,1.927,1.894c0.179,0.973-0.275,1.96-1.131,2.456l-0.712,0.415c-0.216,0.125-0.329,0.373-0.284,0.617    c0.046,0.244,0.242,0.434,0.487,0.472c1.032,0.16,1.858,0.919,2.104,1.935c0.247,1.015-0.138,2.069-0.98,2.686l-0.834,0.611    c-0.229,0.168-0.336,0.457-0.271,0.735c0.065,0.277,0.289,0.488,0.57,0.536c0.972,0.165,1.721,0.934,1.862,1.913    c0.141,0.979-0.359,1.929-1.247,2.364l-0.48,0.236c-0.05,0.024-0.078,0.079-0.07,0.135c0.01,0.054,0.055,0.097,0.11,0.104    c0.93,0.109,1.666,0.803,1.832,1.725s-0.285,1.829-1.12,2.255c-0.106,0.053-0.166,0.17-0.148,0.288    c0.017,0.116,0.108,0.21,0.226,0.232c0.998,0.179,1.776,0.936,1.983,1.93c0.206,0.995-0.207,2.001-1.053,2.563l-2.782,1.847    C429.595,239.898,429.404,239.951,429.216,239.951z"></path></g><g><path fill="#D3DCE6" d="M201.033,92.116h-10.77c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h10.77    c0.274,0,0.496,0.222,0.496,0.496C201.528,91.894,201.307,92.116,201.033,92.116z"></path></g><g><path fill="#D3DCE6" d="M203.81,92.116h-0.982c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h0.982    c0.274,0,0.496,0.222,0.496,0.496C204.306,91.894,204.084,92.116,203.81,92.116z"></path></g><g><path fill="#D3DCE6" d="M194.989,92.116c-0.274,0-0.496-0.222-0.496-0.496V81.506c0-0.274,0.222-0.496,0.496-0.496    c0.274,0,0.496,0.222,0.496,0.496V91.62C195.485,91.894,195.263,92.116,194.989,92.116z"></path></g><g><path fill="#D3DCE6" d="M194.989,72.045c-0.274,0-0.496-0.222-0.496-0.496V61.436c0-0.274,0.222-0.496,0.496-0.496    c0.274,0,0.496,0.222,0.496,0.496v10.113C195.485,71.823,195.263,72.045,194.989,72.045z"></path></g><g><path fill="#D3DCE6" d="M204.879,82.003c-0.274,0-0.496-0.222-0.496-0.496v-9.957c0-0.274,0.222-0.496,0.496-0.496    c0.274,0,0.496,0.222,0.496,0.496v9.957C205.375,81.781,205.153,82.003,204.879,82.003z"></path></g><g><path fill="#D3DCE6" d="M208.085,82.003h-24.269c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h24.269    c0.274,0,0.496,0.222,0.496,0.496C208.58,81.781,208.359,82.003,208.085,82.003z"></path></g><g><path fill="#D3DCE6" d="M211.633,82.003h-1.241c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h1.241    c0.274,0,0.496,0.222,0.496,0.496C212.129,81.781,211.907,82.003,211.633,82.003z"></path></g><g><path fill="#D3DCE6" d="M198.341,61.932h-10.643c-0.274,0-0.496-0.222-0.496-0.496s0.222-0.496,0.496-0.496h10.643    c0.274,0,0.496,0.222,0.496,0.496S198.615,61.932,198.341,61.932z"></path></g><g><path fill="#D3DCE6" d="M196.93,72.01h-11.76c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h11.76    c0.274,0,0.496,0.222,0.496,0.496C197.425,71.788,197.204,72.01,196.93,72.01z"></path></g><g><path fill="#D3DCE6" d="M200.135,72.01h-1.154c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h1.154    c0.274,0,0.496,0.222,0.496,0.496C200.63,71.788,200.409,72.01,200.135,72.01z"></path></g><g><path fill="#D3DCE6" d="M207.7,72.01h-5.77c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h5.77    c0.274,0,0.496,0.222,0.496,0.496C208.195,71.788,207.974,72.01,207.7,72.01z"></path></g><g><path fill="#D3DCE6" d="M419.808,117.992h-10.77c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h10.77    c0.274,0,0.496,0.222,0.496,0.496C420.304,117.77,420.082,117.992,419.808,117.992z"></path></g><g><path fill="#D3DCE6" d="M422.586,117.992h-0.983c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h0.983    c0.274,0,0.496,0.222,0.496,0.496C423.082,117.77,422.86,117.992,422.586,117.992z"></path></g><g><path fill="#D3DCE6" d="M413.765,128.105c-0.274,0-0.496-0.222-0.496-0.496v-10.113c0-0.274,0.222-0.496,0.496-0.496    s0.496,0.222,0.496,0.496v10.113C414.26,127.883,414.039,128.105,413.765,128.105z"></path></g><g><path fill="#D3DCE6" d="M423.654,138.062c-0.274,0-0.496-0.222-0.496-0.496v-9.957c0-0.274,0.222-0.496,0.496-0.496    s0.496,0.222,0.496,0.496v9.957C424.15,137.84,423.928,138.062,423.654,138.062z"></path></g><g><path fill="#D3DCE6" d="M426.86,128.105h-24.269c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h24.269    c0.274,0,0.496,0.222,0.496,0.496C427.356,127.883,427.134,128.105,426.86,128.105z"></path></g><g><path fill="#D3DCE6" d="M430.409,128.105h-1.241c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h1.241    c0.274,0,0.496,0.222,0.496,0.496C430.905,127.883,430.683,128.105,430.409,128.105z"></path></g><g><path fill="#D3DCE6" d="M418.911,138.098h-1.154c-0.274,0-0.496-0.222-0.496-0.496s0.222-0.496,0.496-0.496h1.154    c0.274,0,0.496,0.222,0.496,0.496S419.185,138.098,418.911,138.098z"></path></g><g><path fill="#D3DCE6" d="M426.475,138.098h-5.769c-0.274,0-0.496-0.222-0.496-0.496s0.222-0.496,0.496-0.496h5.769    c0.274,0,0.496,0.222,0.496,0.496S426.749,138.098,426.475,138.098z"></path></g><g><path fill="#D3DCE6" d="M442.032,240.157H40.293c-0.547,0-0.991-0.444-0.991-0.993c0-0.549,0.444-0.993,0.991-0.993h401.739    c0.548,0,0.991,0.444,0.991,0.993C443.023,239.713,442.58,240.157,442.032,240.157z"></path></g><g opacity="0.2"><path fill="#D3DCE6" d="M64.435,76.17c0-32.834,26.678-59.546,59.47-59.546s59.47,26.712,59.47,59.546H64.435z"></path></g><g opacity="0.2"><rect x="64.435" y="79.531" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="105.42" y="79.531" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="146.67" y="79.531" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="64.435" y="119.497" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="105.42" y="119.497" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="146.67" y="119.497" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="64.435" y="159.212" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="105.42" y="159.212" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="146.67" y="159.212" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g><g><path fill="#D3DCE6" d="M69.494,98.751l-0.706-0.697l4.928-4.998c0.193-0.195,0.507-0.197,0.701-0.005     c0.195,0.193,0.197,0.507,0.005,0.702L69.494,98.751z"></path></g><g><path fill="#D3DCE6" d="M76.871,91.059c-0.126,0-0.252-0.047-0.348-0.143c-0.195-0.192-0.197-0.507-0.005-0.702l1.812-1.838     c0.193-0.194,0.506-0.197,0.701-0.004c0.195,0.193,0.197,0.507,0.004,0.702l-1.812,1.837     C77.127,91.01,76.999,91.059,76.871,91.059z"></path></g><g><path fill="#D3DCE6" d="M84.655,89.206c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.194-0.194-0.508,0-0.702l3.205-3.209     c0.194-0.194,0.507-0.194,0.701,0s0.194,0.508,0,0.702l-3.205,3.209C84.909,89.158,84.782,89.206,84.655,89.206z"></path></g><g><path fill="#D3DCE6" d="M75.391,98.482c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.194-0.194-0.508,0-0.702l6.583-6.591     c0.194-0.194,0.507-0.194,0.701,0s0.194,0.508,0,0.702l-6.583,6.591C75.645,98.434,75.518,98.482,75.391,98.482z"></path></g><g><path fill="#D3DCE6" d="M68.372,105.511c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.194-0.194-0.508,0-0.702l4.296-4.301     c0.194-0.194,0.507-0.194,0.701,0c0.194,0.194,0.194,0.508,0,0.702l-4.296,4.301C68.625,105.462,68.499,105.511,68.372,105.511z"></path></g><g><path fill="#D3DCE6" d="M69.141,65.697c-0.127,0-0.255-0.049-0.352-0.147c-0.193-0.194-0.192-0.509,0.003-0.702l4.808-4.777     c0.193-0.193,0.508-0.192,0.701,0.003c0.193,0.194,0.192,0.509-0.003,0.702l-4.808,4.777     C69.394,65.65,69.268,65.697,69.141,65.697z"></path></g><g><path fill="#D3DCE6" d="M76.438,58.449c-0.127,0-0.255-0.049-0.352-0.147c-0.193-0.194-0.192-0.509,0.003-0.702l1.115-1.108     c0.193-0.193,0.507-0.193,0.701,0.003c0.193,0.194,0.192,0.509-0.003,0.702l-1.115,1.108     C76.691,58.401,76.565,58.449,76.438,58.449z"></path></g><g><path fill="#D3DCE6" d="M80.301,54.612c-0.127,0-0.255-0.049-0.352-0.147c-0.193-0.194-0.192-0.509,0.003-0.702l5.79-5.752     c0.194-0.193,0.508-0.192,0.701,0.003c0.193,0.194,0.192,0.509-0.003,0.702l-5.79,5.752     C80.553,54.564,80.427,54.612,80.301,54.612z"></path></g><g><path fill="#D3DCE6" d="M68.372,72.309c-0.128,0-0.256-0.049-0.353-0.148c-0.192-0.195-0.19-0.509,0.005-0.702l1.217-1.203     c0.195-0.193,0.509-0.19,0.701,0.004c0.193,0.195,0.191,0.509-0.004,0.702l-1.218,1.204     C68.623,72.261,68.498,72.309,68.372,72.309z"></path></g><g><path fill="#D3DCE6" d="M148.187,67.449c-0.126,0-0.252-0.048-0.348-0.143c-0.195-0.193-0.197-0.507-0.004-0.702l4.206-4.263     c0.192-0.194,0.506-0.197,0.701-0.004c0.195,0.192,0.197,0.506,0.004,0.702l-4.205,4.263     C148.443,67.4,148.315,67.449,148.187,67.449z"></path></g><g><path fill="#D3DCE6" d="M154.433,61.118c-0.126,0-0.252-0.047-0.348-0.143c-0.195-0.193-0.197-0.507-0.004-0.702l0.828-0.838     c0.192-0.194,0.506-0.197,0.701-0.004c0.195,0.192,0.197,0.506,0.004,0.702l-0.827,0.838     C154.689,61.069,154.561,61.118,154.433,61.118z"></path></g><g><path fill="#D3DCE6" d="M157.46,58.053c-0.126,0-0.252-0.048-0.348-0.143c-0.195-0.193-0.197-0.507-0.004-0.702l5.614-5.677     c0.193-0.195,0.507-0.195,0.701-0.003c0.195,0.193,0.196,0.507,0.003,0.702l-5.613,5.676     C157.715,58.004,157.587,58.053,157.46,58.053z"></path></g><g><path fill="#D3DCE6" d="M149.41,71.946c-0.125,0-0.251-0.048-0.348-0.142c-0.195-0.192-0.197-0.506-0.006-0.702l0.731-0.744     c0.192-0.195,0.505-0.199,0.701-0.006c0.195,0.192,0.198,0.506,0.006,0.702l-0.731,0.744     C149.666,71.896,149.538,71.946,149.41,71.946z"></path></g><g><path fill="#D3DCE6" d="M152.21,69.098c-0.126,0-0.251-0.047-0.348-0.142c-0.195-0.192-0.197-0.507-0.005-0.702l4.961-5.044     c0.192-0.196,0.505-0.197,0.701-0.005c0.195,0.192,0.197,0.507,0.005,0.702l-4.961,5.044     C152.466,69.049,152.338,69.098,152.21,69.098z"></path></g><g><path fill="#D3DCE6" d="M159.588,61.597c-0.126,0-0.251-0.047-0.348-0.143c-0.195-0.192-0.197-0.506-0.005-0.702l4.36-4.43     c0.192-0.195,0.506-0.197,0.701-0.005c0.195,0.192,0.197,0.506,0.005,0.702l-4.36,4.43     C159.844,61.548,159.716,61.597,159.588,61.597z"></path></g><g><path fill="#D3DCE6" d="M166.398,54.68c-0.126,0-0.252-0.047-0.348-0.143c-0.195-0.192-0.197-0.506-0.004-0.702     c0.748-0.758,1.234-1.249,1.347-1.36c0.195-0.192,0.51-0.19,0.701,0.006c0.192,0.196,0.189,0.51-0.006,0.702     c-0.112,0.11-0.594,0.599-1.336,1.351C166.654,54.63,166.526,54.68,166.398,54.68z"></path></g><g><path fill="#D3DCE6" d="M129.723,38.995c-0.127,0-0.255-0.049-0.351-0.146c-0.193-0.194-0.192-0.508,0.002-0.702l3.624-3.609     c0.194-0.194,0.507-0.192,0.701,0.002c0.193,0.194,0.192,0.508-0.002,0.702l-3.624,3.609     C129.976,38.947,129.85,38.995,129.723,38.995z"></path></g><g><path fill="#D3DCE6" d="M135.661,33.081c-0.127,0-0.255-0.049-0.351-0.146c-0.193-0.194-0.192-0.508,0.002-0.702l0.997-0.993     c0.193-0.193,0.508-0.192,0.701,0.003c0.193,0.194,0.192,0.508-0.003,0.702l-0.996,0.992     C135.914,33.033,135.788,33.081,135.661,33.081z"></path></g><g><path fill="#D3DCE6" d="M138.973,29.784c-0.127,0-0.255-0.049-0.351-0.146c-0.193-0.194-0.192-0.508,0.002-0.702l4.341-4.319     c0.193-0.193,0.508-0.193,0.701,0.003c0.193,0.194,0.192,0.508-0.003,0.702l-4.34,4.318     C139.226,29.736,139.1,29.784,138.973,29.784z"></path></g><g><path fill="#D3DCE6" d="M131.434,43.097c-0.126,0-0.252-0.048-0.349-0.143c-0.194-0.193-0.196-0.507-0.003-0.702l0.797-0.805     c0.192-0.194,0.506-0.197,0.701-0.004c0.195,0.192,0.197,0.506,0.004,0.702l-0.797,0.806     C131.689,43.048,131.562,43.097,131.434,43.097z"></path></g><g><path fill="#D3DCE6" d="M134.654,39.841c-0.126,0-0.252-0.048-0.348-0.143c-0.195-0.193-0.197-0.507-0.004-0.702l4.211-4.259     c0.193-0.194,0.506-0.196,0.701-0.003c0.194,0.193,0.196,0.507,0.003,0.702l-4.211,4.258     C134.909,39.792,134.782,39.841,134.654,39.841z"></path></g><g><path fill="#D3DCE6" d="M140.938,33.486c-0.126,0-0.252-0.048-0.349-0.144c-0.194-0.193-0.196-0.507-0.003-0.702l0.765-0.773     c0.193-0.194,0.506-0.196,0.701-0.003c0.194,0.193,0.196,0.507,0.003,0.702l-0.766,0.773     C141.193,33.437,141.066,33.486,140.938,33.486z"></path></g><g><path fill="#D3DCE6" d="M143.681,30.714c-0.126,0-0.252-0.048-0.349-0.144c-0.194-0.193-0.196-0.507-0.003-0.702     c2.248-2.272,3.905-3.944,4.123-4.161c0.195-0.192,0.509-0.191,0.701,0.004c0.193,0.195,0.191,0.509-0.004,0.702     c-0.219,0.217-1.873,1.886-4.117,4.154C143.936,30.665,143.809,30.714,143.681,30.714z"></path></g><g><path fill="#D3DCE6" d="M72.171,68.551c-0.128,0-0.256-0.049-0.352-0.147c-0.193-0.195-0.191-0.509,0.004-0.702l8.342-8.251     c0.195-0.194,0.509-0.19,0.701,0.004c0.193,0.195,0.191,0.509-0.004,0.702l-8.342,8.252     C72.422,68.504,72.297,68.551,72.171,68.551z"></path></g><g><path fill="#D3DCE6" d="M82.748,58.088c-0.128,0-0.256-0.049-0.353-0.147c-0.192-0.195-0.19-0.509,0.004-0.702l1.94-1.919     c0.195-0.192,0.508-0.189,0.701,0.004c0.192,0.195,0.19,0.509-0.004,0.702l-1.94,1.919C83,58.041,82.874,58.088,82.748,58.088z"></path></g><g><path fill="#D3DCE6" d="M69.498,139.45l-0.712-0.69c0,0,5.966-6.176,10.413-10.761c0.191-0.197,0.504-0.202,0.701-0.011     c0.197,0.191,0.201,0.505,0.011,0.702C75.462,133.276,69.498,139.45,69.498,139.45z"></path></g><g><path fill="#D3DCE6" d="M82.167,126.149c-0.125,0-0.249-0.047-0.346-0.141c-0.196-0.191-0.2-0.505-0.009-0.702     c0.75-0.771,1.35-1.385,1.721-1.761c0.192-0.195,0.506-0.198,0.701-0.005c0.195,0.192,0.197,0.506,0.005,0.702     c-0.37,0.376-0.968,0.988-1.717,1.757C82.425,126.1,82.296,126.149,82.167,126.149z"></path></g><g><path fill="#D3DCE6" d="M68.372,146.213c-0.127,0-0.255-0.048-0.351-0.146c-0.193-0.194-0.192-0.509,0.002-0.702l0.762-0.761     c0.194-0.192,0.508-0.193,0.701,0.002c0.193,0.194,0.193,0.508-0.001,0.702l-0.763,0.761     C68.624,146.164,68.498,146.213,68.372,146.213z"></path></g><g><path fill="#D3DCE6" d="M71.532,143.059c-0.127,0-0.254-0.048-0.351-0.145c-0.193-0.195-0.193-0.509,0.001-0.703l4.624-4.615     c0.194-0.193,0.507-0.193,0.701,0.002c0.193,0.194,0.193,0.508-0.001,0.702l-4.624,4.615     C71.785,143.01,71.659,143.059,71.532,143.059z"></path></g><g><path fill="#D3DCE6" d="M79.157,135.438c-0.126,0-0.252-0.046-0.346-0.141c-0.193-0.194-0.204-0.497-0.01-0.691l1.285-1.283     c0.194-0.193,0.507-0.194,0.701,0.001c0.193,0.194,0.193,0.508-0.001,0.702l-1.263,1.261     C79.424,135.386,79.29,135.438,79.157,135.438z"></path></g><g><path fill="#D3DCE6" d="M82.918,131.694c-0.127,0-0.254-0.048-0.351-0.146c-0.194-0.194-0.193-0.508,0.001-0.702l4.942-4.933     c0.194-0.194,0.508-0.193,0.701,0.001c0.193,0.194,0.193,0.508-0.001,0.702l-4.942,4.933     C83.171,131.645,83.045,131.694,82.918,131.694z"></path></g><g><path fill="#D3DCE6" d="M122.969,126.263c-0.124,0-0.249-0.047-0.346-0.141c-0.196-0.191-0.201-0.505-0.01-0.702l1.818-1.873     c0.19-0.195,0.504-0.201,0.701-0.01c0.196,0.191,0.201,0.505,0.01,0.702l-1.818,1.873     C123.227,126.213,123.098,126.263,122.969,126.263z"></path></g><g><path fill="#D3DCE6" d="M125.059,130.412c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.193-0.194-0.508,0-0.702l2.67-2.676     c0.194-0.194,0.507-0.194,0.701,0s0.194,0.508,0,0.702l-2.67,2.676C125.313,130.363,125.186,130.412,125.059,130.412z"></path></g><g><path fill="#D3DCE6" d="M130.015,125.446c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.193-0.194-0.508,0-0.702l1.054-1.056     c0.194-0.194,0.507-0.194,0.701,0c0.194,0.194,0.194,0.508,0,0.702l-1.054,1.056     C130.269,125.397,130.142,125.446,130.015,125.446z"></path></g><g><path fill="#D3DCE6" d="M109.705,98.755l-0.698-0.705l1.438-1.429c0.193-0.193,0.508-0.192,0.701,0.003     c0.193,0.194,0.192,0.509-0.003,0.702L109.705,98.755z"></path></g><g><path fill="#D3DCE6" d="M113.883,94.402c-0.127,0-0.255-0.049-0.352-0.147c-0.193-0.194-0.192-0.509,0.003-0.702l6.788-6.742     l0.698,0.705l-6.788,6.742C114.135,94.354,114.009,94.402,113.883,94.402z"></path></g><g><path fill="#D3DCE6" d="M112.8,101.019c-0.128,0-0.257-0.049-0.354-0.148c-0.192-0.196-0.189-0.51,0.006-0.702l7.336-7.214     c0.196-0.192,0.509-0.189,0.701,0.006c0.192,0.196,0.189,0.51-0.006,0.702l-7.336,7.214     C113.051,100.972,112.925,101.019,112.8,101.019z"></path></g><g><path fill="#D3DCE6" d="M122.805,91.18c-0.128,0-0.257-0.049-0.353-0.148c-0.192-0.196-0.189-0.51,0.006-0.702l1.295-1.274     c0.195-0.192,0.508-0.189,0.701,0.007c0.192,0.195,0.189,0.51-0.007,0.702l-1.294,1.273     C123.056,91.132,122.93,91.18,122.805,91.18z"></path></g><g><path fill="#D3DCE6" d="M126.601,87.446c-0.128,0-0.257-0.049-0.353-0.148c-0.192-0.196-0.189-0.51,0.006-0.702l1.474-1.45     c0.195-0.191,0.508-0.19,0.701,0.007c0.192,0.195,0.189,0.51-0.007,0.702l-1.473,1.449     C126.852,87.399,126.726,87.446,126.601,87.446z"></path></g></g><g><path fill="#F7F8FC" d="M123.905,11.489L123.905,11.489c-35.676,0-64.598,28.959-64.598,64.681v125.333h129.195V76.17    C188.502,40.448,159.581,11.489,123.905,11.489z M183.374,196.368H64.435V76.17c0-32.834,26.678-59.546,59.47-59.546    s59.47,26.712,59.47,59.546V196.368z"></path><path fill="#D3DCE6" d="M188.502,202.497H59.307c-0.547,0-0.991-0.444-0.991-0.993V76.17c0-36.212,29.423-65.673,65.589-65.673    s65.589,29.461,65.589,65.673v125.334C189.493,202.053,189.049,202.497,188.502,202.497z M60.298,200.511h127.212V76.17    c0-35.118-28.534-63.688-63.606-63.688S60.298,41.053,60.298,76.17V200.511z M183.374,197.361H64.435    c-0.547,0-0.991-0.444-0.991-0.993V76.17c0-33.381,27.122-60.538,60.461-60.538s60.461,27.158,60.461,60.538v120.198    C184.365,196.917,183.921,197.361,183.374,197.361z M65.427,195.376h116.956V76.17c0-32.286-26.233-58.553-58.478-58.553    S65.427,43.884,65.427,76.17V195.376z"></path></g><g><path fill="#E3EAF2" d="M123.905,53.405c-12.428,0-22.503,10.088-22.503,22.532h3.59l0.119-1.511    c0.197-2.501,0.793-4.976,1.947-7.204c3.159-6.098,9.525-10.274,16.847-10.274c7.322,0,13.687,4.176,16.847,10.274    c1.154,2.227,1.749,4.702,1.947,7.204l0.119,1.511h3.59C146.408,63.492,136.333,53.405,123.905,53.405z"></path><path fill="#D3DCE6" d="M146.408,76.929h-3.59c-0.517,0-0.948-0.398-0.988-0.915l-0.119-1.511    c-0.202-2.565-0.821-4.861-1.838-6.825c-3.112-6.007-9.23-9.739-15.967-9.739s-12.855,3.732-15.967,9.739    c-1.018,1.966-1.636,4.262-1.838,6.825l-0.119,1.511c-0.041,0.517-0.471,0.915-0.988,0.915h-3.59    c-0.547,0-0.991-0.444-0.991-0.993c0-12.971,10.539-23.524,23.494-23.524c12.955,0,23.494,10.553,23.494,23.524    C147.399,76.485,146.955,76.929,146.408,76.929z M143.734,74.944h1.66c-0.52-11.418-9.96-20.547-21.489-20.547    s-20.969,9.129-21.489,20.547h1.66l0.046-0.596c0.223-2.829,0.914-5.38,2.055-7.583c3.454-6.668,10.247-10.81,17.727-10.81    c7.48,0,14.272,4.142,17.727,10.81c1.14,2.2,1.831,4.751,2.055,7.583L143.734,74.944z"></path></g><g><rect x="64.435" y="75.936" fill="#F7F8FC" width="118.939" height="3.595"></rect><path fill="#D3DCE6" d="M183.374,80.523H64.435c-0.547,0-0.991-0.444-0.991-0.993v-3.595c0-0.548,0.444-0.993,0.991-0.993h118.939    c0.547,0,0.991,0.444,0.991,0.993v3.595C184.365,80.079,183.921,80.523,183.374,80.523z M65.427,78.538h116.956v-1.609H65.427    V78.538z"></path></g><g><path fill="#E3EAF2" d="M183.374,119.658v-3.595h-36.967V79.531h-3.59v36.533h-37.825V79.531h-3.59v36.533H64.435v3.595h36.967    v36.533H64.435v3.595h36.967v36.211h3.59v-36.211h37.825v36.211h3.59v-36.211h36.967v-3.595h-36.967v-36.533H183.374z     M142.817,156.191h-37.825v-36.533h37.825V156.191z"></path><path fill="#D3DCE6" d="M146.407,196.989h-3.59c-0.547,0-0.991-0.444-0.991-0.993v-35.218h-35.843v35.218    c0,0.549-0.444,0.993-0.991,0.993h-3.59c-0.547,0-0.991-0.444-0.991-0.993v-35.218H64.435c-0.547,0-0.991-0.444-0.991-0.993    v-3.595c0-0.549,0.444-0.993,0.991-0.993h35.976v-34.547H64.435c-0.547,0-0.991-0.444-0.991-0.993v-3.595    c0-0.548,0.444-0.993,0.991-0.993h35.976v-35.54c0-0.548,0.444-0.993,0.991-0.993h3.59c0.547,0,0.991,0.444,0.991,0.993v35.54    h35.843v-35.54c0-0.548,0.444-0.993,0.991-0.993h3.59c0.547,0,0.991,0.444,0.991,0.993v35.54h35.975    c0.547,0,0.991,0.444,0.991,0.993v3.595c0,0.548-0.444,0.993-0.991,0.993h-35.975v34.547h35.975c0.547,0,0.991,0.444,0.991,0.993    v3.595c0,0.549-0.444,0.993-0.991,0.993h-35.975v35.218C147.398,196.545,146.955,196.989,146.407,196.989z M143.809,195.004h1.607    v-35.218c0-0.549,0.444-0.993,0.991-0.993h35.976v-1.61h-35.976c-0.547,0-0.991-0.444-0.991-0.993v-36.532    c0-0.548,0.444-0.993,0.991-0.993h35.976v-1.609h-35.976c-0.547,0-0.991-0.444-0.991-0.993v-35.54h-1.607v35.54    c0,0.548-0.444,0.993-0.991,0.993h-37.825c-0.547,0-0.991-0.444-0.991-0.993v-35.54h-1.607v35.54c0,0.548-0.444,0.993-0.991,0.993    H65.427v1.609h35.976c0.547,0,0.991,0.444,0.991,0.993v36.532c0,0.549-0.444,0.993-0.991,0.993H65.427v1.61h35.976    c0.547,0,0.991,0.444,0.991,0.993v35.218h1.607v-35.218c0-0.549,0.444-0.993,0.991-0.993h37.825c0.547,0,0.991,0.444,0.991,0.993    V195.004z M142.817,157.183h-37.825c-0.547,0-0.991-0.444-0.991-0.993v-36.532c0-0.548,0.444-0.993,0.991-0.993h37.825    c0.547,0,0.991,0.444,0.991,0.993v36.532C143.809,156.739,143.365,157.183,142.817,157.183z M105.983,155.198h35.843v-34.547    h-35.843V155.198z"></path></g><g><rect x="122.108" y="16.655" fill="#E3EAF2" width="3.59" height="36.819"></rect><path fill="#D3DCE6" d="M125.698,54.468h-3.59c-0.547,0-0.991-0.444-0.991-0.993v-36.82c0-0.548,0.444-0.993,0.991-0.993h3.59    c0.547,0,0.991,0.444,0.991,0.993v36.82C126.689,54.023,126.245,54.468,125.698,54.468z M123.099,52.482h1.607V17.648h-1.607    V52.482z"></path></g><g><g><polygon fill="#E3EAF2" points="164.727,32.924 138.714,58.97 141.217,61.547 167.26,35.471    "></polygon><path fill="#D3DCE6" d="M141.217,62.54c-0.002,0-0.005,0-0.007,0c-0.265-0.002-0.518-0.11-0.704-0.301l-2.503-2.578     c-0.378-0.389-0.373-1.009,0.01-1.393l26.012-26.046c0.186-0.186,0.438-0.291,0.701-0.291c0,0,0,0,0.001,0     c0.263,0,0.515,0.105,0.701,0.292l2.534,2.547c0.386,0.388,0.385,1.015-0.001,1.402l-26.043,26.077     C141.732,62.435,141.48,62.54,141.217,62.54z M140.106,58.979l1.121,1.155l24.633-24.665l-1.135-1.141L140.106,58.979z"></path></g><g><polygon fill="#E3EAF2" points="106.589,61.547 80.546,35.471 83.08,32.913 109.102,58.97    "></polygon><path fill="#D3DCE6" d="M106.589,62.54c-0.263,0-0.515-0.105-0.701-0.291L79.845,36.173c-0.386-0.386-0.387-1.012-0.003-1.401     l2.533-2.557c0.185-0.188,0.438-0.293,0.702-0.294c0,0,0.001,0,0.002,0c0.263,0,0.515,0.105,0.701,0.291l26.023,26.056     c0.384,0.384,0.388,1.006,0.009,1.395l-2.513,2.578c-0.185,0.19-0.439,0.298-0.704,0.3     C106.593,62.54,106.591,62.54,106.589,62.54z M81.945,35.468l24.636,24.667l1.128-1.157L83.082,34.32L81.945,35.468z"></path></g></g><g><rect x="54.3" y="194.831" fill="#F7F8FC" width="139.209" height="12.901"></rect><path fill="#D3DCE6" d="M193.509,208.724H54.3c-0.547,0-0.991-0.444-0.991-0.993v-12.9c0-0.549,0.444-0.993,0.991-0.993h139.209    c0.547,0,0.991,0.444,0.991,0.993v12.9C194.5,208.28,194.057,208.724,193.509,208.724z M55.291,206.739h137.227v-10.915H55.291    V206.739z"></path></g><g><polygon fill="#EBEEF0" points="146.503,106.022 152.705,116.12 160.367,110.597 175.698,115.562 183.374,107.952 176.2,89.416     171.335,95.37 164.193,87.905 161.1,93.395 146.487,87.105 155.023,101.791   "></polygon><path fill="#D3DCE6" d="M152.705,117.113c-0.065,0-0.13-0.006-0.195-0.019c-0.27-0.054-0.506-0.219-0.65-0.453l-6.202-10.099    c-0.146-0.237-0.185-0.526-0.108-0.794c0.076-0.268,0.263-0.491,0.512-0.615l7.571-3.758l-8.003-13.769    c-0.215-0.37-0.169-0.836,0.115-1.157c0.283-0.32,0.741-0.423,1.134-0.254l13.796,5.938l2.655-4.714    c0.154-0.274,0.428-0.458,0.74-0.497c0.314-0.041,0.623,0.071,0.84,0.298l6.368,6.655l4.157-5.086    c0.223-0.273,0.575-0.409,0.923-0.351c0.348,0.055,0.641,0.292,0.769,0.621l7.174,18.536c0.142,0.368,0.053,0.786-0.227,1.064    l-7.676,7.61c-0.264,0.261-0.651,0.353-1.002,0.239l-14.854-4.81l-7.256,5.23C153.114,117.048,152.911,117.113,152.705,117.113z     M147.916,106.428l5.075,8.264l6.797-4.899c0.256-0.185,0.584-0.236,0.884-0.139l14.757,4.779l6.786-6.727l-6.325-16.342    l-3.788,4.636c-0.18,0.22-0.445,0.352-0.728,0.363c-0.278,0.007-0.559-0.099-0.755-0.305l-6.219-6.5l-2.437,4.326    c-0.249,0.441-0.79,0.624-1.255,0.425l-11.855-5.103l7.025,12.088c0.138,0.237,0.172,0.521,0.092,0.785    c-0.079,0.263-0.263,0.482-0.509,0.604L147.916,106.428z"></path></g><g><path fill="#D3DCE6" d="M164.193,88.401c-0.077,0-0.156-0.018-0.229-0.057c-0.243-0.127-0.336-0.426-0.21-0.669l1.787-3.422    l-1.808-4.538c-0.102-0.254,0.022-0.543,0.277-0.645c0.251-0.102,0.542,0.022,0.644,0.277l1.892,4.75    c0.054,0.134,0.046,0.285-0.021,0.413l-1.892,3.624C164.544,88.304,164.371,88.401,164.193,88.401z"></path></g><g><path fill="#D3DCE6" d="M176.2,89.912c-0.228,0-0.433-0.158-0.484-0.39l-0.857-3.915c-0.037-0.17,0.017-0.348,0.144-0.467    l3.227-3.044c0.199-0.189,0.513-0.179,0.7,0.021c0.188,0.2,0.179,0.514-0.021,0.701l-3.023,2.851l0.797,3.641    c0.059,0.268-0.11,0.532-0.378,0.591C176.271,89.908,176.235,89.912,176.2,89.912z"></path></g><g><path fill="#D3DCE6" d="M163.598,111.335c-0.049-3.931,1.563-7.969,4.633-10.509c2.937-2.43,8.153-3.262,10.806,0.067    c3.549,4.454,0.555,12.75-2.026,17.002c-6.726,11.081-23.88,19.064-18.537,34.599c1.454,4.227,4.456,7.726,6.556,11.631    c2.614,4.86,3.982,9.769,4.037,15.303c0.013,1.277,1.995,1.28,1.982,0c-0.047-4.74-0.933-9.203-2.911-13.522    c-1.975-4.312-5.025-7.981-7.053-12.239c-4.401-9.242,1.439-17.206,7.744-23.546c5.107-5.135,10.288-10.019,12.48-17.132    c1.6-5.193,2.375-13.13-3.812-15.603c-8.771-3.506-15.982,5.993-15.883,13.949C161.631,112.612,163.614,112.615,163.598,111.335    L163.598,111.335z"></path></g><g><path fill="#E3EAF2" d="M159.325,150.606c-4.021-2.043-7.46-4.701-11.671-1.871c-4.37,2.937-4.006,6.962-3.817,11.682    c2.125-2.813,5.737-2.183,8.656-3.282c2.248-0.846,6.884-3.989,6.521-6.84"></path></g><g><g><path fill="#D3DCE6" d="M159.825,149.749c-4.47-2.325-8.922-4.942-13.493-1.267c-3.757,3.02-3.669,7.52-3.487,11.935     c0.033,0.798,1.099,1.388,1.692,0.702c2.513-2.906,7.133-2.146,10.343-4.072c2.375-1.425,5.207-3.715,5.125-6.752     c-0.034-1.275-2.017-1.28-1.982,0c0.084,3.13-4.451,5.62-7.08,6.263c-2.921,0.714-5.698,0.719-7.807,3.157     c0.564,0.234,1.128,0.468,1.692,0.702c-0.135-3.26-0.534-6.987,1.863-9.586c3.81-4.131,8.113-1.458,12.133,0.633     C159.955,152.051,160.959,150.338,159.825,149.749L159.825,149.749z"></path></g></g><g><path fill="#E3EAF2" d="M169.106,128.614c9.523-0.637,13.055,9.409,9.285,17.076c-3.047-0.689-6.266-3.475-8.38-5.883    C168.075,137.603,166.708,130.873,169.106,128.614"></path></g><g><g><path fill="#D3DCE6" d="M169.106,129.607c8.636-0.355,11.663,8.637,8.429,15.582c0.373-0.152,0.746-0.304,1.119-0.456     c-3.256-0.9-7.115-3.697-8.654-6.791c-1.13-2.271-2.099-6.527-0.193-8.626c0.857-0.944-0.541-2.351-1.402-1.404     c-2.41,2.654-1.728,7.13-0.495,10.179c1.612,3.985,6.162,7.435,10.217,8.556c0.39,0.108,0.937-0.064,1.119-0.456     c3.838-8.241,0.093-18.99-10.141-18.569C167.835,127.674,167.828,129.659,169.106,129.607L169.106,129.607z"></path></g></g><g><path fill="#F7F8FC" d="M169.618,99.387c2.866-1.303,4.75,0.343,5.036,1.769c0.564,2.811-1.21,6.966-3.146,7.724    C170.687,106.58,164.794,102.457,169.618,99.387z"></path><path fill="#D3DCE6" d="M171.508,109.873c-0.14,0-0.281-0.03-0.411-0.089c-0.244-0.111-0.432-0.317-0.523-0.569    c-0.167-0.468-0.745-1.206-1.304-1.92c-1.261-1.609-2.83-3.612-2.469-5.719c0.2-1.17,0.969-2.189,2.285-3.026    c0.039-0.025,0.08-0.047,0.122-0.066c1.565-0.711,3.124-0.746,4.389-0.097c1.04,0.533,1.817,1.519,2.029,2.574    c0.653,3.258-1.313,7.887-3.757,8.845C171.752,109.85,171.63,109.873,171.508,109.873z M170.091,100.263    c-0.798,0.52-1.235,1.059-1.336,1.648c-0.212,1.238,1.056,2.857,2.075,4.158c0.382,0.489,0.737,0.942,1.027,1.375    c1.18-1.217,2.229-4.082,1.826-6.093c-0.072-0.356-0.373-0.883-0.989-1.199C171.983,99.788,171.083,99.825,170.091,100.263z"></path></g><g><path fill="#E3EAF2" d="M167.034,100.156c1.454,0.041,2.841-0.662,3.602-1.903c1.212-1.977,1.648-4.477,0.339-6.838    c-1.87-3.373-9.013-1.98-12.355-2.689c3.053,2.487-0.153,6.121,1.528,8.904C161.308,99.55,164.482,100.085,167.034,100.156z"></path></g><g><g><path fill="#D3DCE6" d="M167.034,101.149c5.054-0.286,7.534-6.938,4.382-10.833c-2.813-3.474-8.732-1.867-12.532-2.547     c-0.916-0.164-1.731,0.919-0.964,1.659c2.541,2.454-0.518,6.352,1.703,9.155C161.321,100.726,164.506,101.039,167.034,101.149     c1.276,0.055,1.273-1.93,0-1.985c-1.516-0.066-3.278-0.164-4.652-0.899c-1.903-1.017-1.813-2.751-1.571-4.62     c0.291-2.246,0.209-3.981-1.49-5.621c-0.321,0.553-0.643,1.106-0.964,1.659c2.512,0.449,5.07,0.164,7.598,0.429     c1.514,0.159,3.259,0.434,4.165,1.804c1.711,2.59,0.195,7.062-3.085,7.248C165.766,99.235,165.757,101.221,167.034,101.149z"></path></g></g><g><path fill="#E3EAF2" d="M182.769,110.581c2.169-1.775,7.627-3.377,10.497-2.51c3.977,1.201,6.219,7.409,5.556,11.126    c-4.28-1.375-6.192,2.21-10.592,1.164C184.366,119.444,181.716,114.519,182.769,110.581"></path></g><g><g><path fill="#D3DCE6" d="M183.269,111.438c2.532-1.903,7.461-3.677,10.494-2.088c3.084,1.617,4.562,6.32,4.103,9.583     c0.406-0.231,0.813-0.462,1.219-0.693c-3.201-0.855-5.335,0.796-8.382,1.24c-4.713,0.687-7.894-4.397-6.979-8.636     c0.269-1.246-1.642-1.778-1.912-0.528c-0.848,3.928,0.848,8.364,4.463,10.336c1.653,0.901,3.59,1.086,5.412,0.671     c2.448-0.557,4.249-1.869,6.87-1.169c0.467,0.125,1.144-0.157,1.219-0.693c0.572-4.069-0.979-9.181-4.547-11.538     c-3.667-2.423-9.723-0.634-12.963,1.801C181.26,110.482,182.248,112.206,183.269,111.438L183.269,111.438z"></path></g></g><g><path fill="#E3EAF2" d="M165.599,161.028c5.015-2.514,8.72-6.122,14.737-5.279c5.974,0.837,8.273,5.176,7.9,11.093    c-1.647-0.201-2.951-0.937-4.69-0.776c-2.44,0.226-4.405,1.794-6.938,1.806C172.383,167.891,169.246,162.669,165.599,161.028"></path></g><g><g><path fill="#D3DCE6" d="M166.099,161.885c4.655-2.403,9.053-6.138,14.647-5.067c5.1,0.977,6.717,5.295,6.499,10.023     c0.418-0.319,0.837-0.638,1.255-0.957c-2.02-0.35-3.861-1.089-5.936-0.671c-2.275,0.459-4.466,2.062-6.871,1.571     c-3.799-0.776-6.199-4.924-9.593-6.614c-1.139-0.567-2.144,1.145-1.001,1.714c3.469,1.728,5.721,5.465,9.497,6.657     c1.718,0.542,3.434,0.279,5.109-0.289c1.119-0.379,2.212-0.926,3.386-1.125c1.663-0.282,3.264,0.39,4.882,0.671     c0.65,0.113,1.223-0.267,1.255-0.957c0.233-5.055-1.516-9.969-6.705-11.623c-6.633-2.115-11.864,2.082-17.424,4.952     C163.964,160.757,164.966,162.47,166.099,161.885L166.099,161.885z"></path></g></g><g><path fill="#E3EAF2" d="M169.701,186.076c5.013-3.758,1.128-11.65-5.052-10.636c-1.382,0.227-2.773,0.692-4.197,1.525    c-5.208,3.047-5.688,7.935-3.098,13.266c1.447-0.812,8.799-2.519,11.147-3.471C168.935,186.583,169.333,186.351,169.701,186.076z"></path></g><g><g><path fill="#D3DCE6" d="M170.402,186.777c5.026-4.132,1.814-12.329-4.587-12.419c-3.765-0.053-8.005,2.339-9.857,5.626     c-1.94,3.443-1.025,7.36,0.54,10.746c0.235,0.508,0.915,0.577,1.356,0.356c3.862-1.934,8.699-1.751,12.348-4.155     c1.061-0.699,0.069-2.419-1.001-1.714c-3.614,2.381-8.494,2.225-12.348,4.155c0.452,0.119,0.904,0.237,1.356,0.356     c-1.153-2.494-1.966-5.374-0.87-8.036c1.226-2.979,4.765-5.097,7.9-5.332c5.007-0.374,7.662,5.805,3.761,9.013     C168.013,186.185,169.423,187.582,170.402,186.777z"></path></g></g><g><path fill="#F7F8FC" d="M169.834,178.987c2.529-4.118,6.508-2.89,8.985-1.198c3.432,2.344,4.68,9.858,2.93,13.203    c-3.668-2.601-6.675-0.226-10.557-2.549C167.783,186.403,167.645,182.426,169.834,178.987z"></path></g><g><g><path fill="#D3DCE6" d="M170.69,179.488c2.443-3.585,7.191-2.398,9.21,1.004c1.623,2.736,2.378,7.023,0.994,9.999     c0.452-0.119,0.904-0.237,1.356-0.356c-2.63-1.656-5.068-1.194-7.984-1.655C169.346,187.702,168.436,183.317,170.69,179.488     c0.649-1.103-1.064-2.103-1.712-1.002c-1.75,2.974-2.421,6.831,0.161,9.566c3.397,3.598,8.303,1.4,12.11,3.798     c0.423,0.266,1.135,0.12,1.356-0.356c1.888-4.063,0.957-10.261-2.125-13.552c-3.379-3.609-8.7-3.569-11.502,0.545     C168.257,179.544,169.974,180.539,170.69,179.488z"></path></g></g><g><path fill="#E3EAF2" d="M167.085,133.043c-1.159-4.617-9.446-8.985-11.759,5.625C159.005,136.184,169.459,139.113,167.085,133.043    z"></path><path fill="#D3DCE6" d="M155.326,139.661c-0.185,0-0.37-0.051-0.533-0.155c-0.333-0.212-0.508-0.603-0.446-0.993    c1.462-9.234,5.213-10.77,7.319-10.864c3.079-0.14,5.69,2.523,6.364,5.089c0.537,1.406,0.52,2.579-0.05,3.488    c-1.096,1.745-3.796,1.948-6.655,2.163c-2.109,0.158-4.291,0.322-5.445,1.101C155.713,139.604,155.52,139.661,155.326,139.661z     M161.889,129.63c-0.045,0-0.09,0.001-0.135,0.003c-2.276,0.101-4.101,2.768-5.113,7.395c1.365-0.379,2.968-0.499,4.535-0.617    c2.138-0.161,4.562-0.343,5.125-1.24c0.226-0.359,0.179-0.953-0.139-1.766c-0.015-0.039-0.028-0.079-0.038-0.12    C165.682,131.526,163.851,129.63,161.889,129.63z"></path></g><g><path fill="#D3DCE6" d="M155.433,166.821c-0.319,0-0.648-0.05-0.982-0.154c-0.262-0.08-0.408-0.359-0.327-0.62    c0.08-0.263,0.359-0.412,0.62-0.328c0.993,0.306,1.907-0.067,2.535-1.007c-0.275-0.117-0.613-0.393-0.694-1.035    c-0.059-0.466,0.147-0.877,0.536-1.075c0.402-0.203,0.909-0.126,1.239,0.186c0.108,0.103,0.282,0.316,0.337,0.656    c0.266-0.171,0.497-0.364,0.588-0.496c0.163-0.237,0.338-0.597,0.457-0.957c-0.247-0.138-0.459-0.315-0.599-0.513    c-0.351-0.496-0.275-1.077,0.2-1.517c0.115-0.107,0.272-0.153,0.426-0.123c0.6,0.111,0.868,0.478,0.987,0.767    c0.086,0.207,0.121,0.436,0.119,0.672c0.04-0.006,0.075-0.016,0.103-0.031c0.868-0.462,1.079-1.593,1.172-2.637    c0.024-0.272,0.263-0.466,0.537-0.451c0.273,0.024,0.474,0.265,0.45,0.538c-0.116,1.309-0.408,2.741-1.694,3.426    c-0.225,0.12-0.481,0.164-0.75,0.151c-0.178,0.545-0.443,1.02-0.593,1.237c-0.225,0.328-0.928,0.918-1.667,1.174    C157.766,166.059,156.674,166.821,155.433,166.821z M157.603,163.48c-0.017,0-0.031,0.004-0.037,0.008    c0.031,0.296,0.098,0.311,0.123,0.318c0.006,0.001,0.011,0.002,0.017,0.004c0.034-0.173,0.005-0.274-0.035-0.307    C157.651,163.486,157.625,163.48,157.603,163.48z"></path></g><g><path fill="#F7F8FC" d="M182.578,109.573c4.06,4.199-2.53,7.693-8.473,7.692C173.275,110.948,178.519,105.373,182.578,109.573z"></path><path fill="#D3DCE6" d="M174.108,118.258c-0.001,0-0.001,0-0.002,0c-0.498,0-0.918-0.369-0.983-0.863    c-0.543-4.124,1.31-8.327,4.308-9.777c2.009-0.971,4.145-0.509,5.859,1.265c1.857,1.921,1.697,3.622,1.237,4.711    C183.244,116.623,178.202,118.258,174.108,118.258z M179.521,109.108c-0.408,0-0.818,0.098-1.227,0.297    c-1.79,0.866-3.395,3.588-3.28,6.84c3.556-0.221,6.957-1.7,7.687-3.425c0.123-0.291,0.498-1.177-0.835-2.556    C181.125,109.496,180.33,109.108,179.521,109.108z"></path></g><g><path fill="#F7F8FC" d="M160.452,153.679c-4.156-3.452-2.032-6.298,0.97-7.453c3.285-1.264,6.428,2.11,10.277,0    C173.298,150.738,166.351,157.409,160.452,153.679z"></path><path fill="#D3DCE6" d="M164.099,155.761c-1.356,0-2.78-0.36-4.176-1.243c-0.036-0.023-0.071-0.048-0.104-0.076    c-2.527-2.098-2.823-3.961-2.627-5.156c0.277-1.693,1.69-3.147,3.874-3.988c1.78-0.685,3.442-0.257,5.05,0.16    c1.72,0.444,3.343,0.864,5.106-0.104c0.255-0.141,0.558-0.161,0.83-0.057s0.484,0.322,0.581,0.596    c0.895,2.526-0.319,5.678-3.023,7.841C168.187,154.875,166.227,155.761,164.099,155.761z M161.035,152.874    c3.387,2.099,6.469,0.007,7.337-0.688c1.615-1.292,2.567-3.037,2.569-4.557c-1.955,0.624-3.726,0.165-5.32-0.247    c-1.425-0.368-2.653-0.687-3.843-0.229c-1.488,0.573-2.472,1.491-2.63,2.455C158.949,150.824,160.052,152.047,161.035,152.874z"></path></g><g><path fill="#F7F8FC" d="M164.781,160.108c8.624-5.922,6.364,5.056,8.74,9.153C163.577,170.213,159.903,163.309,164.781,160.108z"></path><path fill="#D3DCE6" d="M171.7,170.343c-5.499,0-8.843-2.444-9.774-5.096c-0.782-2.229,0.101-4.513,2.303-5.963    c2.551-1.75,4.435-2.266,5.935-1.623c2.113,0.904,2.584,3.798,3.04,6.596c0.276,1.695,0.561,3.448,1.175,4.506    c0.169,0.292,0.179,0.651,0.025,0.952c-0.154,0.3-0.451,0.502-0.787,0.534C172.951,170.313,172.312,170.343,171.7,170.343z     M168.836,159.385c-0.664,0-1.745,0.341-3.494,1.542c-0.006,0.004-0.012,0.008-0.017,0.011c-1.451,0.953-2.007,2.283-1.528,3.65    c0.688,1.963,3.532,3.85,8.256,3.766c-0.378-1.151-0.595-2.479-0.806-3.778c-0.352-2.162-0.752-4.615-1.862-5.09    C169.244,159.426,169.065,159.385,168.836,159.385z M164.781,160.108h0.01H164.781z"></path></g><g><path fill="#D3DCE6" d="M184.262,103.937c-0.207,0-0.37-0.062-0.479-0.12c-0.436-0.235-0.673-0.781-0.62-1.426    c0.015-0.185,0.055-0.38,0.123-0.578c-0.511-0.066-1.109-0.029-1.71,0.203c-0.256,0.096-0.543-0.03-0.641-0.285    c-0.098-0.256,0.029-0.543,0.285-0.642c0.896-0.346,1.834-0.371,2.621-0.186c0.277-0.291,0.649-0.542,1.13-0.708    c0.333-0.115,0.903-0.189,1.49-0.132c0.336-0.406,0.827-0.858,1.529-1.354c0.223-0.158,0.532-0.104,0.691,0.12    c0.158,0.224,0.104,0.534-0.12,0.692c-0.432,0.305-0.765,0.583-1.02,0.832c0.011,0.006,0.022,0.011,0.032,0.017    c0.402,0.211,0.67,0.524,0.776,0.904c0.242,0.867-0.194,1.387-0.641,1.569c-0.633,0.256-1.411-0.02-1.737-0.617    c-0.142-0.261-0.25-0.659-0.081-1.184c-0.241,0.01-0.456,0.044-0.598,0.093c-0.153,0.052-0.289,0.118-0.408,0.192    c0.29,0.184,0.517,0.406,0.657,0.653c0.313,0.553,0.16,1.169-0.4,1.608C184.801,103.854,184.502,103.937,184.262,103.937z     M184.236,102.099c-0.05,0.132-0.078,0.263-0.087,0.385c-0.021,0.297,0.075,0.444,0.104,0.459    c0.016,0.005,0.111-0.007,0.277-0.138c0.235-0.184,0.183-0.276,0.148-0.336C184.608,102.344,184.452,102.212,184.236,102.099z     M186.912,101.165c-0.135,0.276-0.132,0.473-0.071,0.585c0.092,0.171,0.344,0.232,0.494,0.174c0.099-0.04,0.119-0.169,0.06-0.382    c-0.012-0.042-0.047-0.169-0.283-0.293C187.051,101.217,186.983,101.189,186.912,101.165z"></path></g><g><path fill="#F7F8FC" d="M168.727,128.573c-0.724,2.639-2.979,3.585-6.084,3.069c-3.28-0.544-4.772-5.874-6.585-8.597    c3.057,1.883,5.42-1.891,8.178-1.32C166.715,122.239,169.601,125.276,168.727,128.573z"></path></g><g><g><path fill="#D3DCE6" d="M167.772,128.309c-1.142,3.408-5.487,3.033-7.344,0.534c-1.437-1.934-2.233-4.267-3.514-6.299     c-0.452,0.453-0.904,0.905-1.356,1.358c1.949,0.983,3.558,0.605,5.465-0.297c1.554-0.736,2.688-1.324,4.322-0.367     C167.111,124.272,168.151,126.278,167.772,128.309c-0.233,1.249,1.677,1.784,1.912,0.528c0.585-3.131-0.97-6.203-3.872-7.601     c-1.112-0.536-2.259-0.685-3.455-0.37c-1.976,0.521-3.661,2.4-5.798,1.321c-0.837-0.423-1.917,0.468-1.356,1.358     c1.805,2.863,2.936,7.516,6.437,8.83c3.337,1.252,6.912-0.156,8.045-3.539C170.09,127.623,168.176,127.102,167.772,128.309z"></path></g></g><g opacity="0.2"><path fill="#D3DCE6" d="M279.839,76.17c0-32.834,26.678-59.546,59.47-59.546s59.47,26.712,59.47,59.546H279.839z"></path></g><g opacity="0.2"><rect x="279.839" y="79.531" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="320.823" y="79.531" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="362.074" y="79.531" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="279.839" y="119.497" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="320.823" y="119.497" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="362.074" y="119.497" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="279.839" y="159.212" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="320.823" y="159.212" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g opacity="0.2"><rect x="362.074" y="159.212" fill="#D3DCE6" width="36.967" height="36.533"></rect></g><g><path fill="#F7F8FC" d="M339.308,11.489L339.308,11.489c-35.676,0-64.598,28.959-64.598,64.681v125.333h129.195V76.17    C403.906,40.448,374.984,11.489,339.308,11.489z M398.778,196.368H279.839V76.17c0-32.834,26.678-59.546,59.47-59.546    s59.47,26.712,59.47,59.546V196.368z"></path><path fill="#D3DCE6" d="M403.905,202.497H274.711c-0.548,0-0.991-0.444-0.991-0.993V76.17c0-36.212,29.423-65.673,65.589-65.673    c36.165,0,65.588,29.461,65.588,65.673v125.334C404.897,202.053,404.453,202.497,403.905,202.497z M275.702,200.511h127.212V76.17    c0-35.118-28.533-63.688-63.606-63.688c-35.073,0-63.607,28.571-63.607,63.688V200.511z M398.778,197.361H279.839    c-0.548,0-0.991-0.444-0.991-0.993V76.17c0-33.381,27.123-60.538,60.461-60.538s60.461,27.158,60.461,60.538v120.198    C399.769,196.917,399.326,197.361,398.778,197.361z M280.83,195.376h116.956V76.17c0-32.286-26.233-58.553-58.478-58.553    S280.83,43.884,280.83,76.17V195.376z"></path></g><g><path fill="#E3EAF2" d="M339.308,53.405c-12.428,0-22.503,10.088-22.503,22.532h3.59l0.119-1.511    c0.197-2.501,0.793-4.976,1.947-7.204c3.159-6.098,9.525-10.274,16.847-10.274c7.322,0,13.687,4.176,16.847,10.274    c1.154,2.227,1.749,4.702,1.947,7.204l0.119,1.511h3.59C361.811,63.492,351.736,53.405,339.308,53.405z"></path><path fill="#D3DCE6" d="M361.811,76.929h-3.59c-0.517,0-0.948-0.398-0.988-0.915l-0.119-1.511    c-0.202-2.565-0.821-4.861-1.838-6.825c-3.111-6.007-9.229-9.739-15.967-9.739c-6.736,0-12.855,3.732-15.967,9.739    c-1.017,1.965-1.636,4.261-1.838,6.825l-0.118,1.511c-0.041,0.517-0.47,0.915-0.988,0.915h-3.59c-0.548,0-0.991-0.444-0.991-0.993    c0-12.971,10.539-23.524,23.494-23.524s23.494,10.553,23.494,23.524C362.802,76.485,362.359,76.929,361.811,76.929z     M359.136,74.944h1.661c-0.52-11.418-9.96-20.547-21.489-20.547s-20.969,9.129-21.489,20.547h1.66l0.046-0.596    c0.224-2.83,0.915-5.38,2.055-7.583c3.455-6.668,10.247-10.81,17.727-10.81s14.272,4.142,17.726,10.81    c1.14,2.2,1.831,4.751,2.055,7.583L359.136,74.944z"></path></g><g><rect x="279.839" y="75.936" fill="#F7F8FC" width="118.939" height="3.595"></rect><path fill="#D3DCE6" d="M398.778,80.523H279.839c-0.548,0-0.991-0.444-0.991-0.993v-3.595c0-0.548,0.443-0.993,0.991-0.993    h118.939c0.548,0,0.991,0.444,0.991,0.993v3.595C399.769,80.079,399.326,80.523,398.778,80.523z M280.83,78.538h116.956v-1.609    H280.83V78.538z"></path></g><g><path fill="#E3EAF2" d="M398.778,119.658v-3.595h-36.967V79.531h-3.59v36.533h-37.825V79.531h-3.59v36.533h-36.967v3.595h36.967    v36.533h-36.967v3.595h36.967v36.211h3.59v-36.211h37.825v36.211h3.59v-36.211h36.967v-3.595h-36.967v-36.533H398.778z     M358.221,156.191h-37.825v-36.533h37.825V156.191z"></path><path fill="#D3DCE6" d="M361.811,196.989h-3.59c-0.548,0-0.991-0.444-0.991-0.993v-35.218h-35.843v35.218    c0,0.549-0.443,0.993-0.991,0.993h-3.589c-0.548,0-0.991-0.444-0.991-0.993v-35.218h-35.975c-0.548,0-0.991-0.444-0.991-0.993    v-3.595c0-0.549,0.443-0.993,0.991-0.993h35.975v-34.547h-35.975c-0.548,0-0.991-0.444-0.991-0.993v-3.595    c0-0.548,0.443-0.993,0.991-0.993h35.975v-35.54c0-0.548,0.443-0.993,0.991-0.993h3.589c0.548,0,0.991,0.444,0.991,0.993v35.54    h35.843v-35.54c0-0.548,0.443-0.993,0.991-0.993h3.59c0.548,0,0.991,0.444,0.991,0.993v35.54h35.975    c0.548,0,0.991,0.444,0.991,0.993v3.595c0,0.548-0.443,0.993-0.991,0.993h-35.975v34.547h35.975c0.548,0,0.991,0.444,0.991,0.993    v3.595c0,0.549-0.443,0.993-0.991,0.993h-35.975v35.218C362.802,196.545,362.359,196.989,361.811,196.989z M359.212,195.004h1.608    v-35.218c0-0.549,0.443-0.993,0.991-0.993h35.975v-1.61h-35.975c-0.548,0-0.991-0.444-0.991-0.993v-36.532    c0-0.548,0.443-0.993,0.991-0.993h35.975v-1.609h-35.975c-0.548,0-0.991-0.444-0.991-0.993v-35.54h-1.608v35.54    c0,0.548-0.443,0.993-0.991,0.993h-37.825c-0.548,0-0.991-0.444-0.991-0.993v-35.54h-1.607v35.54c0,0.548-0.443,0.993-0.991,0.993    H280.83v1.609h35.976c0.548,0,0.991,0.444,0.991,0.993v36.532c0,0.549-0.443,0.993-0.991,0.993H280.83v1.61h35.976    c0.548,0,0.991,0.444,0.991,0.993v35.218h1.607v-35.218c0-0.549,0.443-0.993,0.991-0.993h37.825c0.548,0,0.991,0.444,0.991,0.993    V195.004z M358.221,157.183h-37.825c-0.548,0-0.991-0.444-0.991-0.993v-36.532c0-0.548,0.443-0.993,0.991-0.993h37.825    c0.548,0,0.991,0.444,0.991,0.993v36.532C359.212,156.739,358.769,157.183,358.221,157.183z M321.387,155.198h35.843v-34.547    h-35.843V155.198z"></path></g><g><rect x="337.512" y="16.655" fill="#E3EAF2" width="3.59" height="36.819"></rect><path fill="#D3DCE6" d="M341.101,54.468h-3.589c-0.548,0-0.991-0.444-0.991-0.993v-36.82c0-0.548,0.443-0.993,0.991-0.993h3.589    c0.548,0,0.991,0.444,0.991,0.993v36.82C342.093,54.023,341.649,54.468,341.101,54.468z M338.503,52.482h1.607V17.648h-1.607    V52.482z"></path></g><g><g><polygon fill="#E3EAF2" points="380.13,32.924 354.118,58.97 356.621,61.547 382.664,35.471    "></polygon><path fill="#D3DCE6" d="M356.621,62.54c-0.002,0-0.005,0-0.007,0c-0.265-0.002-0.519-0.11-0.704-0.301l-2.502-2.578     c-0.379-0.389-0.374-1.009,0.01-1.393l26.012-26.046c0.186-0.186,0.438-0.291,0.701-0.291h0.001c0.263,0,0.516,0.105,0.701,0.292     l2.534,2.547c0.386,0.388,0.385,1.015-0.001,1.402l-26.044,26.077C357.136,62.435,356.883,62.54,356.621,62.54z M355.51,58.979     l1.12,1.154l24.633-24.665l-1.135-1.141L355.51,58.979z"></path></g><g><polygon fill="#E3EAF2" points="321.993,61.547 295.95,35.471 298.483,32.913 324.506,58.97    "></polygon><path fill="#D3DCE6" d="M321.993,62.54c-0.262,0-0.515-0.105-0.701-0.291l-26.043-26.077c-0.386-0.386-0.387-1.012-0.003-1.401     l2.533-2.557c0.186-0.188,0.439-0.293,0.702-0.294c0.001,0,0.001,0,0.002,0c0.263,0,0.515,0.105,0.701,0.291l26.022,26.056     c0.384,0.384,0.387,1.006,0.009,1.395l-2.513,2.578c-0.185,0.19-0.439,0.298-0.704,0.3     C321.996,62.54,321.994,62.54,321.993,62.54z M297.349,35.468l24.635,24.667l1.129-1.157L298.486,34.32L297.349,35.468z"></path></g></g><g><g><path fill="#D3DCE6" d="M366.252,98.899c-0.126,0-0.252-0.047-0.349-0.143c-0.195-0.193-0.197-0.507-0.004-0.702l4.928-4.997     c0.192-0.195,0.505-0.197,0.701-0.005c0.195,0.193,0.197,0.507,0.004,0.702l-4.928,4.998     C366.508,98.849,366.38,98.899,366.252,98.899z"></path></g><g><path fill="#D3DCE6" d="M373.982,91.059c-0.126,0-0.252-0.047-0.348-0.143c-0.195-0.192-0.197-0.506-0.004-0.702l1.812-1.837     c0.193-0.195,0.506-0.198,0.701-0.005c0.195,0.193,0.197,0.507,0.004,0.702l-1.812,1.838     C374.238,91.01,374.11,91.059,373.982,91.059z"></path></g><g><path fill="#D3DCE6" d="M381.767,89.206c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.194-0.194-0.508,0-0.702l3.205-3.209     c0.194-0.194,0.507-0.194,0.701,0s0.194,0.508,0,0.702l-3.205,3.209C382.02,89.158,381.894,89.206,381.767,89.206z"></path></g><g><path fill="#D3DCE6" d="M372.503,98.482c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.194-0.194-0.508,0-0.702l6.583-6.591     c0.194-0.194,0.507-0.194,0.701,0s0.194,0.508,0,0.702l-6.583,6.591C372.757,98.434,372.63,98.482,372.503,98.482z"></path></g><g><path fill="#D3DCE6" d="M365.484,105.511c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.194-0.194-0.508,0-0.702l4.295-4.301     c0.194-0.194,0.507-0.194,0.701,0c0.194,0.194,0.194,0.508,0,0.702l-4.295,4.301     C365.737,105.462,365.611,105.511,365.484,105.511z"></path></g><g><path fill="#D3DCE6" d="M284.102,65.697c-0.128,0-0.255-0.049-0.351-0.147c-0.194-0.194-0.192-0.509,0.002-0.702l4.808-4.777     c0.195-0.193,0.508-0.191,0.701,0.003c0.194,0.194,0.192,0.509-0.002,0.702l-4.808,4.777     C284.355,65.65,284.228,65.697,284.102,65.697z"></path></g><g><path fill="#D3DCE6" d="M291.399,58.449c-0.128,0-0.255-0.049-0.351-0.147c-0.194-0.194-0.192-0.509,0.002-0.702l1.115-1.108     c0.196-0.193,0.509-0.191,0.701,0.003c0.194,0.194,0.192,0.509-0.002,0.702l-1.115,1.108     C291.652,58.401,291.525,58.449,291.399,58.449z"></path></g><g><path fill="#D3DCE6" d="M295.262,54.612c-0.128,0-0.255-0.049-0.351-0.147c-0.194-0.194-0.192-0.509,0.002-0.702l5.79-5.752     c0.196-0.193,0.509-0.191,0.701,0.003c0.194,0.194,0.192,0.509-0.002,0.702l-5.79,5.752     C295.514,54.564,295.387,54.612,295.262,54.612z"></path></g><g><path fill="#D3DCE6" d="M283.681,72.166l-0.697-0.707l1.218-1.204c0.196-0.192,0.509-0.19,0.701,0.005     c0.193,0.195,0.191,0.509-0.004,0.702L283.681,72.166z"></path></g><g><path fill="#D3DCE6" d="M363.149,67.449c-0.126,0-0.252-0.048-0.348-0.143c-0.195-0.192-0.197-0.507-0.004-0.702l4.205-4.264     c0.192-0.194,0.505-0.197,0.701-0.004c0.195,0.192,0.197,0.506,0.004,0.702l-4.205,4.263     C363.404,67.4,363.277,67.449,363.149,67.449z"></path></g><g><path fill="#D3DCE6" d="M369.395,61.118c-0.126,0-0.252-0.047-0.348-0.143c-0.196-0.192-0.197-0.506-0.006-0.702l0.829-0.839     c0.193-0.194,0.506-0.197,0.701-0.004c0.195,0.192,0.197,0.506,0.004,0.702l-0.827,0.838     C369.65,61.069,369.522,61.118,369.395,61.118z"></path></g><g><path fill="#D3DCE6" d="M372.421,58.053c-0.126,0-0.252-0.048-0.348-0.143c-0.195-0.193-0.197-0.507-0.004-0.702l5.614-5.677     c0.192-0.194,0.507-0.196,0.701-0.003c0.195,0.193,0.197,0.507,0.004,0.702l-5.614,5.676     C372.676,58.004,372.548,58.053,372.421,58.053z"></path></g><g><path fill="#D3DCE6" d="M364.371,71.946c-0.126,0-0.251-0.048-0.348-0.142c-0.196-0.192-0.197-0.506-0.006-0.702l0.732-0.744     c0.192-0.196,0.505-0.197,0.701-0.006c0.196,0.192,0.197,0.506,0.006,0.702l-0.732,0.744     C364.627,71.896,364.498,71.946,364.371,71.946z"></path></g><g><path fill="#D3DCE6" d="M367.171,69.098c-0.126,0-0.252-0.047-0.348-0.142c-0.196-0.192-0.197-0.507-0.006-0.702l4.961-5.044     c0.193-0.195,0.508-0.197,0.701-0.005c0.196,0.192,0.197,0.506,0.006,0.702l-4.961,5.044     C367.428,69.049,367.299,69.098,367.171,69.098z"></path></g><g><path fill="#D3DCE6" d="M374.549,61.597c-0.126,0-0.252-0.047-0.348-0.143c-0.196-0.192-0.197-0.506-0.006-0.702l4.36-4.43     c0.194-0.195,0.506-0.197,0.702-0.005c0.195,0.192,0.197,0.506,0.005,0.702l-4.36,4.43     C374.805,61.548,374.677,61.597,374.549,61.597z"></path></g><g><path fill="#D3DCE6" d="M381.359,54.68c-0.126,0-0.252-0.047-0.348-0.143c-0.195-0.192-0.197-0.507-0.004-0.702     c0.748-0.758,1.234-1.249,1.347-1.36c0.197-0.191,0.509-0.19,0.701,0.006c0.192,0.196,0.19,0.51-0.006,0.702     c-0.112,0.11-0.594,0.599-1.337,1.351C381.615,54.63,381.487,54.68,381.359,54.68z"></path></g><g><path fill="#D3DCE6" d="M311.357,38.995c-0.127,0-0.255-0.049-0.351-0.146c-0.193-0.194-0.193-0.508,0.002-0.702l3.624-3.609     c0.195-0.194,0.508-0.192,0.701,0.002c0.193,0.194,0.193,0.508-0.002,0.702l-3.624,3.609     C311.61,38.947,311.484,38.995,311.357,38.995z"></path></g><g><path fill="#D3DCE6" d="M317.295,33.081c-0.128,0-0.255-0.049-0.351-0.147c-0.194-0.194-0.192-0.508,0.002-0.702l0.996-0.992     c0.194-0.193,0.507-0.193,0.701,0.002c0.193,0.194,0.193,0.508-0.002,0.702l-0.996,0.993     C317.547,33.033,317.421,33.081,317.295,33.081z"></path></g><g><path fill="#D3DCE6" d="M320.607,29.784c-0.127,0-0.255-0.049-0.351-0.146c-0.193-0.194-0.193-0.508,0.002-0.702l4.34-4.319     c0.195-0.193,0.508-0.191,0.701,0.003c0.194,0.194,0.192,0.508-0.002,0.702l-4.34,4.318     C320.86,29.736,320.734,29.784,320.607,29.784z"></path></g><g><path fill="#D3DCE6" d="M313.068,43.097c-0.126,0-0.252-0.047-0.348-0.143c-0.195-0.192-0.197-0.507-0.004-0.702l0.797-0.807     c0.194-0.194,0.507-0.196,0.701-0.003c0.195,0.193,0.197,0.507,0.004,0.702l-0.797,0.805     C313.324,43.048,313.196,43.097,313.068,43.097z"></path></g><g><path fill="#D3DCE6" d="M316.287,39.841c-0.126,0-0.252-0.048-0.349-0.143c-0.195-0.193-0.197-0.507-0.004-0.702l4.212-4.258     c0.193-0.194,0.508-0.196,0.701-0.003c0.195,0.193,0.197,0.507,0.004,0.702l-4.212,4.258     C316.543,39.792,316.415,39.841,316.287,39.841z"></path></g><g><path fill="#D3DCE6" d="M322.572,33.486c-0.126,0-0.252-0.048-0.348-0.143c-0.195-0.193-0.197-0.507-0.004-0.702l0.709-0.717     c0.194-0.194,0.535-0.225,0.729-0.032c0.195,0.193,0.225,0.479,0.032,0.674l-0.765,0.773     C322.828,33.437,322.7,33.486,322.572,33.486z"></path></g><g><path fill="#D3DCE6" d="M325.314,30.714c-0.126,0-0.253-0.048-0.348-0.144c-0.195-0.193-0.197-0.507-0.004-0.702     c2.25-2.272,3.906-3.944,4.126-4.162c0.196-0.191,0.509-0.19,0.701,0.006c0.192,0.195,0.19,0.509-0.006,0.702     c-0.22,0.216-1.872,1.885-4.116,4.153C325.569,30.665,325.442,30.714,325.314,30.714z"></path></g><g><path fill="#D3DCE6" d="M287.132,68.551c-0.128,0-0.256-0.049-0.352-0.147c-0.193-0.195-0.191-0.509,0.004-0.702l8.342-8.252     c0.196-0.192,0.509-0.19,0.701,0.004c0.193,0.195,0.191,0.509-0.004,0.702l-8.342,8.251     C287.384,68.504,287.258,68.551,287.132,68.551z"></path></g><g><path fill="#D3DCE6" d="M297.71,58.088c-0.128,0-0.256-0.049-0.352-0.147c-0.193-0.195-0.191-0.509,0.004-0.702l1.94-1.92     c0.196-0.192,0.509-0.189,0.701,0.004c0.193,0.195,0.191,0.509-0.004,0.702l-1.94,1.919     C297.961,58.041,297.836,58.088,297.71,58.088z"></path></g><g><path fill="#D3DCE6" d="M284.459,99.335l-0.712-0.69c0,0,5.966-6.175,10.414-10.761c0.191-0.197,0.503-0.202,0.701-0.011     c0.197,0.191,0.2,0.505,0.01,0.702C290.424,93.161,284.459,99.335,284.459,99.335z"></path></g><g><path fill="#D3DCE6" d="M297.128,86.034c-0.125,0-0.25-0.047-0.346-0.141c-0.197-0.191-0.2-0.505-0.01-0.702     c0.75-0.771,1.35-1.385,1.722-1.761c0.193-0.194,0.506-0.198,0.701-0.004c0.195,0.192,0.197,0.507,0.004,0.702     c-0.37,0.375-0.968,0.988-1.716,1.756C297.385,85.984,297.257,86.034,297.128,86.034z"></path></g><g><path fill="#D3DCE6" d="M283.333,106.098c-0.127,0-0.255-0.049-0.351-0.146c-0.193-0.194-0.193-0.508,0.002-0.702l0.762-0.761     c0.194-0.193,0.507-0.194,0.701,0.001c0.194,0.194,0.194,0.508,0,0.702l-0.764,0.762     C283.585,106.05,283.46,106.098,283.333,106.098z"></path></g><g><path fill="#D3DCE6" d="M284.102,139.012c-0.124,0-0.248-0.047-0.345-0.14c-0.197-0.19-0.202-0.504-0.012-0.702l0.753-0.778     c0.191-0.197,0.503-0.202,0.701-0.01c0.196,0.191,0.2,0.505,0.01,0.702l-0.751,0.776     C284.362,138.962,284.232,139.012,284.102,139.012z"></path></g><g><path fill="#D3DCE6" d="M286.365,136.671c-0.124,0-0.249-0.047-0.345-0.14c-0.197-0.191-0.202-0.505-0.012-0.702l5.227-5.403     c0.191-0.196,0.505-0.201,0.701-0.011c0.197,0.19,0.201,0.505,0.012,0.702l-5.227,5.402     C286.623,136.621,286.494,136.671,286.365,136.671z"></path></g><g><path fill="#D3DCE6" d="M293.117,129.695c-0.124,0-0.249-0.047-0.345-0.14c-0.197-0.19-0.201-0.505-0.012-0.702l1.399-1.443     c0.192-0.196,0.505-0.202,0.701-0.011c0.197,0.191,0.201,0.505,0.012,0.702l-1.399,1.443     C293.375,129.644,293.246,129.695,293.117,129.695z"></path></g><g><path fill="#D3DCE6" d="M283.333,145.624c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.194-0.194-0.508,0-0.702l0.73-0.73     c0.194-0.194,0.507-0.194,0.701,0c0.194,0.194,0.194,0.509,0,0.702l-0.73,0.73C283.586,145.575,283.46,145.624,283.333,145.624z"></path></g><g><path fill="#D3DCE6" d="M287.845,141.106c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.194-0.194-0.508,0-0.702l8.4-8.408     c0.194-0.194,0.507-0.194,0.701,0c0.194,0.194,0.194,0.508,0,0.702l-8.4,8.408C288.098,141.057,287.971,141.106,287.845,141.106z     "></path></g><g><path fill="#D3DCE6" d="M299.449,129.488c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.194-0.194-0.508,0-0.702l1.09-1.091     c0.194-0.194,0.507-0.193,0.701,0c0.194,0.194,0.194,0.508,0,0.702l-1.09,1.091C299.703,129.44,299.576,129.488,299.449,129.488z     "></path></g><g><path fill="#D3DCE6" d="M302.207,126.727c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.194-0.194-0.508,0-0.702l1.501-1.502     c0.196-0.195,0.509-0.192,0.701,0.002c0.193,0.194,0.192,0.509-0.002,0.702l-1.499,1.5     C302.461,126.679,302.334,126.727,302.207,126.727z"></path></g><g><path fill="#D3DCE6" d="M286.493,102.944c-0.127,0-0.255-0.048-0.351-0.146c-0.193-0.194-0.193-0.508,0.001-0.702l4.623-4.615     c0.194-0.193,0.508-0.194,0.702,0.001c0.193,0.194,0.193,0.508-0.001,0.702l-4.623,4.615     C286.747,102.896,286.62,102.944,286.493,102.944z"></path></g><g><path fill="#D3DCE6" d="M294.113,95.339c-0.127,0-0.254-0.048-0.35-0.146c-0.194-0.194-0.194-0.508,0-0.702l1.285-1.282     c0.194-0.193,0.507-0.194,0.701,0.001c0.194,0.194,0.194,0.508,0,0.702l-1.285,1.282     C294.366,95.29,294.239,95.339,294.113,95.339z"></path></g><g><path fill="#D3DCE6" d="M297.879,91.579c-0.127,0-0.255-0.048-0.351-0.146c-0.193-0.194-0.193-0.508,0.002-0.702l4.943-4.933     c0.192-0.193,0.507-0.194,0.701,0.001c0.193,0.194,0.193,0.508-0.002,0.702l-4.943,4.933     C298.133,91.531,298.006,91.579,297.879,91.579z"></path></g><g><path fill="#D3DCE6" d="M323.726,139.811c-0.13,0-0.26-0.051-0.357-0.152c-0.19-0.198-0.184-0.512,0.014-0.702l1.506-1.45     c0.197-0.189,0.512-0.183,0.701,0.014c0.19,0.198,0.184,0.512-0.014,0.702l-1.506,1.45     C323.974,139.765,323.85,139.811,323.726,139.811z"></path></g><g><path fill="#D3DCE6" d="M326.806,136.847c-0.13,0-0.26-0.051-0.357-0.152c-0.19-0.198-0.184-0.512,0.014-0.702l8.96-8.624     c0.197-0.189,0.511-0.184,0.701,0.014s0.184,0.512-0.014,0.702l-8.96,8.624C327.053,136.801,326.929,136.847,326.806,136.847z"></path></g><g><path fill="#D3DCE6" d="M337.979,126.092c-0.13,0-0.26-0.051-0.357-0.153c-0.19-0.197-0.184-0.512,0.014-0.701l1.769-1.702     c0.197-0.189,0.512-0.184,0.701,0.014c0.19,0.198,0.184,0.512-0.014,0.702l-1.769,1.702     C338.226,126.046,338.103,126.092,337.979,126.092z"></path></g><g><path fill="#D3DCE6" d="M323.726,146.187c-0.126,0-0.252-0.048-0.349-0.143c-0.195-0.193-0.197-0.507-0.004-0.702     c0.041-0.042,4.138-4.189,6.752-6.696c0.197-0.19,0.511-0.182,0.701,0.016c0.189,0.198,0.182,0.512-0.015,0.702     c-2.604,2.497-6.692,6.635-6.733,6.676C323.982,146.137,323.854,146.187,323.726,146.187z"></path></g><g><path fill="#D3DCE6" d="M365.019,139.811c-0.128,0-0.255-0.048-0.351-0.146c-0.193-0.194-0.193-0.509,0.002-0.702l1.316-1.312     c0.194-0.194,0.507-0.194,0.701,0c0.194,0.195,0.194,0.509,0,0.702l-1.317,1.314     C365.272,139.762,365.146,139.811,365.019,139.811z"></path></g><g><path fill="#D3DCE6" d="M367.846,136.992c-0.127,0-0.255-0.048-0.351-0.146c-0.193-0.194-0.193-0.508,0.002-0.702l3.087-3.074     c0.196-0.194,0.509-0.191,0.701,0.003c0.194,0.194,0.192,0.508-0.002,0.702l-3.087,3.073     C368.098,136.944,367.973,136.992,367.846,136.992z"></path></g><g><path fill="#D3DCE6" d="M372.154,132.706c-0.128,0-0.256-0.049-0.352-0.147c-0.193-0.195-0.191-0.509,0.004-0.702     c0.552-0.547,0.966-0.954,1.144-1.126c0.197-0.189,0.51-0.184,0.701,0.013c0.19,0.197,0.184,0.511-0.014,0.702     c-0.176,0.171-0.587,0.575-1.135,1.117C372.406,132.658,372.28,132.706,372.154,132.706z"></path></g><g><path fill="#D3DCE6" d="M365.019,146.187c-0.126,0-0.253-0.048-0.349-0.144c-0.194-0.193-0.196-0.507-0.002-0.702     c0,0,1.486-1.498,3.341-3.354c0.194-0.194,0.507-0.194,0.701,0c0.194,0.194,0.194,0.508,0,0.702     c-1.853,1.854-3.339,3.352-3.339,3.352C365.274,146.138,365.147,146.187,365.019,146.187z"></path></g><g><path fill="#D3DCE6" d="M369.948,141.45l-0.371-0.331l-0.329-0.372l1.716-1.71c0.194-0.194,0.507-0.19,0.701,0.004     c0.193,0.194,0.191,0.508-0.004,0.702L369.948,141.45z M369.578,141.119h0.01H369.578z"></path></g><g><path fill="#D3DCE6" d="M372.767,138.449c-0.128,0-0.257-0.049-0.353-0.148c-0.192-0.196-0.19-0.51,0.006-0.702l0.974-0.955     c0.197-0.19,0.51-0.186,0.701,0.011s0.187,0.51-0.01,0.701l-0.97,0.951C373.018,138.402,372.893,138.449,372.767,138.449z"></path></g><g><path fill="#D3DCE6" d="M332.569,137.487c-0.131,0-0.26-0.051-0.358-0.153c-0.189-0.198-0.182-0.512,0.016-0.701l1.437-1.379     c0.197-0.189,0.511-0.182,0.701,0.015c0.189,0.198,0.182,0.512-0.016,0.702l-1.437,1.38     C332.816,137.441,332.693,137.487,332.569,137.487z"></path></g><g><path fill="#D3DCE6" d="M335.905,134.284c-0.131,0-0.26-0.051-0.357-0.153c-0.19-0.198-0.184-0.512,0.015-0.702     c4.084-3.924,6.302-6.063,6.778-6.541c0.194-0.194,0.507-0.194,0.701,0c0.194,0.193,0.194,0.508,0,0.702     c-0.481,0.482-2.703,2.626-6.794,6.555C336.152,134.238,336.029,134.284,335.905,134.284z"></path></g><g><path fill="#D3DCE6" d="M344.976,125.446c-0.127,0-0.254-0.048-0.35-0.145c-0.194-0.193-0.194-0.508,0-0.702l1.054-1.056     c0.194-0.194,0.507-0.194,0.701,0c0.194,0.194,0.194,0.508,0,0.702l-1.054,1.056C345.23,125.397,345.103,125.446,344.976,125.446     z"></path></g><g><path fill="#D3DCE6" d="M324.317,98.899c-0.128,0-0.255-0.049-0.352-0.147c-0.193-0.195-0.191-0.509,0.004-0.702l1.438-1.429     c0.196-0.193,0.509-0.191,0.701,0.003c0.194,0.194,0.192,0.509-0.002,0.702l-1.439,1.429     C324.569,98.851,324.443,98.899,324.317,98.899z"></path></g><g><path fill="#D3DCE6" d="M328.844,94.402c-0.128,0-0.255-0.049-0.351-0.147c-0.194-0.194-0.192-0.509,0.002-0.702l6.788-6.742     l0.699,0.705l-6.788,6.742C329.097,94.354,328.97,94.402,328.844,94.402z"></path></g><g><path fill="#D3DCE6" d="M324.317,104.419c-0.129,0-0.257-0.049-0.353-0.148c-0.192-0.196-0.19-0.51,0.006-0.702l10.78-10.614     c0.197-0.191,0.51-0.189,0.701,0.006c0.192,0.196,0.19,0.51-0.006,0.702l-10.78,10.614     C324.567,104.372,324.443,104.419,324.317,104.419z"></path></g><g><path fill="#D3DCE6" d="M337.766,91.18c-0.129,0-0.257-0.049-0.353-0.148c-0.192-0.196-0.19-0.51,0.006-0.702l1.294-1.274     c0.197-0.191,0.511-0.188,0.701,0.007c0.192,0.195,0.189,0.51-0.006,0.702l-1.294,1.273     C338.017,91.132,337.892,91.18,337.766,91.18z"></path></g><g><path fill="#D3DCE6" d="M341.562,87.446c-0.129,0-0.257-0.049-0.353-0.148c-0.192-0.196-0.19-0.51,0.006-0.702l1.474-1.45     c0.197-0.192,0.511-0.189,0.701,0.007c0.192,0.195,0.189,0.51-0.006,0.702l-1.474,1.45     C341.813,87.399,341.688,87.446,341.562,87.446z"></path></g></g><g><rect x="269.704" y="194.831" fill="#F7F8FC" width="139.209" height="12.901"></rect><path fill="#D3DCE6" d="M408.913,208.724H269.704c-0.548,0-0.991-0.444-0.991-0.993v-12.9c0-0.549,0.443-0.993,0.991-0.993    h139.209c0.548,0,0.991,0.444,0.991,0.993v12.9C409.904,208.28,409.461,208.724,408.913,208.724z M270.695,206.739h137.227    v-10.915H270.695V206.739z"></path></g><g><polygon fill="#EBEEF0" points="351.47,75.936 345.503,68.602 342.299,75.936 328.143,75.936 322.777,66.656 330.469,67.11     332.238,58.325 340.109,61.101 349.269,59.784 354.118,70.609   "></polygon><path fill="#D3DCE6" d="M351.47,76.929c-0.296,0-0.579-0.133-0.769-0.366l-4.94-6.073l-2.555,5.845    c-0.158,0.361-0.514,0.595-0.908,0.595h-14.155c-0.353,0-0.681-0.189-0.858-0.495l-5.367-9.28    c-0.183-0.316-0.177-0.707,0.014-1.018c0.192-0.311,0.539-0.497,0.902-0.47l6.832,0.403l1.599-7.94    c0.057-0.282,0.232-0.525,0.482-0.667s0.551-0.169,0.819-0.073l7.642,2.695l8.918-1.282c0.442-0.066,0.865,0.173,1.045,0.576    l4.85,10.825c0.122,0.271,0.115,0.583-0.016,0.849l-2.649,5.328c-0.15,0.302-0.443,0.506-0.778,0.544    C351.542,76.927,351.507,76.929,351.47,76.929z M328.714,74.944h12.936l2.946-6.74c0.138-0.317,0.432-0.539,0.774-0.585    c0.341-0.048,0.683,0.089,0.902,0.357l4.995,6.141l1.754-3.53l-4.351-9.714l-8.42,1.211c-0.161,0.022-0.32,0.007-0.47-0.046    l-6.796-2.397l-1.544,7.666c-0.099,0.485-0.567,0.819-1.03,0.794l-5.853-0.345L328.714,74.944z"></path></g><g><path fill="#EBEEF0" d="M341.102,53.475c5.049,0.218,9.387,2.052,13.016,5.495l18.385-18.409l-6.25,0.713l0.083-6.208    l-9.533,2.742l-10.399-5.222l-2.219,3.04l-3.083-2.557L341.102,53.475z"></path><path fill="#D3DCE6" d="M354.118,59.962c-0.245,0-0.49-0.09-0.681-0.272c-3.437-3.26-7.602-5.017-12.377-5.224    c-0.53-0.023-0.949-0.46-0.949-0.992l-0.001-20.407c0-0.385,0.222-0.735,0.569-0.898c0.348-0.164,0.759-0.112,1.054,0.134    l2.272,1.884l1.597-2.188c0.286-0.392,0.811-0.52,1.245-0.302l10.054,5.049l9.16-2.635c0.299-0.088,0.625-0.026,0.876,0.165    c0.249,0.191,0.393,0.489,0.389,0.802l-0.068,5.082l5.132-0.585c0.427-0.047,0.822,0.176,1.005,0.555    c0.183,0.38,0.106,0.835-0.192,1.133l-18.385,18.408C354.625,59.864,354.372,59.962,354.118,59.962z M342.093,52.543    c4.55,0.381,8.576,2.079,11.992,5.056l15.71-15.73l-3.431,0.391c-0.288,0.032-0.567-0.06-0.777-0.25    c-0.211-0.191-0.33-0.464-0.326-0.749l0.066-4.873l-8.25,2.373c-0.24,0.07-0.496,0.046-0.718-0.066l-9.649-4.846l-1.724,2.362    c-0.162,0.221-0.407,0.365-0.678,0.399c-0.277,0.033-0.546-0.046-0.755-0.221l-1.46-1.211L342.093,52.543z"></path></g><g><path fill="#D3DCE6" d="M310.456,95.858c-4.63,0-8.794-2.508-11.955-7.277c-6.835-10.314-8.064-30.578,1.102-43.167    c4.804-6.598,14.22-13.42,31.781-8.463c4.081,1.152,6.916,2.44,9.417,3.577c5.799,2.634,10.38,4.715,27.077,3.304    c0.542-0.047,1.025,0.36,1.071,0.906c0.046,0.546-0.358,1.026-0.904,1.072c-17.217,1.452-22.001-0.721-28.063-3.474    c-2.557-1.162-5.199-2.362-9.136-3.474c-16.468-4.65-25.207,1.633-29.641,7.722c-8.686,11.931-7.525,31.131-1.052,40.9    c2.388,3.602,6.584,7.579,13.012,6.065c7.156-1.684,9.179-7.976,11.135-14.061c1.871-5.82,3.815-11.837,10.912-10.538    c3.096,0.567,5.742,3.109,6.437,6.182c0.121,0.535-0.214,1.066-0.748,1.187c-0.533,0.119-1.065-0.215-1.186-0.749    c-0.524-2.319-2.523-4.239-4.859-4.667c-5.155-0.944-6.579,2.691-8.669,9.193c-1.926,5.99-4.323,13.445-12.57,15.385    C312.545,95.733,311.488,95.858,310.456,95.858z"></path></g><g><path fill="#E3EAF2" d="M325.963,72.191c1.195,0.355,2.499,0.079,3.402-0.781c1.439-1.369,1.826-3.127,1.084-5.318    c-1.111-3.28-6.326-3.9-8.937-5.225c1.981,2.734-0.059,4.833,0.72,7.509C322.77,70.222,323.865,71.568,325.963,72.191z"></path></g><g><g><path fill="#D3DCE6" d="M325.7,73.148c4.438,0.919,7.198-3.594,5.613-7.545c-1.489-3.711-6.133-4.092-9.3-5.593     c-0.84-0.398-1.918,0.451-1.356,1.358c1.539,2.487-0.164,5.252,0.849,7.929C322.257,71.284,323.734,72.466,325.7,73.148     c1.208,0.42,1.727-1.497,0.527-1.914c-5.115-1.777-1.629-7.267-3.859-10.868c-0.452,0.453-0.904,0.905-1.356,1.358     c1.946,0.922,4.095,1.348,6.014,2.329c1.187,0.607,2.156,1.337,2.571,2.661c0.712,2.27-0.604,5.093-3.37,4.521     C324.982,70.977,324.449,72.89,325.7,73.148z"></path></g></g><g><path fill="#D3DCE6" d="M290.706,63.563c-0.207,0-0.401-0.058-0.559-0.145c-0.604-0.337-0.88-1.129-0.615-1.766    c0.116-0.281,0.365-0.622,0.897-0.82c-0.166-0.192-0.335-0.347-0.468-0.431c-0.146-0.093-0.29-0.161-0.432-0.209    c0.042,0.353,0.012,0.68-0.097,0.952c-0.237,0.598-0.82,0.867-1.522,0.703c-0.793-0.186-0.993-0.661-1.043-0.927    c-0.091-0.494,0.19-1.029,0.733-1.396c0.159-0.108,0.343-0.202,0.547-0.274c-0.274-0.456-0.69-0.915-1.264-1.249    c-0.237-0.138-0.318-0.442-0.18-0.678c0.137-0.237,0.441-0.316,0.678-0.179c0.849,0.494,1.469,1.227,1.824,1.971    c0.409,0.034,0.845,0.169,1.286,0.447c0.304,0.193,0.728,0.602,1.057,1.105c0.537,0.008,1.211,0.11,2.056,0.353    c0.263,0.076,0.415,0.35,0.34,0.614c-0.075,0.263-0.351,0.415-0.613,0.34c-0.527-0.151-0.966-0.24-1.33-0.283    c0.003,0.016,0.007,0.033,0.01,0.05c0.089,0.453,0.013,0.864-0.221,1.189C291.457,63.396,291.06,63.563,290.706,63.563z     M290.975,61.707c-0.316,0.07-0.476,0.202-0.528,0.325c-0.077,0.188,0.036,0.437,0.182,0.519c0.101,0.055,0.221-0.011,0.356-0.2    c0.026-0.037,0.106-0.149,0.053-0.421C291.026,61.857,291.003,61.783,290.975,61.707z M288.522,60.17    c-0.137,0.044-0.26,0.104-0.365,0.175c-0.258,0.175-0.32,0.352-0.313,0.394c0.002,0.01,0.066,0.088,0.294,0.141    c0.3,0.072,0.347-0.033,0.375-0.103C288.569,60.636,288.574,60.422,288.522,60.17z"></path></g><g><path fill="#D3DCE6" d="M330.244,88.699c-0.106,0-0.21-0.014-0.306-0.038c-0.739-0.187-1.256-0.952-1.155-1.706    c0.047-0.353,0.235-0.819,0.822-1.197c-0.28-0.201-0.561-0.352-0.767-0.417c-0.247-0.078-0.48-0.112-0.697-0.113    c0.186,0.411,0.268,0.815,0.227,1.167c-0.084,0.709-0.615,1.147-1.418,1.171c-0.895,0.015-1.243-0.416-1.37-0.682    c-0.234-0.497-0.084-1.146,0.393-1.695c0.159-0.183,0.358-0.358,0.591-0.506c-0.456-0.465-1.092-0.893-1.885-1.109    c-0.264-0.072-0.419-0.345-0.348-0.61c0.073-0.264,0.346-0.416,0.609-0.348c1.079,0.295,1.989,0.943,2.601,1.675    c0.469-0.094,1.007-0.08,1.592,0.104c0.409,0.128,1.002,0.472,1.507,0.933c0.601-0.157,1.389-0.247,2.43-0.227    c0.274,0.005,0.491,0.232,0.486,0.506c-0.006,0.274-0.198,0.49-0.505,0.487c-0.689-0.015-1.244,0.024-1.695,0.098    c0.028,0.049,0.054,0.098,0.078,0.148c0.224,0.46,0.259,0.921,0.104,1.333C331.25,88.438,330.712,88.699,330.244,88.699z     M330.359,86.476c-0.383,0.181-0.565,0.402-0.593,0.612c-0.038,0.276,0.193,0.555,0.415,0.612    c0.173,0.041,0.319-0.081,0.431-0.378c0.058-0.155,0.037-0.334-0.068-0.548C330.496,86.673,330.433,86.574,330.359,86.476z     M327.163,85.481c-0.178,0.103-0.327,0.228-0.442,0.361c-0.239,0.276-0.287,0.527-0.244,0.618c0.03,0.063,0.162,0.123,0.444,0.115    c0.429-0.013,0.451-0.197,0.463-0.296C327.408,86.079,327.331,85.794,327.163,85.481z"></path></g><g><path fill="#E3EAF2" d="M308.191,39.416c-5.568-1.908-9.632,5.291-5.574,9.559c0.908,0.955,2.03,1.738,3.404,2.456    c3.341,1.747,9.165,0.222,11.928-4.614c-5.857-2.199-6.611-5.509-8.593-6.829C308.989,39.743,308.599,39.556,308.191,39.416z"></path></g><g><g><path fill="#D3DCE6" d="M308.454,38.459c-6.277-1.808-10.962,5.701-6.943,10.75c4.887,6.138,13.473,4.305,17.293-1.89     c0.368-0.596-0.021-1.229-0.592-1.458c-2.528-1.012-4.485-2.46-6.212-4.538C310.932,40.037,310.031,39.109,308.454,38.459     c-1.179-0.486-1.692,1.434-0.527,1.914c1.748,0.72,2.639,2.478,3.923,3.767c1.663,1.671,3.662,2.764,5.836,3.634     c-0.197-0.486-0.395-0.972-0.592-1.458c-2.719,4.409-8.081,6.306-12.449,3.118c-1.983-1.447-3.23-3.638-2.415-6.102     c0.837-2.531,3.195-3.681,5.698-2.959C309.156,40.727,309.68,38.812,308.454,38.459z"></path></g></g><g><path fill="#E3EAF2" d="M343.979,43.317c-5.446-7.136,0.577-15.125,8.532-16.152c1.044,2.747,0.538,6.719-0.247,9.628    C351.545,39.455,346.992,44.024,343.979,43.317"></path></g><g><g><path fill="#D3DCE6" d="M344.835,42.816c-4.824-6.744,0.773-13.583,7.94-14.694c-0.406-0.231-0.813-0.462-1.219-0.693     c0.969,2.965,0.787,7.108-0.592,9.939c-1.043,2.141-4.082,5.377-6.721,4.992c-1.248-0.182-1.787,1.731-0.527,1.914     c3.433,0.5,6.588-2.31,8.393-4.975c2.239-3.306,2.573-8.683,1.358-12.398c-0.181-0.554-0.666-0.779-1.219-0.693     c-8.42,1.305-14.646,9.89-9.125,17.61C343.859,44.847,345.58,43.857,344.835,42.816L344.835,42.816z"></path></g></g><g><path fill="#E3EAF2" d="M301.803,90.194c-3.172-4.637-14.135-6.073-10.718,11.052C294.142,96.986,306.915,95.941,301.803,90.194z"></path><path fill="#D3DCE6" d="M291.086,102.239c-0.07,0-0.139-0.007-0.209-0.022c-0.386-0.084-0.685-0.388-0.763-0.776    c-2.134-10.697,1.309-13.882,3.552-14.829c3.281-1.382,7.164,0.458,8.918,2.969c1.135,1.294,1.586,2.551,1.337,3.735    c-0.48,2.293-3.347,3.607-6.382,4.999c-2.292,1.051-4.661,2.137-5.647,3.511C291.702,102.088,291.4,102.239,291.086,102.239z     M296.032,88.132c-0.551,0-1.091,0.096-1.596,0.309c-2.602,1.098-3.557,4.983-2.699,10.772c1.374-1.053,3.196-1.888,4.976-2.704    c2.341-1.073,4.993-2.289,5.268-3.601c0.115-0.549-0.194-1.24-0.919-2.054c-0.027-0.032-0.053-0.064-0.077-0.099    C299.993,89.306,297.957,88.132,296.032,88.132z"></path></g><g><path fill="#E3EAF2" d="M295.98,72.234c-1.184,0.477-1.615,1.935-0.897,2.992c1.772,2.604,3.421,4.944,7.022,4.538    c4.391-0.496,5.674-3.636,7.356-7.226c-2.67,1.273-5.416,1.051-8.108-0.297C300.14,71.634,297.793,71.504,295.98,72.234z"></path></g><g><g><path fill="#D3DCE6" d="M295.48,71.377c-4.419,2.629,1.021,8.445,4.295,9.251c5.523,1.36,8.559-3.343,10.542-7.589     c0.315-0.675-0.234-1.83-1.119-1.458c-3.142,1.32-5.087,0.395-8.086-0.501c-1.776-0.531-3.655-0.383-5.395,0.197     c-1.204,0.402-0.688,2.32,0.527,1.914c2.902-0.969,4.595,0.268,7.28,0.906c2.124,0.505,4.204,0.236,6.201-0.602     c-0.373-0.486-0.746-0.972-1.119-1.458c-1.14,2.441-2.24,5.311-4.953,6.34c-1.743,0.662-3.632,0.61-5.13-0.556     c-0.881-0.686-3.904-3.623-2.042-4.73C297.576,72.439,296.58,70.722,295.48,71.377z"></path></g></g><g><path fill="#E3EAF2" d="M323.28,35.785c-4.1,2.219-3.846,5.916-2.423,7.53c2.806,3.181,9.288,4.804,11.914,3.196    C328.644,43.592,331.212,32.834,323.28,35.785z"></path><path fill="#D3DCE6" d="M329.984,48.122c-3.371,0-7.653-1.638-9.869-4.15c-0.96-1.088-1.383-2.736-1.105-4.301    c0.343-1.929,1.692-3.619,3.799-4.76c0.041-0.022,0.083-0.041,0.126-0.057c1.945-0.724,3.499-0.759,4.752-0.109    c1.992,1.034,2.648,3.517,3.282,5.918c0.535,2.029,1.089,4.127,2.376,5.036c0.272,0.193,0.43,0.51,0.418,0.844    c-0.011,0.334-0.189,0.64-0.473,0.814C332.433,47.882,331.275,48.122,329.984,48.122z M323.69,36.691    c-1.957,1.08-2.565,2.403-2.73,3.328c-0.171,0.968,0.079,2.003,0.64,2.639c2.166,2.455,6.718,3.808,9.367,3.425    c-0.977-1.355-1.452-3.155-1.917-4.912c-0.547-2.074-1.064-4.034-2.277-4.663C326.069,36.141,325.031,36.203,323.69,36.691z"></path></g><g><path fill="#E3EAF2" d="M296.046,77.08c2.242-4.204-0.97-13.023-12.497-3.747C287.946,73.969,293.73,83.18,296.046,77.08z"></path><path fill="#D3DCE6" d="M293.768,80.152c-1.754,0-3.621-1.456-5.583-2.986c-1.671-1.303-3.399-2.65-4.777-2.85    c-0.391-0.056-0.711-0.34-0.815-0.721c-0.104-0.381,0.028-0.788,0.336-1.035c7.284-5.864,11.095-4.475,12.721-3.127    c2.378,1.974,2.524,5.701,1.301,8.058c-0.546,1.404-1.347,2.262-2.379,2.552C294.306,80.117,294.039,80.152,293.768,80.152z     M285.625,73.003c1.267,0.638,2.537,1.628,3.778,2.596c1.693,1.321,3.614,2.815,4.634,2.532c0.408-0.114,0.772-0.587,1.083-1.404    c0.015-0.039,0.032-0.078,0.052-0.115c0.873-1.638,0.765-4.362-0.788-5.651C292.628,69.503,289.482,70.254,285.625,73.003z"></path></g><g><path fill="#F7F8FC" d="M314.526,94.596c-0.535,1.238-2.039,1.718-3.193,1.024c-2.977-1.792-5.455-3.391-5.256-7.48    c0.24-4.947,3.653-6.606,7.538-8.744c-1.23,3.078,1.029,5.683,1.562,8.569C315.464,89.512,315.416,92.535,314.526,94.596z"></path></g><g><g><path fill="#D3DCE6" d="M313.67,94.095c-1.2,1.944-4.669-1.078-5.455-2.056c-1.262-1.571-1.422-3.761-0.869-5.653     c0.93-3.182,4.086-4.662,6.769-6.134c-0.485-0.374-0.971-0.747-1.456-1.121c-0.795,2.539,0.037,4.581,0.92,6.973     c0.995,2.695,1.007,5.522-0.009,8.228c-0.45,1.197,1.466,1.714,1.912,0.528c0.782-2.081,1.04-4.447,0.727-6.653     c-0.419-2.947-2.594-5.491-1.637-8.547c0.267-0.854-0.725-1.522-1.456-1.121c-4.577,2.511-9.282,5.896-7.838,11.92     c0.866,3.611,7.236,9.284,10.104,4.638C316.055,94.007,314.341,93.009,313.67,94.095z"></path></g></g><g><path fill="#F7F8FC" d="M304.963,43.723c5.342-6.32-5.266-16.444-14.831-8.499C296.9,38.325,299.579,50.879,304.963,43.723z"></path></g><g><g><path fill="#D3DCE6" d="M305.664,44.425c2.812-3.606,1.817-8.175-1.717-10.922c-4.54-3.53-10.282-2.314-14.516,1.019     c-0.487,0.384-0.326,1.298,0.201,1.559c3.965,1.967,5.718,6.125,8.769,9.083C300.932,47.618,303.533,47.111,305.664,44.425     c0.785-0.99-0.609-2.404-1.402-1.404c-0.982,1.238-2.06,2.411-3.631,1.447c-1.252-0.769-2.205-2.257-3.081-3.395     c-1.973-2.564-3.953-5.237-6.918-6.707c0.067,0.52,0.134,1.039,0.201,1.559c3.278-2.581,7.673-3.654,11.367-1.241     c2.813,1.838,4.31,5.454,2.062,8.337C303.486,44.016,304.879,45.431,305.664,44.425z"></path></g></g><g><path fill="#E3EAF2" d="M311.651,94.167c2.153-1.517,7.377-2.649,10.009-1.641c3.647,1.395,5.329,7.366,4.457,10.806    c-3.919-1.578-5.953,1.652-10.007,0.374C312.549,102.583,310.397,97.788,311.651,94.167"></path></g><g><g><path fill="#D3DCE6" d="M312.151,95.025c2.479-1.589,7.257-2.911,9.954-1.153c2.729,1.779,3.692,6.213,3.056,9.196     c0.406-0.231,0.813-0.462,1.219-0.693c-3.229-1.095-5.57,0.844-8.724,0.603c-4.071-0.311-6.096-4.969-5.05-8.547     c0.359-1.228-1.553-1.753-1.912-0.528c-1.028,3.515,0.206,7.636,3.24,9.794c1.464,1.042,3.254,1.439,5.029,1.241     c2.483-0.277,4.346-1.513,6.889-0.65c0.486,0.165,1.112-0.191,1.219-0.693c0.807-3.785-0.356-8.678-3.531-11.119     c-3.323-2.554-9.137-1.253-12.39,0.833C310.079,93.997,311.072,95.716,312.151,95.025L312.151,95.025z"></path></g></g><g><path fill="#F7F8FC" d="M317.208,37.061c-2.89-2.19-3.264-5.593-2.174-8.029c1.595-3.568,4.748-6.329,10.61-4.925    c-4.857,5.133-1.441,7.63-1.552,10.634C323.949,38.606,319.98,39.161,317.208,37.061z"></path></g><g><g><path fill="#D3DCE6" d="M317.909,36.359c-2.752-2.306-3.094-5.595-1.084-8.525c2.025-2.951,5.225-3.471,8.554-2.77     c-0.146-0.553-0.292-1.106-0.437-1.659c-2.077,2.32-3.397,4.809-2.634,7.952c0.267,1.1,0.863,2.227,0.791,3.384     c-0.2,3.215-3.469,2.78-5.392,1.463c-1.056-0.723-2.048,0.996-1.001,1.714c2.665,1.825,6.992,1.997,8.138-1.685     c0.493-1.585,0.063-3.046-0.384-4.57c-0.82-2.799-0.076-4.666,1.882-6.854c0.466-0.52,0.335-1.496-0.437-1.659     c-4.214-0.888-8.292-0.078-10.793,3.682c-2.434,3.658-2.029,8.063,1.394,10.931C317.48,38.578,318.889,37.18,317.909,36.359z"></path></g></g><g><polygon fill="#EBEEF0" points="398.778,156.191 388.267,156.191 386.601,148.985 384.036,146.891 382.664,155.883     376.818,155.883 373.465,142.188 379.933,139.315 374.888,126.498 379.085,119.658 391.473,119.658 394.165,127.24     398.778,125.596   "></polygon><path fill="#D3DCE6" d="M398.778,157.183h-10.511c-0.462,0-0.862-0.319-0.966-0.769l-1.59-6.875l-0.956-0.781l-1.11,7.275    c-0.074,0.485-0.49,0.842-0.98,0.842h-5.846c-0.457,0-0.854-0.312-0.963-0.756l-3.353-13.695    c-0.114-0.467,0.122-0.949,0.561-1.144l5.599-2.488l-4.697-11.931c-0.114-0.29-0.085-0.617,0.078-0.883l4.197-6.84    c0.18-0.294,0.499-0.473,0.844-0.473h12.387c0.419,0,0.794,0.264,0.934,0.66l2.361,6.646l3.678-1.311    c0.3-0.11,0.639-0.063,0.903,0.124c0.263,0.186,0.42,0.488,0.42,0.811v30.595C399.769,156.739,399.326,157.183,398.778,157.183z     M389.055,155.198h8.732v-28.196l-3.289,1.172c-0.247,0.09-0.521,0.075-0.757-0.038c-0.238-0.113-0.421-0.316-0.509-0.564    l-2.459-6.922H379.64l-3.648,5.945l4.864,12.354c0.195,0.495-0.035,1.056-0.521,1.272l-5.709,2.537l2.97,12.132h4.218l1.243-8.151    c0.053-0.352,0.291-0.648,0.623-0.776c0.329-0.128,0.708-0.068,0.983,0.158l2.564,2.095c0.17,0.139,0.289,0.331,0.34,0.545    L389.055,155.198z"></path></g><g><polygon fill="#EBEEF0" points="104.144,27.537 110.248,18.21 122.108,24.071 122.108,44.867 114.914,52.166 110.555,51.544     102.307,52.166 90.414,40.257 93.374,28.179   "></polygon><path fill="#D3DCE6" d="M114.914,53.159c-0.046,0-0.093-0.003-0.14-0.01l-4.252-0.607l-8.14,0.614    c-0.296,0.021-0.572-0.083-0.775-0.288L89.713,40.959c-0.245-0.245-0.345-0.601-0.262-0.938l2.96-12.079    c0.104-0.423,0.47-0.728,0.904-0.754l10.273-0.613l5.831-8.91c0.274-0.42,0.819-0.568,1.268-0.347l11.86,5.861    c0.338,0.167,0.553,0.512,0.553,0.89v20.797c0,0.261-0.103,0.511-0.286,0.697l-7.194,7.299    C115.432,53.053,115.177,53.159,114.914,53.159z M91.51,39.951l11.177,11.191l7.794-0.587c0.072-0.005,0.143-0.003,0.214,0.007    l3.864,0.552l6.558-6.653V24.688l-10.521-5.199l-5.623,8.592c-0.172,0.262-0.457,0.428-0.77,0.446l-10.041,0.599L91.51,39.951z     M104.144,27.537h0.01H104.144z"></path></g><g><polygon fill="#EBEEF0" points="64.435,176.37 70.637,166.271 78.672,168.517 93.63,166.829 93.059,183.433 82.125,194.486     79.033,188.996 69.141,192.622 72.955,180.6   "></polygon><path fill="#D3DCE6" d="M82.125,195.479c-0.044,0-0.088-0.003-0.132-0.009c-0.308-0.042-0.578-0.225-0.731-0.496l-2.679-4.755    l-9.101,3.336c-0.354,0.13-0.753,0.046-1.026-0.215c-0.273-0.263-0.374-0.657-0.259-1.018l3.556-11.212l-7.758-3.852    c-0.249-0.123-0.436-0.347-0.512-0.615c-0.077-0.268-0.038-0.556,0.108-0.794l6.202-10.099c0.232-0.378,0.686-0.557,1.111-0.436    l7.849,2.193l14.767-1.666c0.286-0.03,0.572,0.062,0.784,0.258c0.212,0.196,0.327,0.475,0.318,0.763l-0.572,16.604    c-0.009,0.25-0.111,0.487-0.287,0.665L82.83,195.185C82.642,195.374,82.388,195.479,82.125,195.479z M79.033,188.004    c0.349,0,0.683,0.185,0.863,0.505l2.448,4.346l9.737-9.845l0.518-15.066l-13.817,1.56c-0.128,0.013-0.255,0.003-0.378-0.031    l-7.315-2.044l-5.241,8.535l7.547,3.747c0.438,0.217,0.652,0.722,0.504,1.189l-3.202,10.095l7.994-2.931    C78.804,188.023,78.919,188.004,79.033,188.004z"></path></g><g><path fill="#D3DCE6" d="M70.637,166.767c-0.143,0-0.284-0.061-0.382-0.179l-3.077-3.721c-0.148-0.179-0.152-0.437-0.01-0.62    l2.137-2.764c0.168-0.217,0.479-0.256,0.696-0.089c0.216,0.168,0.256,0.48,0.089,0.696l-1.894,2.45l2.824,3.415    c0.174,0.211,0.145,0.524-0.066,0.699C70.861,166.729,70.749,166.767,70.637,166.767z"></path></g><g><path fill="#D3DCE6" d="M93.63,167.326c-0.199,0-0.387-0.121-0.463-0.319c-0.098-0.256,0.03-0.543,0.286-0.641l3.404-1.307    l-0.465-2.415c-0.052-0.269,0.124-0.529,0.393-0.582c0.269-0.052,0.528,0.124,0.581,0.394l0.544,2.824    c0.045,0.237-0.085,0.471-0.31,0.557l-3.792,1.455C93.749,167.315,93.689,167.326,93.63,167.326z"></path></g><g><line fill="#E3EAF2" x1="93.059" y1="183.433" x2="96.503" y2="185.316"></line><path fill="#D3DCE6" d="M96.502,185.812c-0.08,0-0.162-0.019-0.237-0.061l-3.444-1.883c-0.24-0.131-0.329-0.432-0.197-0.673    c0.132-0.241,0.433-0.331,0.673-0.198l3.444,1.883c0.24,0.131,0.329,0.432,0.197,0.673    C96.848,185.719,96.678,185.812,96.502,185.812z"></path></g><g><path fill="#D3DCE6" d="M80.98,165.19c-0.135,0-0.269-0.054-0.367-0.163l-1.947-2.144c-0.089-0.098-0.136-0.229-0.128-0.362    c0.007-0.133,0.068-0.257,0.167-0.345l3.144-2.764c0.206-0.179,0.519-0.16,0.699,0.046c0.181,0.206,0.161,0.52-0.045,0.701    l-2.765,2.431l1.608,1.771c0.184,0.203,0.169,0.517-0.033,0.701C81.218,165.148,81.099,165.19,80.98,165.19z"></path></g><g><path fill="#D3DCE6" d="M67.56,232.147c-0.274,0-0.496-0.222-0.496-0.496c0-0.612-0.497-1.109-1.107-1.109    c-0.61,0-1.107,0.497-1.107,1.109c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-0.612-0.497-1.109-1.107-1.109s-1.107,0.497-1.107,1.109c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-0.612-0.497-1.109-1.107-1.109c-0.61,0-1.107,0.497-1.107,1.109c0,0.274-0.222,0.496-0.496,0.496    c-0.274,0-0.496-0.222-0.496-0.496c0-1.158,0.941-2.101,2.098-2.101c0.642,0,1.218,0.29,1.603,0.746    c0.385-0.457,0.961-0.746,1.603-0.746s1.217,0.29,1.603,0.746c0.385-0.457,0.961-0.746,1.603-0.746    c1.157,0,2.099,0.943,2.099,2.101C68.056,231.926,67.834,232.147,67.56,232.147z"></path></g><g><path fill="#D3DCE6" d="M46.704,224.486c-0.274,0-0.496-0.222-0.496-0.496c0-0.612-0.497-1.109-1.107-1.109    s-1.107,0.497-1.107,1.109c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-0.612-0.497-1.109-1.107-1.109    c-0.61,0-1.107,0.497-1.107,1.109c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-1.158,0.941-2.101,2.098-2.101c0.642,0,1.218,0.29,1.603,0.746c0.385-0.457,0.961-0.746,1.603-0.746    c1.157,0,2.098,0.943,2.098,2.101C47.199,224.264,46.978,224.486,46.704,224.486z"></path></g><g><path fill="#D3DCE6" d="M56.391,121.861c-0.274,0-0.496-0.222-0.496-0.496c0-0.611-0.497-1.108-1.107-1.108    s-1.107,0.497-1.107,1.108c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-0.611-0.497-1.108-1.107-1.108    c-0.61,0-1.107,0.497-1.107,1.108c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-1.158,0.941-2.101,2.098-2.101c0.642,0,1.218,0.29,1.603,0.746c0.385-0.456,0.961-0.746,1.603-0.746    c1.157,0,2.098,0.943,2.098,2.101C56.887,121.639,56.665,121.861,56.391,121.861z"></path></g><g><path fill="#D3DCE6" d="M423.65,218.969c-0.274,0-0.496-0.222-0.496-0.496c0-0.611-0.497-1.108-1.106-1.108    c-0.611,0-1.107,0.497-1.107,1.108c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-0.611-0.497-1.108-1.107-1.108    c-0.61,0-1.106,0.497-1.106,1.108c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-0.611-0.497-1.108-1.107-1.108    c-0.611,0-1.107,0.497-1.107,1.108c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-1.158,0.942-2.1,2.099-2.1    c0.642,0,1.218,0.29,1.603,0.746c0.385-0.457,0.96-0.746,1.602-0.746c0.642,0,1.218,0.29,1.603,0.746    c0.385-0.457,0.961-0.746,1.603-0.746c1.157,0,2.098,0.942,2.098,2.1C424.146,218.747,423.924,218.969,423.65,218.969z"></path></g><g><path fill="#D3DCE6" d="M423.739,206.445c-0.274,0-0.496-0.222-0.496-0.496c0-0.612-0.497-1.109-1.107-1.109    c-0.61,0-1.106,0.497-1.106,1.109c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-0.612-0.497-1.109-1.107-1.109c-0.61,0-1.106,0.497-1.106,1.109c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496    c0-1.158,0.941-2.101,2.098-2.101c0.642,0,1.218,0.29,1.603,0.746c0.385-0.457,0.96-0.746,1.602-0.746    c1.157,0,2.099,0.943,2.099,2.101C424.235,206.223,424.013,206.445,423.739,206.445z"></path></g><g><path fill="#D3DCE6" d="M393.731,230.261c-0.274,0-0.496-0.222-0.496-0.496c0-0.612-0.497-1.109-1.106-1.109    c-0.611,0-1.107,0.497-1.107,1.109c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-0.612-0.497-1.109-1.107-1.109    c-0.61,0-1.106,0.497-1.106,1.109c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-1.158,0.941-2.101,2.098-2.101c0.642,0,1.218,0.29,1.603,0.746c0.385-0.457,0.961-0.746,1.603-0.746    c1.157,0,2.098,0.943,2.098,2.101C394.226,230.039,394.005,230.261,393.731,230.261z"></path></g><g><path fill="#D3DCE6" d="M56.391,159.691c-0.274,0-0.496-0.222-0.496-0.496c0-0.611-0.497-1.108-1.107-1.108    s-1.107,0.497-1.107,1.108c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-0.611-0.497-1.108-1.107-1.108    c-0.61,0-1.107,0.497-1.107,1.108c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496c0-1.158,0.941-2.1,2.098-2.1    c0.642,0,1.218,0.29,1.603,0.746c0.385-0.457,0.961-0.746,1.603-0.746c1.157,0,2.098,0.942,2.098,2.1    C56.887,159.469,56.665,159.691,56.391,159.691z"></path></g><g><path fill="#E3EAF2" d="M194.7,33.068c4.614,0.41,8.779-0.518,12.644,2.686c3.837,3.181,3.573,7.229,0.75,11.226    c-1.07-0.856-1.669-1.939-2.961-2.581c-1.813-0.9-3.873-0.652-5.658-1.743C196.497,40.836,196.553,35.804,194.7,33.068"></path></g><g><g><path fill="#D3DCE6" d="M194.7,34.06c3.546,0.261,7.579-0.321,10.767,1.583c4.449,2.656,4.411,6.885,1.771,10.836     c0.519-0.067,1.038-0.134,1.557-0.201c-1.125-0.996-2.021-2.171-3.398-2.836c-1.83-0.883-4.147-0.6-5.765-1.924     c-2.506-2.051-2.43-6.266-4.076-8.951c-0.666-1.087-2.382-0.091-1.712,1.002c1.685,2.748,1.652,6.391,3.857,8.854     c1.058,1.182,2.447,1.722,3.968,2.058c1.134,0.251,2.172,0.389,3.188,0.985c0.994,0.582,1.677,1.456,2.535,2.216     c0.498,0.441,1.187,0.352,1.557-0.201c2.554-3.823,3.261-8.376-0.27-11.858c-3.864-3.81-9.019-3.182-13.98-3.547     C193.427,31.981,193.433,33.967,194.7,34.06L194.7,34.06z"></path></g></g><g><path fill="#E3EAF2" d="M180.789,41.537c-2.287,0.35-6.286,2.815-7.343,5.057c-1.464,3.106,1.097,7.917,3.74,9.566    c1.525-3.388,4.778-2.579,6.572-5.859C185.334,47.42,183.784,43.069,180.789,41.537"></path></g><g><g><path fill="#D3DCE6" d="M180.526,40.58c-3.224,0.657-7.475,3.198-8.322,6.612c-0.911,3.668,1.562,7.796,4.483,9.825     c0.426,0.296,1.122,0.092,1.356-0.356c1.758-3.354,6.273-3.332,7.179-7.54c0.715-3.318-1.083-6.769-3.932-8.44     c-1.103-0.647-2.102,1.068-1.001,1.714c3.135,1.839,4.445,6.599,1.175,9.011c-1.973,1.455-3.919,1.938-5.133,4.254     c0.452-0.119,0.904-0.237,1.356-0.356c-2.317-1.609-4.617-5.426-3.319-8.269c1.062-2.326,4.293-4.052,6.685-4.539     C182.302,42.24,181.774,40.326,180.526,40.58L180.526,40.58z"></path></g></g><g><path fill="#E3EAF2" d="M194.275,36.718c-3.581,1.756-5.816-0.861-6.799-3.136c-1.361-3.153,1.081-8.949,3.777-10.51    c1.413,3.437,4.558,3.109,6.243,6.446C198.976,32.449,197.318,35.286,194.275,36.718z"></path></g><g><g><path fill="#D3DCE6" d="M194.012,35.761c-3.29,1.37-6.024-1.281-5.92-4.633c0.08-2.585,1.465-5.751,3.662-7.199     c-0.452-0.119-0.904-0.237-1.356-0.356c0.929,1.949,2.393,2.862,4.08,4.081c3.481,2.515,3.021,6.255-0.703,8.207     c-1.131,0.593-0.13,2.307,1.001,1.714c2.847-1.492,5.049-4.3,3.964-7.647c-1.144-3.528-5.121-4.192-6.63-7.357     c-0.222-0.467-0.937-0.632-1.356-0.356c-3.122,2.058-5.222,6.766-4.548,10.48c0.73,4.023,4.476,6.587,8.333,4.98     C195.7,37.192,195.19,35.27,194.012,35.761z"></path></g></g><g><path fill="#D3DCE6" d="M181.54,43.77c-0.954,0-1.824-0.149-2.62-0.442c-4.143-1.526-5.41-6.692-6.751-12.162    c-2.462-10.036-5.251-21.411-25.709-16.385c-0.744,0.183-1.514,0.423-2.287,0.713c-0.509,0.193-1.083-0.067-1.276-0.582    c-0.192-0.513,0.068-1.085,0.581-1.277c0.846-0.317,1.691-0.581,2.51-0.782c22.382-5.498,25.69,7.989,28.106,17.839    c1.265,5.157,2.358,9.611,5.511,10.772c3.408,1.256,9.4-1.264,18.322-7.706c0.445-0.319,1.065-0.22,1.384,0.224    c0.32,0.445,0.22,1.065-0.224,1.386C191.183,41.074,185.6,43.769,181.54,43.77z"></path></g><g><path fill="#F7F8FC" d="M198.277,36.8c-2.852-1.178-13.149-0.104-3.548,11.614C195.383,43.938,207.021,40.507,198.277,36.8z"></path><path fill="#D3DCE6" d="M194.729,49.406c-0.292,0-0.575-0.13-0.766-0.363c-4.109-5.015-5.243-8.84-3.372-11.37    c1.907-2.577,6.263-2.537,8.065-1.791c0.003,0.001,0.006,0.002,0.008,0.003c2.389,1.013,3.602,2.119,3.815,3.483    c0.305,1.939-1.516,3.515-3.445,5.183c-1.47,1.272-3.135,2.713-3.325,4.006c-0.057,0.389-0.337,0.708-0.715,0.813    C194.907,49.395,194.817,49.406,194.729,49.406z M196.027,37.421c-1.42,0-3.078,0.4-3.843,1.434    c-1.089,1.472-0.281,4.141,2.272,7.596c0.775-1.232,2.043-2.33,3.283-3.402c1.367-1.183,2.916-2.523,2.783-3.372    c-0.043-0.273-0.385-1.011-2.625-1.961C197.445,37.531,196.768,37.421,196.027,37.421z"></path></g><g><path fill="#D3DCE6" d="M186.402,41.803c-0.076,0-0.152-0.017-0.225-0.054c-0.597-0.305-1.996-1.02-2.143-2.426    c-0.022-0.204,0.018-0.41,0.1-0.607c-0.348-0.301-0.615-0.635-0.732-0.813c-0.182-0.276-0.417-0.995-0.395-1.654    c-1.075-1.207-1.182-2.632-0.268-3.756c0.173-0.212,0.485-0.245,0.697-0.072c0.212,0.173,0.244,0.486,0.072,0.698    c-0.63,0.775-0.394,1.542-0.061,2.069c0.195-0.155,0.519-0.294,1.009-0.164c0.41,0.109,0.686,0.423,0.72,0.82    c0.035,0.412-0.197,0.805-0.575,0.978c-0.106,0.047-0.295,0.11-0.534,0.083c0.043,0.187,0.1,0.354,0.163,0.451    c0.128,0.194,0.319,0.406,0.521,0.583c0.177-0.133,0.369-0.231,0.555-0.275c0.526-0.128,0.995,0.14,1.198,0.676    c0.056,0.146,0.039,0.31-0.045,0.442c-0.227,0.358-0.57,0.556-0.965,0.56c-0.159-0.017-0.314-0.029-0.468-0.08    c0.105,0.743,0.867,1.227,1.603,1.603c0.244,0.125,0.341,0.424,0.216,0.667C186.757,41.704,186.583,41.803,186.402,41.803z"></path></g><g><path fill="#E3EAF2" d="M173.117,30.422c-2.013-1.394-1.899-2.895-0.919-4.315c1.023-1.483,3.363-0.411,5.282-2.041    C179.656,28.533,177.404,33.28,173.117,30.422z"></path><path fill="#D3DCE6" d="M175.524,32.284c-0.805,0-1.794-0.261-2.956-1.035c-0.005-0.003-0.01-0.007-0.015-0.01    c-2.226-1.542-2.642-3.564-1.171-5.695c0.76-1.101,1.938-1.251,2.978-1.383c0.893-0.113,1.737-0.221,2.478-0.851    c0.233-0.198,0.546-0.278,0.845-0.214c0.3,0.063,0.553,0.261,0.688,0.536c1.446,2.968,1.205,6.253-0.573,7.809    C177.423,31.769,176.654,32.284,175.524,32.284z M173.674,29.601c0.686,0.456,1.957,1.102,2.819,0.346    c0.806-0.706,1.14-2.452,0.514-4.408c-0.843,0.393-1.68,0.499-2.396,0.59c-0.952,0.121-1.363,0.204-1.597,0.543    C172.302,27.703,172.164,28.553,173.674,29.601z"></path></g><g><path fill="#F7F8FC" d="M198.091,37.5c-4.428-0.525-3.328-4.396-1.764-6.546c1.711-2.352,5.018-0.822,6.74-4.015    C206.197,29.348,203.852,37.434,198.091,37.5z"></path><path fill="#D3DCE6" d="M198.091,38.493c-0.039,0-0.078-0.002-0.117-0.007c-2.349-0.279-3.31-1.409-3.702-2.308    c-0.821-1.883,0.109-4.235,1.253-5.808c0.994-1.366,2.378-1.698,3.6-1.991c1.308-0.314,2.342-0.562,3.07-1.91    c0.138-0.256,0.381-0.439,0.666-0.499c0.284-0.061,0.58,0.007,0.811,0.184c1.72,1.324,2.255,4.078,1.331,6.853    c-1.099,3.298-3.806,5.452-6.899,5.488C198.099,38.493,198.095,38.493,198.091,38.493z M203.118,28.567    c-1.078,1.153-2.412,1.473-3.531,1.742c-1.175,0.282-1.922,0.492-2.458,1.23c-0.818,1.124-1.492,2.807-1.039,3.845    c0.263,0.604,0.954,0.982,2.054,1.123c2.675-0.063,4.324-2.168,4.977-4.13C203.597,30.946,203.576,29.531,203.118,28.567z"></path></g><g><path fill="#F7F8FC" d="M181.068,43.07c-2.322,1.171-3.931-0.124-4.214-1.291c-0.559-2.301,0.766-5.788,2.339-6.479    C179.946,37.171,184.946,40.377,181.068,43.07z"></path><path fill="#D3DCE6" d="M179.303,44.522c-0.548,0-1.074-0.111-1.558-0.335c-0.936-0.433-1.629-1.246-1.855-2.173    c-0.665-2.733,0.855-6.722,2.904-7.622c0.246-0.106,0.525-0.111,0.772-0.01c0.248,0.101,0.445,0.299,0.545,0.548    c0.143,0.354,0.635,0.933,1.112,1.493c1.116,1.312,2.505,2.945,2.268,4.77c-0.133,1.023-0.758,1.929-1.858,2.693    c-0.038,0.026-0.077,0.05-0.119,0.071C180.77,44.332,180.017,44.522,179.303,44.522z M181.068,43.07h0.01H181.068z     M178.951,36.783c-0.797,1.045-1.517,3.185-1.134,4.761c0.061,0.254,0.298,0.627,0.76,0.84c0.547,0.254,1.232,0.194,1.983-0.17    c0.584-0.418,0.909-0.848,0.965-1.278c0.124-0.952-0.949-2.213-1.811-3.227C179.438,37.385,179.178,37.079,178.951,36.783z"></path></g><g><path fill="#E3EAF2" d="M162.502,12.029c6.608-0.287,1.725,4.847,1.63,7.842C158.477,17.047,158.814,12.111,162.502,12.029z"></path><path fill="#D3DCE6" d="M164.132,20.863c-0.151,0-0.303-0.034-0.442-0.104c-3.952-1.973-5.255-4.943-4.793-7.01    c0.364-1.629,1.732-2.667,3.572-2.713c1.32-0.054,3.163,0.016,4.04,1.274c0.946,1.358,0.192,3.163-0.538,4.908    c-0.406,0.972-0.826,1.977-0.848,2.683c-0.011,0.338-0.193,0.647-0.483,0.82C164.484,20.816,164.308,20.863,164.132,20.863z     M163.018,13.009c-0.146,0-0.303,0.003-0.473,0.011c-0.007,0-0.014,0-0.021,0c-0.929,0.021-1.531,0.434-1.694,1.162    c-0.243,1.091,0.497,2.753,2.596,4.142c0.192-0.62,0.456-1.251,0.715-1.871c0.448-1.073,1.062-2.544,0.74-3.007    C164.806,13.337,164.457,13.009,163.018,13.009z M162.503,12.028h0.01H162.503z"></path></g><g><path fill="#D3DCE6" d="M170.873,21.811c-0.059,0-0.119-0.011-0.178-0.033c-0.256-0.098-0.383-0.385-0.285-0.641    c0.283-0.738,0.781-1.331,1.327-1.721c-0.017-0.332,0.038-0.696,0.202-1.08c0.114-0.268,0.38-0.654,0.732-0.985    c-0.059-0.433-0.061-0.978,0.021-1.666c0.033-0.271,0.279-0.468,0.551-0.434c0.272,0.033,0.466,0.28,0.433,0.552    c-0.045,0.369-0.061,0.686-0.056,0.956c0.344-0.108,0.676-0.087,0.965,0.056c0.715,0.356,0.797,0.96,0.649,1.368    c-0.207,0.569-0.852,0.918-1.44,0.78c-0.233-0.055-0.525-0.197-0.758-0.541c-0.085,0.112-0.15,0.219-0.186,0.304    c-0.031,0.072-0.055,0.141-0.073,0.208c0.237-0.051,0.464-0.056,0.667-0.012c0.557,0.124,0.875,0.593,0.831,1.226    c-0.052,0.739-0.484,0.971-0.667,1.036c-0.42,0.15-0.919-0.016-1.308-0.43c-0.087-0.093-0.17-0.2-0.244-0.319    c-0.292,0.271-0.557,0.631-0.72,1.057C171.261,21.69,171.072,21.811,170.873,21.811z M172.906,19.923    c0.007,0.012,0.015,0.023,0.022,0.033c0.136,0.199,0.287,0.275,0.346,0.287c-0.011-0.014,0.007-0.07,0.014-0.165    c0.008-0.115-0.014-0.166-0.02-0.174c-0.013-0.011-0.112-0.044-0.319,0.007C172.935,19.915,172.92,19.919,172.906,19.923z     M173.797,17.753c0.051,0.107,0.108,0.178,0.167,0.217c0.084,0.056,0.169,0.028,0.225-0.005c0.084-0.048,0.119-0.118,0.118-0.136    c-0.003-0.01-0.039-0.064-0.162-0.126c-0.063-0.031-0.152-0.027-0.267,0.015C173.852,17.729,173.824,17.741,173.797,17.753z"></path></g><g><path fill="#D3DCE6" d="M157.075,18.876c-0.103,0-0.207-0.032-0.296-0.099c-1.176-0.879-1.62-1.88-1.651-2.729    c-0.416-0.311-0.777-0.73-0.975-1.194c-0.419-0.981-0.002-1.912,1.114-2.49c0.242-0.126,0.542-0.03,0.668,0.213    c0.125,0.244,0.03,0.543-0.213,0.669c-0.88,0.455-0.79,0.928-0.646,1.245c0.07,0.153,0.167,0.294,0.279,0.421    c0.263-0.543,0.726-0.887,1.179-0.863c0.442,0.018,0.79,0.349,0.932,0.885c0.314,1.187-0.358,1.519-0.571,1.593    c-0.201,0.069-0.432,0.075-0.673,0.03c0.146,0.417,0.47,0.916,1.15,1.424c0.219,0.164,0.264,0.475,0.1,0.694    C157.375,18.808,157.226,18.876,157.075,18.876z M156.18,15.514c0.17,0.074,0.312,0.102,0.385,0.078    c-0.01-0.01,0.015-0.127-0.058-0.403c-0.029-0.109-0.063-0.158-0.074-0.169C156.435,15.054,156.274,15.212,156.18,15.514z"></path></g><g><path fill="#F7F8FC" d="M164.663,12.346c-1.26,0.603-2.77,0.465-3.865-0.402c-1.403-1.112-2.385-2.78-2.174-4.851    c0.323-3.169,6.198-4.439,8.504-6.065c-1.51,2.883,2.105,4.597,1.733,7.256C168.614,10.053,166.527,11.454,164.663,12.346z"></path></g><g><g><path fill="#D3DCE6" d="M164.399,11.389c-2.409,0.892-4.804-1.111-4.811-3.621c-0.005-1.46,0.974-2.216,2.138-2.931     c1.881-1.153,4.056-1.741,5.903-2.953c-0.452-0.453-0.904-0.905-1.356-1.358c-0.737,1.725-0.479,3.107,0.44,4.714     c0.636,1.112,1.578,2.201,0.941,3.559c-0.606,1.289-2.301,2.094-3.49,2.691c-1.141,0.572-0.138,2.285,1.001,1.714     c1.964-0.985,4.438-2.487,4.689-4.92c0.25-2.421-2.827-4.51-1.868-6.755c0.35-0.819-0.433-1.964-1.356-1.358     c-2.745,1.802-7.676,2.506-8.821,6.065c-1.349,4.194,3.019,8.586,7.12,7.068C166.113,12.864,165.6,10.945,164.399,11.389z"></path></g></g><g><path fill="#F7F8FC" d="M172.162,36.467c4.438-2.659,1.919-9.473-3.244-9.168c-1.155,0.068-2.337,0.331-3.577,0.894    c-4.538,2.058-5.348,6.032-3.675,10.632c1.258-0.543,7.442-1.317,9.452-1.899C171.489,36.818,171.836,36.662,172.162,36.467z"></path></g><g><g><path fill="#D3DCE6" d="M172.662,37.324c4.611-3.083,2.89-10.316-2.68-10.978c-3.114-0.37-6.802,1.221-8.659,3.75     c-1.954,2.66-1.623,6.032-0.613,8.992c0.161,0.473,0.692,0.89,1.219,0.693C165.358,38.503,169.38,39.028,172.662,37.324     c1.133-0.588,0.132-2.302-1.001-1.714c-3.09,1.605-7.016,1.048-10.259,2.258c0.406,0.231,0.813,0.462,1.219,0.693     c-1.608-4.715-0.164-9.06,5.159-10.123c2.021-0.404,4.06,0.109,5.123,2.005c1.049,1.871,0.53,3.982-1.242,5.167     C170.605,36.316,171.597,38.036,172.662,37.324z"></path></g></g><g><path fill="#E3EAF2" d="M390.525,194.639c-0.854-2.153-4.151-5.502-6.57-6.029c-3.352-0.731-7.458,2.848-8.47,5.797    c3.64,0.728,3.583,4.083,7.178,5.097C385.821,200.394,389.707,197.905,390.525,194.639"></path></g><g><g><path fill="#D3DCE6" d="M391.381,194.138c-1.36-2.992-4.817-6.585-8.329-6.607c-3.787-0.024-7.197,3.291-8.522,6.612     c-0.197,0.495,0.219,1.096,0.692,1.221c2.18,0.573,2.932,2.252,4.504,3.625c1.239,1.083,2.804,1.713,4.456,1.678     c3.395-0.071,6.312-2.609,7.298-5.764c0.382-1.222-1.531-1.745-1.912-0.528c-1.122,3.588-5.573,5.765-8.648,3.013     c-1.798-1.609-2.689-3.286-5.172-3.939c0.231,0.407,0.462,0.814,0.692,1.221c1.049-2.63,4.414-5.852,7.498-5.033     c2.419,0.643,4.734,3.311,5.73,5.502C390.197,196.301,391.906,195.294,391.381,194.138L391.381,194.138z"></path></g></g><g><path fill="#E3EAF2" d="M398.243,206.716c-2.513-3.099-0.468-5.868,1.526-7.338c2.763-2.036,8.952-0.955,11.076,1.325    c-3.027,2.15-2.002,5.146-4.871,7.539C403.453,210.344,400.32,209.364,398.243,206.716z"></path></g><g><g><path fill="#D3DCE6" d="M399.099,206.215c-2.275-3.22,0.395-6.534,3.879-6.887c2.399-0.243,5.383,0.373,7.166,2.077     c0-0.468,0-0.936,0-1.404c-1.87,1.515-2.243,3.341-3.252,5.402c-1.855,3.788-5.461,3.515-7.948,0.61     c-0.832-0.971-2.229,0.438-1.402,1.404c1.918,2.24,4.819,3.789,7.731,2.438c3.697-1.715,3.378-6.106,6.273-8.451     c0.41-0.332,0.356-1.063,0-1.404c-2.683-2.564-7.673-3.521-11.116-2.1c-3.847,1.588-5.474,5.875-3.042,9.315     C398.118,208.251,399.838,207.261,399.099,206.215z"></path></g></g><g><path fill="#F7F8FC" d="M400.662,209.73c3.217,3.336,6.972,5.368,7.795,10.324c0.817,4.92-2.03,7.806-6.778,8.973    c-0.249-1.349,0.008-2.56-0.548-3.892c-0.78-1.869-2.5-3.033-3.135-5.028C396.936,216.778,400.271,213.013,400.662,209.73"></path></g><g><g><path fill="#D3DCE6" d="M399.961,210.432c2.746,2.77,6.412,5.106,7.386,9.127c1.112,4.595-1.759,7.391-5.932,8.511     c0.418,0.319,0.837,0.638,1.255,0.957c-0.184-1.477-0.085-2.999-0.683-4.393c-0.748-1.743-2.479-2.964-3.035-4.791     c-0.985-3.238,2.132-6.714,2.666-9.849c0.213-1.25-1.697-1.786-1.912-0.528c-0.548,3.21-3.004,6.029-2.907,9.374     c0.041,1.422,0.627,2.593,1.406,3.743c0.55,0.811,1.285,1.504,1.737,2.382c0.668,1.297,0.57,2.661,0.745,4.062     c0.079,0.63,0.57,1.141,1.255,0.957c4.202-1.127,7.758-3.86,7.641-8.579c-0.141-5.691-4.589-8.713-8.22-12.377     C400.463,208.12,399.061,209.524,399.961,210.432L399.961,210.432z"></path></g></g><g><path fill="#E3EAF2" d="M392.693,184.048c3.584,3.733,9.65-0.255,8.194-5.223c-0.326-1.112-0.847-2.206-1.673-3.29    c-3.022-3.966-7.071-3.864-11.172-1.199c0.811,1.105,2.953,6.966,3.97,8.796C392.2,183.471,392.43,183.774,392.693,184.048z"></path></g><g><g><path fill="#D3DCE6" d="M391.992,184.75c4.134,3.835,10.828,0.342,10.03-5.31c-0.434-3.071-2.764-6.234-5.636-7.428     c-3.045-1.266-6.183-0.171-8.845,1.467c-0.439,0.27-0.654,0.9-0.356,1.358C389.184,177.901,389.599,181.934,391.992,184.75     c0.828,0.974,2.224-0.435,1.402-1.404c-2.254-2.653-2.604-6.609-4.496-9.511c-0.119,0.453-0.237,0.905-0.356,1.358     c4.368-2.688,9.212-2.052,11.169,3.23c1.456,3.929-2.809,8.177-6.317,4.923C392.459,182.479,391.054,183.879,391.992,184.75z"></path></g></g><g><path fill="#D3DCE6" d="M401.29,211.353c-0.232,0-0.466-0.081-0.653-0.246c-9.049-7.942-12.835-13.459-12.274-17.889    c0.556-4.385,5.299-6.782,10.32-9.319c9.216-4.656,19.66-9.933,10.174-28.764c-2.461-4.884-7.734-9.848-11.397-9.188    c-2.581,0.477-4.261,3.794-4.858,9.593c-0.056,0.546-0.53,0.932-1.088,0.886c-0.545-0.056-0.941-0.545-0.885-1.089    c0.708-6.863,2.886-10.679,6.472-11.341c4.736-0.865,10.702,4.64,13.526,10.246c10.379,20.603-2.007,26.86-11.05,31.43    c-4.735,2.392-8.824,4.459-9.247,7.796c-0.457,3.606,3.342,8.888,11.613,16.147c0.411,0.362,0.453,0.989,0.092,1.401    C401.84,211.238,401.565,211.353,401.29,211.353z"></path></g><g><path fill="#E3EAF2" d="M414.186,170.768c0.292-2.485,1.896-5.115,4.884-5.49c3.157-0.396,5.712,5.051,7.812,6.936    c-3.144-0.826-4.001,3.086-6.673,3.32C417.809,175.745,415.306,172.529,414.186,170.768"></path></g><g><g><path fill="#D3DCE6" d="M415.141,171.032c0.514-3.26,3.516-6.378,6.532-3.525c1.712,1.62,2.816,3.77,4.508,5.408     c0.321-0.553,0.643-1.106,0.964-1.659c-2.112-0.38-3.322,0.495-4.829,1.861c-1.192,1.08-2.181,1.838-3.809,0.923     c-1.449-0.815-2.581-2.425-3.467-3.773c-0.698-1.063-2.416-0.069-1.712,1.002c1.414,2.152,3.516,5.018,6.325,5.247     c2.986,0.244,4.249-3.834,6.964-3.346c0.917,0.165,1.729-0.919,0.964-1.659c-2.308-2.234-4.023-6.605-7.551-7.176     c-3.662-0.593-6.296,2.953-6.803,6.168C413.033,171.754,414.943,172.292,415.141,171.032L415.141,171.032z"></path></g></g><g><path fill="#E3EAF2" d="M397.791,206.095c-1.858-2.467-11.27-6.783-8.952,8.195C391.675,210.769,403.439,213.739,397.791,206.095z    "></path><path fill="#D3DCE6" d="M388.839,215.283c-0.085,0-0.172-0.011-0.257-0.034c-0.379-0.102-0.662-0.419-0.722-0.806    c-0.992-6.411-0.027-10.282,2.869-11.507c2.947-1.252,6.681,1.004,7.855,2.562c0.001,0.003,0.003,0.005,0.005,0.008    c1.543,2.088,2.025,3.658,1.517,4.941c-0.721,1.824-3.09,2.255-5.597,2.709c-1.912,0.347-4.078,0.741-4.897,1.758    C389.42,215.15,389.134,215.283,388.839,215.283z M392.585,204.561c-0.384,0-0.752,0.062-1.085,0.203    c-1.685,0.713-2.345,3.422-1.9,7.698c1.292-0.667,2.942-0.966,4.554-1.259c1.777-0.323,3.793-0.688,4.108-1.488    c0.103-0.257,0.182-1.065-1.264-3.025C396.3,205.766,394.282,204.561,392.585,204.561z"></path></g><g><path fill="#D3DCE6" d="M392.009,200.561c-0.04,0-0.08-0.005-0.12-0.015c-0.266-0.067-0.427-0.336-0.361-0.602    c0.163-0.651,0.544-2.177,1.881-2.635c0.194-0.067,0.403-0.075,0.612-0.04c0.215-0.406,0.48-0.742,0.627-0.898    c0.228-0.239,0.875-0.629,1.521-0.756c0.933-1.32,2.295-1.747,3.596-1.104c0.246,0.12,0.347,0.418,0.226,0.664    c-0.12,0.246-0.415,0.348-0.663,0.226c-0.893-0.438-1.589-0.039-2.028,0.405c0.195,0.155,0.403,0.441,0.386,0.948    c-0.014,0.425-0.257,0.764-0.636,0.886c-0.397,0.124-0.829-0.012-1.081-0.342c-0.07-0.091-0.171-0.262-0.2-0.503    c-0.172,0.083-0.322,0.177-0.402,0.261c-0.16,0.169-0.323,0.402-0.451,0.64c0.169,0.142,0.307,0.308,0.392,0.48    c0.24,0.484,0.087,1.002-0.389,1.321c-0.13,0.087-0.293,0.106-0.44,0.055c-0.399-0.142-0.669-0.431-0.761-0.815    c-0.037-0.153-0.043-0.313-0.027-0.475c-0.7,0.269-0.999,1.121-1.199,1.923C392.433,200.411,392.232,200.561,392.009,200.561z"></path></g><g><path fill="#F7F8FC" d="M399.197,183.562c0.905-2.277,2.391-2.503,3.993-1.866c1.673,0.665,1.155,3.189,3.173,4.695    C402.504,189.518,397.379,188.386,399.197,183.562z"></path><path fill="#D3DCE6" d="M401.898,189.136c-0.999,0-1.916-0.254-2.641-0.778c-0.691-0.5-2.172-2.003-0.987-5.147    c0.002-0.005,0.004-0.011,0.007-0.016c1-2.518,2.873-3.378,5.28-2.421c1.243,0.494,1.653,1.61,2.015,2.595    c0.311,0.846,0.605,1.646,1.383,2.227c0.246,0.183,0.393,0.47,0.399,0.776c0.006,0.306-0.13,0.598-0.368,0.791    C405.393,188.453,403.536,189.136,401.898,189.136z M400.121,183.92c-0.289,0.772-0.631,2.157,0.297,2.828    c0.868,0.63,2.643,0.562,4.404-0.489c-0.571-0.735-0.862-1.528-1.112-2.206c-0.332-0.901-0.504-1.284-0.887-1.436    C401.661,182.154,400.803,182.213,400.121,183.92z"></path></g><g><path fill="#F7F8FC" d="M400.648,211.516c-2.81-3.466,0.673-5.475,3.291-5.926c2.864-0.493,4.171,2.912,7.628,1.824    C412.135,211.326,404.825,215.489,400.648,211.516z"></path><path fill="#D3DCE6" d="M404.789,214.111c-1.81,0-3.52-0.636-4.824-1.877c-0.031-0.029-0.06-0.06-0.087-0.094    c-1.491-1.839-1.393-3.32-1.048-4.239c0.722-1.923,3.026-2.961,4.942-3.291c1.662-0.289,2.888,0.441,3.966,1.084    c1.159,0.688,2.073,1.231,3.532,0.772c0.277-0.086,0.58-0.048,0.825,0.107c0.246,0.155,0.411,0.41,0.453,0.698    c0.313,2.15-1.222,4.497-3.817,5.843C407.442,213.783,406.089,214.111,404.789,214.111z M401.377,210.84    c1.961,1.819,4.609,1.461,6.443,0.512c1.338-0.694,2.308-1.723,2.65-2.734c-1.572,0.058-2.755-0.627-3.745-1.216    c-1.038-0.617-1.722-0.984-2.618-0.834c-1.369,0.236-3.024,0.972-3.422,2.034C400.454,209.218,400.687,209.972,401.377,210.84z"></path></g><g><path fill="#E3EAF2" d="M405.281,147.419c-1.917-4.031-4.421-1.957-5.953,0.216c-1.677,2.377,0.181,4.631-2.286,7.288    C400.324,157.119,407.066,152.904,405.281,147.419z"></path><path fill="#D3DCE6" d="M399.16,156.512c-0.981,0-1.902-0.251-2.67-0.765c-0.241-0.161-0.4-0.421-0.434-0.71    c-0.034-0.289,0.061-0.579,0.258-0.791c1.105-1.19,1.144-2.245,1.19-3.465c0.041-1.128,0.088-2.409,1.013-3.72    c1.001-1.419,2.59-3.063,4.43-2.918c1.296,0.11,2.382,1.07,3.228,2.85c0.018,0.039,0.034,0.079,0.047,0.119    c1.113,3.422-0.639,6.271-2.65,7.797C402.18,155.966,400.606,156.512,399.16,156.512z M398.613,154.479    c1.131,0.173,2.558-0.237,3.763-1.152c0.708-0.537,2.929-2.514,1.982-5.539c-0.5-1.031-1.059-1.623-1.579-1.667    c-0.681-0.047-1.679,0.721-2.642,2.087c-0.585,0.829-0.614,1.631-0.651,2.648C399.447,151.905,399.401,153.155,398.613,154.479z"></path></g><g><path fill="#F7F8FC" d="M389.096,195.256c-1.661-2.002-0.762-3.863,0.31-4.402c2.113-1.062,5.805-0.552,6.83,0.827    C394.585,192.836,392.588,198.435,389.096,195.256z"></path><path fill="#D3DCE6" d="M391.163,197.213c-0.923,0-1.842-0.41-2.735-1.222c-0.034-0.031-0.066-0.065-0.096-0.101    c-0.941-1.134-1.321-2.422-1.07-3.625c0.211-1.011,0.845-1.87,1.697-2.298c2.513-1.262,6.736-0.675,8.071,1.122    c0.16,0.215,0.226,0.487,0.183,0.751c-0.044,0.265-0.192,0.501-0.41,0.654c-0.314,0.219-0.766,0.83-1.204,1.42    c-1.026,1.383-2.303,3.105-4.132,3.284C391.366,197.208,391.264,197.213,391.163,197.213z M389.815,194.568    c0.537,0.476,1.02,0.7,1.46,0.654c0.955-0.093,1.941-1.423,2.734-2.491c0.255-0.343,0.494-0.665,0.731-0.954    c-1.196-0.543-3.44-0.765-4.889-0.037c-0.232,0.117-0.542,0.431-0.646,0.93C389.08,193.262,389.291,193.917,389.815,194.568z"></path></g><g><path fill="#F7F8FC" d="M414.089,170.973c6.586-0.619,1.966,4.754,2.022,7.75C410.321,176.189,410.41,171.241,414.089,170.973z"></path><path fill="#D3DCE6" d="M416.111,179.716c-0.135,0-0.27-0.027-0.397-0.083c-4.047-1.772-5.497-4.671-5.14-6.76    c0.282-1.645,1.596-2.751,3.432-2.887c1.317-0.122,3.163-0.142,4.099,1.068c1.013,1.309,0.35,3.149-0.289,4.929    c-0.357,0.991-0.726,2.016-0.712,2.723c0.006,0.338-0.16,0.656-0.44,0.844C416.496,179.66,416.304,179.716,416.111,179.716z     M415.065,171.917c-0.251,0-0.543,0.013-0.883,0.046c-0.007,0-0.015,0.001-0.021,0.001c-0.926,0.068-1.506,0.51-1.632,1.245    c-0.189,1.102,0.634,2.725,2.801,4.006c0.161-0.629,0.392-1.273,0.62-1.905c0.394-1.095,0.933-2.594,0.589-3.04    C416.465,172.176,416.163,171.917,415.065,171.917z M414.089,170.974h0.01H414.089z"></path></g><g><path fill="#D3DCE6" d="M412.131,183.984c-0.043,0-0.084-0.003-0.124-0.008c-0.601-0.073-1.087-0.624-1.082-1.229    c0.001-0.24,0.074-0.556,0.356-0.862c-0.128-0.057-0.246-0.097-0.338-0.113c-0.076-0.014-0.149-0.021-0.218-0.024    c0.103,0.22,0.159,0.44,0.161,0.647c0.005,0.571-0.38,0.988-1.006,1.087c-0.731,0.111-1.054-0.255-1.159-0.42    c-0.239-0.374-0.191-0.9,0.125-1.373c0.071-0.106,0.156-0.21,0.256-0.309c-0.329-0.225-0.739-0.401-1.192-0.465    c-0.271-0.039-0.459-0.29-0.421-0.561c0.039-0.27,0.294-0.451,0.56-0.422c0.782,0.11,1.47,0.463,1.974,0.909    c0.317-0.092,0.685-0.12,1.095-0.046c0.286,0.05,0.722,0.223,1.124,0.492c0.409-0.154,0.938-0.279,1.625-0.353    c0.272-0.029,0.517,0.168,0.546,0.44c0.029,0.273-0.167,0.518-0.439,0.547c-0.369,0.04-0.681,0.095-0.943,0.16    c0.181,0.312,0.237,0.641,0.162,0.955C413.023,183.742,412.54,183.984,412.131,183.984z M412.102,182.477    c-0.092,0.073-0.148,0.145-0.173,0.211c-0.035,0.093,0.01,0.17,0.054,0.218c0.066,0.073,0.141,0.084,0.16,0.085    c0.009-0.005,0.053-0.052,0.085-0.186c0.016-0.07-0.009-0.157-0.075-0.259C412.137,182.524,412.12,182.5,412.102,182.477z     M409.564,182.542h0.01H409.564z M409.79,182.094c-0.01,0.011-0.018,0.019-0.027,0.029c-0.164,0.178-0.202,0.342-0.201,0.402    c0.011-0.014,0.07-0.009,0.164-0.024c0.114-0.017,0.159-0.05,0.165-0.058c0.008-0.015,0.019-0.117-0.077-0.308    C409.806,182.121,409.798,182.108,409.79,182.094z"></path></g><g><path fill="#D3DCE6" d="M407.738,166.798c-0.067,0-0.135-0.014-0.199-0.042c-0.251-0.11-0.365-0.404-0.255-0.654    c0.591-1.344,1.466-2.003,2.285-2.225c0.208-0.475,0.536-0.922,0.943-1.218c0.86-0.631,1.859-0.432,2.673,0.528    c0.176,0.209,0.151,0.522-0.058,0.7c-0.208,0.175-0.52,0.153-0.699-0.058c-0.639-0.756-1.079-0.564-1.356-0.35    c-0.133,0.102-0.248,0.228-0.347,0.365c0.588,0.136,1.02,0.501,1.105,0.957c0.081,0.435-0.163,0.85-0.652,1.109    c-1.085,0.573-1.559-0.008-1.68-0.2c-0.112-0.18-0.169-0.403-0.18-0.649c-0.373,0.236-0.786,0.666-1.127,1.441    C408.11,166.688,407.928,166.798,407.738,166.798z M410.325,164.785c-0.033,0.181-0.029,0.327,0.011,0.394    c0.008-0.013,0.128-0.015,0.379-0.147c0.1-0.052,0.14-0.097,0.148-0.11C410.844,164.926,410.648,164.808,410.325,164.785z"></path></g><g><path fill="#F7F8FC" d="M402.819,147.921c-3.863-0.988-3.871-4.431-3.145-6.801c1.005-3.284,6.618-6.111,9.681-5.549    c-1.15,3.534,1.457,5.326,0.579,8.961C409.162,147.723,406.063,148.806,402.819,147.921z"></path></g><g><g><path fill="#D3DCE6" d="M403.083,146.963c-3.319-1.041-3.527-4.868-1.405-7.254c1.8-2.024,4.957-3.484,7.678-3.147     c-0.319-0.419-0.637-0.838-0.956-1.256c-0.592,2.264,0.039,3.936,0.516,6.136C409.806,145.546,406.963,147.858,403.083,146.963     c-1.242-0.286-1.772,1.627-0.527,1.914c2.894,0.667,6.2,0.236,7.768-2.607c1.962-3.56-0.946-6.869-0.012-10.437     c0.179-0.685-0.323-1.178-0.956-1.256c-3.802-0.472-8.825,2.111-10.402,5.67c-1.607,3.627-0.21,7.434,3.603,8.63     C403.776,149.26,404.298,147.345,403.083,146.963z"></path></g></g><g><path fill="#E3EAF2" d="M104.362,107.532c-0.343-0.989-0.163-2.094,0.522-2.885c1.09-1.261,2.546-1.654,4.409-1.116    c2.788,0.805,3.51,5.156,4.72,7.296c-2.365-1.556-4.043,0.237-6.312-0.313C106.134,110.135,104.964,109.268,104.362,107.532z"></path></g><g><g><path fill="#D3DCE6" d="M105.318,107.268c-0.462-1.811,1.046-3.092,2.792-2.966c1.41,0.101,2.193,0.92,2.864,2.07     c0.911,1.563,1.335,3.359,2.182,4.956c0.452-0.453,0.904-0.905,1.356-1.358c-1.415-0.79-2.635-0.852-4.205-0.584     C108.166,109.752,106.222,109.534,105.318,107.268c-0.468-1.172-2.386-0.661-1.912,0.528c0.651,1.63,1.657,2.867,3.356,3.467     c2.263,0.799,4.668-0.74,6.749,0.422c0.883,0.493,1.819-0.485,1.356-1.358c-1.399-2.638-1.917-6.552-5.12-7.683     c-3.45-1.219-7.317,1.33-6.342,5.153C103.721,109.033,105.634,108.509,105.318,107.268z"></path></g></g><g><path fill="#D3DCE6" d="M119.269,72.123c-0.204,0-0.395-0.127-0.468-0.331c-0.195-0.554-0.297-1.012-0.333-1.39    c-0.357-0.218-0.651-0.492-0.797-0.697c-0.209-0.291-0.328-0.587-0.38-0.87c-0.537-0.235-1.067-0.645-1.444-1.214    c-0.151-0.228-0.089-0.536,0.139-0.688c0.228-0.153,0.536-0.09,0.687,0.139c0.205,0.309,0.463,0.538,0.721,0.699    c0.036-0.091,0.078-0.175,0.123-0.253c0.265-0.447,0.683-0.698,1.092-0.643c0.181,0.022,0.622,0.144,0.816,0.798    c0.117,0.392,0.057,0.748-0.154,1.004c0.481-0.163,1.054,0.028,1.33,0.462c0.217,0.341,0.267,0.903-0.305,1.368    c-0.211,0.171-0.464,0.259-0.768,0.249c0.046,0.202,0.113,0.436,0.208,0.708c0.091,0.258-0.045,0.542-0.303,0.633    C119.38,72.114,119.324,72.123,119.269,72.123z M119.493,69.757c0.058,0.007,0.136,0.01,0.179-0.024    c0.065-0.052,0.088-0.09,0.091-0.1c-0.023,0.005-0.076-0.025-0.13-0.025c-0.016,0-0.032,0.002-0.046,0.009    C119.561,69.628,119.523,69.671,119.493,69.757z M118.434,69.062c0.014,0.021,0.028,0.042,0.043,0.063    c0.033,0.046,0.08,0.097,0.138,0.152c0.054-0.114,0.118-0.208,0.186-0.285C118.689,69.029,118.566,69.053,118.434,69.062z     M118.46,67.906c-0.036,0.036-0.079,0.091-0.117,0.169c0.082-0.004,0.133-0.019,0.155-0.03c-0.004-0.009-0.007-0.04-0.022-0.091    C118.471,67.936,118.465,67.92,118.46,67.906z"></path></g><g><path fill="#D3DCE6" d="M115.077,37.014c-0.057,0-0.114-0.01-0.17-0.03c-0.257-0.094-0.39-0.379-0.296-0.636    c0.127-0.348,0.158-0.693,0.135-0.996c-0.094,0.025-0.188,0.042-0.277,0.05c-0.511,0.052-0.963-0.139-1.165-0.498    c-0.089-0.159-0.252-0.587,0.158-1.131c0.245-0.326,0.557-0.489,0.899-0.471c-0.416-0.29-0.603-0.866-0.418-1.346    c0.146-0.377,0.568-0.75,1.281-0.565c0.263,0.068,0.487,0.23,0.656,0.471c0.136-0.157,0.284-0.35,0.445-0.587    c0.154-0.226,0.462-0.286,0.688-0.132c0.227,0.154,0.286,0.463,0.132,0.689c-0.33,0.487-0.638,0.84-0.921,1.093    c0.037,0.417-0.01,0.817-0.087,1.056c-0.11,0.342-0.277,0.613-0.474,0.823c0.13,0.572,0.115,1.242-0.12,1.885    C115.469,36.889,115.28,37.014,115.077,37.014z M114.224,34.412c0.049,0.007,0.119,0.009,0.205-0.006    c-0.051-0.064-0.093-0.096-0.116-0.108c-0.004,0.009-0.028,0.03-0.06,0.072C114.242,34.386,114.232,34.4,114.224,34.412z     M114.894,33.493c0.097,0.068,0.189,0.154,0.274,0.254c0.009-0.023,0.018-0.047,0.026-0.073c0.017-0.054,0.031-0.123,0.04-0.201    C115.111,33.498,114.997,33.502,114.894,33.493z M114.866,32.335c-0.014,0-0.023,0.001-0.027,0.003    c0.013,0.01,0.032,0.118,0.091,0.152c0.025,0.013,0.081,0.019,0.168-0.008c-0.029-0.052-0.073-0.116-0.125-0.13    C114.925,32.339,114.889,32.335,114.866,32.335z"></path></g><g><path fill="#D3DCE6" d="M111.221,127.257c-0.076,0-0.152-0.008-0.229-0.027c-0.532-0.126-0.863-0.661-0.737-1.194    c1.947-8.261-2.594-13.307-6.986-18.187c-5.037-5.597-10.245-11.384-4.662-21.378c3.102-5.553,9.067-8.639,14.836-11.623    c9.893-5.117,19.237-9.951,15.588-26.455c-1.632-7.382-7.428-9.395-10.737-9.937c-7.615-1.252-15.931,2.482-19.777,8.871    c-0.283,0.469-0.893,0.62-1.361,0.338c-0.469-0.283-0.62-0.893-0.337-1.362c4.249-7.056,13.414-11.181,21.795-9.806    c6.473,1.062,10.975,5.241,12.352,11.467c3.979,17.996-6.49,23.412-16.614,28.648c-5.762,2.981-11.205,5.796-14.016,10.829    c-4.889,8.753-0.582,13.538,4.405,19.08c4.513,5.015,9.629,10.699,7.443,19.971C112.077,126.95,111.67,127.257,111.221,127.257z"></path></g><g><path fill="#E3EAF2" d="M128.927,58.161c-2.651-4.171,2.411-8.907,6.686-6.435c0.956,0.553,1.815,1.315,2.671,2.296    c2.081,2.384,1.987,7.439-1.407,10.648c-2.945-4.349-5.789-4.313-7.255-5.67C129.35,58.749,129.121,58.467,128.927,58.161z"></path></g><g><g><path fill="#D3DCE6" d="M129.782,57.66c-1.082-1.98-0.433-4.151,1.572-5.194c2.116-1.101,4.262,0.135,5.714,1.695     c2.704,2.906,1.679,7.17-0.892,9.807c0.519,0.067,1.038,0.134,1.557,0.201c-1.136-1.579-2.395-2.993-4.056-4.03     C132.375,59.327,130.716,58.949,129.782,57.66c-0.742-1.024-2.463-0.035-1.712,1.002c0.779,1.076,1.623,1.647,2.79,2.236     c2.122,1.07,3.746,2.307,5.16,4.273c0.364,0.505,1.076,0.694,1.557,0.201c4.257-4.364,4.158-11.362-1.465-14.503     c-5.11-2.855-10.876,2.606-8.042,7.793C128.683,59.783,130.396,58.783,129.782,57.66z"></path></g></g><g><path fill="#E3EAF2" d="M109.314,78.664c-7.2,2.189-7.007,10.583-2.092,15.185c2.055-1.359,3.654-4.312,4.542-6.678    C112.577,85.005,111.712,79.66,109.314,78.664"></path></g><g><g><path fill="#D3DCE6" d="M109.05,77.707c-7.753,2.629-7.816,11.629-2.53,16.844c0.285,0.281,0.852,0.415,1.201,0.155     c2.689-2,5.133-5.674,5.314-9.107c0.143-2.704-0.628-6.411-3.222-7.791c-1.126-0.599-2.129,1.114-1.001,1.714     c1.903,1.012,2.396,4.13,2.24,6.077c-0.211,2.649-2.239,5.836-4.332,7.393c0.4,0.052,0.801,0.103,1.201,0.155     c-4.143-4.087-4.713-11.366,1.655-13.526C110.779,79.214,110.264,77.296,109.05,77.707L109.05,77.707z"></path></g></g><g><path fill="#E3EAF2" d="M112.192,127.113c-4.124-0.376-7.721-1.924-11.454,0.426c-3.706,2.334-3.866,6.148-1.756,10.335    c1.031-0.621,1.666-1.533,2.872-1.918c1.692-0.541,3.492,0.029,5.178-0.694C109.846,134.055,110.286,129.358,112.192,127.113"></path></g><g><g><path fill="#D3DCE6" d="M112.192,126.12c-4.613-0.504-9.493-2.015-13.317,1.6c-3.128,2.957-2.42,7.129-0.748,10.654     c0.218,0.459,0.943,0.642,1.356,0.356c0.729-0.505,1.429-1.23,2.209-1.63c1.364-0.699,3.04-0.297,4.489-0.582     c1.106-0.217,2.049-0.667,2.841-1.488c1.989-2.059,2.307-5.173,4.026-7.417c0.776-1.013-0.945-2.003-1.712-1.002     c-1.573,2.053-1.828,5.25-3.716,7.015c-1.451,1.357-3.386,0.863-5.176,1.182c-1.646,0.293-2.627,1.281-3.963,2.207     c0.452,0.119,0.904,0.237,1.356,0.356c-1.669-3.517-1.831-7.437,2.145-9.396c3.156-1.556,6.918-0.23,10.209,0.129     C113.459,128.244,113.449,126.258,112.192,126.12L112.192,126.12z"></path></g></g><g><path fill="#E3EAF2" d="M110.283,127.449c-0.132,2.208,1.365,6.439,3.243,7.876c2.603,1.991,7.6,0.56,9.667-1.58    c-2.853-2.104-1.448-4.982-4.146-7.316C116.678,124.38,112.311,124.957,110.283,127.449"></path></g><g><g><path fill="#D3DCE6" d="M109.292,127.449c-0.024,3.255,1.527,7.898,4.744,9.298c3.219,1.401,7.416-0.008,9.859-2.3     c0.368-0.345,0.4-1.064,0-1.404c-2.845-2.419-1.925-6.868-5.98-8.402c-2.895-1.095-6.276-0.144-8.332,2.106     c-0.86,0.941,0.538,2.348,1.402,1.404c2.166-2.369,6.508-2.932,8.357,0.178c1.291,2.171,1.076,4.354,3.151,6.118     c0-0.468,0-0.936,0-1.404c-1.877,1.761-5.537,3.098-7.983,1.741c-2.207-1.224-3.253-4.987-3.236-7.335     C111.284,126.171,109.302,126.17,109.292,127.449L109.292,127.449z"></path></g></g><g><path fill="#F7F8FC" d="M113.931,128.652c-0.846-0.924-2.119-1.319-3.278-0.988c-2.05,0.585-5.138,1.836-5.815,4.172    c-1.093,3.767,5.113,8.263,7.028,11.31c-0.412-4.058,4.561-4.126,5.362-7.339C117.793,133.538,115.77,130.661,113.931,128.652z"></path></g><g><g><path fill="#D3DCE6" d="M114.632,127.95c-3.253-2.871-10.113-0.24-10.849,4.097c-0.791,4.659,4.982,8.258,7.227,11.6     c0.517,0.769,1.888,0.543,1.847-0.501c-0.125-3.209,3.918-3.731,5.076-6.379C119.331,133.571,116.627,130.199,114.632,127.95     c-0.849-0.957-2.247,0.451-1.402,1.404c1.281,1.444,3.581,3.989,3.042,6.189c-0.325,1.325-1.675,2.015-2.68,2.759     c-1.708,1.266-2.804,2.614-2.717,4.843c0.616-0.167,1.231-0.334,1.847-0.501c-1.679-2.498-4.101-4.39-5.789-6.879     c-1.023-1.509-1.818-3.17-0.488-4.783c1.336-1.619,4.936-3.261,6.785-1.629C114.184,130.196,115.592,128.797,114.632,127.95z"></path></g></g><g><path fill="#F7F8FC" d="M94.65,88.121c-3.039,0.073-4.959,2.208-5.409,4.401c-0.659,3.212,0.137,6.639,4.816,8.558    c-0.797-5.878,2.752-5.903,4.146-8.003C99.996,90.375,97.566,88.05,94.65,88.121z"></path></g><g><g><path fill="#D3DCE6" d="M94.65,87.128c-3.677,0.3-6.244,2.757-6.563,6.47c-0.339,3.954,1.999,6.783,5.469,8.339     c0.604,0.271,1.58-0.028,1.492-0.857c-0.23-2.166-0.057-3.918,1.684-5.366c1.018-0.847,2.092-1.494,2.668-2.752     C100.953,89.567,97.716,87.245,94.65,87.128c-1.276-0.049-1.274,1.936,0,1.985c2.484,0.095,4.123,2.026,2.141,4.058     c-0.608,0.624-1.425,1.029-2.045,1.648c-1.708,1.704-1.926,3.951-1.681,6.26c0.497-0.286,0.994-0.571,1.492-0.857     c-2.411-1.081-4.387-2.734-4.522-5.547c-0.142-2.951,1.563-5.314,4.615-5.563C95.913,89.01,95.924,87.024,94.65,87.128z"></path></g></g><g><path fill="#F7F8FC" d="M131.709,53.999c3.125,6.201-7.505,12.385-13.758,4.033C124.078,56.825,128.713,47.107,131.709,53.999z"></path></g><g><g><path fill="#D3DCE6" d="M130.853,54.5c1.272,2.823-0.784,5.41-3.457,6.266c-3.465,1.11-6.622-0.765-8.744-3.436     c-0.146,0.553-0.292,1.106-0.437,1.659c2.569-0.609,4.625-2.208,6.64-3.835c0.94-0.759,1.886-1.665,2.983-2.203     C129.468,52.151,130.147,53.01,130.853,54.5c0.546,1.154,2.256,0.147,1.712-1.002c-1.184-2.5-3.152-3.654-5.729-2.261     c-3.226,1.744-5.432,4.957-9.149,5.838c-0.794,0.188-0.872,1.111-0.437,1.659c2.83,3.563,7.459,5.565,11.818,3.5     c3.434-1.627,5.089-5.203,3.497-8.735C132.041,52.336,130.332,53.344,130.853,54.5z"></path></g></g><g><path fill="#E3EAF2" d="M109.683,78.792c-4.429,1.602-12.597-2.798-1.891-12.784C107.79,70.409,115.976,77.386,109.683,78.792z"></path><path fill="#D3DCE6" d="M107.747,80.104c-2.091,0-4.332-0.875-5.494-2.78c-1.09-1.787-1.907-5.727,4.864-12.042    c0.289-0.27,0.711-0.34,1.072-0.184c0.362,0.158,0.595,0.516,0.595,0.911c-0.001,1.377,1.071,3.261,2.107,5.082    c1.407,2.473,2.736,4.808,1.909,6.679c-0.431,0.975-1.386,1.64-2.84,1.977C109.286,79.982,108.527,80.104,107.747,80.104z     M107.17,68.016c-3.224,3.384-4.398,6.352-3.225,8.274c1.037,1.7,3.678,2.192,5.402,1.569c0.04-0.015,0.08-0.026,0.121-0.035    c0.839-0.188,1.35-0.476,1.519-0.857c0.422-0.955-0.768-3.047-1.818-4.892C108.4,70.724,107.615,69.345,107.17,68.016z"></path></g><g><path fill="#E3EAF2" d="M103.394,41.364c-0.573-0.906-0.153-2.11,0.853-2.477c2.481-0.904,4.749-1.689,7.002,0.354    c2.747,2.491,2.085,5.259,1.474,8.529c-1.196-2.177-3.174-3.373-5.667-3.775C105.933,43.814,104.271,42.751,103.394,41.364z"></path></g><g><g><path fill="#D3DCE6" d="M104.25,40.863c-0.614-1.331,3.219-1.93,3.85-1.918c1.482,0.028,2.794,1.04,3.528,2.284     c1.129,1.913,0.523,4.238,0.14,6.277c0.604-0.079,1.208-0.158,1.812-0.237c-0.915-1.54-2.147-2.746-3.789-3.488     C107.71,42.842,105.716,42.924,104.25,40.863c-0.734-1.032-2.454-0.041-1.712,1.002c1.014,1.426,2.354,2.559,4.059,3.041     c2.273,0.642,3.985,1.201,5.271,3.365c0.408,0.686,1.648,0.632,1.812-0.237c0.756-4.018,1.038-8.889-3.613-10.696     c-2.837-1.103-9.438,0.389-7.528,4.527C103.072,43.024,104.782,42.016,104.25,40.863z"></path></g></g><g><path fill="#E3EAF2" d="M119.715,72.378c2.707-2.825,5.637-1.794,6.622-0.281c1.943,2.982,1.807,8.593-0.078,10.36    C124.823,78.463,115.562,78.142,119.715,72.378z"></path><path fill="#D3DCE6" d="M126.26,83.45c-0.077,0-0.155-0.009-0.232-0.028c-0.324-0.078-0.588-0.314-0.701-0.629    c-0.428-1.19-1.973-2.092-3.467-2.964c-1.828-1.066-3.718-2.169-4.123-4.083c-0.256-1.206,0.129-2.498,1.175-3.95    c0.027-0.038,0.057-0.073,0.089-0.107c1.426-1.488,3.142-2.218,4.822-2.063c1.373,0.128,2.655,0.867,3.346,1.927    c2.157,3.31,2.034,9.503-0.23,11.627C126.752,83.356,126.509,83.45,126.26,83.45z M120.478,73.015    c-0.661,0.933-0.931,1.714-0.802,2.32c0.223,1.053,1.66,1.892,3.182,2.78c1.249,0.728,2.527,1.474,3.417,2.486    c0.784-2.062,0.655-5.779-0.768-7.962c-0.275-0.423-0.93-0.947-1.87-1.035C122.893,71.534,121.74,71.724,120.478,73.015z"></path></g><g><path fill="#E3EAF2" d="M105.81,38.096c-0.53,3.963-7.032,8.393-10.344-3.579C98.771,36.242,107.217,32.807,105.81,38.096z"></path><path fill="#D3DCE6" d="M101.517,43.279c-1.865,0-4.992-1.218-7.006-8.497c-0.105-0.381,0.025-0.788,0.332-1.037    c0.306-0.249,0.732-0.292,1.081-0.109c0.999,0.521,2.814,0.452,4.568,0.385c2.447-0.092,4.758-0.182,5.887,1.233    c0.594,0.744,0.73,1.765,0.404,3.036c-0.333,2.265-2.313,4.794-4.975,4.977C101.716,43.275,101.618,43.279,101.517,43.279z     M96.954,35.956c1.247,3.534,2.919,5.43,4.719,5.332c1.611-0.111,2.956-1.841,3.154-3.324c0.006-0.042,0.014-0.083,0.025-0.124    c0.12-0.452,0.214-1.052-0.021-1.346c-0.505-0.632-2.588-0.553-4.264-0.489C99.337,36.053,98.08,36.101,96.954,35.956z"></path></g><g><path fill="#F7F8FC" d="M104.88,107.544c0.242-1.105-0.548-2.17-1.674-2.263c-2.904-0.24-5.374-0.366-7.239,2.516    c-2.257,3.487-0.745,6.291,0.855,9.652c0.668-2.699,3.481-3.365,5.256-5.069C103.031,111.466,104.478,109.383,104.88,107.544z"></path></g><g><g><path fill="#D3DCE6" d="M105.871,107.544c0.179-4.338-6.186-4.011-8.767-2.325c-4.795,3.133-3.137,8.544-1.137,12.731     c0.391,0.818,1.568,0.513,1.812-0.237c0.738-2.274,3.151-2.961,4.788-4.443c1.584-1.435,2.693-3.418,3.269-5.462     c0.347-1.232-1.565-1.757-1.912-0.528c-0.805,2.858-2.563,4.481-4.913,6.082c-1.486,1.012-2.58,2.085-3.144,3.823     c0.604-0.079,1.208-0.158,1.812-0.237c-1.345-2.817-2.773-5.709-0.855-8.65c0.692-1.061,1.689-1.768,2.92-2.035     c0.906-0.196,4.216-0.441,4.145,1.281C103.836,108.821,105.818,108.819,105.871,107.544z"></path></g></g><g><path fill="#D3DCE6" d="M79.066,239.794c-0.369,0-0.724-0.207-0.894-0.563c-0.237-0.493-0.029-1.087,0.464-1.324l6.084-2.927    c0.182-0.088,0.282-0.289,0.242-0.488c-0.04-0.198-0.21-0.344-0.413-0.353c-1.097-0.049-2.026-0.836-2.258-1.911    c-0.233-1.073,0.287-2.173,1.266-2.674l1.123-0.574c0.097-0.049,0.146-0.159,0.117-0.266c-0.028-0.104-0.133-0.165-0.235-0.17    c-0.817,0.052-1.575-0.355-2.003-1.044c-0.427-0.69-0.443-1.558-0.043-2.262l0.358-0.632c0.099-0.174,0.067-0.391-0.076-0.528    c-0.144-0.138-0.361-0.16-0.529-0.054c-0.781,0.49-1.78,0.476-2.546-0.039c-0.765-0.512-1.16-1.431-1.007-2.339    c0.026-0.157-0.052-0.31-0.194-0.381c-0.144-0.074-0.313-0.042-0.422,0.074l-1.039,1.1c-0.552,0.584-1.417,0.763-2.151,0.449    c-0.699-0.297-1.159-0.987-1.171-1.743l-2.044,1.491c-0.765,0.556-1.764,0.637-2.605,0.208c-0.843-0.43-1.366-1.284-1.366-2.231    c0-0.199-0.116-0.383-0.296-0.468c-0.178-0.084-0.395-0.059-0.549,0.068l-3.025,2.478c-0.665,0.544-1.594,0.655-2.369,0.289    c-0.775-0.367-1.276-1.16-1.276-2.019c0-0.1-0.06-0.19-0.151-0.23c-0.092-0.04-0.197-0.02-0.269,0.048l-1.41,1.338    c-0.746,0.708-1.883,0.834-2.765,0.308c-0.882-0.527-1.312-1.589-1.046-2.581c0.032-0.119-0.008-0.248-0.102-0.328    c-0.095-0.082-0.228-0.099-0.341-0.049l-0.814,0.366c-1.144,0.513-2.487,0.187-3.267-0.798c-0.779-0.982-0.792-2.366-0.031-3.364    c0.154-0.203,0.197-0.466,0.114-0.706c-0.083-0.24-0.279-0.421-0.523-0.485c-1.145-0.298-2.027-1.24-2.249-2.401    c-0.206-1.072,0.181-2.179,0.991-2.892c-0.827-0.131-1.567-0.649-1.959-1.413c-0.501-0.976-0.345-2.181,0.39-2.996l2.269-2.521    c-0.981-0.428-1.63-1.282-1.768-2.276c-0.143-1.022,0.273-2.05,1.088-2.684c0.251-0.196,0.373-0.513,0.316-0.827    c-0.057-0.316-0.281-0.571-0.586-0.667c-1.038-0.328-1.786-1.198-1.954-2.272c-0.169-1.075,0.278-2.133,1.165-2.761l1.633-1.155    c0.191-0.136,0.3-0.364,0.283-0.599s-0.156-0.447-0.364-0.553c-0.755-0.389-1.282-1.12-1.412-1.96    c-0.129-0.841,0.153-1.699,0.757-2.297l0.717-0.711c0.16-0.159,0.219-0.392,0.154-0.607c-0.065-0.216-0.242-0.377-0.463-0.421    c-0.879-0.175-1.618-0.805-1.927-1.645c-0.31-0.839-0.16-1.799,0.393-2.504l0.448-0.569c0.136-0.174,0.145-0.413,0.02-0.596    c-0.124-0.183-0.349-0.263-0.563-0.199c-0.913,0.28-1.919-0.001-2.561-0.71c-0.642-0.71-0.821-1.739-0.456-2.623l0.888-2.156    c0.055-0.134,0.021-0.291-0.086-0.391c-0.106-0.099-0.265-0.122-0.394-0.055c-0.647,0.325-1.391,0.334-2.043,0.025    c-0.653-0.309-1.12-0.891-1.279-1.596l-0.484-2.137c-0.036-0.159-0.17-0.277-0.334-0.292c-0.172-0.016-0.316,0.077-0.38,0.228    c-0.36,0.842-1.184,1.404-2.1,1.432c-0.894,0.008-1.769-0.484-2.179-1.305c-0.157-0.316-0.495-0.489-0.845-0.446    c-0.349,0.048-0.627,0.313-0.693,0.66l-0.411,2.17c-0.102,0.538-0.623,0.892-1.158,0.79c-0.538-0.102-0.892-0.621-0.789-1.16    l0.411-2.17c0.224-1.184,1.176-2.091,2.367-2.255c1.19-0.17,2.353,0.445,2.891,1.524c0.065,0.131,0.212,0.25,0.347,0.207    c0.148-0.004,0.279-0.093,0.336-0.228c0.403-0.944,1.355-1.519,2.382-1.424c1.022,0.094,1.861,0.83,2.088,1.83l0.484,2.138    c0.024,0.106,0.094,0.193,0.192,0.239c0.096,0.046,0.21,0.044,0.306-0.004c0.865-0.434,1.923-0.285,2.633,0.374    c0.711,0.661,0.939,1.707,0.57,2.602l-0.888,2.157c-0.074,0.179-0.037,0.388,0.093,0.531c0.129,0.143,0.334,0.2,0.518,0.143    c1.044-0.316,2.159,0.078,2.774,0.979c0.615,0.903,0.575,2.086-0.1,2.945l-0.448,0.568c-0.129,0.165-0.165,0.39-0.091,0.587    c0.073,0.197,0.246,0.344,0.452,0.386c0.94,0.185,1.698,0.872,1.976,1.794c0.277,0.921,0.026,1.913-0.657,2.59l-0.717,0.712    c-0.153,0.152-0.226,0.37-0.193,0.584c0.033,0.212,0.167,0.398,0.359,0.497c0.821,0.423,1.372,1.258,1.436,2.18    c0.065,0.922-0.363,1.826-1.117,2.36l-1.632,1.154c-0.263,0.187-0.401,0.514-0.351,0.833c0.051,0.325,0.277,0.587,0.59,0.686    c1.01,0.317,1.755,1.162,1.943,2.207c0.188,1.043-0.214,2.096-1.05,2.748c-0.256,0.199-0.386,0.521-0.341,0.841    c0.045,0.321,0.259,0.595,0.559,0.716c0.648,0.261,1.08,0.766,1.222,1.378c0.141,0.612-0.025,1.255-0.445,1.721l-2.327,2.585    c-0.186,0.206-0.226,0.512-0.099,0.76c0.128,0.249,0.406,0.396,0.677,0.363c0.78-0.079,1.533,0.364,1.821,1.102    c0.287,0.738,0.043,1.579-0.593,2.047l-0.325,0.238c-0.339,0.248-0.506,0.675-0.427,1.088c0.079,0.413,0.393,0.748,0.8,0.854    c0.888,0.23,1.599,0.887,1.899,1.756c0.301,0.869,0.147,1.826-0.41,2.559c-0.21,0.275-0.207,0.656,0.008,0.927    c0.215,0.272,0.585,0.362,0.901,0.221l0.814-0.366c0.807-0.363,1.765-0.227,2.439,0.349c0.673,0.573,0.96,1.497,0.731,2.353    c-0.037,0.14,0.023,0.288,0.146,0.362c0.123,0.074,0.282,0.055,0.386-0.044l1.41-1.338c0.648-0.614,1.595-0.782,2.416-0.431    c0.821,0.355,1.35,1.16,1.35,2.053c0,0.097,0.055,0.184,0.143,0.226c0.085,0.039,0.19,0.029,0.264-0.032l3.026-2.479    c0.743-0.608,1.784-0.735,2.652-0.325c0.869,0.413,1.43,1.301,1.43,2.262c0,0.196,0.108,0.373,0.283,0.461    c0.174,0.09,0.379,0.073,0.538-0.043l2.137-1.56c0.595-0.432,1.397-0.489,2.046-0.139c0.602,0.323,0.988,0.954,1.012,1.634    l0.938-0.994c0.714-0.755,1.818-0.95,2.746-0.486c0.929,0.463,1.438,1.464,1.264,2.488c-0.023,0.139,0.037,0.28,0.155,0.359    c0.117,0.079,0.271,0.081,0.391,0.006c0.937-0.588,2.153-0.465,2.953,0.304c0.8,0.768,0.976,1.978,0.428,2.942l-0.358,0.632    c-0.042,0.074-0.04,0.164,0.004,0.236c0.045,0.072,0.124,0.113,0.208,0.109c1.044-0.078,1.988,0.628,2.259,1.633    c0.271,1.004-0.204,2.076-1.128,2.55l-1.124,0.575c-0.178,0.091-0.272,0.291-0.23,0.487c0.043,0.196,0.211,0.339,0.41,0.348    c1.112,0.051,2.043,0.849,2.266,1.939c0.222,1.092-0.323,2.191-1.326,2.673l-6.084,2.927    C79.356,239.763,79.21,239.794,79.066,239.794z M49.049,209.204c-0.001,0-0.001,0.001-0.002,0.001    C49.048,209.205,49.048,209.204,49.049,209.204z"></path></g><g><path fill="#D3DCE6" d="M55.519,171.055c-0.254,0-0.509-0.031-0.761-0.097c-1.146-0.297-2.026-1.242-2.242-2.408    c-0.058-0.309-0.266-0.564-0.558-0.682c-0.293-0.116-0.619-0.079-0.875,0.105c-0.963,0.689-2.231,0.724-3.231,0.089    c-1-0.632-1.512-1.794-1.303-2.961l0.405-2.275c0.034-0.189-0.027-0.383-0.163-0.519c-0.136-0.136-0.331-0.197-0.518-0.164    c-1.115,0.198-2.208-0.342-2.729-1.344c-0.521-1.002-0.334-2.212,0.465-3.01l2.561-2.558c0.42-0.419,0.599-1.016,0.481-1.597    c-0.119-0.581-0.519-1.058-1.069-1.278c-1.315-0.525-2.234-1.778-2.341-3.192c-0.107-1.413,0.612-2.791,1.832-3.51l0.769-0.452    c0.274-0.161,0.428-0.471,0.392-0.788c-0.036-0.316-0.255-0.583-0.559-0.679c-1.146-0.363-1.921-1.414-1.927-2.617    c-0.008-1.204,0.755-2.265,1.897-2.64c0.314-0.104,0.529-0.396,0.533-0.727c0.004-0.331-0.202-0.63-0.514-0.742l-0.137-0.048    c-1.242-0.448-2.084-1.588-2.148-2.905c-0.063-1.318,0.665-2.534,1.856-3.097c0.256-0.121,0.41-0.392,0.383-0.675    c-0.027-0.282-0.229-0.52-0.503-0.59c-1.048-0.27-1.821-1.138-1.97-2.211c-0.148-1.074,0.361-2.12,1.296-2.665l0.954-0.556    c0.236-0.137,0.37-0.401,0.342-0.673c-0.028-0.271-0.213-0.502-0.471-0.588c-1.043-0.347-1.76-1.281-1.828-2.378    c-0.067-1.099,0.53-2.114,1.523-2.586l1.12-0.533c0.204-0.097,0.328-0.305,0.318-0.53c-0.01-0.225-0.153-0.421-0.363-0.499    c-1.057-0.392-1.722-1.41-1.655-2.536c0.065-1.125,0.845-2.059,1.94-2.323c0.283-0.068,0.502-0.285,0.573-0.567    c0.071-0.282-0.018-0.578-0.234-0.772l-0.943-0.848c-0.923-0.831-1.224-2.16-0.748-3.307c0.476-1.148,1.627-1.873,2.866-1.806    c0.261,0.017,0.516-0.08,0.704-0.258c0.188-0.178,0.296-0.429,0.296-0.689v-0.898c0-1.093,0.733-2.067,1.784-2.367    c1.049-0.302,2.186,0.138,2.764,1.067c0.09,0.145,0.259,0.246,0.423,0.224c0.17-0.006,0.325-0.104,0.404-0.255    c0.554-1.062,1.72-1.65,2.901-1.468c1.182,0.185,2.114,1.101,2.319,2.281l0.502,2.885c0.094,0.54-0.267,1.054-0.807,1.148    c-0.536,0.094-1.052-0.268-1.147-0.808l-0.502-2.885c-0.059-0.341-0.329-0.606-0.67-0.659c-0.341-0.055-0.679,0.118-0.839,0.424    c-0.406,0.781-1.206,1.288-2.087,1.322c-0.887,0.023-1.715-0.412-2.18-1.16c-0.111-0.18-0.334-0.264-0.536-0.207    c-0.204,0.058-0.346,0.247-0.346,0.459v0.898c0,0.802-0.333,1.578-0.915,2.13c-0.582,0.552-1.373,0.844-2.176,0.799    c-0.398-0.031-0.773,0.213-0.927,0.584c-0.153,0.371-0.056,0.801,0.242,1.07l0.942,0.847c0.765,0.688,1.084,1.736,0.832,2.736    c-0.253,0.999-1.03,1.769-2.031,2.01c-0.24,0.058-0.411,0.263-0.425,0.51c-0.015,0.248,0.131,0.472,0.363,0.557    c0.96,0.355,1.611,1.246,1.657,2.271c0.046,1.025-0.522,1.972-1.448,2.412l-1.12,0.533c-0.258,0.123-0.413,0.386-0.395,0.671    c0.018,0.284,0.204,0.527,0.475,0.617c0.996,0.331,1.71,1.221,1.817,2.267c0.108,1.046-0.409,2.064-1.317,2.593l-0.954,0.556    c-0.238,0.139-0.367,0.404-0.329,0.677c0.038,0.272,0.234,0.492,0.5,0.561c1.08,0.278,1.877,1.212,1.983,2.324    c0.106,1.113-0.501,2.18-1.509,2.658c-0.464,0.22-0.748,0.694-0.723,1.207c0.025,0.513,0.353,0.958,0.835,1.132l0.137,0.049    c1.11,0.4,1.843,1.46,1.827,2.638c-0.017,1.178-0.779,2.217-1.896,2.586c-0.322,0.106-0.536,0.403-0.534,0.742    c0.002,0.338,0.22,0.634,0.542,0.737c1.049,0.331,1.807,1.253,1.931,2.349c0.124,1.095-0.409,2.163-1.358,2.723l-0.769,0.452    c-0.572,0.337-0.91,0.984-0.86,1.647c0.05,0.665,0.482,1.253,1.099,1.499c1.171,0.468,2.022,1.487,2.276,2.724    c0.253,1.238-0.129,2.509-1.023,3.401l-2.561,2.558c-0.182,0.182-0.225,0.458-0.106,0.687c0.119,0.23,0.369,0.348,0.623,0.307    c0.824-0.145,1.674,0.121,2.267,0.714c0.594,0.595,0.86,1.444,0.712,2.272l-0.405,2.274c-0.066,0.368,0.095,0.735,0.411,0.934    c0.317,0.202,0.717,0.19,1.021-0.027c0.812-0.579,1.846-0.7,2.768-0.33c0.923,0.374,1.582,1.182,1.764,2.161    c0.076,0.411,0.387,0.744,0.79,0.849c0.403,0.1,0.837-0.036,1.103-0.359l2.185-2.645c0.349-0.421,0.974-0.481,1.395-0.132    c0.422,0.349,0.481,0.975,0.132,1.398l-2.185,2.645C57.297,170.657,56.421,171.055,55.519,171.055z"></path></g><g><path fill="#D3DCE6" d="M40.678,134.504h-10.77c-0.274,0-0.496-0.222-0.496-0.496s0.222-0.496,0.496-0.496h10.77    c0.274,0,0.496,0.222,0.496,0.496S40.952,134.504,40.678,134.504z"></path></g><g><path fill="#D3DCE6" d="M28.111,134.504H27.13c-0.274,0-0.496-0.222-0.496-0.496s0.222-0.496,0.496-0.496h0.982    c0.274,0,0.496,0.222,0.496,0.496S28.385,134.504,28.111,134.504z"></path></g><g><path fill="#D3DCE6" d="M35.951,134.504c-0.274,0-0.496-0.222-0.496-0.496v-10.113c0-0.274,0.222-0.496,0.496-0.496    s0.496,0.222,0.496,0.496v10.113C36.446,134.282,36.225,134.504,35.951,134.504z"></path></g><g><path fill="#D3DCE6" d="M35.951,114.433c-0.274,0-0.496-0.222-0.496-0.496v-10.113c0-0.274,0.222-0.496,0.496-0.496    s0.496,0.222,0.496,0.496v10.113C36.446,114.211,36.225,114.433,35.951,114.433z"></path></g><g><path fill="#D3DCE6" d="M26.061,124.39c-0.274,0-0.496-0.222-0.496-0.496v-9.957c0-0.274,0.222-0.496,0.496-0.496    s0.496,0.222,0.496,0.496v9.957C26.557,124.168,26.335,124.39,26.061,124.39z"></path></g><g><path fill="#D3DCE6" d="M47.125,124.39H22.855c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h24.269    c0.274,0,0.496,0.222,0.496,0.496C47.62,124.168,47.399,124.39,47.125,124.39z"></path></g><g><path fill="#D3DCE6" d="M20.548,124.39h-1.241c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h1.241    c0.274,0,0.496,0.222,0.496,0.496C21.043,124.168,20.822,124.39,20.548,124.39z"></path></g><g><path fill="#D3DCE6" d="M43.242,104.32H32.599c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h10.643    c0.274,0,0.496,0.222,0.496,0.496C43.738,104.098,43.516,104.32,43.242,104.32z"></path></g><g><path fill="#D3DCE6" d="M45.771,114.398H34.01c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h11.76    c0.274,0,0.496,0.222,0.496,0.496C46.267,114.176,46.045,114.398,45.771,114.398z"></path></g><g><path fill="#D3DCE6" d="M31.959,114.398h-1.154c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h1.154    c0.274,0,0.496,0.222,0.496,0.496C32.454,114.176,32.233,114.398,31.959,114.398z"></path></g><g><path fill="#D3DCE6" d="M29.01,114.398h-5.77c-0.274,0-0.496-0.222-0.496-0.496c0-0.274,0.222-0.496,0.496-0.496h5.77    c0.274,0,0.496,0.222,0.496,0.496C29.506,114.176,29.284,114.398,29.01,114.398z"></path></g><g><path fill="#5F5370" d="M466.513,260.147H1.487c-0.821,0-1.487-0.667-1.487-1.489c0-0.822,0.666-1.489,1.487-1.489h465.026    c0.821,0,1.487,0.667,1.487,1.489C468,259.48,467.334,260.147,466.513,260.147z"></path></g><g><path fill="#FFFFFF" d="M257.139,57.74h-13.584c-12.799,0-23.174,10.375-23.174,23.174v44.459c0,4.197,3.402,7.599,7.599,7.599    h44.734c4.197,0,7.599-3.402,7.599-7.599V80.914C280.313,68.115,269.937,57.74,257.139,57.74z"></path></g><g><path fill="#BABAD5" d="M257.098,57.476h-13.503c-12.821,0-23.214,10.393-23.214,23.214v44.669c0,4.204,3.408,7.612,7.612,7.612    H272.7c4.204,0,7.612-3.408,7.612-7.612V80.691C280.313,67.87,269.919,57.476,257.098,57.476z"></path></g><g><path fill="#867B99" d="M276.611,86.539c-0.274,0-0.496-0.222-0.496-0.496v-2.624c0-0.274,0.222-0.496,0.496-0.496    c0.274,0,0.496,0.222,0.496,0.496v2.624C277.106,86.317,276.885,86.539,276.611,86.539z"></path></g><g><path fill="#867B99" d="M276.464,79.229c-0.247,0-0.461-0.185-0.491-0.437c-1.194-9.96-9.661-17.47-19.695-17.47h-6.605    c-0.274,0-0.496-0.222-0.496-0.496s0.222-0.496,0.496-0.496h6.605c10.536,0,19.426,7.886,20.679,18.344    c0.033,0.272-0.161,0.519-0.433,0.552C276.503,79.229,276.484,79.229,276.464,79.229z"></path></g><g><path fill="#867B99" d="M224.145,80.088c-0.013,0-0.026,0-0.039-0.001c-0.273-0.021-0.477-0.26-0.456-0.533    c0.796-10.295,9.16-18.542,19.455-19.183c0.294-0.01,0.508,0.192,0.526,0.464c0.017,0.274-0.191,0.509-0.464,0.526    c-9.805,0.61-17.77,8.464-18.528,18.269C224.618,79.89,224.401,80.088,224.145,80.088z"></path></g><g><path fill="#867B99" d="M224.083,94.002c-0.274,0-0.496-0.222-0.496-0.496v-2.624c0-0.274,0.222-0.496,0.496-0.496    c0.274,0,0.496,0.222,0.496,0.496v2.624C224.578,93.78,224.357,94.002,224.083,94.002z"></path></g><g><path fill="#867B99" d="M220.381,125.354c0,4.207,3.406,7.617,7.607,7.617h44.717c4.201,0,7.607-3.41,7.607-7.617H220.381z"></path><path fill="#5E5271" d="M272.705,133.964h-44.716c-4.741,0-8.599-3.863-8.599-8.61c0-0.548,0.444-0.993,0.991-0.993h59.932    c0.548,0,0.991,0.444,0.991,0.993C281.304,130.102,277.446,133.964,272.705,133.964z M221.446,126.347    c0.48,3.184,3.231,5.632,6.542,5.632h44.716c3.312,0,6.063-2.449,6.542-5.632H221.446z"></path></g><g><g><path fill="#FBB563" d="M245.163,57.476v-2.794c0-4.6,2.321-8.33,5.184-8.33h0c2.863,0,5.184,3.729,5.184,8.33v2.794h4.246     v-2.794c0-4.6-4.222-8.33-9.43-8.33h0c-5.208,0-9.43,3.729-9.43,8.33v2.794H245.163z"></path><path fill="#FBB563" d="M259.777,57.972h-4.246c-0.274,0-0.496-0.222-0.496-0.496v-2.794c0-4.32-2.104-7.834-4.689-7.834     c-2.585,0-4.688,3.514-4.688,7.834v2.794c0,0.274-0.222,0.496-0.496,0.496h-4.247c-0.274,0-0.496-0.222-0.496-0.496v-2.794     c0-4.867,4.453-8.826,9.926-8.826c5.473,0,9.926,3.959,9.926,8.826v2.794C260.273,57.75,260.051,57.972,259.777,57.972z      M256.027,56.98h3.254v-2.298c0-3.343-2.401-6.204-5.77-7.326c1.517,1.587,2.516,4.278,2.516,7.326V56.98z M241.412,56.98h3.255     v-2.298c0-3.048,0.999-5.74,2.516-7.326c-3.37,1.122-5.771,3.983-5.771,7.326V56.98z"></path></g></g><g><path fill="#BABAD5" d="M272.637,98.431h-44.581c-1.299,0-2.352,1.053-2.352,2.352v24.306c0,1.299,1.053,2.352,2.352,2.352h44.581    c1.299,0,2.352-1.053,2.352-2.352v-24.306C274.99,99.484,273.936,98.431,272.637,98.431z"></path><path fill="#5E5271" d="M272.639,127.938h-44.584c-1.57,0-2.846-1.279-2.846-2.851v-24.303c0-1.572,1.277-2.85,2.846-2.85h44.584    c1.569,0,2.846,1.278,2.846,2.85v24.303C275.485,126.659,274.208,127.938,272.639,127.938z M228.055,98.927    c-1.023,0-1.855,0.833-1.855,1.858v24.303c0,1.025,0.832,1.858,1.855,1.858h44.584c1.022,0,1.855-0.834,1.855-1.858v-24.303    c0-1.025-0.833-1.858-1.855-1.858H228.055z"></path></g><g><polygon fill="#FBB563" points="258.401,78.673 250.347,86.737 242.293,78.673 250.347,70.609   "></polygon><path fill="#5E5271" d="M250.346,87.73c-0.254,0-0.507-0.097-0.701-0.291l-8.054-8.064c-0.387-0.388-0.387-1.016,0-1.404    l8.054-8.064c0.387-0.388,1.014-0.388,1.402,0l8.054,8.064c0.387,0.388,0.387,1.016,0,1.404l-8.054,8.064    C250.854,87.633,250.6,87.73,250.346,87.73z M243.694,78.673l6.652,6.661l6.652-6.661l-6.652-6.661L243.694,78.673z"></path></g><g><g><path fill="#5E5271" d="M248.851,81.154c-0.274,0-0.496-0.222-0.496-0.496v-3.984c0-0.274,0.222-0.496,0.496-0.496     c0.274,0,0.496,0.222,0.496,0.496v3.984C249.347,80.932,249.125,81.154,248.851,81.154z"></path></g><g><path fill="#5E5271" d="M251.843,81.154c-0.274,0-0.496-0.222-0.496-0.496v-3.984c0-0.274,0.222-0.496,0.496-0.496     s0.496,0.222,0.496,0.496v3.984C252.339,80.932,252.117,81.154,251.843,81.154z"></path></g></g><g><path fill="#FBB563" d="M231.87,113.433h-1.395c-0.854,0-1.519-0.744-1.424-1.594l0.651-5.835    c0.081-0.726,0.694-1.275,1.424-1.275l0,0c0.721,0,1.33,0.537,1.421,1.253l0.744,5.835    C233.401,112.674,232.733,113.433,231.87,113.433z"></path><path fill="#5E5271" d="M231.87,113.929h-1.395c-0.548,0-1.072-0.235-1.438-0.644c-0.365-0.409-0.54-0.956-0.479-1.502    l0.651-5.835c0.11-0.978,0.934-1.717,1.917-1.717c0.968,0,1.79,0.725,1.913,1.687l0.744,5.835c0.07,0.55-0.1,1.104-0.466,1.52    C232.952,113.69,232.424,113.929,231.87,113.929z M231.126,105.225c-0.478,0-0.878,0.359-0.931,0.835l-0.651,5.835    c-0.03,0.269,0.053,0.528,0.233,0.73c0.18,0.202,0.428,0.313,0.698,0.313h1.395c0.273,0,0.523-0.113,0.704-0.318    c0.181-0.205,0.261-0.468,0.226-0.739l-0.744-5.835C231.996,105.577,231.596,105.225,231.126,105.225z"></path></g><g><path fill="#867B99" d="M274.99,107.001h-49.286v-6.218c0-1.299,1.053-2.352,2.352-2.352h44.581c1.299,0,2.352,1.053,2.352,2.352    V107.001z"></path><path fill="#5E5271" d="M274.989,107.994h-49.285c-0.547,0-0.991-0.444-0.991-0.993v-6.216c0-1.845,1.499-3.346,3.342-3.346    h44.584c1.842,0,3.342,1.501,3.342,3.346v6.216C275.981,107.549,275.537,107.994,274.989,107.994z M226.695,106.008h47.303v-5.224    c0-0.751-0.61-1.361-1.359-1.361h-44.584c-0.75,0-1.36,0.611-1.36,1.361V106.008z"></path></g><g><path fill="#5E5271" d="M272.705,133.964h-44.716c-4.741,0-8.599-3.863-8.599-8.61V80.706c0-13.356,10.852-24.222,24.19-24.222    h13.533c13.339,0,24.191,10.866,24.191,24.222v44.648C281.304,130.102,277.446,133.964,272.705,133.964z M243.58,58.469    c-12.245,0-22.208,9.975-22.208,22.237v44.648c0,3.653,2.968,6.625,6.616,6.625h44.716c3.648,0,6.616-2.972,6.616-6.625V80.706    c0-12.262-9.963-22.237-22.208-22.237H243.58z"></path></g><g><path fill="#5E5271" d="M272.639,128.435h-44.584c-1.843,0-3.342-1.501-3.342-3.347v-24.303c0-1.845,1.499-3.346,3.342-3.346    h44.584c1.842,0,3.342,1.501,3.342,3.346v24.303C275.981,126.933,274.481,128.435,272.639,128.435z M228.055,99.423    c-0.75,0-1.36,0.611-1.36,1.361v24.303c0,0.751,0.61,1.362,1.36,1.362h44.584c0.749,0,1.359-0.611,1.359-1.362v-24.303    c0-0.751-0.61-1.361-1.359-1.361H228.055z"></path></g><g><g><path fill="#A1C083" d="M288.077,115.488c-0.203-6.632,5.025-12.141,10.771-14.67c5.656-2.489,15.236-3.281,19.799,1.856     c3.224,3.63,2.13,9.117,0.512,13.214c-2.585,6.548-7.566,11.189-13.107,15.348c-1.009,0.757-0.022,2.481,1.001,1.714     c7.871-5.908,17.191-15.327,15.478-26.328c-1.913-12.282-19.701-10.991-27.557-5.975c-5.028,3.211-9.068,8.659-8.879,14.839     C286.133,116.762,288.116,116.768,288.077,115.488L288.077,115.488z"></path></g></g><g><g><path fill="#A1C083" d="M314.557,98.802c-2.31-0.895-5.57-0.595-7.3,2.321c-1.795,3.026-0.423,5.35,1.043,8.143     c0.476-2.307,2.836-2.964,4.282-4.465C313.695,103.645,315.592,100.417,314.557,98.802"></path></g><g><g><path fill="#5F5371" d="M314.82,97.845c-2.839-0.982-6.02-0.381-7.923,2.059c-2.534,3.25-1.157,6.626,0.546,9.862      c0.407,0.774,1.584,0.555,1.812-0.237c0.672-2.33,3.776-3.385,5.105-5.43c1.105-1.7,1.992-3.849,1.052-5.798      c-0.555-1.15-2.265-0.144-1.712,1.002c0.961,1.991-1.633,4.758-3.049,5.799c-1.492,1.096-2.771,2.037-3.308,3.899      c0.604-0.079,1.208-0.158,1.812-0.237c-1.334-2.535-2.784-5.395-0.482-7.913c1.48-1.619,3.657-1.77,5.62-1.092      C315.501,100.177,316.021,98.26,314.82,97.845L314.82,97.845z"></path></g></g></g><g><g><path fill="#A1C083" d="M319.918,103.976c7.873-0.527,10.793,7.779,7.676,14.117c-2.519-0.569-5.181-2.873-6.928-4.863     C319.066,111.407,317.935,105.843,319.918,103.976"></path></g><g><g><path fill="#5F5371" d="M319.918,104.968c7.007-0.251,9.427,6.965,6.82,12.624c0.373-0.152,0.746-0.304,1.119-0.456      c-2.632-0.751-5.633-2.926-6.966-5.369c-0.988-1.809-1.782-5.369-0.272-7.089c0.839-0.956-0.558-2.365-1.402-1.404      c-2.024,2.306-1.506,6.016-0.425,8.651c1.368,3.336,5.15,6.159,8.539,7.126c0.387,0.11,0.939-0.065,1.119-0.456      c3.207-6.961,0.086-15.92-8.532-15.611C318.646,103.029,318.64,105.014,319.918,104.968L319.918,104.968z"></path></g></g></g><g><g><path fill="#A1C083" d="M304.191,133.813c1.523,0.043,2.976-0.694,3.773-1.994c1.27-2.071,1.726-4.69,0.356-7.163     c-1.959-3.533-9.442-2.075-12.943-2.817c3.199,2.606-0.16,6.413,1.601,9.328C298.192,133.178,301.517,133.738,304.191,133.813z"></path></g><g><g><path fill="#5F5371" d="M304.191,134.806c5.299-0.236,7.928-7.476,4.432-11.41c-3.064-3.447-8.997-1.792-12.983-2.515      c-0.913-0.166-1.735,0.923-0.964,1.659c2.624,2.506-0.413,6.436,1.619,9.363C297.984,134.34,301.483,134.688,304.191,134.806      c1.276,0.055,1.273-1.93,0-1.985c-1.614-0.07-3.434-0.183-4.897-0.948c-2.117-1.106-1.931-2.852-1.665-4.914      c0.295-2.297,0.21-4.141-1.551-5.822c-0.321,0.553-0.643,1.106-0.964,1.659c2.752,0.499,5.568,0.151,8.336,0.495      c1.505,0.187,3.126,0.515,4.015,1.866c1.813,2.755,0.209,7.509-3.273,7.664C302.92,132.877,302.913,134.862,304.191,134.806z"></path></g></g></g><g><g><path fill="#A1C083" d="M321.299,104.094c0.772-2.479,4.173-6.504,6.832-7.3c3.685-1.103,8.58,2.548,9.961,5.759     c-4.007,1.123-3.658,4.87-7.591,6.309C327.048,110.126,322.492,107.675,321.299,104.094"></path></g><g><g><path fill="#5F5371" d="M322.255,104.358c0.974-2.687,3.972-6.6,7.075-6.768c3.28-0.177,6.558,2.676,7.907,5.464      c0.197-0.486,0.395-0.972,0.592-1.458c-2.879,0.974-3.614,3.042-5.65,5.025c-3.217,3.134-8.408,1.085-9.923-2.791      c-0.46-1.176-2.378-0.664-1.912,0.528c1.362,3.484,4.834,6.051,8.666,5.808c1.738-0.11,3.347-0.916,4.571-2.141      c1.647-1.648,2.398-3.71,4.776-4.515c0.639-0.216,0.882-0.86,0.592-1.458c-1.719-3.555-6.08-6.978-10.226-6.386      c-3.817,0.545-7.14,4.745-8.379,8.164C319.907,105.033,321.822,105.551,322.255,104.358L322.255,104.358z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M320.825,103c-2.766-0.326-3.09-2.71-2.806-4.418c0.393-2.367,4.018-4.844,6.191-4.739     c-0.47,2.553,1.501,3.553,1.229,6.151C325.199,102.276,323.153,103.313,320.825,103z"></path></g><g><g><path fill="#5F5371" d="M321.088,102.043c-2.039-0.359-2.719-2.363-1.769-4.141c0.865-1.62,3.056-3.038,4.891-3.067      c-0.33-0.331-0.661-0.662-0.991-0.993c-0.218,1.76,0.586,2.897,1.057,4.506c0.759,2.592-1.069,3.883-3.451,3.659      c-1.27-0.119-1.262,1.867,0,1.985c2.201,0.207,4.562-0.583,5.361-2.834c0.958-2.699-1.306-4.721-0.984-7.316      c0.065-0.528-0.507-1-0.991-0.993c-2.815,0.044-6.241,2.287-7.052,5.073c-0.802,2.751,0.504,5.523,3.404,6.035      C321.809,104.177,322.344,102.264,321.088,102.043z"></path></g></g></g><g><path fill="#A1C083" d="M299.267,101.509c3.112-3.894,1.499-13.584-12.139-6.257C291.529,96.751,295.714,107.339,299.267,101.509z    "></path><path fill="#5F5371" d="M296.912,104.24c-2.016,0-3.815-2.035-5.716-4.184c-1.472-1.666-2.996-3.389-4.388-3.863    c-0.374-0.127-0.636-0.464-0.669-0.858c-0.032-0.394,0.172-0.769,0.52-0.956c8.591-4.615,12.226-2.47,13.63-0.782    c2.054,2.47,1.492,6.309-0.208,8.484c-0.823,1.328-1.8,2.05-2.904,2.148C297.088,104.236,297,104.24,296.912,104.24z     M289.237,95.302c1.2,0.9,2.335,2.183,3.444,3.438c1.497,1.692,3.192,3.616,4.32,3.511c0.458-0.04,0.935-0.464,1.419-1.258    c0.021-0.036,0.046-0.071,0.072-0.104c1.225-1.531,1.638-4.382,0.273-6.024C297.214,93,293.786,93.175,289.237,95.302z"></path></g><g><path fill="#5F5371" d="M317.211,122.29c-0.068,0-0.137-0.014-0.203-0.044c-0.25-0.112-0.361-0.406-0.249-0.656    c0.262-0.585,0.31-1.092,0.139-1.467c-0.095-0.207-0.25-0.36-0.421-0.472c-0.168,0.37-0.495,0.642-0.95,0.783    c-0.398,0.124-0.753,0.027-0.959-0.258c-0.23-0.318-0.197-0.798,0.084-1.193c0.169-0.238,0.446-0.457,0.808-0.542    c-0.09-0.182-0.196-0.326-0.256-0.368c-0.136-0.083-0.392-0.179-0.669-0.228c-0.203,0.34-0.47,0.634-0.742,0.791    c-0.441,0.255-0.906,0.184-1.218-0.185c-0.112-0.133-0.147-0.316-0.09-0.481c0.171-0.502,0.517-0.858,0.997-1.031    c0.135-0.048,0.274-0.08,0.415-0.098c0.013-0.061,0.016-0.114,0.008-0.155c-0.161-0.442-0.725-0.587-1.875-0.479    c-0.256,0.036-0.514-0.173-0.54-0.447c-0.025-0.273,0.174-0.515,0.447-0.541c0.723-0.07,2.406-0.227,2.902,1.135    c0.059,0.161,0.07,0.35,0.044,0.549c0.348,0.08,0.65,0.208,0.842,0.326c0.313,0.192,0.695,0.74,0.83,1.35    c0.585,0.237,1.012,0.625,1.243,1.132c0.204,0.448,0.347,1.208-0.136,2.286C317.58,122.181,317.399,122.29,317.211,122.29z"></path></g><g><path fill="#CCDBB0" d="M296.162,99.42c4.913-3.645,7.632,3.688,6.815,9.867C296.31,109.283,291.249,103.065,296.162,99.42z"></path><path fill="#5F5371" d="M302.977,110.279C302.977,110.279,302.977,110.279,302.977,110.279c-4.333-0.002-8.42-2.492-9.506-5.791    c-0.724-2.2,0.042-4.338,2.101-5.867c2.225-1.651,3.95-1.259,5.005-0.635c2.95,1.74,3.945,7.188,3.383,11.431    C303.894,109.91,303.474,110.279,302.977,110.279z M298.664,99.436c-0.463,0-1.094,0.174-1.912,0.781    c-1.368,1.014-1.851,2.276-1.399,3.649c0.66,2.004,3.301,4.073,6.733,4.387c0.273-3.76-0.805-7.548-2.517-8.557    C299.424,99.61,299.129,99.436,298.664,99.436z"></path></g><g><path fill="#A1C083" d="M308.193,135.596c-4.354-3.616-2.129-6.598,1.017-7.808c3.441-1.324,6.734,2.211,10.766,0    C321.65,132.515,314.373,139.503,308.193,135.596z"></path><path fill="#5F5371" d="M312.013,137.73c-1.412,0-2.895-0.375-4.35-1.294c-0.036-0.023-0.071-0.048-0.104-0.076    c-2.629-2.183-2.939-4.118-2.736-5.357c0.288-1.757,1.757-3.266,4.03-4.141c1.853-0.71,3.585-0.264,5.261,0.169    c1.808,0.468,3.521,0.909,5.384-0.113c0.256-0.14,0.558-0.161,0.83-0.057c0.271,0.103,0.484,0.321,0.581,0.595    c0.931,2.629-0.336,5.909-3.153,8.163C316.273,136.807,314.231,137.73,312.013,137.73z M308.775,134.791    c3.577,2.218,6.828,0.011,7.744-0.722c1.725-1.381,2.734-3.254,2.708-4.875c-2.063,0.676-3.929,0.194-5.609-0.24    c-1.499-0.388-2.794-0.723-4.055-0.238c-1.575,0.606-2.616,1.581-2.784,2.609C306.568,132.62,307.736,133.917,308.775,134.791z"></path></g><g><path fill="#5F5371" d="M310.63,97.452c-0.069,0-0.137-0.014-0.204-0.044c-0.249-0.113-0.36-0.407-0.248-0.657    c0.415-0.919,1.099-1.629,1.82-2.068c-0.009-0.421,0.082-0.883,0.319-1.362c0.166-0.331,0.539-0.808,1.018-1.196    c-0.049-0.55-0.016-1.25,0.143-2.142c0.048-0.269,0.301-0.447,0.576-0.401c0.269,0.048,0.448,0.306,0.4,0.576    c-0.101,0.563-0.145,1.027-0.149,1.409c0.022-0.007,0.045-0.015,0.067-0.021c0.449-0.136,0.872-0.103,1.225,0.1    c0.804,0.46,0.861,1.156,0.665,1.612c-0.277,0.648-1.052,1.009-1.72,0.806c-0.299-0.09-0.676-0.311-0.932-0.844    c-0.184,0.194-0.328,0.39-0.405,0.542c-0.082,0.167-0.138,0.329-0.172,0.485c0.361-0.084,0.702-0.088,0.993-0.006    c0.628,0.178,0.96,0.741,0.867,1.468c-0.106,0.823-0.564,1.075-0.828,1.152c-0.487,0.142-1.057-0.086-1.485-0.598    c-0.129-0.154-0.247-0.336-0.342-0.542c-0.442,0.329-0.873,0.807-1.157,1.437C310.999,97.344,310.819,97.452,310.63,97.452z     M313.117,95.258c0.06,0.143,0.137,0.268,0.224,0.37c0.194,0.232,0.386,0.297,0.447,0.283c0.022-0.007,0.093-0.096,0.122-0.327    c0.043-0.33-0.076-0.363-0.154-0.386C313.604,95.155,313.377,95.175,313.117,95.258z M314.428,92.589    c0.106,0.329,0.263,0.485,0.398,0.525c0.201,0.057,0.455-0.084,0.525-0.248c0.05-0.116-0.033-0.237-0.246-0.359    c-0.042-0.023-0.166-0.098-0.444-0.012C314.584,92.52,314.507,92.551,314.428,92.589z"></path></g><g><path fill="#CCDBB0" d="M303.81,130.674c3.256,0.521,3.951,3.05,3.377,4.462c-1.131,2.782-5.081,5.384-7.21,4.925    C300.589,137.576,297.824,130.561,303.81,130.674z"></path><path fill="#5F5371" d="M300.496,141.104c-0.254,0-0.497-0.024-0.728-0.074c-0.261-0.056-0.49-0.217-0.632-0.445    c-0.141-0.227-0.186-0.503-0.121-0.764c0.126-0.512,0.047-1.496-0.029-2.447c-0.17-2.126-0.382-4.773,1.135-6.387    c0.841-0.896,2.083-1.331,3.708-1.305c0.046,0.001,0.093,0.005,0.138,0.013c1.763,0.282,3.133,1.146,3.856,2.432    c0.593,1.055,0.702,2.351,0.284,3.383C306.915,138.439,303.169,141.104,300.496,141.104z M303.665,131.665    c-0.983,0-1.671,0.223-2.101,0.681c-0.915,0.974-0.742,3.134-0.602,4.869c0.053,0.67,0.103,1.289,0.103,1.848    c1.749-0.358,4.382-2.28,5.205-4.302c0.146-0.362,0.19-1.014-0.174-1.661c-0.419-0.744-1.239-1.239-2.374-1.435    C303.703,131.665,303.683,131.665,303.665,131.665z"></path></g><g><rect x="197.039" y="104.905" fill="#FCB663" width="40.851" height="32.256"></rect><path fill="#5E5271" d="M237.891,138.153H197.04c-0.547,0-0.991-0.444-0.991-0.993v-32.255c0-0.548,0.444-0.993,0.991-0.993    h40.851c0.548,0,0.991,0.444,0.991,0.993v32.255C238.882,137.709,238.439,138.153,237.891,138.153z M198.031,136.168H236.9v-30.27    h-38.869V136.168z"></path></g><g><path fill="#FFDB98" d="M308.768,78.663L308.768,78.663c-0.692-0.235-1.493,0.105-1.892,0.805l-42.4,71.32    c-2.126,3.729-6.671,5.099-9.924,2.991h0c-3.253-2.108-3.865-6.821-1.337-10.29l47.628-67.931    c0.474-0.651,0.457-1.522-0.041-2.058l0,0c-0.988-1.063-1.073-2.77-0.205-4.112v0c1.027-1.588,3.02-2.123,4.453-1.194l6.814,4.417    c1.432,0.929,1.761,2.969,0.735,4.557l0,0C311.731,78.51,310.141,79.13,308.768,78.663z"></path></g><g><path fill="#FEEFD1" d="M289.313,108.859c-0.077,0-0.156-0.018-0.229-0.056l-4.316-2.252c-0.242-0.126-0.337-0.426-0.21-0.669    c0.127-0.243,0.427-0.337,0.669-0.211l4.316,2.252c0.242,0.126,0.337,0.426,0.21,0.669    C289.665,108.762,289.491,108.859,289.313,108.859z"></path></g><g><path fill="#FEEFD1" d="M282.904,114.416c-0.077,0-0.156-0.018-0.229-0.056c-0.242-0.126-0.337-0.426-0.21-0.669l2.249-4.321    c0.127-0.244,0.427-0.336,0.669-0.211c0.242,0.126,0.337,0.426,0.21,0.669l-2.249,4.321    C283.255,114.32,283.082,114.416,282.904,114.416z"></path></g><g><path fill="#FEEFD1" d="M286.798,112.66c-0.068,0-0.137-0.014-0.203-0.044l-3.533-1.587c-0.25-0.112-0.361-0.406-0.249-0.656    c0.111-0.251,0.402-0.361,0.655-0.25l3.533,1.587c0.25,0.112,0.361,0.406,0.249,0.656    C287.168,112.551,286.987,112.66,286.798,112.66z"></path></g><g><path fill="#5E5271" d="M257.942,155.765c-1.402,0-2.754-0.391-3.929-1.153c-1.689-1.094-2.83-2.837-3.212-4.906    c-0.43-2.325,0.159-4.805,1.614-6.801l47.618-67.916c0.2-0.276,0.216-0.627,0.044-0.811c-1.303-1.404-1.432-3.595-0.312-5.328    c1.323-2.045,3.935-2.712,5.824-1.488l6.815,4.417c1.889,1.224,2.35,3.884,1.029,5.929c-1.121,1.734-3.169,2.514-4.982,1.897    c0,0,0,0-0.001,0c-0.236-0.084-0.551,0.076-0.711,0.357l-42.409,71.336c-1.215,2.13-3.233,3.683-5.529,4.243    C259.177,155.69,258.554,155.765,257.942,155.765z M303.487,68.729c-0.766,0-1.563,0.432-2.058,1.198    c-0.617,0.953-0.575,2.171,0.099,2.896c0.822,0.886,0.871,2.281,0.117,3.319l-47.619,67.917c-1.146,1.573-1.607,3.493-1.276,5.285    c0.282,1.527,1.113,2.806,2.34,3.601c1.228,0.797,2.735,1.029,4.24,0.665c1.769-0.431,3.33-1.639,4.285-3.314l42.409-71.336    c0.627-1.099,1.917-1.625,3.063-1.237c0.934,0.32,2.064-0.143,2.68-1.096c0.727-1.126,0.529-2.555-0.441-3.185l-6.815-4.417    C304.2,68.825,303.847,68.729,303.487,68.729z"></path></g><g><polygon fill="#FEEFD1" points="292.823,104.381 283.895,98.595 299.233,76.998 306.222,81.528   "></polygon><path fill="#5E5271" d="M292.823,105.374c-0.19,0-0.377-0.054-0.538-0.159l-8.928-5.787c-0.227-0.147-0.384-0.38-0.436-0.647    c-0.05-0.266,0.01-0.541,0.166-0.762l15.338-21.596c0.309-0.433,0.903-0.547,1.346-0.258l6.989,4.53    c0.446,0.289,0.586,0.877,0.317,1.336l-13.399,22.853c-0.136,0.234-0.363,0.401-0.626,0.463    C292.976,105.365,292.9,105.374,292.823,105.374z M285.303,98.325l7.189,4.66l12.396-21.14l-5.397-3.497L285.303,98.325z"></path></g><g><path fill="#FEEFD1" d="M304.411,84.618c0,0-1.456-0.213-3.233-0.473"></path><path fill="#5E5271" d="M304.411,85.114c-0.024,0-0.048-0.001-0.073-0.005l-3.233-0.473c-0.271-0.04-0.459-0.292-0.419-0.563    c0.041-0.272,0.295-0.464,0.562-0.419l3.233,0.473c0.271,0.039,0.458,0.291,0.419,0.563    C304.864,84.936,304.653,85.114,304.411,85.114z"></path></g><g><path fill="#FEEFD1" d="M298.75,83.789c-2.078-0.304-3.932-0.575-3.932-0.575"></path><path fill="#5E5271" d="M298.751,84.286c-0.024,0-0.048-0.001-0.073-0.005l-3.932-0.575c-0.271-0.04-0.459-0.291-0.419-0.563    c0.041-0.272,0.292-0.466,0.562-0.419l3.932,0.575c0.271,0.04,0.458,0.291,0.419,0.563    C299.204,84.108,298.993,84.286,298.751,84.286z"></path></g><g><path fill="#FEEFD1" d="M300.066,92.028c0,0-1.302-0.233-2.977-0.533"></path><path fill="#5E5271" d="M300.067,92.524c-0.029,0-0.059-0.002-0.088-0.008l-2.977-0.533c-0.27-0.048-0.449-0.306-0.401-0.576    c0.047-0.27,0.31-0.451,0.575-0.401l2.977,0.533c0.269,0.048,0.449,0.306,0.401,0.576    C300.511,92.355,300.302,92.524,300.067,92.524z"></path></g><g><path fill="#FEEFD1" d="M294.93,91.108c-2.541-0.455-5.072-0.908-5.072-0.908"></path><path fill="#5E5271" d="M294.931,91.604c-0.029,0-0.059-0.002-0.088-0.008l-5.072-0.908c-0.269-0.048-0.449-0.306-0.401-0.576    c0.047-0.27,0.309-0.448,0.575-0.401l5.072,0.908c0.269,0.048,0.449,0.306,0.401,0.576    C295.375,91.436,295.166,91.604,294.931,91.604z"></path></g><g><path fill="#FEEFD1" d="M296.343,98.377c0,0-1.786-0.256-3.93-0.563"></path><path fill="#5E5271" d="M296.345,98.873c-0.023,0-0.047-0.001-0.071-0.005l-3.93-0.563c-0.271-0.039-0.46-0.29-0.421-0.562    c0.04-0.272,0.291-0.464,0.56-0.421l3.93,0.563c0.271,0.039,0.46,0.29,0.421,0.562C296.799,98.695,296.587,98.873,296.345,98.873z    "></path></g><g><path fill="#FEEFD1" d="M289.985,97.466c-2.507-0.359-4.8-0.687-4.8-0.687"></path><path fill="#5E5271" d="M289.986,97.963c-0.023,0-0.047-0.001-0.072-0.005l-4.799-0.687c-0.271-0.039-0.46-0.29-0.421-0.562    c0.039-0.272,0.293-0.463,0.56-0.421l4.801,0.687c0.27,0.039,0.459,0.29,0.42,0.562C290.44,97.784,290.228,97.963,289.986,97.963z    "></path></g><g><line fill="#FFDB98" x1="300.802" y1="73.5" x2="303.097" y2="75.146"></line><path fill="#5E5271" d="M303.096,76.138c-0.199,0-0.402-0.06-0.576-0.186l-2.295-1.646c-0.445-0.319-0.548-0.939-0.229-1.385    s0.939-0.549,1.383-0.229l2.295,1.646c0.445,0.319,0.548,0.939,0.229,1.385C303.71,75.994,303.405,76.138,303.096,76.138z"></path></g><g><line fill="#FFDB98" x1="306.407" y1="77.2" x2="308.835" y2="78.642"></line><path fill="#5E5271" d="M308.834,79.635c-0.172,0-0.346-0.045-0.504-0.139l-2.429-1.442c-0.471-0.28-0.626-0.888-0.348-1.36    c0.279-0.472,0.887-0.627,1.358-0.348l2.429,1.442c0.471,0.28,0.626,0.888,0.348,1.36    C309.503,79.461,309.173,79.635,308.834,79.635z"></path></g><g><path fill="#619DD4" d="M180.964,120.264l-5.751-14.978c-3.16-8.23,0.929-17.471,9.165-20.642l17.749-6.833    c8.236-3.171,17.472,0.941,20.632,9.171l5.751,14.978C211.371,104.712,195.522,110.812,180.964,120.264z"></path><path fill="#5E5271" d="M180.964,121.256c-0.103,0-0.206-0.016-0.306-0.048c-0.284-0.093-0.512-0.309-0.619-0.588l-5.751-14.978    c-1.624-4.23-1.507-8.838,0.329-12.977c1.837-4.142,5.177-7.319,9.406-8.947l17.749-6.833c8.729-3.361,18.559,1.009,21.913,9.741    l5.751,14.978c0.107,0.279,0.083,0.592-0.066,0.852c-0.149,0.259-0.407,0.437-0.702,0.485    c-16.925,2.717-32.793,8.826-47.164,18.156C181.341,121.202,181.153,121.256,180.964,121.256z M207.847,77.737    c-1.786,0-3.6,0.321-5.364,1.001l-17.749,6.833c-3.734,1.437-6.684,4.243-8.306,7.9c-1.621,3.655-1.724,7.724-0.289,11.459    l5.314,13.841c13.989-8.893,29.349-14.806,45.696-17.591l-5.315-13.841C219.551,81.392,213.865,77.737,207.847,77.737z"></path></g><g><path fill="#B8D3E9" d="M185.643,117.543c11.851-6.577,24.376-11.398,37.574-14.465"></path><path fill="#619DD4" d="M185.644,118.536c-0.349,0-0.687-0.184-0.868-0.511c-0.266-0.479-0.092-1.084,0.386-1.349    c11.876-6.591,24.604-11.491,37.831-14.564c0.536-0.123,1.065,0.209,1.19,0.742c0.124,0.534-0.208,1.067-0.742,1.191    c-13.047,3.031-25.603,7.865-37.318,14.366C185.971,118.496,185.806,118.536,185.644,118.536z"></path></g><g><path fill="#FFFFFF" d="M215.89,89.275l5.561,14.483c-12.022,2.613-23.369,6.982-34.043,13.105l-5.561-14.483    c-2.768-7.208,0.268-15.065,6.79-17.576l10.453-4.024C205.597,78.276,213.122,82.067,215.89,89.275z"></path></g><g><path fill="#5E5271" d="M211.771,84.323c-0.231,0-0.463-0.08-0.651-0.245c-0.724-0.632-1.51-1.181-2.339-1.631    c-0.481-0.262-0.66-0.864-0.398-1.346s0.864-0.66,1.344-0.399c0.956,0.52,1.863,1.152,2.697,1.88    c0.412,0.361,0.455,0.987,0.095,1.401C212.322,84.209,212.047,84.323,211.771,84.323z"></path></g><g><path fill="#5E5271" d="M218.657,97.475c-0.398,0-0.774-0.242-0.925-0.637l-2.768-7.207c-0.402-1.047-0.921-2.041-1.544-2.952    c-0.309-0.453-0.193-1.071,0.259-1.38c0.454-0.308,1.07-0.192,1.378,0.259c0.709,1.039,1.301,2.17,1.757,3.361l2.768,7.207    c0.196,0.512-0.059,1.086-0.57,1.283C218.896,97.453,218.776,97.475,218.657,97.475z"></path></g><g><path fill="#5E5271" d="M185.56,113.043c-0.398,0-0.774-0.242-0.925-0.637l-3.713-9.67c-1.548-4.032-1.436-8.473,0.307-12.186    c0.232-0.496,0.824-0.712,1.318-0.476c0.496,0.233,0.709,0.824,0.475,1.32c-1.514,3.226-1.605,7.1-0.25,10.63l3.713,9.67    c0.196,0.512-0.059,1.086-0.57,1.283C185.799,113.022,185.679,113.043,185.56,113.043z"></path></g><g><polygon fill="#619DD4" points="200.507,93.995 204.068,92.624 195.87,88.032 192.856,96.94 196.417,95.569 194.502,101.228     198.524,99.679 199.738,102.842 202.906,101.622 201.692,98.46 205.714,96.911   "></polygon><path fill="#619DD4" d="M199.738,103.338c-0.199,0-0.387-0.121-0.463-0.318l-1.036-2.699l-3.559,1.37    c-0.177,0.069-0.381,0.029-0.521-0.106c-0.139-0.133-0.188-0.335-0.126-0.517l1.576-4.656l-2.575,0.992    c-0.178,0.07-0.382,0.029-0.521-0.105c-0.139-0.134-0.188-0.335-0.126-0.518l3.015-8.908c0.047-0.14,0.154-0.251,0.292-0.304    c0.137-0.053,0.291-0.041,0.42,0.03l8.198,4.591c0.167,0.094,0.266,0.277,0.252,0.469c-0.014,0.192-0.137,0.359-0.316,0.428    l-2.575,0.991l4.285,2.4c0.168,0.094,0.266,0.277,0.252,0.469c-0.014,0.192-0.137,0.359-0.317,0.428l-3.56,1.37l1.037,2.699    c0.047,0.123,0.044,0.26-0.01,0.38c-0.054,0.12-0.152,0.214-0.275,0.262l-3.168,1.22    C199.857,103.327,199.797,103.338,199.738,103.338z M198.524,99.183c0.199,0,0.387,0.121,0.463,0.318l1.036,2.699l2.243-0.864    l-1.037-2.699c-0.047-0.123-0.044-0.26,0.01-0.38c0.054-0.12,0.152-0.214,0.275-0.262l3.036-1.168l-4.284-2.4    c-0.168-0.094-0.266-0.277-0.252-0.469c0.014-0.192,0.137-0.359,0.316-0.428l2.575-0.991l-6.755-3.784l-2.484,7.341l2.575-0.992    c0.179-0.068,0.382-0.027,0.521,0.105c0.139,0.134,0.188,0.335,0.126,0.518l-1.576,4.656l3.035-1.168    C198.404,99.194,198.464,99.183,198.524,99.183z"></path></g><g><path fill="#619DD4" d="M195.868,82.01l-4.02,1.548c-1.544,0.594-3.277-0.176-3.87-1.72l-0.364-0.948    c-0.592-1.542,0.177-3.273,1.719-3.866l4.02-1.548c1.544-0.594,3.277,0.176,3.87,1.72l0.364,0.948    C198.179,79.686,197.409,81.417,195.868,82.01z"></path><path fill="#5E5271" d="M190.769,84.753c-0.55,0-1.099-0.115-1.617-0.346c-0.972-0.433-1.718-1.219-2.099-2.213l-0.363-0.945    c-0.381-0.994-0.354-2.078,0.078-3.051c0.432-0.973,1.217-1.72,2.21-2.102l4.022-1.548c0.993-0.381,2.075-0.354,3.047,0.079    c0.972,0.433,1.718,1.219,2.1,2.213l0.363,0.946c0.381,0.994,0.354,2.077-0.078,3.05c-0.432,0.973-1.217,1.72-2.21,2.102l0,0    l-4.023,1.548C191.736,84.664,191.252,84.753,190.769,84.753z M194.431,76.266c-0.242,0-0.485,0.045-0.718,0.135l-4.022,1.548    c-0.499,0.192-0.893,0.567-1.11,1.056c-0.217,0.489-0.231,1.033-0.039,1.532l0.363,0.945c0.192,0.5,0.566,0.894,1.054,1.111    c0.488,0.218,1.031,0.233,1.53,0.039l4.023-1.548c0.499-0.192,0.893-0.567,1.11-1.056c0.217-0.489,0.231-1.033,0.039-1.532    l-0.363-0.946c-0.192-0.499-0.566-0.894-1.054-1.111C194.983,76.325,194.707,76.266,194.431,76.266z M195.867,82.011h0.01H195.867    z"></path></g><g><path fill="#5E5271" d="M177.904,124.144c-0.478,0-0.946-0.23-1.234-0.656c-0.459-0.681-0.28-1.607,0.4-2.067    c1.626-1.1,3.227-2.129,4.757-3.06c1.491-0.944,2.973-1.829,4.383-2.616c11.056-6.283,22.967-10.868,35.391-13.623    c1.525-0.35,3.169-0.678,5.017-1c1.711-0.327,3.531-0.626,5.539-0.909c0.809-0.111,1.565,0.452,1.68,1.266    c0.115,0.814-0.452,1.567-1.265,1.682c-1.96,0.277-3.733,0.568-5.421,0.89c-1.819,0.316-3.413,0.634-4.896,0.975    c-12.146,2.693-23.779,7.171-34.587,13.313c-1.372,0.766-2.807,1.623-4.274,2.552c-1.513,0.92-3.073,1.923-4.66,2.997    C178.48,124.061,178.19,124.144,177.904,124.144z"></path></g><g><polygon fill="#D0D5E8" points="377.288,258.431 377.288,190.23 85.494,190.23 85.494,202.016 87.547,208.133 85.494,210.717     85.494,258.431   "></polygon><path fill="#5F5371" d="M377.289,259.919H85.494c-0.821,0-1.487-0.667-1.487-1.489v-47.713c0-0.336,0.114-0.664,0.323-0.927    l1.549-1.95l-1.795-5.35c-0.051-0.152-0.077-0.313-0.077-0.474V190.23c0-0.822,0.666-1.489,1.487-1.489h291.795    c0.821,0,1.487,0.667,1.487,1.489v68.2C378.776,259.252,378.11,259.919,377.289,259.919z M86.981,256.941h288.821v-65.222H86.981    v10.053l1.975,5.887c0.161,0.479,0.068,1.006-0.246,1.401l-1.729,2.176V256.941z"></path></g><g opacity="0.15"><path fill="#5F5371" d="M86.733,197.084l0.81,0.297c11.654,0.553,8.511,16.546,37.616,8.691    c30.634-8.267,28.854-1.076,43.188-1.128c6.797-0.025,12.15-4.92,18.826-5.953c11.236-1.739,16.394,10.427,38.398-2.107    L86.733,197.084z"></path><path fill="#5F5371" d="M111.426,209.213c-8.702,0-12.48-3.507-15.705-6.499c-2.408-2.234-4.488-4.163-8.225-4.34    c-0.101-0.005-0.2-0.025-0.295-0.06l-0.81-0.298c-0.451-0.166-0.718-0.631-0.635-1.104c0.084-0.474,0.495-0.819,0.975-0.82    l138.838-0.201c0,0,0.001,0,0.001,0c0.45,0,0.843,0.302,0.958,0.738c0.116,0.436-0.076,0.895-0.468,1.118    c-14.809,8.436-22.25,5.952-28.817,3.762c-3.374-1.125-6.288-2.097-9.92-1.535c-2.849,0.441-5.542,1.661-8.146,2.842    c-3.371,1.529-6.856,3.108-10.828,3.123c-4.776-0.007-7.803-0.747-10.743-1.486c-6.028-1.513-11.721-2.945-32.191,2.58    C119.657,208.586,115.102,209.213,111.426,209.213z M93.137,198.067c1.445,0.883,2.671,2.021,3.932,3.191    c4.45,4.127,9.491,8.807,27.833,3.857c20.969-5.659,26.905-4.169,33.19-2.588c2.821,0.709,5.754,1.436,10.253,1.426    c3.548-0.014,6.69-1.437,10.018-2.947c2.725-1.235,5.543-2.512,8.66-2.995c0.197-0.031,0.393-0.057,0.587-0.079L93.137,198.067z     M191.249,197.925c2.305,0.258,4.425,0.965,6.623,1.699c5.636,1.879,11.957,3.991,23.699-1.743L191.249,197.925z"></path></g><g opacity="0.15"><path fill="#5F5371" d="M86.401,252.641c29.052-12.625,29.097-2.216,50.017-2.918s42.652-9.036,55.794-4.631    c7.457,2.499,3.888,15.268,26.884,5.727c7.13-2.958,26.045-4.899,23.842,7.585l-156.793,0.027L86.401,252.641z"></path><path fill="#5F5371" d="M86.146,259.423c-0.271,0-0.529-0.111-0.716-0.306c-0.187-0.196-0.286-0.459-0.274-0.73l0.255-5.789    c0.017-0.379,0.248-0.715,0.596-0.867c19.212-8.349,26.175-6.728,34.238-4.848c4.41,1.026,8.973,2.091,16.14,1.848    c8.303-0.279,16.673-1.759,24.768-3.191c11.958-2.115,23.254-4.112,31.375-1.39c2.548,0.854,3.925,2.721,5.256,4.526    c2.878,3.902,5.597,7.587,20.935,1.224c4.907-2.035,16.951-4.08,22.552,0.423c1.638,1.317,3.427,3.818,2.645,8.252    c-0.083,0.474-0.495,0.82-0.976,0.82L86.146,259.423z M87.364,253.306l-0.182,4.132l154.897-0.027    c0.247-2.417-0.427-4.235-2.049-5.539c-4.735-3.803-15.729-2.139-20.553-0.137c-16.771,6.958-20.234,2.263-23.289-1.879    c-1.254-1.7-2.336-3.168-4.29-3.823c-7.644-2.562-18.698-0.607-30.401,1.463c-8.162,1.443-16.603,2.936-25.046,3.219    c-7.431,0.256-12.333-0.892-16.656-1.899C111.839,246.965,105.536,245.494,87.364,253.306z"></path></g><g opacity="0.15"><path fill="#5F5371" d="M376.514,199.025c-3.228,1.202-5.314,4.398-8.379,5.971c-11.775,6.045-33.498-3.477-37.225-3.877    c-14.322-1.537-15.252,10.187-42.281,1.372c-10.346-3.374-18.545,2.847-27.128,0.912c-8.378-1.888-14.031-6.841-12.643-9.734    L376.514,199.025z"></path><path fill="#5F5371" d="M358.321,207.995c-8.212,0-17.269-2.832-22.959-4.611c-2.06-0.644-3.838-1.2-4.558-1.278    c-5.155-0.551-8.544,0.707-12.13,2.04c-6.17,2.293-13.163,4.895-30.352-0.711c-5.434-1.774-10.307-0.765-15.02,0.211    c-4.085,0.845-7.943,1.646-12.02,0.725c-6.172-1.391-11.586-4.645-13.164-7.911c-0.705-1.459-0.472-2.557-0.154-3.221    c0.172-0.357,0.527-0.586,0.935-0.561l127.657,5.355c0.471,0.019,0.863,0.369,0.937,0.836c0.075,0.466-0.191,0.921-0.633,1.086    c-1.594,0.593-2.914,1.755-4.311,2.984c-1.211,1.067-2.464,2.17-3.962,2.939C365.604,207.412,362.049,207.995,358.321,207.995z     M328.328,199.985c0.845,0,1.738,0.047,2.687,0.148c0.914,0.098,2.602,0.625,4.938,1.356c8.003,2.503,22.895,7.157,31.73,2.624    c1.279-0.656,2.385-1.631,3.557-2.663c0.605-0.533,1.218-1.073,1.865-1.575l-123.464-5.179c0.015,0.269,0.102,0.57,0.26,0.899    c1.126,2.329,5.545,5.426,11.816,6.839c3.659,0.825,7.313,0.068,11.183-0.733c4.967-1.027,10.101-2.09,16.035-0.155    c16.531,5.392,22.894,3.027,29.048,0.739C321.151,201.109,324.173,199.985,328.328,199.985z"></path></g><g><rect x="77.308" y="174.582" fill="#E7E8F2" width="308.177" height="21.414"></rect></g><g opacity="0.2"><g><path fill="#867B99" d="M78.964,181.534c-0.089,0-0.179-0.004-0.272-0.012c-0.273-0.022-0.476-0.262-0.454-0.535     c0.022-0.272,0.269-0.467,0.534-0.454c1.463,0.116,2.265-1.151,3.066-4.853c0.058-0.268,0.323-0.437,0.59-0.38     c0.268,0.057,0.438,0.322,0.379,0.589C82.188,178.753,81.378,181.534,78.964,181.534z"></path></g><g><path fill="#867B99" d="M78.8,189.259c-0.087,0-0.175-0.004-0.265-0.012c-0.272-0.022-0.475-0.263-0.453-0.535     c0.022-0.273,0.253-0.473,0.535-0.454c2.182,0.173,3.305-3.603,4.598-7.986c0.228-0.773,0.463-1.57,0.712-2.376     c0.384-1.202,0.754-1.955,1.199-2.445c0.185-0.205,0.499-0.218,0.7-0.034c0.202,0.184,0.217,0.498,0.033,0.701     c-0.341,0.376-0.655,1.036-0.988,2.077c-0.246,0.797-0.48,1.589-0.707,2.358C82.736,185.401,81.597,189.259,78.8,189.259z"></path></g><g><path fill="#867B99" d="M93.551,197.137c-0.083,0-0.166-0.02-0.243-0.064c-0.238-0.135-0.322-0.438-0.188-0.677     c0.479-0.848,0.973-1.49,1.452-2.111c1.55-2.011,2.89-3.748,2.197-11.886c-0.463-5.536-1.515-5.717-1.56-5.722     c-0.24-0.034-1.152,0.596-2.169,3.806c-1.039,3.301-1.377,3.916-2.929,3.564c-0.211-0.047-0.458-0.105-0.76-0.133     c-0.855-0.093-1.45,0.868-2.491,2.908c-2.334,4.564-4.979,9.737-8.221,10.147c-0.273,0.036-0.52-0.159-0.554-0.43     c-0.034-0.271,0.158-0.521,0.43-0.554c2.722-0.344,5.351-5.484,7.463-9.614c0.986-1.932,1.85-3.599,3.466-3.445     c0.351,0.033,0.641,0.098,0.887,0.154c0.675,0.154,0.796,0.181,1.764-2.896c0.986-3.111,2.064-4.621,3.225-4.494     c1.279,0.144,2.076,2.311,2.437,6.625c0.726,8.522-0.723,10.4-2.4,12.576c-0.457,0.593-0.93,1.206-1.373,1.993     C93.892,197.046,93.724,197.137,93.551,197.137z"></path></g><g><path fill="#867B99" d="M88.677,197.137c-0.028,0-0.055-0.002-0.083-0.007c-0.27-0.046-0.452-0.302-0.406-0.572     c0.253-1.497,0.027-2.034-0.128-2.108c-0.142-0.071-0.7,0.081-1.513,0.986c-0.414,0.447-0.802,1.023-1.093,1.474     c-0.149,0.231-0.455,0.294-0.685,0.147c-0.23-0.149-0.296-0.457-0.147-0.686c0.314-0.486,0.733-1.107,1.194-1.604     c1.009-1.124,1.961-1.554,2.676-1.211c0.742,0.359,0.969,1.424,0.674,3.167C89.124,196.966,88.915,197.137,88.677,197.137z"></path></g><g><path fill="#867B99" d="M98.523,197.137c-0.077,0-0.156-0.018-0.229-0.056c-0.242-0.127-0.336-0.426-0.21-0.67     c0.411-0.787,0.937-1.869,1.359-3.253c1.015-3.389,0.82-7.57,0.614-11.998c-0.082-1.772-0.167-3.604-0.167-5.376     c0-0.274,0.222-0.496,0.496-0.496c0.274,0,0.496,0.222,0.496,0.496c0,1.75,0.085,3.569,0.167,5.329     c0.21,4.515,0.409,8.779-0.656,12.331c-0.446,1.466-0.998,2.601-1.428,3.425C98.875,197.04,98.702,197.137,98.523,197.137z"></path></g><g><path fill="#867B99" d="M102.859,197.137c-0.042,0-0.084-0.005-0.126-0.016c-0.265-0.069-0.424-0.34-0.354-0.605     c0.336-1.286,0.563-2.594,0.695-3.998c0.221-2.352,0.238-4.474,0.254-6.526c0.024-2.98,0.047-5.797,0.679-8.974l0.277-1.334     c0.056-0.268,0.319-0.443,0.587-0.384c0.268,0.056,0.439,0.319,0.383,0.587l-0.275,1.326c-0.613,3.083-0.636,5.854-0.659,8.787     c-0.017,2.072-0.034,4.215-0.258,6.61c-0.137,1.458-0.374,2.818-0.723,4.155C103.28,196.99,103.079,197.137,102.859,197.137z"></path></g><g><path fill="#867B99" d="M106.486,197.137c-0.042,0-0.083-0.005-0.125-0.016c-0.265-0.069-0.424-0.339-0.355-0.605     c0.64-2.461,1.021-4.603,1.199-6.74c0.198-2.351,0.328-4.861,0.454-7.288c0.116-2.249,0.236-4.574,0.41-6.742     c0.022-0.272,0.255-0.471,0.534-0.455c0.273,0.021,0.476,0.261,0.454,0.534c-0.173,2.155-0.293,4.472-0.409,6.714     c-0.126,2.435-0.256,4.952-0.456,7.32c-0.182,2.194-0.573,4.39-1.227,6.907C106.907,196.989,106.706,197.137,106.486,197.137z"></path></g><g><path fill="#867B99" d="M111.182,197.137c-0.015,0-0.03-0.001-0.045-0.002c-0.272-0.025-0.473-0.267-0.449-0.539     c0.254-2.794,0.274-5.953,0.274-9.793c-0.003-0.949-0.016-1.911-0.03-2.877c-0.038-2.746-0.078-5.585,0.128-8.182     c0.022-0.272,0.265-0.473,0.533-0.455c0.273,0.021,0.477,0.261,0.455,0.534c-0.203,2.549-0.164,5.365-0.125,8.089     c0.014,0.968,0.028,1.935,0.03,2.888c0,3.867-0.02,7.049-0.278,9.884C111.651,196.944,111.436,197.137,111.182,197.137z"></path></g><g><path fill="#867B99" d="M112.851,197.137c-0.009,0-0.017,0-0.026-0.001c-0.273-0.014-0.484-0.247-0.47-0.521l0.012-0.314     c0.003-0.115,0.006-0.228,0.013-0.34c0.325-8.598,2.089-13.582,4.023-18.341c0.223-0.548,0.552-1.356,0.92-2.065     c0.126-0.244,0.424-0.341,0.668-0.211c0.243,0.126,0.337,0.426,0.212,0.669c-0.347,0.668-0.666,1.451-0.877,1.969     c-1.905,4.685-3.636,9.579-3.956,18.027l-0.024,0.657C113.332,196.932,113.113,197.137,112.851,197.137z"></path></g><g><path fill="#867B99" d="M120.572,197.137c-0.258,0-0.475-0.2-0.494-0.461c-0.214-3.008-0.314-5.718-0.314-8.528     c0-0.613,0.023-1.486,0.049-2.501c0.079-3.01,0.199-7.556-0.209-9.772c-0.05-0.269,0.128-0.528,0.397-0.579     c0.273-0.042,0.528,0.129,0.577,0.398c0.427,2.318,0.31,6.745,0.226,9.979c-0.027,1.004-0.049,1.869-0.049,2.475     c0,2.786,0.099,5.473,0.311,8.458c0.02,0.273-0.186,0.511-0.459,0.53C120.595,197.137,120.583,197.137,120.572,197.137z"></path></g><g><path fill="#867B99" d="M117.017,197.137c-0.251,0-0.466-0.19-0.493-0.446c-0.16-1.56-0.325-2.197-0.418-2.45     c-0.104,0.328-0.248,1.016-0.347,2.435c-0.019,0.273-0.262,0.487-0.529,0.46c-0.273-0.019-0.479-0.257-0.46-0.53     c0.192-2.753,0.563-3.401,1.101-3.554c0.24-0.068,0.607-0.046,0.973,0.463c0.178,0.252,0.438,0.84,0.667,3.076     c0.028,0.272-0.17,0.516-0.442,0.544C117.051,197.136,117.034,197.137,117.017,197.137z"></path></g><g><path fill="#867B99" d="M126.331,197.137c-0.239,0-0.45-0.173-0.489-0.418c-0.116-0.724-0.237-1.443-0.357-2.157l-0.231-1.386     c-0.576-3.449-1.297-6.539-1.994-9.528c-0.532-2.282-1.083-4.641-1.559-7.12c-0.038-0.218-0.075-0.428-0.111-0.669     c-0.041-0.271,0.145-0.524,0.415-0.565c0.272-0.043,0.524,0.145,0.564,0.416c0.035,0.233,0.071,0.435,0.106,0.638     c0.47,2.453,1.019,4.803,1.549,7.075c0.701,3.004,1.425,6.11,2.007,9.592l0.231,1.383c0.121,0.716,0.242,1.437,0.358,2.164     c0.044,0.27-0.14,0.525-0.41,0.569C126.383,197.135,126.357,197.137,126.331,197.137z"></path></g><g><path fill="#867B99" d="M132.203,197.137c-0.26,0-0.478-0.203-0.494-0.465c-0.101-1.617-0.276-3.205-0.523-4.722     c-0.088-0.518-0.547-2.06-1.128-4.012c-0.973-3.268-2.306-7.744-3.308-12.04c-0.062-0.267,0.103-0.533,0.37-0.596     c0.264-0.061,0.533,0.104,0.595,0.371c0.996,4.267,2.323,8.725,3.293,11.981c0.615,2.063,1.059,3.552,1.157,4.133     c0.252,1.552,0.432,3.173,0.534,4.823c0.017,0.273-0.191,0.509-0.464,0.526C132.224,197.137,132.213,197.137,132.203,197.137z"></path></g><g><path fill="#867B99" d="M136.007,187.256c-0.125,0-0.231-0.025-0.308-0.051c-1.086-0.374-1.589-2.687-2.286-6.451     c-0.194-1.043-0.377-2.029-0.561-2.764c-0.109-0.445-0.218-0.854-0.32-1.239c-0.078-0.295-0.152-0.575-0.22-0.843     c-0.067-0.266,0.094-0.536,0.36-0.603c0.267-0.063,0.535,0.095,0.602,0.361c0.067,0.265,0.14,0.541,0.217,0.831     c0.104,0.39,0.214,0.805,0.324,1.254c0.192,0.763,0.378,1.763,0.574,2.823c0.329,1.77,1.011,5.446,1.628,5.692     c0.001-0.005,0.034-0.02,0.086-0.067c0.472-0.42,1.54-4.092,2.179-6.288c0.433-1.488,0.807-2.774,1.085-3.516     c0.093-0.257,0.188-0.519,0.271-0.766c0.088-0.26,0.37-0.403,0.628-0.312c0.259,0.087,0.399,0.368,0.312,0.628     c-0.086,0.255-0.183,0.524-0.28,0.794c-0.267,0.711-0.654,2.041-1.063,3.45c-1.081,3.717-1.837,6.196-2.475,6.754     C136.48,187.187,136.216,187.256,136.007,187.256z"></path></g><g><path fill="#867B99" d="M137.668,197.137c-0.034,0-0.068-0.003-0.103-0.011c-0.268-0.056-0.439-0.32-0.383-0.588     c0.839-3.988,1.996-7.655,3.75-11.889c1.196-2.884,2.17-5.375,2.903-8.964c0.055-0.268,0.316-0.439,0.585-0.387     c0.268,0.055,0.441,0.318,0.386,0.586c-0.75,3.675-1.741,6.211-2.958,9.144c-1.73,4.176-2.87,7.788-3.696,11.715     C138.103,196.977,137.897,197.137,137.668,197.137z"></path></g><g><path fill="#867B99" d="M141.883,197.137c-0.033,0-0.067-0.003-0.102-0.011c-0.268-0.055-0.44-0.319-0.384-0.586     c0.263-1.266,0.617-2.413,1.052-3.407c0.616-1.426,1.326-2.486,2.012-3.512c1.05-1.57,2.043-3.052,2.754-5.807     c0.526-2.021,0.912-4.734,1.15-8.064c0.019-0.273,0.244-0.489,0.529-0.46c0.273,0.019,0.479,0.257,0.459,0.53     c-0.242,3.391-0.638,6.166-1.179,8.244c-0.754,2.917-1.84,4.54-2.89,6.11c-0.692,1.034-1.346,2.01-1.927,3.355     c-0.408,0.934-0.741,2.015-0.991,3.213C142.319,196.977,142.113,197.137,141.883,197.137z"></path></g><g><path fill="#867B99" d="M149.473,197.137c-0.039,0-0.079-0.005-0.119-0.015c-0.266-0.065-0.428-0.334-0.363-0.6     c0.155-0.633,0.311-1.28,0.466-1.958c1.129-4.925,2.044-11.782,2.511-18.813c0.018-0.274,0.255-0.485,0.528-0.462     c0.273,0.018,0.48,0.255,0.462,0.528c-0.469,7.081-1.393,13.994-2.534,18.97c-0.156,0.681-0.313,1.335-0.47,1.971     C149.898,196.986,149.696,197.137,149.473,197.137z"></path></g><g><path fill="#867B99" d="M154.193,197.137c-0.024,0-0.049-0.002-0.074-0.006c-0.271-0.04-0.457-0.293-0.417-0.564     c0.9-6.04,1.413-12.647,1.616-20.795c0.007-0.274,0.262-0.479,0.508-0.484c0.274,0.007,0.49,0.235,0.484,0.509     c-0.204,8.189-0.721,14.836-1.626,20.917C154.646,196.961,154.434,197.137,154.193,197.137z"></path></g><g><path fill="#867B99" d="M163.33,197.137c-0.239,0-0.449-0.173-0.489-0.417c-0.185-1.141-0.427-2.388-0.739-3.813     c-0.488-2.211-1.104-4.316-1.699-6.353c-0.75-2.563-1.525-5.213-2.063-8.124c-0.165-0.889-0.285-1.765-0.355-2.603     c-0.023-0.273,0.179-0.513,0.452-0.536c0.272-0.012,0.513,0.179,0.535,0.453c0.068,0.806,0.183,1.65,0.342,2.506     c0.529,2.862,1.297,5.488,2.04,8.028c0.6,2.052,1.221,4.173,1.716,6.418c0.316,1.443,0.561,2.708,0.75,3.867     c0.044,0.27-0.139,0.525-0.41,0.569C163.383,197.135,163.356,197.137,163.33,197.137z"></path></g><g><path fill="#867B99" d="M158.239,197.137c-0.062,0-0.123-0.012-0.181-0.034c-0.083,0.033-0.177,0.044-0.271,0.025     c-0.269-0.05-0.446-0.309-0.396-0.579c0.038-0.202,0.076-0.388,0.114-0.543c0.049-0.201,0.217-0.351,0.422-0.375     c0.205-0.027,0.404,0.08,0.499,0.263c0.089,0.172,0.178,0.344,0.267,0.548c0.11,0.251-0.005,0.544-0.256,0.653     C158.373,197.124,158.305,197.137,158.239,197.137z"></path></g><g><path fill="#867B99" d="M166.237,197.137c-0.27,0-0.491-0.216-0.496-0.488c-0.036-2.129-0.121-4.228-0.251-6.239     c-0.381-5.795-1.068-8.411-2.107-12.372c-0.161-0.615-0.331-1.26-0.508-1.953c-0.102-0.254,0.007-0.601,0.261-0.703     c0.254-0.103,0.529-0.037,0.631,0.217c0.035,0.088,0.056,0.175,0.074,0.263c0.172,0.668,0.341,1.311,0.501,1.924     c1.054,4.015,1.75,6.668,2.138,12.559c0.131,2.027,0.216,4.142,0.253,6.287c0.005,0.274-0.213,0.5-0.487,0.505     C166.243,197.137,166.24,197.137,166.237,197.137z"></path></g><g><path fill="#867B99" d="M170.512,197.137c-0.266,0-0.486-0.211-0.495-0.48c-0.012-0.363-0.024-0.712-0.048-1.061     c-0.242-4.538-0.711-9.07-1.165-13.453c-0.134-1.29-0.267-2.576-0.394-3.857c-0.065-0.689-0.168-1.424-0.275-2.185l-0.035-0.247     c-0.038-0.271,0.151-0.522,0.422-0.56c0.268-0.036,0.521,0.151,0.56,0.423l0.035,0.246c0.109,0.777,0.214,1.527,0.28,2.227     c0.126,1.277,0.259,2.562,0.393,3.85c0.455,4.396,0.926,8.941,1.169,13.496c0.024,0.353,0.036,0.713,0.048,1.088     c0.009,0.274-0.205,0.503-0.479,0.513C170.523,197.137,170.518,197.137,170.512,197.137z"></path></g><g><path fill="#867B99" d="M174.162,197.137c-0.266,0-0.486-0.211-0.495-0.48c-0.103-3.098-0.291-6.198-0.444-8.552     c-0.158-2.422-0.701-5.315-1.275-8.378c-0.24-1.281-0.483-2.578-0.7-3.859c-0.046-0.27,0.136-0.526,0.405-0.573     c0.27-0.047,0.527,0.136,0.572,0.406c0.217,1.276,0.459,2.566,0.698,3.842c0.58,3.093,1.127,6.015,1.29,8.498     c0.153,2.361,0.342,5.472,0.445,8.583c0.009,0.274-0.205,0.503-0.479,0.513C174.173,197.137,174.168,197.137,174.162,197.137z"></path></g><g><path fill="#867B99" d="M177.357,197.137c-0.004,0-0.008,0-0.012,0c-0.273-0.007-0.49-0.235-0.484-0.508     c0.064-2.671,0.041-5.081-0.072-7.365c-0.115-2.299-0.469-4.793-0.845-7.432c-0.278-1.959-0.566-3.984-0.762-5.999     c-0.027-0.273,0.173-0.516,0.445-0.543c0.267-0.014,0.515,0.173,0.541,0.446c0.194,1.994,0.481,4.008,0.757,5.955     c0.378,2.664,0.736,5.179,0.854,7.523c0.114,2.309,0.137,4.742,0.073,7.437C177.846,196.923,177.626,197.137,177.357,197.137z"></path></g><g><path fill="#867B99" d="M182.485,197.137c-0.002,0-0.004,0-0.006,0c-0.274-0.004-0.493-0.229-0.489-0.503     c0.012-0.942,0.012-1.915,0.012-2.917l0-0.994c0.002-5.975,0.004-9.922-0.788-15.389l-0.035-0.244     c-0.061-0.421-0.12-0.832-0.17-1.243c-0.033-0.272,0.159-0.52,0.431-0.553c0.273-0.04,0.518,0.16,0.552,0.431     c0.05,0.405,0.108,0.809,0.168,1.223l0.035,0.244c0.802,5.537,0.8,9.512,0.798,15.531l0,0.994c0,1.006,0,1.983-0.012,2.931     C182.978,196.919,182.756,197.137,182.485,197.137z"></path></g><g><path fill="#867B99" d="M186.856,197.137c-0.265,0-0.484-0.209-0.495-0.477c-0.127-3.294-0.446-6.559-0.755-9.717l-0.204-2.117     c-0.105-1.101-0.224-2.247-0.346-3.423c-0.188-1.805-0.383-3.68-0.543-5.577c-0.023-0.273,0.179-0.513,0.452-0.536     c0.274-0.012,0.513,0.179,0.535,0.453c0.16,1.89,0.354,3.759,0.542,5.558c0.122,1.179,0.242,2.327,0.347,3.432l0.204,2.113     c0.31,3.172,0.63,6.452,0.758,9.775c0.011,0.274-0.202,0.505-0.476,0.516C186.869,197.137,186.863,197.137,186.856,197.137z"></path></g><g><path fill="#867B99" d="M190.219,197.137c-0.013,0-0.027-0.001-0.04-0.002c-0.273-0.021-0.476-0.261-0.454-0.534     c0.226-2.818,0.335-5.293,0.335-7.567c0.009-3.532-0.341-6.8-0.712-10.261c-0.105-0.976-0.21-1.954-0.306-2.94     c-0.027-0.272,0.172-0.516,0.445-0.543c0.28-0.014,0.515,0.173,0.542,0.446c0.096,0.983,0.201,1.958,0.305,2.93     c0.358,3.335,0.728,6.783,0.718,10.368c0,2.299-0.11,4.801-0.338,7.646C190.692,196.941,190.475,197.137,190.219,197.137z"></path></g><g><path fill="#867B99" d="M193.306,197.137c-0.009,0-0.018,0-0.027-0.001c-0.273-0.015-0.483-0.248-0.469-0.522     c0.036-0.658,0.047-1.316,0.06-1.974l0.013-1.089c0.081-7.712,0.306-15.84,1.352-17.631c0.309-0.536,0.708-0.497,0.868-0.454     c0.446,0.119,1.192,0.32,2.044,9.288c0.42,4.425,0.702,9.451,0.702,11.371v0.517c0,0.274-0.222,0.496-0.496,0.496     c-0.274,0-0.496-0.222-0.496-0.496v-0.517c0-3.977-0.974-16.771-1.907-19.354c-0.927,2.697-1.034,12.835-1.075,16.791     l-0.013,1.093c-0.012,0.673-0.025,1.343-0.061,2.014C193.786,196.933,193.567,197.137,193.306,197.137z"></path></g><g><path fill="#867B99" d="M200.294,197.137c-0.258,0-0.476-0.2-0.494-0.461c-0.357-5.129-0.881-9.707-1.258-12.645     c-0.393-2.988-0.696-5.529-0.891-8.21c-0.02-0.273,0.185-0.511,0.458-0.531c0.266-0.018,0.51,0.186,0.53,0.459     c0.194,2.657,0.494,5.181,0.886,8.154c0.378,2.952,0.905,7.551,1.264,12.703c0.019,0.273-0.187,0.511-0.46,0.53     C200.317,197.137,200.306,197.137,200.294,197.137z"></path></g><g><path fill="#867B99" d="M203.872,197.09c-0.008,0-0.015,0-0.023,0c-0.273-0.015-0.485-0.202-0.471-0.476l0.005-0.094     c0.139-2.575,0.259-4.8,0.283-5.974c0.058-4.093,0.447-9.357,1.096-14.819c0.032-0.272,0.277-0.476,0.551-0.434     c0.272,0.032,0.466,0.279,0.434,0.551c-0.645,5.43-1.032,10.657-1.089,14.719c-0.024,1.194-0.139,3.32-0.284,6.011     C204.359,196.84,204.135,197.09,203.872,197.09z"></path></g><g><path fill="#867B99" d="M205.455,197.137c-0.04,0-0.081-0.005-0.121-0.015c-0.265-0.067-0.426-0.337-0.36-0.603     c0.332-1.319,0.555-2.628,0.683-4.002c0.226-2.361,0.243-4.49,0.26-6.547c0.024-2.975,0.047-5.784,0.684-8.954l0.277-1.333     c0.056-0.268,0.321-0.443,0.587-0.384c0.268,0.056,0.439,0.319,0.383,0.587l-0.275,1.326c-0.619,3.076-0.641,5.84-0.665,8.765     c-0.017,2.08-0.034,4.23-0.265,6.634c-0.133,1.424-0.365,2.782-0.709,4.15C205.878,196.987,205.676,197.137,205.455,197.137z"></path></g><g><path fill="#867B99" d="M209.081,197.137c-0.042,0-0.083-0.005-0.125-0.016c-0.265-0.069-0.424-0.339-0.355-0.605     c0.616-2.369,1.008-4.575,1.199-6.742c0.204-2.343,0.331-4.843,0.453-7.262c0.114-2.257,0.232-4.591,0.412-6.767     c0.023-0.273,0.257-0.473,0.535-0.454c0.272,0.022,0.475,0.263,0.453,0.535c-0.179,2.161-0.296,4.487-0.41,6.735     c-0.122,2.428-0.249,4.938-0.455,7.299c-0.196,2.224-0.597,4.483-1.227,6.906C209.502,196.989,209.301,197.137,209.081,197.137z"></path></g><g><path fill="#867B99" d="M213.765,197.137c-0.015,0-0.03-0.001-0.045-0.002c-0.273-0.025-0.473-0.267-0.449-0.539     c0.254-2.799,0.274-5.956,0.274-9.793c0-1.021-0.013-2.058-0.026-3.099c-0.034-2.666-0.069-5.424,0.123-7.958     c0.021-0.273,0.245-0.481,0.532-0.458c0.272,0.021,0.477,0.26,0.456,0.533c-0.189,2.49-0.154,5.224-0.121,7.87     c0.013,1.045,0.026,2.086,0.026,3.111c0,3.862-0.02,7.042-0.278,9.882C214.234,196.944,214.019,197.137,213.765,197.137z"></path></g><g><path fill="#867B99" d="M215.446,197.137c-0.008,0-0.016,0-0.025-0.001c-0.273-0.014-0.484-0.246-0.471-0.52l0.011-0.307     c0.003-0.119,0.007-0.234,0.014-0.348c0.325-8.576,2.082-13.569,4.01-18.34c0.219-0.54,0.55-1.354,0.935-2.071     c0.129-0.24,0.43-0.331,0.671-0.203c0.242,0.13,0.332,0.43,0.202,0.672c-0.36,0.672-0.679,1.456-0.89,1.975     c-1.893,4.684-3.619,9.588-3.939,18.014l-0.024,0.656C215.928,196.931,215.709,197.137,215.446,197.137z"></path></g><g><path fill="#867B99" d="M223.167,197.137c-0.258,0-0.475-0.2-0.494-0.461c-0.214-3.008-0.314-5.718-0.314-8.528     c0-0.613,0.023-1.486,0.049-2.501c0.079-3.01,0.199-7.556-0.209-9.772c-0.05-0.269,0.128-0.528,0.397-0.579     c0.274-0.042,0.528,0.129,0.577,0.398c0.427,2.318,0.31,6.745,0.226,9.979c-0.027,1.004-0.049,1.869-0.049,2.475     c0,2.786,0.099,5.473,0.311,8.458c0.02,0.273-0.186,0.511-0.459,0.53C223.191,197.137,223.178,197.137,223.167,197.137z"></path></g><g><path fill="#867B99" d="M219.612,197.137c-0.251,0-0.466-0.19-0.493-0.446c-0.161-1.563-0.326-2.201-0.419-2.452     c-0.105,0.327-0.253,1.014-0.359,2.439c-0.02,0.273-0.263,0.48-0.531,0.458c-0.273-0.021-0.478-0.259-0.457-0.532     c0.206-2.755,0.579-3.401,1.114-3.552c0.242-0.067,0.607-0.044,0.971,0.463c0.178,0.252,0.438,0.84,0.667,3.076     c0.028,0.272-0.17,0.516-0.442,0.544C219.646,197.136,219.629,197.137,219.612,197.137z"></path></g><g><path fill="#867B99" d="M229.952,197.137c-0.239,0-0.45-0.173-0.489-0.418c-0.116-0.724-0.237-1.443-0.357-2.157l-0.231-1.386     c-0.576-3.449-1.297-6.539-1.994-9.528c-0.532-2.282-1.083-4.641-1.559-7.12c-0.038-0.218-0.075-0.428-0.111-0.669     c-0.041-0.271,0.145-0.524,0.415-0.565c0.272-0.043,0.524,0.145,0.564,0.416c0.035,0.233,0.071,0.435,0.106,0.638     c0.47,2.453,1.019,4.803,1.549,7.075c0.701,3.004,1.425,6.11,2.007,9.592l0.231,1.383c0.121,0.716,0.242,1.437,0.358,2.164     c0.044,0.27-0.14,0.525-0.41,0.569C230.005,197.135,229.978,197.137,229.952,197.137z"></path></g><g><path fill="#867B99" d="M235.825,197.137c-0.26,0-0.478-0.203-0.495-0.465c-0.095-1.536-0.275-3.124-0.534-4.722     c-0.086-0.531-0.559-2.125-1.158-4.142c-0.961-3.237-2.278-7.671-3.267-11.91c-0.062-0.267,0.103-0.533,0.37-0.596     c0.264-0.061,0.533,0.104,0.595,0.371c0.982,4.21,2.294,8.627,3.252,11.852c0.633,2.132,1.091,3.673,1.186,4.266     c0.265,1.629,0.449,3.251,0.546,4.819c0.016,0.274-0.191,0.51-0.464,0.526C235.846,197.137,235.835,197.137,235.825,197.137z"></path></g><g><path fill="#867B99" d="M239.629,187.256c-0.125,0-0.229-0.025-0.306-0.051c-1.082-0.372-1.586-2.67-2.285-6.413     c-0.198-1.057-0.385-2.057-0.575-2.801c-0.112-0.455-0.223-0.869-0.326-1.26c-0.076-0.287-0.149-0.56-0.215-0.823     c-0.068-0.266,0.093-0.536,0.358-0.603c0.274-0.071,0.535,0.093,0.602,0.359c0.066,0.26,0.137,0.529,0.213,0.812     c0.105,0.395,0.217,0.817,0.329,1.273c0.197,0.772,0.387,1.786,0.588,2.861c0.329,1.758,1.013,5.41,1.626,5.654     c0.002-0.005,0.034-0.02,0.087-0.067c0.461-0.417,1.521-4.068,2.155-6.25c0.438-1.505,0.815-2.805,1.096-3.553     c0.112-0.311,0.196-0.544,0.269-0.764c0.085-0.26,0.367-0.402,0.626-0.315c0.26,0.086,0.401,0.367,0.315,0.627     c-0.076,0.229-0.163,0.47-0.25,0.711c-0.3,0.802-0.69,2.147-1.105,3.571c-1.074,3.695-1.824,6.16-2.449,6.715     C240.103,187.186,239.838,187.256,239.629,187.256z"></path></g><g><path fill="#867B99" d="M241.29,197.137c-0.034,0-0.069-0.003-0.104-0.011c-0.267-0.056-0.439-0.32-0.382-0.588     c0.83-3.938,2.021-7.716,3.75-11.889c1.197-2.886,2.17-5.377,2.902-8.963c0.055-0.269,0.323-0.44,0.585-0.388     c0.269,0.055,0.441,0.317,0.387,0.585c-0.75,3.674-1.74,6.211-2.958,9.145c-1.728,4.171-2.868,7.784-3.696,11.715     C241.724,196.977,241.518,197.137,241.29,197.137z"></path></g><g><path fill="#867B99" d="M245.505,197.137c-0.034,0-0.069-0.004-0.104-0.011c-0.267-0.056-0.439-0.32-0.382-0.588     c0.269-1.277,0.622-2.422,1.051-3.405c0.617-1.425,1.326-2.485,2.012-3.511c1.05-1.57,2.043-3.052,2.754-5.808     c0.526-2.017,0.906-4.655,1.163-8.067c0.021-0.272,0.237-0.481,0.532-0.458c0.273,0.021,0.477,0.26,0.457,0.533     c-0.262,3.471-0.652,6.167-1.193,8.241c-0.753,2.918-1.839,4.541-2.89,6.111c-0.692,1.033-1.346,2.01-1.926,3.354     c-0.403,0.923-0.736,2.003-0.99,3.215C245.94,196.977,245.734,197.137,245.505,197.137z"></path></g><g><path fill="#867B99" d="M253.094,197.137c-0.039,0-0.079-0.005-0.119-0.015c-0.265-0.066-0.428-0.334-0.362-0.601     c0.156-0.632,0.312-1.279,0.467-1.957c1.13-4.923,2.044-11.781,2.51-18.813c0.018-0.273,0.261-0.485,0.528-0.462     c0.273,0.018,0.48,0.255,0.462,0.528c-0.469,7.082-1.393,13.996-2.533,18.97c-0.157,0.681-0.313,1.335-0.47,1.972     C253.519,196.986,253.316,197.137,253.094,197.137z"></path></g><g><path fill="#867B99" d="M257.815,197.137c-0.025,0-0.049-0.002-0.075-0.006c-0.27-0.04-0.457-0.293-0.416-0.564     c0.899-6.039,1.413-12.646,1.616-20.795c0.007-0.269,0.228-0.484,0.496-0.484c0.004,0,0.008,0,0.013,0     c0.273,0.007,0.49,0.235,0.483,0.509c-0.204,8.189-0.721,14.837-1.627,20.917C258.267,196.961,258.056,197.137,257.815,197.137z"></path></g><g><path fill="#867B99" d="M266.939,197.137c-0.238,0-0.448-0.173-0.488-0.417c-0.189-1.158-0.431-2.406-0.74-3.813     c-0.488-2.233-1.11-4.359-1.712-6.414c-0.745-2.544-1.516-5.175-2.049-8.063c-0.169-0.931-0.286-1.782-0.355-2.603     c-0.023-0.272,0.179-0.513,0.452-0.536c0.248-0.025,0.513,0.179,0.535,0.453c0.067,0.789,0.179,1.609,0.343,2.507     c0.525,2.837,1.287,5.442,2.026,7.963c0.607,2.072,1.234,4.214,1.729,6.482c0.313,1.425,0.559,2.69,0.749,3.866     c0.045,0.27-0.139,0.525-0.409,0.569C266.993,197.135,266.966,197.137,266.939,197.137z"></path></g><g><path fill="#867B99" d="M261.848,197.137c-0.06,0-0.119-0.011-0.174-0.032c-0.081,0.033-0.173,0.042-0.268,0.023     c-0.268-0.051-0.444-0.312-0.393-0.582c0.039-0.201,0.076-0.386,0.114-0.54c0.048-0.201,0.217-0.351,0.421-0.375     c0.21-0.031,0.405,0.08,0.5,0.263c0.093,0.179,0.186,0.361,0.265,0.573c0.096,0.257-0.035,0.543-0.291,0.639     C261.965,197.128,261.907,197.137,261.848,197.137z"></path></g><g><path fill="#867B99" d="M269.859,197.137c-0.269,0-0.49-0.215-0.496-0.485c-0.05-2.218-0.139-4.318-0.263-6.242     c-0.372-5.805-1.06-8.424-2.101-12.389c-0.16-0.61-0.327-1.249-0.503-1.936c-0.104-0.253,0.005-0.599,0.258-0.704     c0.256-0.102,0.53-0.038,0.634,0.215c0.037,0.09,0.057,0.179,0.075,0.269c0.169,0.657,0.337,1.295,0.497,1.902     c1.055,4.022,1.752,6.678,2.131,12.578c0.125,1.939,0.214,4.053,0.265,6.283c0.006,0.274-0.211,0.501-0.484,0.508     C269.867,197.137,269.863,197.137,269.859,197.137z"></path></g><g><path fill="#867B99" d="M274.134,197.137c-0.267,0-0.487-0.212-0.496-0.481c-0.012-0.363-0.022-0.711-0.046-1.06     c-0.242-4.536-0.712-9.068-1.165-13.45c-0.134-1.291-0.267-2.578-0.394-3.861c-0.064-0.678-0.166-1.398-0.27-2.144l-0.041-0.288     c-0.038-0.271,0.151-0.522,0.422-0.56c0.265-0.037,0.521,0.15,0.56,0.423l0.041,0.287c0.107,0.763,0.21,1.498,0.275,2.187     c0.127,1.278,0.259,2.564,0.394,3.854c0.455,4.395,0.925,8.938,1.168,13.492c0.024,0.353,0.037,0.713,0.048,1.089     c0.009,0.274-0.206,0.503-0.48,0.512C274.144,197.137,274.138,197.137,274.134,197.137z"></path></g><g><path fill="#867B99" d="M277.785,197.137c-0.266,0-0.486-0.211-0.496-0.48c-0.105-3.131-0.291-6.215-0.443-8.552     c-0.161-2.453-0.714-5.387-1.301-8.495c-0.235-1.243-0.472-2.5-0.687-3.741c-0.046-0.269,0.135-0.526,0.405-0.574     c0.263-0.046,0.526,0.135,0.573,0.405c0.213,1.237,0.449,2.488,0.683,3.726c0.592,3.138,1.152,6.101,1.316,8.614     c0.152,2.345,0.34,5.44,0.445,8.584c0.009,0.273-0.205,0.503-0.479,0.513C277.796,197.137,277.79,197.137,277.785,197.137z"></path></g><g><path fill="#867B99" d="M280.967,197.137c-0.004,0-0.008,0-0.012,0c-0.274-0.007-0.491-0.235-0.484-0.508     c0.068-2.822,0.049-5.161-0.059-7.365c-0.117-2.314-0.477-4.835-0.859-7.505c-0.277-1.936-0.562-3.936-0.761-5.925     c-0.028-0.272,0.171-0.516,0.443-0.543c0.268-0.033,0.515,0.171,0.542,0.444c0.197,1.968,0.482,3.958,0.757,5.883     c0.384,2.694,0.747,5.237,0.866,7.596c0.11,2.228,0.13,4.591,0.061,7.437C281.456,196.923,281.235,197.137,280.967,197.137z"></path></g><g><path fill="#867B99" d="M286.107,197.137c-0.002,0-0.004,0-0.006,0c-0.274-0.004-0.493-0.229-0.49-0.502     c0.012-0.943,0.012-1.916,0.012-2.918v-0.793c0.002-6.059,0.003-10.062-0.787-15.592l-0.023-0.16     c-0.065-0.45-0.128-0.888-0.182-1.326c-0.034-0.272,0.16-0.52,0.431-0.553c0.275-0.039,0.519,0.16,0.553,0.431     c0.053,0.432,0.115,0.863,0.18,1.306l0.023,0.162c0.8,5.599,0.799,9.631,0.797,15.732v0.793c0,1.006,0,1.983-0.012,2.93     C286.6,196.919,286.378,197.137,286.107,197.137z"></path></g><g><path fill="#867B99" d="M290.479,197.137c-0.265,0-0.485-0.209-0.496-0.477c-0.121-3.111-0.419-6.198-0.708-9.185     c-0.085-0.883-0.17-1.766-0.252-2.65c-0.104-1.1-0.224-2.246-0.346-3.422c-0.188-1.805-0.383-3.68-0.543-5.577     c-0.023-0.273,0.179-0.513,0.452-0.536c0.269-0.025,0.512,0.179,0.535,0.453c0.16,1.89,0.354,3.759,0.541,5.558     c0.123,1.179,0.243,2.327,0.348,3.432c0.08,0.884,0.166,1.765,0.251,2.647c0.29,2.999,0.59,6.102,0.712,9.241     c0.011,0.274-0.203,0.505-0.476,0.516C290.491,197.137,290.484,197.137,290.479,197.137z"></path></g><g><path fill="#867B99" d="M293.842,197.137c-0.014,0-0.027-0.001-0.041-0.002c-0.273-0.021-0.476-0.261-0.454-0.534     c0.226-2.823,0.335-5.297,0.335-7.567c0.009-3.535-0.342-6.806-0.713-10.269c-0.105-0.973-0.209-1.948-0.306-2.931     c-0.026-0.272,0.173-0.516,0.445-0.543c0.27-0.015,0.515,0.173,0.542,0.446c0.096,0.98,0.2,1.952,0.304,2.921     c0.358,3.338,0.728,6.789,0.719,10.377c0,2.295-0.11,4.797-0.339,7.646C294.314,196.941,294.097,197.137,293.842,197.137z"></path></g><g><path fill="#867B99" d="M296.927,197.137c-0.009,0-0.018,0-0.027-0.001c-0.274-0.015-0.483-0.249-0.468-0.522     c0.035-0.634,0.046-1.268,0.059-1.901l0.014-1.161c0.08-7.713,0.303-15.84,1.339-17.632c0.313-0.537,0.713-0.499,0.873-0.455     c0.447,0.121,1.196,0.324,2.05,9.289c0.42,4.419,0.703,9.447,0.703,11.37v0.517c0,0.274-0.222,0.496-0.496,0.496     c-0.274,0-0.496-0.222-0.496-0.496v-0.517c0-4.097-0.959-16.81-1.915-19.364c-0.921,2.679-1.027,12.84-1.068,16.802l-0.013,1.091     c-0.014,0.723-0.026,1.369-0.062,2.014C297.407,196.933,297.188,197.137,296.927,197.137z"></path></g><g><path fill="#867B99" d="M303.916,197.137c-0.258,0-0.475-0.2-0.494-0.461c-0.365-5.237-0.892-9.766-1.27-12.643     c-0.336-2.64-0.684-5.368-0.892-8.212c-0.019-0.273,0.186-0.511,0.459-0.531c0.252-0.022,0.51,0.185,0.53,0.459     c0.204,2.817,0.551,5.531,0.886,8.155c0.379,2.889,0.909,7.439,1.276,12.701c0.018,0.273-0.187,0.511-0.46,0.53     C303.94,197.137,303.927,197.137,303.916,197.137z"></path></g><g><path fill="#867B99" d="M307.436,197.137c-0.012,0-0.022,0-0.034-0.001c-0.273-0.018-0.48-0.255-0.462-0.528l0.056-0.842     c0.144-2.172,0.268-4.049,0.279-5.214c0.046-3.348-0.541-7.318-1.108-11.157c-0.175-1.184-0.35-2.37-0.508-3.543     c-0.037-0.272,0.153-0.521,0.424-0.558c0.274-0.046,0.522,0.152,0.558,0.425c0.159,1.17,0.333,2.351,0.507,3.531     c0.573,3.878,1.165,7.889,1.119,11.313c-0.011,1.191-0.136,3.081-0.281,5.269l-0.056,0.842     C307.913,196.936,307.695,197.137,307.436,197.137z"></path></g><g><path fill="#867B99" d="M309.856,197.137c-0.042,0-0.083-0.005-0.126-0.016c-0.264-0.069-0.423-0.34-0.353-0.606     c0.335-1.282,0.562-2.59,0.694-3.997c0.221-2.352,0.237-4.473,0.254-6.524c0.024-2.981,0.046-5.798,0.679-8.976     c0.085-0.417,0.181-0.876,0.278-1.335c0.057-0.269,0.326-0.432,0.588-0.383c0.268,0.057,0.439,0.32,0.382,0.588l-0.276,1.325     c-0.614,3.084-0.636,5.855-0.659,8.788c-0.016,2.072-0.034,4.214-0.257,6.609c-0.137,1.462-0.374,2.821-0.723,4.156     C310.278,196.99,310.077,197.137,309.856,197.137z"></path></g><g><path fill="#867B99" d="M313.484,197.137c-0.041,0-0.083-0.005-0.125-0.016c-0.264-0.07-0.424-0.34-0.355-0.606     c0.641-2.468,1.021-4.609,1.199-6.74c0.203-2.341,0.329-4.838,0.451-7.253c0.114-2.26,0.232-4.598,0.413-6.778     c0.023-0.274,0.286-0.472,0.534-0.454c0.273,0.022,0.476,0.263,0.453,0.535c-0.179,2.164-0.297,4.495-0.41,6.747     c-0.122,2.424-0.249,4.93-0.454,7.287c-0.182,2.187-0.572,4.382-1.227,6.906C313.906,196.989,313.704,197.137,313.484,197.137z"></path></g><g><path fill="#867B99" d="M318.18,197.137c-0.015,0-0.031-0.001-0.045-0.002c-0.273-0.025-0.474-0.267-0.449-0.539     c0.255-2.798,0.275-5.956,0.275-9.793c-0.003-0.947-0.016-1.908-0.031-2.872c-0.039-2.748-0.078-5.589,0.129-8.186     c0.021-0.273,0.265-0.47,0.533-0.455c0.273,0.021,0.476,0.261,0.454,0.534c-0.203,2.551-0.164,5.368-0.125,8.092     c0.015,0.968,0.028,1.933,0.031,2.885c0,3.864-0.02,7.045-0.279,9.884C318.649,196.944,318.432,197.137,318.18,197.137z"></path></g><g><path fill="#867B99" d="M319.848,197.137c-0.008,0-0.016,0-0.024-0.001c-0.274-0.014-0.484-0.246-0.47-0.52l0.023-0.654     c0.326-8.599,2.089-13.583,4.023-18.342c0.218-0.537,0.548-1.349,0.921-2.066c0.127-0.243,0.426-0.333,0.669-0.21     c0.242,0.127,0.337,0.426,0.21,0.67c-0.35,0.674-0.67,1.46-0.882,1.98c-1.899,4.673-3.63,9.567-3.951,18.014l-0.024,0.656     C320.33,196.931,320.112,197.137,319.848,197.137z"></path></g><g><path fill="#867B99" d="M327.569,197.137c-0.257,0-0.474-0.2-0.494-0.461c-0.214-3.005-0.314-5.715-0.314-8.528     c0-0.612,0.023-1.485,0.049-2.5c0.079-3.01,0.199-7.557-0.209-9.773c-0.05-0.269,0.128-0.528,0.397-0.578     c0.265-0.052,0.528,0.128,0.577,0.397c0.428,2.318,0.312,6.746,0.227,9.98c-0.026,1.004-0.049,1.868-0.049,2.474     c0,2.789,0.099,5.476,0.312,8.458c0.019,0.273-0.187,0.511-0.46,0.53C327.594,197.137,327.582,197.137,327.569,197.137z"></path></g><g><path fill="#867B99" d="M324.014,197.137c-0.251,0-0.466-0.19-0.492-0.446c-0.16-1.56-0.324-2.197-0.418-2.45     c-0.104,0.328-0.249,1.015-0.348,2.435c-0.019,0.274-0.276,0.481-0.53,0.46c-0.273-0.019-0.479-0.257-0.46-0.53     c0.193-2.753,0.564-3.401,1.101-3.554c0.248-0.067,0.61-0.043,0.973,0.463c0.179,0.253,0.439,0.842,0.667,3.076     c0.028,0.272-0.17,0.517-0.442,0.544C324.048,197.136,324.031,197.137,324.014,197.137z"></path></g><g><path fill="#867B99" d="M333.327,197.137c-0.239,0-0.449-0.173-0.489-0.418c-0.119-0.748-0.244-1.492-0.368-2.229l-0.22-1.312     c-0.576-3.451-1.297-6.542-1.994-9.531c-0.532-2.281-1.083-4.64-1.559-7.118c-0.038-0.219-0.075-0.428-0.11-0.669     c-0.042-0.271,0.145-0.524,0.415-0.565c0.269-0.039,0.524,0.145,0.564,0.416c0.036,0.233,0.071,0.436,0.105,0.639     c0.47,2.451,1.018,4.801,1.549,7.072c0.701,3.005,1.426,6.111,2.007,9.594l0.219,1.311c0.125,0.74,0.25,1.485,0.371,2.236     c0.043,0.27-0.141,0.525-0.411,0.569C333.38,197.135,333.353,197.137,333.327,197.137z"></path></g><g><path fill="#867B99" d="M339.201,197.137c-0.26,0-0.478-0.203-0.495-0.465c-0.1-1.612-0.276-3.201-0.523-4.722     c-0.088-0.518-0.547-2.06-1.129-4.012c-0.973-3.268-2.306-7.744-3.309-12.04c-0.062-0.267,0.104-0.533,0.371-0.596     c0.272-0.062,0.532,0.104,0.595,0.371c0.995,4.267,2.323,8.725,3.292,11.981c0.615,2.063,1.058,3.552,1.157,4.133     c0.253,1.558,0.433,3.179,0.534,4.823c0.016,0.274-0.191,0.51-0.464,0.526C339.221,197.137,339.211,197.137,339.201,197.137z"></path></g><g><path fill="#867B99" d="M343.004,187.256c-0.125,0-0.23-0.025-0.307-0.051c-1.087-0.374-1.589-2.687-2.287-6.451     c-0.194-1.043-0.377-2.029-0.561-2.764c-0.108-0.442-0.217-0.849-0.318-1.232c-0.079-0.297-0.154-0.579-0.223-0.85     c-0.067-0.266,0.095-0.536,0.36-0.603c0.266-0.066,0.534,0.095,0.602,0.361c0.067,0.268,0.14,0.545,0.218,0.837     c0.103,0.388,0.213,0.801,0.322,1.246c0.192,0.764,0.378,1.764,0.574,2.823c0.328,1.771,1.011,5.447,1.628,5.692     c0.002-0.005,0.034-0.02,0.087-0.068c0.471-0.419,1.539-4.092,2.178-6.288c0.433-1.488,0.806-2.773,1.084-3.515     c0.093-0.257,0.188-0.519,0.271-0.766c0.087-0.26,0.37-0.403,0.627-0.312c0.259,0.087,0.399,0.368,0.312,0.628     c-0.085,0.255-0.182,0.524-0.281,0.795c-0.266,0.71-0.652,2.039-1.062,3.447c-1.081,3.719-1.838,6.198-2.475,6.756     C343.478,187.187,343.214,187.256,343.004,187.256z"></path></g><g><path fill="#867B99" d="M344.666,197.137c-0.034,0-0.069-0.003-0.104-0.011c-0.267-0.056-0.439-0.32-0.382-0.588     c0.839-3.988,1.996-7.655,3.75-11.889c1.197-2.886,2.17-5.377,2.902-8.963c0.055-0.269,0.32-0.44,0.585-0.388     c0.269,0.055,0.441,0.317,0.387,0.585c-0.75,3.674-1.741,6.211-2.958,9.145c-1.73,4.176-2.87,7.788-3.696,11.715     C345.1,196.977,344.894,197.137,344.666,197.137z"></path></g><g><path fill="#867B99" d="M348.881,197.137c-0.034,0-0.068-0.003-0.102-0.011c-0.268-0.055-0.44-0.318-0.384-0.586     c0.262-1.263,0.616-2.409,1.051-3.407c0.617-1.426,1.326-2.486,2.013-3.512c1.05-1.57,2.042-3.052,2.753-5.807     c0.526-2.017,0.906-4.655,1.163-8.067c0.021-0.272,0.241-0.481,0.532-0.458c0.273,0.021,0.477,0.26,0.457,0.533     c-0.262,3.471-0.652,6.167-1.193,8.241c-0.753,2.917-1.839,4.54-2.89,6.11c-0.692,1.034-1.346,2.01-1.926,3.355     c-0.409,0.937-0.741,2.018-0.99,3.213C349.317,196.977,349.111,197.137,348.881,197.137z"></path></g><g><path fill="#867B99" d="M356.47,197.137c-0.039,0-0.079-0.005-0.119-0.015c-0.265-0.066-0.428-0.334-0.362-0.601     c0.156-0.632,0.312-1.279,0.467-1.957c1.13-4.929,2.044-11.786,2.51-18.813c0.018-0.273,0.257-0.485,0.528-0.462     c0.273,0.018,0.48,0.255,0.462,0.528c-0.469,7.077-1.392,13.99-2.533,18.97c-0.157,0.681-0.313,1.335-0.47,1.972     C356.895,196.986,356.692,197.137,356.47,197.137z"></path></g><g><path fill="#867B99" d="M361.191,197.137c-0.024,0-0.049-0.002-0.074-0.006c-0.271-0.04-0.458-0.293-0.417-0.563     c0.898-6.038,1.412-12.645,1.616-20.796c0.007-0.273,0.185-0.486,0.508-0.484c0.273,0.007,0.49,0.235,0.483,0.509     c-0.205,8.191-0.722,14.838-1.627,20.916C361.644,196.961,361.432,197.137,361.191,197.137z"></path></g><g><path fill="#867B99" d="M370.328,197.137c-0.238,0-0.448-0.173-0.488-0.417c-0.187-1.147-0.429-2.394-0.741-3.813     c-0.488-2.212-1.104-4.319-1.7-6.356c-0.749-2.563-1.525-5.212-2.062-8.122c-0.166-0.892-0.285-1.768-0.354-2.603     c-0.023-0.273,0.18-0.514,0.452-0.536c0.269-0.025,0.512,0.179,0.535,0.453c0.068,0.804,0.182,1.647,0.341,2.507     c0.529,2.859,1.297,5.484,2.04,8.023c0.6,2.053,1.221,4.176,1.716,6.421c0.316,1.437,0.561,2.702,0.75,3.867     c0.045,0.27-0.139,0.525-0.409,0.569C370.381,197.135,370.355,197.137,370.328,197.137z"></path></g><g><path fill="#867B99" d="M365.224,197.137c-0.06,0-0.119-0.011-0.174-0.032c-0.082,0.033-0.173,0.042-0.268,0.023     c-0.268-0.051-0.444-0.312-0.393-0.582c0.039-0.201,0.076-0.386,0.114-0.54c0.048-0.201,0.217-0.351,0.421-0.375     c0.213-0.031,0.404,0.08,0.499,0.263c0.093,0.179,0.186,0.361,0.265,0.573c0.096,0.257-0.035,0.543-0.291,0.639     C365.34,197.128,365.282,197.137,365.224,197.137z"></path></g><g><path fill="#867B99" d="M373.235,197.137c-0.27,0-0.491-0.217-0.496-0.488c-0.036-2.123-0.12-4.221-0.252-6.239     c-0.381-5.798-1.069-8.415-2.108-12.377c-0.161-0.614-0.33-1.257-0.507-1.948c-0.104-0.253,0.005-0.599,0.258-0.704     c0.257-0.102,0.53-0.038,0.634,0.215c0.037,0.09,0.057,0.179,0.075,0.269c0.17,0.662,0.339,1.304,0.499,1.914     c1.054,4.018,1.751,6.671,2.139,12.565c0.133,2.034,0.218,4.149,0.254,6.287c0.005,0.274-0.214,0.5-0.487,0.505     C373.241,197.137,373.238,197.137,373.235,197.137z"></path></g><g><path fill="#867B99" d="M377.509,197.137c-0.267,0-0.487-0.212-0.496-0.481c-0.012-0.363-0.023-0.712-0.046-1.061     c-0.242-4.535-0.711-9.067-1.165-13.449c-0.134-1.291-0.267-2.578-0.394-3.861c-0.066-0.688-0.168-1.422-0.276-2.182l-0.035-0.25     c-0.038-0.271,0.151-0.522,0.422-0.56c0.266-0.037,0.521,0.15,0.56,0.423l0.035,0.249c0.109,0.775,0.214,1.525,0.281,2.224     c0.127,1.278,0.259,2.564,0.394,3.854c0.455,4.395,0.925,8.938,1.168,13.492c0.023,0.354,0.037,0.714,0.048,1.089     c0.009,0.274-0.206,0.503-0.48,0.512C377.52,197.137,377.514,197.137,377.509,197.137z"></path></g><g><path fill="#867B99" d="M381.161,197.137c-0.266,0-0.486-0.211-0.496-0.48c-0.105-3.131-0.291-6.215-0.443-8.552     c-0.159-2.418-0.7-5.306-1.272-8.364c-0.241-1.286-0.485-2.588-0.704-3.873c-0.045-0.27,0.136-0.526,0.406-0.573     c0.266-0.046,0.526,0.135,0.572,0.406c0.217,1.28,0.46,2.576,0.7,3.857c0.579,3.088,1.125,6.005,1.287,8.482     c0.152,2.345,0.34,5.44,0.445,8.584c0.009,0.273-0.205,0.503-0.479,0.513C381.172,197.137,381.166,197.137,381.161,197.137z"></path></g><g><path fill="#867B99" d="M384.355,197.137c-0.004,0-0.008,0-0.012,0c-0.274-0.007-0.491-0.235-0.484-0.508     c0.064-2.667,0.041-5.076-0.072-7.365c-0.116-2.298-0.47-4.792-0.845-7.431c-0.279-1.959-0.566-3.985-0.763-6     c-0.026-0.273,0.173-0.516,0.445-0.543c0.272-0.015,0.516,0.173,0.542,0.446c0.194,1.995,0.48,4.009,0.757,5.957     c0.378,2.663,0.736,5.177,0.853,7.522c0.114,2.314,0.138,4.747,0.074,7.437C384.844,196.923,384.623,197.137,384.355,197.137z"></path></g></g><g><path fill="#5F5371" d="M385.483,198.632H264.875c-0.105,0-0.209-0.011-0.311-0.033l-4.505-0.965l-5.197,0.973    c-0.09,0.016-0.181,0.025-0.273,0.025h-77.574c-0.133,0-0.266-0.017-0.394-0.053l-6.838-1.882l-2.763,1.713    c-0.235,0.145-0.506,0.223-0.783,0.223H77.304c-0.821,0-1.487-0.667-1.487-1.489v-22.562c0-0.822,0.666-1.489,1.487-1.489h221.54    c0.23,0,0.458,0.053,0.664,0.157l3.519,1.759l4.585-1.813c0.174-0.069,0.359-0.104,0.546-0.104h77.326    c0.821,0,1.487,0.667,1.487,1.489v22.562C386.97,197.965,386.304,198.632,385.483,198.632z M265.032,195.654h118.964V176.07    h-75.557l-4.938,1.952c-0.394,0.154-0.832,0.137-1.21-0.053l-3.799-1.899H78.791v19.584h87.024l2.954-1.832    c0.351-0.218,0.779-0.28,1.177-0.17l7.27,2.002h77.236l5.354-1.002c0.194-0.036,0.392-0.035,0.584,0.008L265.032,195.654z"></path></g><g><path fill="#5F5371" d="M89.033,185.994c-0.123,0-0.245-0.046-0.342-0.137c-0.198-0.189-0.206-0.503-0.017-0.702l3.107-3.272    l-2.794-1.412c-0.231-0.116-0.333-0.391-0.236-0.631l2.299-5.634c0.104-0.253,0.395-0.375,0.646-0.271    c0.254,0.104,0.375,0.394,0.272,0.647l-2.126,5.21l2.981,1.506c0.14,0.071,0.239,0.204,0.265,0.359    c0.027,0.154-0.021,0.312-0.129,0.426l-3.567,3.757C89.295,185.942,89.164,185.994,89.033,185.994z"></path></g><g><path fill="#5F5371" d="M87.076,181.23c-0.208,0-0.402-0.132-0.47-0.34c-0.086-0.261,0.055-0.542,0.315-0.627l2.134-0.706    c0.261-0.088,0.54,0.055,0.626,0.315c0.086,0.261-0.055,0.542-0.315,0.627l-2.134,0.706    C87.179,181.222,87.127,181.23,87.076,181.23z"></path></g><g><path fill="#5F5371" d="M364.146,197.148c-0.126,0-0.252-0.048-0.349-0.143l-3.175-3.137c-0.115-0.113-0.167-0.276-0.14-0.436    c0.027-0.159,0.131-0.296,0.277-0.365l4.775-2.268l-1.12-3.662c-0.079-0.263,0.068-0.54,0.329-0.62    c0.263-0.079,0.539,0.069,0.62,0.33l1.245,4.072c0.072,0.236-0.04,0.489-0.262,0.594l-4.523,2.148l2.672,2.639    c0.195,0.192,0.197,0.506,0.004,0.702C364.402,197.099,364.274,197.148,364.146,197.148z"></path></g><g><path fill="#5F5371" d="M366.133,191.559c-0.083,0-0.167-0.02-0.245-0.065c-0.238-0.135-0.321-0.438-0.186-0.677l1.658-2.926    c0.135-0.239,0.438-0.324,0.676-0.186c0.238,0.135,0.321,0.438,0.186,0.677l-1.658,2.926    C366.473,191.469,366.306,191.559,366.133,191.559z"></path></g><g><path fill="#A1C083" d="M158.487,171.783c-0.497,0-0.926-0.374-0.984-0.881c-0.037-0.325-3.848-32.694-17.932-49.674    c-0.35-0.422-0.292-1.047,0.129-1.397c0.422-0.35,1.046-0.292,1.395,0.129c7.576,9.134,12.17,22.447,14.689,32.008    c2.72,10.324,3.678,18.627,3.688,18.711c0.061,0.545-0.329,1.036-0.873,1.097C158.562,171.781,158.525,171.783,158.487,171.783z"></path></g><g><path fill="#A1C083" d="M157.286,171.783c-0.452,0-0.86-0.311-0.965-0.77c-3.723-16.201,2.947-44.499,3.232-45.696    c0.128-0.533,0.664-0.859,1.195-0.735c0.532,0.127,0.861,0.663,0.734,1.196c-0.069,0.289-6.846,29.043-3.228,44.789    c0.122,0.535-0.211,1.067-0.744,1.19C157.434,171.775,157.359,171.783,157.286,171.783z"></path></g><g><path fill="#867B99" d="M160.076,171.783c-0.02,0-0.041-0.001-0.061-0.002c-0.546-0.034-0.962-0.504-0.929-1.052    c0.012-0.2,1.101-20.206-8.874-41.699c-0.231-0.497-0.015-1.088,0.481-1.318c0.495-0.232,1.086-0.016,1.317,0.482    c10.196,21.969,9.067,42.453,9.055,42.658C161.032,171.378,160.596,171.783,160.076,171.783z"></path></g><g><path fill="#A1C083" d="M158.874,171.782c-0.038,0-0.077-0.002-0.116-0.007c-0.543-0.063-0.932-0.554-0.869-1.098    c0.034-0.298,0.907-7.372,6.828-15.596c0.32-0.444,0.94-0.543,1.384-0.225c0.444,0.321,0.545,0.941,0.224,1.386    c-5.599,7.776-6.459,14.595-6.467,14.663C159.798,171.411,159.37,171.782,158.874,171.782z"></path></g><g><path fill="#867B99" d="M155.513,171.751c-0.536,0-0.977-0.427-0.99-0.967c-0.218-8.524-5.344-15.22-5.396-15.286    c-0.336-0.433-0.258-1.057,0.174-1.393c0.432-0.338,1.055-0.26,1.391,0.173c0.227,0.294,5.579,7.286,5.812,16.455    c0.014,0.548-0.418,1.003-0.966,1.018C155.53,171.751,155.522,171.751,155.513,171.751z"></path></g><g><path fill="#867B99" d="M388.25,238.311c-0.101,0-0.204-0.016-0.306-0.048c-0.521-0.169-0.805-0.729-0.637-1.25    c0.065-0.201,6.507-20.215,6.669-29.295c0.01-0.542,0.452-0.975,0.991-0.975c0.006,0,0.012,0,0.017,0    c0.548,0.01,0.984,0.462,0.974,1.01c-0.167,9.375-6.496,29.04-6.766,29.873C389.057,238.045,388.668,238.311,388.25,238.311z"></path></g><g><path fill="#A1C083" d="M388.935,236.6c-0.107,0-0.215-0.017-0.321-0.053c-0.518-0.177-0.794-0.742-0.617-1.261    c0.287-0.836,7.135-20.623,18.556-32.798c0.375-0.4,1.002-0.42,1.401-0.044c0.399,0.375,0.419,1.003,0.044,1.403    c-11.13,11.867-18.056,31.882-18.124,32.083C389.732,236.342,389.347,236.6,388.935,236.6z"></path></g><g><path fill="#867B99" d="M390.242,237.574c-0.111,0-0.224-0.018-0.334-0.058c-0.516-0.185-0.784-0.753-0.599-1.269    c0.137-0.385,3.495-9.567,14.68-23.227c0.348-0.424,0.971-0.487,1.395-0.139c0.424,0.348,0.485,0.973,0.138,1.397    c-10.971,13.396-14.314,22.547-14.347,22.637C391.03,237.322,390.648,237.574,390.242,237.574z"></path></g><g><path fill="#5F5371" d="M358.721,159.347c-0.261,0-0.48-0.205-0.495-0.469c-0.031-0.561-0.207-1.054-0.439-1.443    c-0.131,0.118-0.268,0.215-0.407,0.292c-0.533,0.294-1.096,0.297-1.468,0.013c-0.163-0.125-0.522-0.499-0.333-1.265    c0.161-0.652,0.637-1.025,1.235-0.968c0.246,0.022,0.502,0.118,0.752,0.275c0.01-0.104,0.011-0.217-0.001-0.338    c-0.011-0.122-0.054-0.289-0.123-0.468c-0.37,0.314-0.735,0.364-1.003,0.348c-0.642-0.05-1.182-0.616-1.205-1.261    c-0.016-0.459,0.263-1.04,1.104-1.166c0.361-0.057,0.725,0.05,1.056,0.301c0.105-0.294,0.204-0.656,0.29-1.103    c0.052-0.269,0.317-0.444,0.582-0.393c0.268,0.052,0.444,0.313,0.392,0.583c-0.149,0.763-0.34,1.34-0.55,1.776    c0.263,0.468,0.414,0.97,0.444,1.292c0.043,0.462-0.025,0.867-0.161,1.209c0.446,0.592,0.774,1.386,0.822,2.263    c0.016,0.273-0.195,0.508-0.468,0.522C358.739,159.347,358.73,159.347,358.721,159.347z M356.697,156.491    c-0.049,0-0.106,0.025-0.154,0.221c-0.046,0.184-0.015,0.25-0.015,0.251c0.021,0.006,0.211,0.009,0.458-0.157    c0.036-0.024,0.09-0.065,0.152-0.123c-0.153-0.113-0.298-0.179-0.414-0.19C356.715,156.492,356.707,156.491,356.697,156.491z     M356.528,153.873c-0.018,0-0.031,0.002-0.041,0.003c-0.12,0.018-0.263,0.059-0.259,0.149c0.004,0.129,0.139,0.296,0.291,0.307    c0.081-0.002,0.238-0.053,0.4-0.237c-0.037-0.038-0.075-0.072-0.113-0.102C356.673,153.89,356.581,153.873,356.528,153.873z"></path></g><g><g><g><path fill="#A1C083" d="M323.93,157.279c3.955-5.674,0.348-13.47-6.313-16.534c-1.943,2.475-2.69,6.698-2.814,9.922      c-0.068,1.78,1.068,4.713,2.706,6.815C319.143,159.579,322.41,159.46,323.93,157.279z"></path></g><g><g><path fill="#5F5371" d="M324.786,157.78c4.36-6.724-0.15-14.705-6.669-17.892c-0.517-0.253-1.023-0.107-1.356,0.356       c-2.773,3.85-3.878,10.002-2.014,14.426c0.844,2.003,2.081,4.292,4.265,5.031c2.101,0.712,4.238-0.046,5.619-1.72       c0.807-0.978-0.588-2.39-1.402-1.404c-3.629,4.397-7.242-2.358-7.429-5.654c-0.183-3.211,0.797-7.073,2.673-9.678       c-0.452,0.119-0.904,0.237-1.356,0.356c5.56,2.719,9.753,9.322,5.958,15.176C322.377,157.853,324.093,158.849,324.786,157.78z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M321.883,162.813c-0.984-0.745-1.45-2.039-1.163-3.421c0.459-2.201,1.762-4.4,4.125-5.556      c3.377-1.652,7.198,3.261,9.85,4.49c-3.594,0.323-5.224,5.186-8.101,6.474C324.61,165.69,323.61,164.121,321.883,162.813z"></path></g><g><g><path fill="#5F5371" d="M322.584,162.111c-1.698-1.578-0.677-4.222,0.622-5.752c1.372-1.616,3.027-2.242,4.972-1.331       c2.218,1.039,3.85,3.025,6.018,4.155c0.079-0.605,0.158-1.209,0.237-1.814c-2.034,0.323-3.441,1.63-4.756,3.131       c-0.695,0.794-1.328,1.663-2.101,2.385C325.621,164.708,324.225,163.434,322.584,162.111c-0.985-0.794-2.396,0.602-1.402,1.404       c2.236,1.802,4.118,3.544,6.884,1.548c2.438-1.759,3.673-5.269,6.893-5.78c0.846-0.134,0.952-1.441,0.237-1.814       c-3.324-1.732-6.625-6.413-10.851-4.49c-3.602,1.639-6.545,7.393-3.163,10.536       C322.117,164.383,323.522,162.983,322.584,162.111z"></path></g></g></g><g><path fill="#A1C083" d="M386.06,192.789c-0.508,0-0.941-0.389-0.986-0.904c-0.194-2.178,0.979-3.62,2.22-5.147     c2.113-2.598,4.742-5.831,3.626-14.853c-1.057-8.537-6.262-14.626-13.922-16.288c-8.698-1.891-17.985,2.474-23.112,10.849     c-4.648,7.592-12.769,10.272-21.724,7.162c-7.291-2.53-12.364-8.049-11.8-12.837c0.064-0.545,0.552-0.935,1.101-0.869     c0.543,0.064,0.932,0.557,0.868,1.102c-0.442,3.757,4.259,8.57,10.48,10.729c3.004,1.043,13.272,3.663,19.386-6.324     c5.568-9.095,15.705-13.815,25.222-11.752c8.521,1.848,14.304,8.571,15.47,17.984c1.221,9.862-1.829,13.612-4.055,16.351     c-1.253,1.54-1.9,2.404-1.783,3.717c0.048,0.546-0.354,1.028-0.899,1.077C386.119,192.788,386.089,192.789,386.06,192.789z"></path></g><g><g><path fill="#CCDBB0" d="M321.871,160.32c0.623,7.749-13.005,9.664-15.962-1.639C312.769,160.021,321.674,151.908,321.871,160.32      z"></path></g><g><g><path fill="#5F5371" d="M320.88,160.32c0.16,3.378-2.665,5.385-5.854,5.329c-4.249-0.074-7.065-3.386-8.162-7.233       c-0.406,0.407-0.813,0.814-1.219,1.221c2.993,0.476,5.821-0.291,8.675-1.151c1.306-0.394,2.662-0.904,4.031-1.013       C320.318,157.316,320.783,158.485,320.88,160.32c0.068,1.271,2.05,1.279,1.983,0c-0.495-9.321-11.49-1.77-16.69-2.596       c-0.715-0.114-1.445,0.43-1.219,1.221c1.372,4.812,5.181,8.865,10.484,8.686c4.095-0.138,7.629-3.011,7.425-7.311       C322.802,159.048,320.819,159.04,320.88,160.32z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M386.232,158.823c0.022,2.386-1.822,6.864-3.924,8.309c-2.913,2.003-8.22,0.188-10.33-2.231      c3.189-2.111,1.831-5.29,4.866-7.656C379.51,155.166,384.183,156.027,386.232,158.823"></path></g><g><g><path fill="#5F5371" d="M385.241,158.823c-0.103,2.593-1.483,6.507-3.94,7.751c-2.732,1.384-6.684-0.351-8.622-2.374       c-0.067,0.52-0.134,1.039-0.201,1.559c2.366-1.795,2.325-4.046,3.788-6.398c2.14-3.441,6.991-2.61,9.265,0.164       c0.81,0.988,2.206-0.423,1.402-1.404c-2.05-2.501-5.66-3.686-8.779-2.664c-1.397,0.458-2.603,1.399-3.411,2.624       c-1.3,1.97-1.257,4.44-3.265,5.964c-0.508,0.386-0.684,1.054-0.201,1.559c2.491,2.6,6.977,4.296,10.479,2.916       c3.466-1.365,5.329-6.234,5.467-9.697C387.275,157.545,385.292,157.547,385.241,158.823L385.241,158.823z"></path></g></g></g><g><path fill="#A1C083" d="M331.257,171.431c4.712,0.839,9.677,8.862-4.811,12.219C328.678,179.776,325.003,169.473,331.257,171.431     z"></path><path fill="#5F5371" d="M326.446,184.643c-0.31,0-0.607-0.145-0.797-0.401c-0.235-0.318-0.259-0.744-0.062-1.088     c0.701-1.215,0.711-3.421,0.721-5.554c0.014-2.887,0.026-5.615,1.696-6.838c0.87-0.637,2.045-0.737,3.489-0.296     c2.618,0.496,5.468,2.927,5.548,6.033c0.054,2.122-1.221,5.998-10.371,8.119C326.595,184.634,326.521,184.643,326.446,184.643z      M329.866,172.178c-0.29,0-0.522,0.062-0.691,0.186c-0.863,0.632-0.874,3.083-0.884,5.246c-0.008,1.588-0.015,3.21-0.301,4.612     c4.577-1.345,7.128-3.371,7.068-5.671c-0.051-2.033-2.136-3.814-3.975-4.142c-0.042-0.007-0.082-0.017-0.123-0.03     C330.533,172.245,330.167,172.178,329.866,172.178z"></path></g><g><g><path fill="#A1C083" d="M387.723,164.402c-3.086-1.308-3.534-5.476-0.78-7.388c1.987-1.379,4.078-2.078,7.004-0.948      c4.943,1.908,5.481,5.94,6.346,10.614c-2.712-2.287-6.117-0.863-9.227-1.29C390.202,165.272,388.964,164.928,387.723,164.402z"></path></g><g><g><path fill="#5F5371" d="M388.223,163.545c-2.102-1.065-2.921-3.671-1.059-5.446c2.1-2.001,5.176-1.932,7.579-0.575       c3.437,1.941,3.945,5.885,4.594,9.42c0.485-0.374,0.971-0.747,1.456-1.121c-1.738-1.266-3.581-1.533-5.697-1.454       c-2.581,0.096-4.672,0.041-7.11-0.924c-1.187-0.47-1.702,1.449-0.527,1.914c1.785,0.706,3.501,1.133,5.427,1.101       c2.477-0.042,4.756-0.489,6.906,1.077c0.77,0.561,1.596-0.362,1.456-1.121c-0.539-2.933-0.992-6.114-2.951-8.491       c-1.902-2.308-5.223-3.782-8.205-3.318c-2.421,0.376-5.06,1.96-5.767,4.441c-0.73,2.562,0.603,5.05,2.897,6.212       C388.359,165.835,389.363,164.123,388.223,163.545z"></path></g></g></g><g><path fill="#CCDBB0" d="M352.323,165.53c2.978-0.177,3.787-2.171,3.635-4.745c-0.159-2.689-3.28-3.178-4.289-6.762     C346.618,157.967,346.05,165.766,352.323,165.53z"></path><path fill="#5F5371" d="M352.057,166.527c-2.428,0-4.223-1.129-4.952-3.13c-1.144-3.137,0.556-7.503,3.953-10.157     c0.262-0.205,0.608-0.263,0.919-0.161c0.314,0.103,0.556,0.356,0.646,0.674c0.436,1.548,1.343,2.436,2.219,3.294     c0.985,0.963,2.004,1.961,2.105,3.68c0.283,4.789-2.739,5.686-4.566,5.793c-0.007,0.001-0.014,0.001-0.02,0.001     C352.258,166.525,352.157,166.527,352.057,166.527z M352.323,165.529h0.01H352.323z M351.268,155.713     c-2.202,2.276-2.939,5.254-2.301,7.003c0.463,1.272,1.568,1.882,3.308,1.822c1.436-0.087,2.876-0.598,2.693-3.695     c-0.054-0.908-0.583-1.467-1.512-2.377C352.74,157.766,351.894,156.937,351.268,155.713z"></path></g><g><path fill="#CCDBB0" d="M385.22,158.095c3.111-0.601,3.701-3.05,3.107-4.388c-1.171-2.637-5.043-5.014-7.074-4.508     C383.334,151.936,379.475,158.387,385.22,158.095z"></path><path fill="#5F5371" d="M384.853,159.097c-1.29,0-2.251-0.331-2.926-1.004c-1.18-1.178-1.096-2.993-1.014-4.748     c0.064-1.369,0.13-2.783-0.449-3.545c-0.201-0.266-0.257-0.615-0.146-0.93c0.11-0.315,0.372-0.553,0.696-0.634     c2.553-0.63,6.861,2.014,8.219,5.068c0.439,0.989,0.374,2.251-0.17,3.292c-0.661,1.269-1.959,2.147-3.655,2.475     c-0.046,0.009-0.092,0.014-0.137,0.016C385.127,159.094,384.988,159.097,384.853,159.097z M385.22,158.095h0.01H385.22z      M382.774,150.265c0.221,1.021,0.168,2.139,0.12,3.172c-0.062,1.324-0.126,2.693,0.432,3.249     c0.315,0.314,0.907,0.447,1.774,0.421c1.071-0.221,1.832-0.714,2.206-1.431c0.323-0.619,0.264-1.231,0.115-1.566     C386.647,152.367,384.43,150.749,382.774,150.265z"></path></g><g><path fill="#A1C083" d="M353.956,165.463c-10.447,1.284-1.438,8.06-0.505,12.736     C361.587,172.283,359.766,164.624,353.956,165.463z"></path><path fill="#5F5371" d="M353.451,179.191c-0.122,0-0.244-0.022-0.361-0.068c-0.315-0.123-0.545-0.398-0.611-0.73     c-0.241-1.209-1.193-2.723-2.113-4.186c-1.517-2.413-3.085-4.91-2.095-6.998c0.703-1.482,2.467-2.35,5.554-2.73     c2.628-0.376,4.806,0.759,5.698,2.959c1.18,2.912-0.059,7.617-5.489,11.564C353.862,179.127,353.657,179.191,353.451,179.191z      M354.814,166.391c-0.23,0-0.469,0.018-0.717,0.054c-0.007,0.001-0.014,0.001-0.02,0.002c-2.852,0.351-3.757,1.071-4.014,1.614     c-0.523,1.102,0.808,3.22,1.983,5.089c0.706,1.123,1.428,2.273,1.908,3.395c3.633-3.08,4.521-6.418,3.733-8.361     C357.215,167.023,356.187,166.391,354.814,166.391z M353.956,165.463h0.01H353.956z"></path></g></g><g><path fill="#A1C083" d="M151.227,255.46c-0.05,0.23,0.01,0.47,0.17,0.65c0.799,0.89,0.949,2.2,0.36,3.25    c-0.599,1.05-1.788,1.6-2.976,1.37l-2.117-0.42c-0.23-0.04-0.449,0.03-0.609,0.19c-0.16,0.15-0.23,0.38-0.19,0.6    c0.19,1.09-0.29,2.16-1.238,2.73c-0.939,0.58-2.107,0.52-2.986-0.15c-0.32-0.24-0.649-0.32-0.969-0.25s-0.589,0.27-0.749,0.56    l-0.33,0.62c-0.519,0.94-1.468,1.54-2.547,1.61c-1.079,0.06-2.087-0.43-2.706-1.31l-0.519-0.73c-0.2-0.28-0.519-0.46-0.869-0.47    c-0.34,0.01-0.689,0.14-0.909,0.41l-1.059,1.28c-0.589,0.72-1.468,1.13-2.387,1.13c-0.08,0-0.17,0-0.25-0.01    c-1.009-0.08-1.918-0.65-2.427-1.52l-0.4-0.7c-0.2-0.33-0.559-0.54-0.949-0.54c-0.399,0.01-0.749,0.2-0.949,0.52    c-0.599,0.97-1.678,1.53-2.816,1.47c-1.128-0.07-2.137-0.76-2.617-1.79l-0.08-0.18c-0.12-0.27-0.39-0.44-0.689-0.44    c-0.3,0-0.569,0.17-0.699,0.45c-0.41,0.92-1.298,1.54-2.307,1.61c-1.019,0.06-1.977-0.43-2.517-1.28l-0.909-1.45    c-0.14-0.22-0.38-0.36-0.639-0.37s-0.509,0.12-0.659,0.34c-0.649,0.93-1.778,1.37-2.886,1.11c-1.109-0.25-1.938-1.14-2.117-2.25    l-0.07-0.47c-0.1-0.6-0.639-1-1.238-0.94l-1.139,0.14c-1.109,0.13-2.197-0.47-2.687-1.48s-0.28-2.23,0.509-3.02    c0.16-0.16,0.23-0.39,0.18-0.61c-0.05-0.22-0.21-0.4-0.419-0.48l-1.258-0.47c-0.949-0.35-1.578-1.27-1.578-2.28    c0-1.01,0.639-1.93,1.588-2.27c0.18-0.06,0.29-0.23,0.29-0.41c0-0.19-0.11-0.35-0.28-0.42c-1.029-0.38-1.738-1.37-1.748-2.47    c-0.02-1.1,0.659-2.11,1.668-2.53c0.28-0.11,0.469-0.34,0.519-0.63c0.05-0.29-0.05-0.58-0.26-0.78l-0.16-0.14    c-0.939-0.86-1.228-2.22-0.699-3.38c0.519-1.17,1.728-1.86,2.996-1.72c0.509,0.06,0.949-0.28,1.039-0.77l0.06-0.29    c0.24-1.26,1.258-2.25,2.517-2.47c1.268-0.21,2.557,0.38,3.206,1.49l0.18,0.32c0.12,0.2,0.33,0.32,0.559,0.32    c0.23,0,0.449-0.12,0.559-0.32c0.509-0.85,1.438-1.34,2.427-1.29c0.989,0.06,1.848,0.66,2.247,1.57l0.41,0.93    c0.15,0.35,0.459,0.59,0.829,0.65c0.37,0.07,0.749-0.05,1.009-0.33l0.26-0.28c0.779-0.81,1.947-1.15,3.036-0.86    c1.089,0.28,1.938,1.14,2.217,2.23l0.19,0.73c0.07,0.29,0.3,0.52,0.599,0.59c0.29,0.07,0.599-0.03,0.799-0.25    c0.709-0.8,1.818-1.12,2.846-0.84c1.019,0.29,1.808,1.15,1.997,2.2l0.05,0.31c0.06,0.3,0.29,0.55,0.579,0.62    c0.3,0.08,0.619-0.03,0.809-0.27c0.669-0.84,1.778-1.22,2.816-0.96c1.049,0.26,1.848,1.11,2.057,2.16l0.14,0.75    c0.08,0.39,0.37,0.72,0.749,0.85c0.389,0.12,0.809,0.03,1.109-0.25l0.779-0.71c0.799-0.73,1.938-1,2.976-0.69    c1.039,0.3,1.848,1.14,2.127,2.2l0.34,1.3c0.09,0.37,0.36,0.66,0.719,0.78c0.36,0.12,0.749,0.06,1.049-0.18l0.909-0.71    c0.929-0.73,2.167-0.87,3.236-0.37c1.059,0.5,1.748,1.54,1.778,2.72l0.02,0.68c0.02,0.52,0.38,0.95,0.889,1.06l0.24,0.05    c1.158,0.25,2.027,1.25,2.117,2.43c0.1,1.18-0.609,2.3-1.708,2.73C151.447,255.05,151.287,255.24,151.227,255.46z"></path></g><g><g><path fill="#CCDBB0" d="M143.357,256.04c-0.274,0-0.496-0.222-0.496-0.496c0-0.763-0.62-1.383-1.381-1.383     c-0.761,0-1.381,0.62-1.381,1.383c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496     c0-0.763-0.619-1.383-1.38-1.383c-0.761,0-1.381,0.62-1.381,1.383c0,0.274-0.222,0.496-0.496,0.496     c-0.274,0-0.496-0.222-0.496-0.496c0-0.763-0.62-1.383-1.381-1.383s-1.381,0.62-1.381,1.383c0,0.274-0.222,0.496-0.496,0.496     c-0.274,0-0.496-0.222-0.496-0.496c0-1.309,1.064-2.376,2.372-2.376c0.763,0,1.442,0.363,1.877,0.924     c0.434-0.561,1.114-0.924,1.876-0.924c0.762,0,1.442,0.363,1.876,0.924c0.434-0.561,1.114-0.924,1.876-0.924     c1.308,0,2.372,1.066,2.372,2.376C143.853,255.818,143.631,256.04,143.357,256.04z"></path></g></g><g><g><path fill="#A1C083" d="M82.248,250.358c0.733,3.531-0.684,10.715-3.376,13.477c-3.73,3.828-12.133,2.702-15.973-0.263     c4.108-4.071,1.16-8.383,4.965-12.787C71.205,246.917,78.388,246.816,82.248,250.358"></path></g><g><g><path fill="#5F5371" d="M81.292,250.621c0.699,3.994-0.408,10.645-3.904,13.162c-3.898,2.807-10.336,1.579-13.989-1.068      c0.067,0.52,0.134,1.039,0.201,1.559c1.443-1.571,2.306-3.256,2.667-5.363c0.45-2.624,0.422-5.296,2.297-7.424      c3.223-3.658,9.432-3.45,12.982-0.427c0.967,0.823,2.376-0.575,1.402-1.404c-3.587-3.053-8.948-3.799-13.177-1.598      c-2.103,1.095-3.705,2.999-4.498,5.231c-1.19,3.349-0.479,6.753-3.076,9.581c-0.464,0.505-0.327,1.177,0.201,1.559      c4.288,3.107,11.712,4.216,16.206,0.931c4.169-3.047,5.435-10.493,4.599-15.266C82.984,248.838,81.073,249.37,81.292,250.621      L81.292,250.621z"></path></g></g></g><g><path fill="#A1C083" d="M77.991,241.091c4.618,4.012,4.811,16.069-13.274,10.243C69.7,248.55,72.414,234.839,77.991,241.091z"></path><path fill="#5F5371" d="M73.095,253.888c-2.24,0-5.081-0.45-8.681-1.609c-0.376-0.121-0.644-0.454-0.683-0.847    s0.159-0.772,0.503-0.964c1.628-0.91,3.102-3.354,4.527-5.717c1.868-3.097,3.633-6.022,6.126-6.254    c1.28-0.122,2.561,0.514,3.8,1.886c2.473,2.189,3.97,6.582,2.089,9.926C79.901,251.865,77.848,253.888,73.095,253.888z     M66.827,250.927c6.268,1.705,10.68,1.15,12.223-1.592c1.339-2.38,0.174-5.859-1.708-7.495c-0.032-0.027-0.062-0.057-0.09-0.088    c-0.809-0.908-1.541-1.337-2.18-1.278c-1.498,0.14-3.081,2.765-4.613,5.304C69.33,247.65,68.172,249.568,66.827,250.927z"></path></g><g><g><path fill="#A1C083" d="M89.451,243.072c-11.872,3.113-12.085,16.806-4.364,24.616c3.435-2.085,6.225-6.797,7.822-10.597     C94.371,253.612,93.297,244.847,89.451,243.072"></path></g><g><g><path fill="#5F5371" d="M89.188,242.115c-12.402,3.514-12.747,17.975-4.801,26.275c0.29,0.303,0.842,0.391,1.201,0.155      c4.32-2.831,8.37-8.691,8.867-13.923c0.389-4.085-0.485-10.252-4.503-12.407c-1.124-0.603-2.127,1.11-1.001,1.714      c3.35,1.796,3.913,7.45,3.504,10.811c-0.538,4.426-4.22,9.7-7.868,12.091c0.4,0.052,0.801,0.103,1.201,0.155      c-6.895-7.203-7.01-19.858,3.927-22.957C90.941,243.682,90.42,241.766,89.188,242.115L89.188,242.115z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M86.643,224.341c7.053,6.984-4.549,20.21-16.82,11.733C77.581,231.648,79.45,216.361,86.643,224.341z"></path></g><g><g><path fill="#5F5371" d="M85.942,225.043c3.066,3.239,1.862,7.774-1.36,10.429c-4.287,3.533-9.912,2.613-14.26-0.254      c0,0.571,0,1.143,0,1.714c3.49-2.113,5.61-5.645,7.751-9.003c0.916-1.436,1.857-3.186,3.249-4.224      C83.113,222.37,84.631,223.649,85.942,225.043c0.877,0.932,2.277-0.474,1.402-1.404c-2.828-3.005-5.936-3.333-8.657-0.052      c-3.183,3.838-4.929,8.944-9.365,11.63c-0.66,0.4-0.619,1.306,0,1.714c5.261,3.47,12.158,4.11,17.05-0.396      c3.771-3.474,4.628-9.034,0.972-12.896C86.464,222.71,85.064,224.115,85.942,225.043z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M102.784,245.432c-2.407,2.684-4.787,9.607-3.847,13.35c1.303,5.187,9.133,8.442,13.941,7.811     c-1.508-5.586,3.205-7.831,2.127-13.553C114.058,248.016,107.899,244.313,102.784,245.432"></path></g><g><g><path fill="#5F5371" d="M102.083,244.73c-3.179,3.787-5.887,11.086-3.52,15.848c2.416,4.863,9.133,7.533,14.315,7.008      c0.654-0.066,1.111-0.579,0.956-1.256c-0.753-3.295,0.917-5.577,1.841-8.575c0.705-2.288,0.641-4.772-0.369-6.961      c-2.18-4.728-7.802-7.216-12.785-6.319c-1.254,0.226-0.723,2.139,0.527,1.914c5.246-0.945,11.369,3.041,11.119,8.728      c-0.091,2.076-1.173,3.88-1.877,5.781c-0.737,1.993-0.841,3.891-0.368,5.959c0.319-0.419,0.637-0.838,0.956-1.256      c-4.361,0.442-10.06-1.567-12.34-5.531c-2.284-3.97,0.24-10.711,2.947-13.936C104.301,245.162,102.905,243.751,102.083,244.73      L102.083,244.73z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M100.035,239.808c-4.793,4.765-10.497,7.641-11.477,14.775c-0.974,7.082,3.617,11.282,11.053,13.032     c0.306-1.941-0.166-3.691,0.618-5.603c1.099-2.684,3.697-4.337,4.563-7.205C106.236,250.022,100.837,244.546,100.035,239.808"></path></g><g><g><path fill="#5F5371" d="M99.334,239.106c-5.215,5.082-11.971,9.217-11.897,17.393c0.063,6.894,5.857,10.568,11.91,12.073      c0.678,0.169,1.185-0.314,1.255-0.957c0.186-1.714-0.057-3.504,0.552-5.141c0.551-1.482,1.636-2.617,2.588-3.851      c1.287-1.668,2.307-3.476,2.284-5.64c-0.052-4.916-4.067-8.758-5.036-13.438c-0.259-1.25-2.17-0.721-1.912,0.528      c0.944,4.56,5.388,8.744,4.947,13.525c-0.25,2.703-2.666,4.472-3.994,6.647c-1.44,2.361-1.126,4.735-1.412,7.371      c0.418-0.319,0.837-0.638,1.255-0.957c-5.715-1.421-11.027-4.813-10.401-11.419c0.647-6.82,6.805-10.386,11.262-14.728      C101.651,239.617,100.249,238.214,99.334,239.106L99.334,239.106z"></path></g></g></g><g><g><path fill="#A1C083" d="M95.54,247.502c-5.005-2.93-9.217-6.605-14.838-3.295c-5.834,3.435-5.673,8.63-5.791,14.702     c2.943-3.448,7.531-2.363,11.362-3.55c2.95-0.914,9.141-4.594,8.892-8.28"></path></g><g><g><path fill="#5F5371" d="M96.041,246.645c-5.613-3.343-11.08-6.998-17.182-2.394c-4.733,3.571-4.84,9.224-4.939,14.658      c-0.016,0.848,1.103,1.325,1.692,0.702c3.335-3.524,9.115-2.21,13.297-4.282c3.148-1.56,7.207-4.333,7.247-8.25      c0.013-1.278-1.969-1.279-1.983,0c-0.04,3.867-5.876,6.85-9.138,7.573c-3.922,0.869-7.829,0.389-10.826,3.556      c0.564,0.234,1.128,0.468,1.692,0.702c0.081-4.408-0.085-9.311,3.461-12.518c5.38-4.865,10.622-1.043,15.676,1.968      C96.139,249.014,97.138,247.298,96.041,246.645L96.041,246.645z"></path></g></g></g><g><path fill="#A1C083" d="M98.762,238.09c-13.394,1.183-2.187,10.228-1.2,16.239C108.209,247.132,106.217,237.272,98.762,238.09z"></path><path fill="#5F5371" d="M97.562,255.322c-0.133,0-0.267-0.027-0.393-0.081c-0.31-0.134-0.531-0.417-0.586-0.75    c-0.263-1.604-1.425-3.601-2.548-5.532c-1.794-3.084-3.649-6.272-2.363-8.761c0.915-1.769,3.136-2.753,6.992-3.095    c3.234-0.35,5.863,1.121,6.86,3.846c1.344,3.669-0.426,9.483-7.408,14.204C97.95,255.265,97.756,255.322,97.562,255.322z     M99.624,239.034c-0.244,0-0.496,0.015-0.755,0.043c-0.007,0.001-0.014,0.001-0.021,0.002c-2.993,0.265-4.866,0.967-5.416,2.032    c-0.786,1.519,0.791,4.229,2.316,6.849c0.915,1.573,1.854,3.187,2.399,4.728c5.125-3.918,6.491-8.396,5.516-11.056    C103.05,239.956,101.598,239.034,99.624,239.034z M98.762,238.09h0.01H98.762z"></path></g><g><g><path fill="#A1C083" d="M98.748,238.635c0-3.272-2.27-6.155-5.47-6.817c-2.23-0.462-4.742-0.539-6.456,0.732     c-3.981,2.952-1.012,11.838-1.355,16.223c2.656-4.315,7.82-0.83,11.081-3.442C98.247,243.971,98.749,241.279,98.748,238.635z"></path></g><g><g><path fill="#5F5371" d="M99.74,238.635c-0.154-3.108-1.743-5.946-4.65-7.26c-2.678-1.211-6.82-1.42-9.155,0.63      c-4.45,3.906-1.198,11.788-1.457,16.767c-0.055,1.061,1.326,1.244,1.847,0.501c2.235-3.188,6.519-1.056,9.627-2.443      C99.111,245.419,99.678,241.73,99.74,238.635c0.025-1.278-1.957-1.278-1.983,0c-0.041,2.102-0.188,4.925-2.187,6.171      c-1.404,0.875-3.222,0.593-4.788,0.615c-2.636,0.037-4.604,0.616-6.17,2.85c0.616,0.167,1.231,0.334,1.847,0.501      c0.211-4.04-1.199-8.064-0.634-12.104c0.426-3.046,2.459-4.384,5.553-4.127c3.521,0.292,6.197,2.414,6.379,6.094      C97.82,239.907,99.803,239.914,99.74,238.635z"></path></g></g></g><g><path fill="#CCDBB0" d="M86.325,239.796c-1.035-3.918-4.204-4.458-5.855-3.583c-3.255,1.724-6.045,4.777-5.124,9.42    C78.649,242.739,87.196,247.103,86.325,239.796z"></path><path fill="#5F5371" d="M75.346,246.625c-0.107,0-0.215-0.017-0.319-0.053c-0.335-0.113-0.584-0.398-0.653-0.745    c-0.869-4.382,1.131-8.108,5.633-10.491c1.147-0.608,2.665-0.632,3.965-0.062c1.593,0.699,2.77,2.215,3.312,4.269    c0.012,0.045,0.02,0.09,0.026,0.137c0.218,1.83-0.079,3.184-0.908,4.14c-1.316,1.516-3.572,1.565-5.754,1.612    c-1.797,0.039-3.654,0.079-4.648,0.95C75.815,246.54,75.583,246.625,75.346,246.625z M82.02,236.846    c-0.444,0-0.827,0.107-1.087,0.244c-2.298,1.217-4.843,3.372-4.773,6.93c1.334-0.508,2.907-0.541,4.444-0.575    c1.831-0.039,3.56-0.077,4.3-0.93c0.427-0.492,0.576-1.344,0.444-2.533c-0.499-1.818-1.454-2.576-2.173-2.891    C82.772,236.914,82.376,236.846,82.02,236.846z"></path></g><g><g><path fill="#A1C083" d="M83.729,227.514c-2.648,2.805-2.443,6.441-0.872,8.805c2.3,3.462,3.469,3.476,9.596,4.423     c-3.52-7.402-0.452-8.874-1.096-12.005C90.529,224.708,86.268,224.823,83.729,227.514z"></path></g><g><g><path fill="#5F5371" d="M83.028,226.812c-2.872,3.359-2.981,7.575-0.269,11.071c2.358,3.04,5.852,3.266,9.43,3.816      c0.884,0.136,1.495-0.632,1.119-1.458c-1.195-2.626-1.894-5.118-1.305-7.972c0.314-1.523,0.643-2.896,0.14-4.43      C90.709,223.47,85.75,224.177,83.028,226.812c-0.919,0.89,0.484,2.292,1.402,1.404c1.616-1.565,4.744-2.692,5.802,0.151      c0.45,1.21,0.068,2.357-0.181,3.553c-0.694,3.329,0.157,6.271,1.546,9.323c0.373-0.486,0.746-0.972,1.119-1.458      c-2.336-0.359-5.501-0.398-7.406-2.015c-2.947-2.502-3.423-6.581-0.88-9.554C85.255,227.25,83.859,225.84,83.028,226.812z"></path></g></g></g><g><g><path fill="#A1C083" d="M140.003,174.279c1.297-6.078-1.492-13.907-8.127-15.426c-6.319-1.447-9.677,3.606-10.051,9.262     c-0.441,6.652,2.094,12.399,5.666,17.855c4.497,6.868,10.619,14.605,6.923,23.226c-1.976,4.609-6.472,7.778-9.498,11.677     c-2.92,3.764-4.787,7.852-5.775,12.51c-0.264,1.246,1.646,1.779,1.912,0.528c0.807-3.807,2.179-7.299,4.426-10.49     c2.316-3.288,5.3-5.895,7.887-8.939c4.477-5.269,5.223-11.988,2.565-18.283c-2.674-6.332-7.636-11.368-10.372-17.662     c-1.905-4.382-3.11-11.427-0.26-15.665c2.239-3.33,6.996-2.641,9.648-0.19c2.954,2.731,3.966,7.225,3.146,11.068     C137.826,174.997,139.736,175.529,140.003,174.279L140.003,174.279z"></path></g></g><g><g><path fill="#A1C083" d="M134.906,209.776c3.969-1.103,7.528-2.861,10.789,0.434c3.384,3.42,2.332,6.959,1.312,11.151     c-1.396-2.903-4.744-2.992-7.161-4.504c-1.86-1.164-5.445-4.817-4.607-7.304"></path></g><g><g><path fill="#5F5371" d="M135.17,210.733c3.592-1.035,7.357-2.722,10.256,0.685c2.446,2.874,1.435,6.373,0.626,9.68      c0.604-0.079,1.208-0.158,1.812-0.237c-1.357-2.403-3.573-3.084-5.976-4.1c-2.308-0.975-6.344-4.015-5.691-6.943      c0.278-1.244-1.633-1.776-1.912-0.528c-0.628,2.814,1.484,5.417,3.456,7.182c2.474,2.214,6.742,2.436,8.411,5.391      c0.413,0.731,1.609,0.593,1.812-0.237c1.023-4.18,1.887-8.33-1.291-11.815c-3.434-3.766-7.793-2.212-12.03-0.992      C133.419,209.172,133.939,211.088,135.17,210.733L135.17,210.733z"></path></g></g></g><g><g><path fill="#A1C083" d="M130.111,188.314c-8.413-2.292-13.387,6.066-11.393,13.614c2.853-0.066,6.238-1.979,8.566-3.753     C129.414,196.55,131.852,190.771,130.111,188.314"></path></g><g><g><path fill="#5F5371" d="M130.375,187.357c-9.146-2.198-14.571,6.607-12.613,14.835c0.094,0.396,0.537,0.76,0.956,0.729      c3.766-0.28,8.357-2.384,10.601-5.525c1.815-2.54,3.356-6.644,1.648-9.583c-0.641-1.104-2.355-0.106-1.712,1.002      c1.305,2.245-0.274,5.852-1.739,7.683c-1.932,2.414-5.781,4.213-8.798,4.438c0.319,0.243,0.637,0.486,0.956,0.729      c-1.595-6.7,2.519-14.233,10.174-12.393C131.088,189.569,131.617,187.655,130.375,187.357L130.375,187.357z"></path></g></g></g><g><path fill="#CCDBB0" d="M134.923,162.047c-2.332-1.685-4.316-0.552-4.829,0.674c-1.012,2.415-0.172,6.457,1.425,7.486    C132.668,168.295,138.689,165.668,134.923,162.047z"></path><path fill="#5F5371" d="M131.519,171.2c-0.189,0-0.375-0.054-0.536-0.158c-2.045-1.318-2.989-5.874-1.803-8.705    c0.396-0.944,1.27-1.688,2.336-1.988c1.277-0.362,2.692-0.043,3.987,0.894c0.038,0.027,0.073,0.056,0.106,0.088    c1.046,1.006,1.56,2.078,1.528,3.188c-0.058,1.989-1.84,3.513-3.272,4.738c-0.624,0.534-1.27,1.086-1.497,1.463    c-0.138,0.23-0.364,0.394-0.625,0.455C131.669,171.191,131.594,171.2,131.519,171.2z M132.579,162.187    c-0.181,0-0.356,0.024-0.526,0.072c-0.578,0.163-0.924,0.557-1.045,0.845c-0.7,1.671-0.318,4.312,0.47,5.62    c0.324-0.314,0.698-0.635,1.099-0.978c1.134-0.969,2.545-2.176,2.578-3.285c0.015-0.52-0.269-1.059-0.869-1.65    C133.698,162.399,133.117,162.187,132.579,162.187z"></path></g><g><g><path fill="#A1C083" d="M137.098,163.203c-1.309-0.226-2.425-1.107-2.882-2.355c-0.729-1.989-0.669-4.308,0.929-6.185     c2.282-2.683,8.429-0.144,11.549-0.175c-3.183,1.676-0.967,5.51-2.973,7.698C142.335,163.695,139.396,163.6,137.098,163.203z"></path></g><g><g><path fill="#5F5371" d="M137.361,162.246c-2.325-0.608-3.073-3.179-2.374-5.324c0.718-2.201,2.34-2.574,4.373-2.472      c2.472,0.124,4.855,0.964,7.334,1.029c-0.167-0.617-0.334-1.233-0.5-1.85c-1.616,1.021-2.221,2.373-2.396,4.245      c-0.101,1.074,0.065,2.452-0.604,3.38C141.987,162.929,139.084,162.511,137.361,162.246c-1.248-0.192-1.786,1.72-0.527,1.914      c2.47,0.38,5.809,0.731,7.664-1.374c1.883-2.136,0.219-5.877,2.695-7.442c0.833-0.526,0.495-1.823-0.5-1.85      c-3.671-0.096-8.938-2.691-12.075,0.292c-3.208,3.05-2.182,9.225,2.215,10.374C138.07,164.483,138.597,162.569,137.361,162.246z      "></path></g></g></g><g><g><path fill="#A1C083" d="M121.127,169.695c-1.623-1.982-6.221-4.402-8.948-4.145c-3.778,0.357-6.905,5.511-6.982,8.96     c4.081-0.458,5.146,3.098,9.276,2.957C118.099,177.343,121.36,173.412,121.127,169.695"></path></g><g><g><path fill="#5F5371" d="M121.828,168.993c-2.51-2.792-7.509-5.462-11.292-4.047c-3.7,1.384-6.087,5.79-6.33,9.563      c-0.033,0.514,0.481,1.023,0.991,0.993c4.027-0.237,6.482,3.879,10.799,2.727c3.708-0.99,6.153-4.822,6.122-8.534      c-0.011-1.277-1.993-1.28-1.983,0c0.035,4.164-3.956,8.134-8.166,6.276c-2.424-1.07-3.931-2.621-6.773-2.454      c0.33,0.331,0.661,0.662,0.991,0.993c0.194-3.013,2.311-6.993,5.418-7.836c2.952-0.801,6.919,1.608,8.82,3.723      C121.281,171.348,122.68,169.941,121.828,168.993L121.828,168.993z"></path></g></g></g><g><g><path fill="#A1C083" d="M127.408,217.976c-4.038-3.158-6.705-7.059-12.246-7.391c-5.501-0.33-8.342,3.14-9.074,8.506     c1.511,0.118,2.812-0.305,4.34,0.153c2.144,0.643,3.622,2.403,5.888,2.871C120.095,222.896,123.846,218.786,127.408,217.976"></path></g><g><g><path fill="#5F5371" d="M128.109,217.274c-4.457-3.576-8.289-8.185-14.577-7.659c-5.079,0.425-7.672,4.522-8.401,9.211      c-0.099,0.636,0.255,1.243,0.956,1.256c1.33,0.026,2.776-0.25,4.076,0.118c1.096,0.31,2.005,1.027,2.969,1.593      c1.409,0.827,2.845,1.472,4.515,1.4c3.727-0.161,6.548-3.292,10.024-4.26c1.227-0.342,0.706-2.258-0.527-1.914      c-3.315,0.923-6.611,4.494-10.163,4.192c-2.024-0.172-3.567-1.788-5.362-2.572c-1.824-0.796-3.604-0.503-5.532-0.541      c0.319,0.419,0.637,0.838,0.956,1.256c0.68-4.377,2.938-7.919,7.782-7.788c5.039,0.136,8.249,4.197,11.882,7.112      C127.694,219.469,129.105,218.073,128.109,217.274L128.109,217.274z"></path></g></g></g><g><g><path fill="#A1C083" d="M120.534,237.219c-3.812-4.272,1.091-10.637,6.442-8.612c1.197,0.453,2.359,1.121,3.484,2.124     c4.115,3.67,3.663,8.135,0.383,12.44c-1.149-0.989-7.426-3.846-9.357-5.123C121.128,237.812,120.813,237.532,120.534,237.219z"></path></g><g><g><path fill="#5F5371" d="M121.235,236.517c-3.327-4.155,1.856-8.628,6.069-6.676c2.41,1.116,4.666,3.281,5.049,6.012      c0.356,2.542-0.925,4.831-2.366,6.817c0.519-0.067,1.038-0.134,1.557-0.201C128.441,240.064,124.031,239.292,121.235,236.517      c-0.907-0.9-2.31,0.503-1.402,1.404c2.842,2.82,7.186,3.531,10.309,5.952c0.539,0.418,1.147,0.364,1.557-0.201      c2.068-2.851,3.515-6.358,2.176-9.84c-1.22-3.173-4.597-6.018-7.99-6.523c-5.997-0.894-9.738,6.008-6.052,10.612      C120.631,238.918,122.025,237.505,121.235,236.517z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M121.692,230.847c-1.522-4.145-5.308-3.764-7.831-2.697c-3.496,1.479-5.969,7.983-5.005,11.294     c3.754-1.666,6.018,1.004,9.914-0.375C122.192,237.859,123.032,234.322,121.692,230.847z"></path></g><g><g><path fill="#5F5371" d="M122.548,230.346c-1.784-4.194-6.694-4.986-10.286-2.397c-3.336,2.405-5.306,7.772-4.362,11.76      c0.115,0.487,0.73,0.879,1.219,0.693c3.786-1.438,7.689,1.299,11.382-1.077c3.002-1.932,3.208-5.649,2.146-8.741      c-0.413-1.201-2.328-0.685-1.912,0.528c1.316,3.831-0.277,7.545-4.793,7.365c-2.683-0.107-4.692-0.997-7.35,0.012      c0.406,0.231,0.813,0.462,1.219,0.693c-0.704-2.972,0.763-6.807,2.836-8.94c2.547-2.621,6.695-2.404,8.188,1.108      C121.335,232.52,123.043,231.51,122.548,230.346z"></path></g></g></g><g><path fill="#A1C083" d="M131.123,192.645c1.87-3.926,10.079-6.339,9.517,7.163C137.792,196.918,127.902,197.652,131.123,192.645z"></path><path fill="#5F5371" d="M140.639,200.801c-0.26,0-0.516-0.103-0.706-0.296c-0.877-0.89-2.79-1.428-4.639-1.948    c-2.543-0.715-4.945-1.391-5.627-3.192c-0.357-0.943-0.159-2.021,0.589-3.205c1.084-2.204,3.936-4.138,6.713-3.449    c1.895,0.471,5.019,2.544,4.661,11.139c-0.016,0.394-0.265,0.741-0.634,0.884C140.88,200.78,140.759,200.801,140.639,200.801z     M135.81,190.556c-1.559,0-3.17,1.209-3.793,2.516c-0.018,0.038-0.038,0.075-0.061,0.11c-0.286,0.445-0.593,1.062-0.435,1.48    c0.327,0.865,2.535,1.485,4.309,1.984c1.336,0.376,2.702,0.76,3.839,1.316c-0.093-4.202-1.219-6.837-3.178-7.324    C136.268,190.582,136.039,190.556,135.81,190.556z M131.123,192.645h0.01H131.123z"></path></g><g><path fill="#5F5371" d="M136.047,225.1c-1.41,0-2.501-0.94-2.918-2.53c-0.618-0.371-1.139-1.025-1.283-1.36    c-0.094-0.221-0.243-0.683-0.306-1.197c-0.236-0.04-0.456-0.128-0.634-0.273c-1.185-0.975-0.995-2.683-0.914-3.413    c0.03-0.271,0.284-0.461,0.547-0.438c0.272,0.03,0.468,0.276,0.438,0.549c-0.105,0.94-0.121,1.977,0.558,2.535    c0.008,0.007,0.017,0.013,0.029,0.019c0.043-0.198,0.114-0.383,0.222-0.544c0.233-0.348,0.595-0.52,1.059-0.527    c0.156,0.003,0.303,0.079,0.394,0.205c0.36,0.498,0.322,1.054-0.099,1.45c-0.158,0.149-0.372,0.268-0.61,0.349    c0.043,0.327,0.129,0.662,0.228,0.895c0.055,0.129,0.202,0.314,0.38,0.492c0.118-0.268,0.301-0.417,0.413-0.488    c0.365-0.231,0.856-0.205,1.192,0.059c0.328,0.259,0.443,0.682,0.301,1.107c-0.183,0.546-0.517,0.748-0.788,0.818    c0.283,0.658,0.868,1.399,2.024,1.287c0.283-0.025,0.516,0.172,0.543,0.444c0.028,0.272-0.171,0.516-0.443,0.543    C136.267,225.094,136.155,225.1,136.047,225.1z M134.104,221.674c-0.033,0.007-0.071,0.055-0.083,0.16    C134.059,221.8,134.091,221.715,134.104,221.674z"></path></g><g><path fill="#CCDBB0" d="M121.48,168.826c-4.393,3.027,0.879,7.347,6.201,8.42C129.563,171.739,125.872,165.799,121.48,168.826z"></path><path fill="#5F5371" d="M127.681,178.24c-0.065,0-0.131-0.006-0.197-0.019c-3.694-0.745-7.949-3.146-8.558-6.129    c-0.182-0.887-0.164-2.598,1.992-4.084l0,0c1.888-1.301,3.92-1.329,5.575-0.071c2.452,1.862,3.366,6.003,2.126,9.632    C128.479,177.976,128.097,178.24,127.681,178.24z M122.042,169.644c-1.396,0.962-1.228,1.781-1.174,2.05    c0.334,1.634,3.039,3.525,6.12,4.368c0.643-2.824-0.283-5.473-1.693-6.545C124.326,168.783,123.231,168.824,122.042,169.644    L122.042,169.644z"></path></g><g><path fill="#CCDBB0" d="M133.342,212.325c4.344-2.34,2.956-5.273,0.475-6.85c-2.714-1.726-6.137,0.728-9.203-1.858    C122.369,207.369,127.387,214.599,133.342,212.325z"></path><path fill="#5F5371" d="M131.062,213.753c-2.533,0-4.667-1.388-5.997-2.977c-2.055-2.454-2.577-5.536-1.302-7.668    c0.15-0.25,0.4-0.422,0.687-0.469c0.29-0.045,0.58,0.033,0.802,0.22c1.38,1.163,2.824,1.086,4.495,0.995    c1.527-0.082,3.106-0.167,4.601,0.782c1.831,1.165,2.848,2.749,2.791,4.347c-0.041,1.127-0.651,2.774-3.328,4.215    c-0.038,0.02-0.076,0.038-0.116,0.053C132.784,213.6,131.9,213.753,131.062,213.753z M133.342,212.325h0.01H133.342z     M125.102,205.144c-0.216,1.316,0.319,2.969,1.482,4.358c0.642,0.767,2.991,3.163,6.346,1.918    c1.009-0.552,2.189-1.426,2.228-2.508c0.031-0.863-0.669-1.834-1.873-2.6c-0.959-0.61-2.105-0.547-3.432-0.476    C128.37,205.918,126.727,206.004,125.102,205.144z"></path></g><g><path fill="#CCDBB0" d="M128.306,217.3c-6.655-6.862-6.611,3.378-9.477,6.617C127.563,226.567,132.098,221.048,128.306,217.3z"></path><path fill="#5F5371" d="M123.155,225.603c-1.378,0.001-2.923-0.224-4.614-0.737c-0.323-0.098-0.575-0.354-0.666-0.679    c-0.092-0.326-0.012-0.676,0.212-0.929c0.73-0.825,1.299-2.336,1.849-3.797c0.921-2.445,1.873-4.973,3.974-5.411    c1.489-0.3,3.11,0.501,5.1,2.551c1.74,1.725,2.123,3.97,1,5.859C128.961,224.229,126.568,225.603,123.155,225.603z     M120.439,223.311c4.107,0.883,6.922-0.271,7.868-1.865c0.654-1.101,0.4-2.354-0.697-3.439c-0.005-0.005-0.01-0.01-0.015-0.016    c-1.395-1.438-2.559-2.151-3.282-1.997c-1.034,0.215-1.825,2.315-2.523,4.167C121.381,221.25,120.962,222.364,120.439,223.311z"></path></g><g><path fill="#5F5371" d="M121.179,163.535c-0.249,0-0.599-0.095-0.948-0.504c-0.437-0.512-0.463-1.113-0.068-1.568    c0.161-0.186,0.387-0.338,0.658-0.451c-0.078-0.068-0.168-0.134-0.273-0.195c-0.105-0.062-0.265-0.123-0.449-0.173    c0.039,0.483-0.128,0.811-0.301,1.017c-0.413,0.492-1.187,0.602-1.724,0.247c-0.382-0.254-0.691-0.818-0.305-1.576    c0.166-0.325,0.462-0.56,0.858-0.683c-0.177-0.255-0.414-0.547-0.725-0.875c-0.188-0.2-0.18-0.514,0.019-0.702    c0.199-0.189,0.512-0.178,0.701,0.019c0.533,0.564,0.891,1.055,1.12,1.479c0.532,0.058,1.027,0.227,1.305,0.39    c0.4,0.234,0.688,0.523,0.887,0.832c0.737,0.004,1.574,0.176,2.314,0.647c0.231,0.147,0.299,0.454,0.152,0.685    c-0.147,0.23-0.452,0.299-0.684,0.152c-0.472-0.3-0.974-0.444-1.423-0.483c0.019,0.175,0.018,0.344,0,0.5    c-0.071,0.604-0.394,1.064-0.843,1.201C121.389,163.514,121.295,163.535,121.179,163.535z M121.305,161.887    c-0.181,0.059-0.317,0.138-0.393,0.226c-0.036,0.042-0.081,0.093,0.072,0.272c0.123,0.144,0.194,0.158,0.195,0.158    c0.017-0.016,0.13-0.169,0.137-0.463C121.318,162.037,121.316,161.97,121.305,161.887z M119.081,160.561    c-0.052,0.009-0.101,0.019-0.148,0.033c-0.215,0.063-0.264,0.158-0.28,0.189c-0.055,0.109-0.105,0.248-0.03,0.298    c0.106,0.073,0.32,0.059,0.417-0.058C119.102,160.949,119.135,160.797,119.081,160.561z"></path></g><g><g><path fill="#CCDBB0" d="M130.458,188.345c0.173,2.494,2.022,3.749,4.895,3.848c3.035,0.105,5.332-4.398,7.447-6.509     c-3.077,1.134-4.512-2.673-7.086-2.66C133.402,183.036,130.27,185.235,130.458,188.345z"></path></g><g><g><path fill="#5F5371" d="M129.467,188.345c0.418,3.214,3.138,5.199,6.415,4.813c3.53-0.416,5.429-4.46,7.62-6.772      c0.673-0.71,0.008-1.926-0.964-1.659c-1.979,0.544-3.129-1.167-4.673-2.051c-1.082-0.619-2.227-0.775-3.442-0.474      C131.561,182.911,129.508,185.41,129.467,188.345c-0.018,1.278,1.965,1.278,1.983,0c0.026-1.878,1.216-3.419,2.97-4.067      c1.522-0.562,2.557,0.159,3.736,1.035c1.579,1.174,2.926,1.874,4.909,1.328c-0.321-0.553-0.643-1.106-0.964-1.659      c-1.434,1.513-2.523,3.345-4.034,4.783c-1.997,1.9-6.164,2.056-6.616-1.421C131.287,187.096,129.302,187.08,129.467,188.345z"></path></g></g></g><g><path fill="#FCB663" d="M290.967,115.782l-1.91,9.909l-2.38,12.361l-2.01,5.109l-0.112,5.912l-4.666,24.234    c-0.109,0.566-0.604,0.975-1.179,0.975h-94.368c-0.576,0-1.07-0.409-1.179-0.975l-3.073-15.963l0.733-3.913l-2.685-6.226    l-4.142-21.514l-1.909-9.909H290.967z"></path><path fill="#5F5371" d="M278.71,175.77h-94.368c-1.286,0-2.396-0.917-2.639-2.181l-3.073-15.963    c-0.036-0.184-0.036-0.373-0.001-0.556l0.65-3.466l-2.505-5.809c-0.043-0.099-0.075-0.203-0.095-0.308l-6.051-31.423    c-0.084-0.436,0.03-0.887,0.313-1.23s0.703-0.541,1.147-0.541h118.88c0.443,0,0.864,0.198,1.147,0.541    c0.282,0.343,0.397,0.794,0.313,1.23l-4.289,22.269c-0.017,0.09-0.043,0.178-0.076,0.264l-1.912,4.86l-0.107,5.644    c-0.002,0.085-0.011,0.17-0.027,0.254l-4.666,24.235C281.105,174.853,279.995,175.77,278.71,175.77z M184.579,172.792h93.896    l4.597-23.876l0.108-5.785c0.004-0.177,0.039-0.353,0.104-0.518l1.96-4.981l3.921-20.362H173.888l5.679,29.493l2.621,6.077    c0.118,0.272,0.151,0.574,0.096,0.865l-0.681,3.635L184.579,172.792z"></path></g><g><path fill="#FFDB98" d="M263.325,140.435c-0.362,0-0.711-0.199-0.886-0.545c-0.247-0.489-0.051-1.086,0.438-1.334l10.81-5.475    c0.488-0.248,1.084-0.051,1.332,0.438c0.247,0.489,0.051,1.086-0.438,1.334l-10.81,5.475    C263.628,140.401,263.475,140.435,263.325,140.435z"></path></g><g><path fill="#FFDB98" d="M262.442,145.604c-0.356,0-0.701-0.193-0.878-0.53c-0.256-0.486-0.069-1.086,0.415-1.34l9.325-4.914    c0.483-0.256,1.084-0.069,1.339,0.416c0.256,0.486,0.069,1.086-0.415,1.34l-9.325,4.914    C262.756,145.567,262.598,145.604,262.442,145.604z"></path></g><g><g><path fill="#FFDB98" d="M193.663,158.378c-0.356,0-0.701-0.193-0.878-0.53c-0.255-0.486-0.069-1.086,0.415-1.34l19.293-10.166     c0.487-0.254,1.085-0.069,1.339,0.416c0.255,0.486,0.069,1.086-0.415,1.34l-19.293,10.166     C193.976,158.341,193.818,158.378,193.663,158.378z"></path></g><g><path fill="#FFDB98" d="M194.524,163.461c-0.356,0-0.701-0.193-0.878-0.53c-0.255-0.486-0.069-1.086,0.415-1.341l19.294-10.166     c0.487-0.254,1.085-0.068,1.339,0.416c0.255,0.486,0.069,1.086-0.415,1.34l-19.294,10.166     C194.837,163.424,194.68,163.461,194.524,163.461z"></path></g><g><path fill="#FFDB98" d="M206.123,162.722c-0.263,0-0.526-0.105-0.721-0.311l-11.6-12.316c-0.376-0.399-0.357-1.027,0.041-1.404     c0.398-0.377,1.025-0.357,1.401,0.041l11.6,12.316c0.376,0.399,0.357,1.027-0.041,1.404     C206.612,162.633,206.367,162.722,206.123,162.722z"></path></g><g><path fill="#FFDB98" d="M214.174,161.224c-0.26,0-0.52-0.102-0.715-0.305l-13.936-14.525c-0.379-0.395-0.366-1.024,0.028-1.403     c0.394-0.38,1.022-0.369,1.402,0.028l13.936,14.525c0.379,0.395,0.366,1.024-0.028,1.403     C214.669,161.132,214.422,161.224,214.174,161.224z"></path></g></g><g><g><path fill="#5F5371" d="M272.189,168.295c-0.059,0-0.118-0.005-0.178-0.016c-0.538-0.099-0.896-0.615-0.798-1.154l6.429-35.432     c0.099-0.539,0.616-0.898,1.153-0.799c0.538,0.098,0.896,0.615,0.798,1.154l-6.429,35.432     C273.077,167.959,272.659,168.295,272.189,168.295z"></path></g><g><path fill="#5F5371" d="M264.058,168.295c-0.047,0-0.095-0.003-0.143-0.011c-0.542-0.079-0.918-0.583-0.838-1.124l5.143-35.432     c0.078-0.542,0.577-0.916,1.123-0.839c0.542,0.079,0.918,0.583,0.838,1.125l-5.143,35.431     C264.966,167.939,264.543,168.295,264.058,168.295z"></path></g><g><path fill="#5F5371" d="M255.928,168.295c-0.036,0-0.072-0.002-0.108-0.006c-0.544-0.059-0.937-0.55-0.878-1.094l3.858-35.432     c0.059-0.545,0.537-0.94,1.093-0.879c0.544,0.06,0.937,0.55,0.878,1.094l-3.858,35.432     C256.857,167.918,256.428,168.295,255.928,168.295z"></path></g><g><path fill="#5F5371" d="M247.798,168.295c-0.024,0-0.048-0.001-0.073-0.003c-0.546-0.04-0.956-0.515-0.917-1.061l2.571-35.432     c0.04-0.547,0.52-0.949,1.06-0.918c0.546,0.04,0.956,0.515,0.917,1.062l-2.571,35.432     C248.747,167.896,248.313,168.295,247.798,168.295z"></path></g><g><path fill="#5F5371" d="M239.667,168.295c-0.013,0-0.024,0-0.037-0.001c-0.547-0.019-0.975-0.48-0.954-1.027l1.286-35.432     c0.02-0.548,0.475-0.988,1.026-0.956c0.547,0.02,0.975,0.48,0.954,1.028l-1.286,35.432     C240.637,167.874,240.198,168.295,239.667,168.295z"></path></g><g><path fill="#5F5371" d="M231.536,168.295c-0.547,0-0.991-0.444-0.991-0.993v-35.432c0-0.548,0.444-0.993,0.991-0.993     s0.991,0.444,0.991,0.993v35.432C232.527,167.851,232.083,168.295,231.536,168.295z"></path></g><g><path fill="#5F5371" d="M223.405,168.295c-0.531,0-0.971-0.421-0.99-0.957l-1.286-35.432c-0.02-0.548,0.408-1.008,0.955-1.028     c0.556-0.027,1.007,0.409,1.027,0.956l1.286,35.432c0.02,0.548-0.408,1.008-0.955,1.027     C223.429,168.295,223.417,168.295,223.405,168.295z"></path></g><g><path fill="#5F5371" d="M215.274,168.295c-0.515,0-0.95-0.398-0.988-0.921l-2.572-35.432c-0.04-0.547,0.371-1.022,0.917-1.062     c0.539-0.031,1.021,0.371,1.06,0.918l2.572,35.432c0.04,0.547-0.371,1.022-0.917,1.061     C215.322,168.294,215.298,168.295,215.274,168.295z"></path></g><g><path fill="#5F5371" d="M207.143,168.295c-0.499,0-0.929-0.376-0.984-0.885l-3.858-35.432c-0.06-0.545,0.334-1.035,0.878-1.094     c0.534-0.06,1.034,0.334,1.093,0.879l3.858,35.432c0.06,0.545-0.334,1.035-0.878,1.094     C207.215,168.293,207.179,168.295,207.143,168.295z"></path></g><g><path fill="#5F5371" d="M199.012,168.295c-0.484,0-0.908-0.356-0.98-0.85l-5.143-35.431c-0.078-0.543,0.297-1.046,0.838-1.125     c0.543-0.074,1.045,0.297,1.124,0.839l5.143,35.432c0.078,0.542-0.297,1.046-0.838,1.124     C199.108,168.292,199.06,168.295,199.012,168.295z"></path></g><g><path fill="#5F5371" d="M190.882,168.295c-0.47,0-0.887-0.335-0.974-0.815l-6.429-35.432c-0.098-0.539,0.259-1.056,0.798-1.154     c0.542-0.098,1.055,0.26,1.152,0.799l6.429,35.432c0.098,0.539-0.259,1.056-0.798,1.154     C191.001,168.29,190.941,168.295,190.882,168.295z"></path></g></g><g opacity="0.2"><polygon fill="#5F5371" points="290.967,115.782 289.057,125.69 173.996,125.69 172.087,115.782   "></polygon><path fill="#5F5371" d="M289.057,126.683H173.996c-0.475,0-0.883-0.337-0.973-0.804l-1.909-9.909    c-0.056-0.291,0.021-0.592,0.209-0.82c0.188-0.228,0.469-0.361,0.764-0.361h118.88c0.296,0,0.576,0.132,0.765,0.361    c0.188,0.229,0.264,0.529,0.208,0.82l-1.91,9.909C289.939,126.346,289.532,126.683,289.057,126.683z M174.814,124.698h113.424    l1.527-7.924H173.288L174.814,124.698z"></path></g><g opacity="0.2"><path fill="#5F5371" d="M237.495,117.453c0,1.648-0.888,3.247-2.438,4.076l-56.227,29.219l-1.825-9.451l53.717-27.909    c2.245-1.202,5.031-0.349,6.232,1.9C237.327,115.986,237.495,116.72,237.495,117.453z"></path><path fill="#5F5371" d="M178.831,151.742c-0.148,0-0.295-0.033-0.432-0.099c-0.281-0.137-0.482-0.397-0.542-0.706l-1.826-9.45    c-0.083-0.431,0.127-0.867,0.517-1.069l53.717-27.91c1.308-0.701,2.823-0.85,4.253-0.412c1.428,0.436,2.603,1.404,3.309,2.725    c0.437,0.816,0.658,1.702,0.658,2.633c0,2.076-1.135,3.973-2.961,4.952l-56.238,29.225    C179.144,151.705,178.987,151.742,178.831,151.742z M178.119,141.839l1.433,7.418l55.049-28.608    c1.169-0.627,1.903-1.853,1.903-3.195c0-0.6-0.142-1.171-0.423-1.696c-0.457-0.856-1.217-1.482-2.14-1.764    c-0.923-0.282-1.9-0.186-2.751,0.27L178.119,141.839z"></path></g><g><path fill="#FFDB98" d="M295.457,112.735h-127.86c-1.083,0-1.96,0.878-1.96,1.96v5.983c0,1.083,0.878,1.96,1.96,1.96h127.86    c1.083,0,1.96-0.878,1.96-1.96v-5.983C297.417,113.613,296.539,112.735,295.457,112.735z"></path><path fill="#5F5371" d="M295.458,124.127H167.595c-1.9,0-3.446-1.548-3.446-3.45v-5.98c0-1.902,1.546-3.45,3.446-3.45h127.863    c1.899,0,3.445,1.548,3.445,3.45v5.98C298.903,122.579,297.357,124.127,295.458,124.127z M167.595,114.224    c-0.26,0-0.472,0.212-0.472,0.473v5.98c0,0.261,0.212,0.473,0.472,0.473h127.863c0.26,0,0.471-0.212,0.471-0.473v-5.98    c0-0.261-0.211-0.473-0.471-0.473H167.595z"></path></g><g><path fill="#867B99" d="M167.74,148.225c-0.607,0.253-1.305-0.03-1.565-0.635l-2.686-6.261c-0.264-0.615,0.025-1.327,0.642-1.585    l66.068-27.549c2.336-1.005,5.043,0.077,6.047,2.416v0c1.003,2.339-0.077,5.05-2.413,6.055L167.74,148.225z"></path><path fill="#5F5371" d="M167.285,149.309c-0.852,0-1.666-0.5-2.021-1.328l-2.686-6.261c-0.233-0.542-0.239-1.143-0.017-1.689    c0.222-0.549,0.644-0.975,1.188-1.203l66.069-27.55c1.362-0.585,2.883-0.606,4.271-0.051c1.388,0.555,2.477,1.617,3.067,2.992    c0.59,1.374,0.61,2.897,0.056,4.287c-0.554,1.39-1.615,2.48-2.988,3.071l-66.103,27.564l0,0    C167.847,149.255,167.564,149.309,167.285,149.309z M167.74,148.225h0.01H167.74z M232.014,112.811    c-0.484,0-0.967,0.098-1.425,0.296l-66.078,27.553c-0.066,0.028-0.099,0.079-0.114,0.115c-0.015,0.038-0.027,0.095,0.002,0.162    l2.686,6.261c0.045,0.106,0.169,0.156,0.273,0.111l66.093-27.56c0.876-0.377,1.561-1.081,1.919-1.978    c0.357-0.898,0.345-1.88-0.037-2.768c-0.38-0.888-1.084-1.574-1.98-1.932C232.92,112.898,232.467,112.811,232.014,112.811z"></path></g><g><path fill="#BABAD5" d="M168.188,142.207c-0.194,0-0.378-0.114-0.457-0.305c-0.106-0.253,0.014-0.544,0.267-0.648l62.648-26.187    c0.251-0.105,0.543,0.014,0.648,0.267c0.106,0.252-0.014,0.543-0.267,0.649l-62.648,26.186    C168.316,142.194,168.252,142.207,168.188,142.207z"></path></g><g><path fill="#A1C083" d="M190.306,170.81c0.02,1.12-0.589,2.13-1.578,2.64c-0.35,0.18-0.549,0.56-0.509,0.95l0.15,1.17    c0.15,1.16-0.419,2.29-1.448,2.86c-1.029,0.58-2.277,0.47-3.196-0.27c-0.2-0.16-0.469-0.22-0.729-0.17s-0.479,0.21-0.609,0.45    l-0.709,1.32c-0.449,0.85-1.298,1.42-2.257,1.52c-0.959,0.11-1.898-0.27-2.527-1.01c-0.22-0.26-0.559-0.37-0.889-0.31    c-0.33,0.07-0.599,0.31-0.699,0.63l-0.04,0.11c-0.3,0.92-1.069,1.62-2.017,1.83c-0.949,0.2-1.938-0.11-2.587-0.83    c-0.19-0.2-0.479-0.29-0.749-0.21c-0.27,0.07-0.479,0.29-0.539,0.56l-0.14,0.67c-0.2,0.94-0.889,1.71-1.808,2    c-0.919,0.28-1.928,0.05-2.637-0.61c-0.15-0.14-0.36-0.2-0.549-0.15c-0.2,0.05-0.37,0.19-0.439,0.38    c-0.4,0.98-1.358,1.63-2.417,1.63h-0.08c-1.089-0.04-2.047-0.75-2.387-1.79l-0.09-0.27c-0.13-0.39-0.429-0.71-0.819-0.86    c-0.379-0.15-0.819-0.12-1.178,0.08c-1.009,0.56-2.207,0.57-3.216,0.03c-1.009-0.55-1.668-1.56-1.758-2.7    c-0.02-0.23-0.17-0.42-0.38-0.5c-0.22-0.07-0.459-0.01-0.609,0.16c-0.549,0.6-1.358,0.91-2.167,0.82    c-0.809-0.08-1.538-0.56-1.938-1.26l-0.27-0.47c-0.26-0.44-0.689-0.75-1.178-0.85c-0.499-0.1-1.019,0.02-1.418,0.34    c-0.699,0.54-1.598,0.78-2.477,0.64c-0.879-0.13-1.668-0.62-2.177-1.35c-0.34-0.48-0.959-0.66-1.498-0.46l-0.459,0.18    c-1.288,0.5-2.716,0.1-3.565-0.99c-0.839-1.09-0.879-2.58-0.08-3.7c0.19-0.26,0.25-0.59,0.18-0.89    c-0.27-1.25,0.22-2.52,1.268-3.25c1.049-0.73,2.417-0.75,3.485-0.05c0.34,0.22,0.759,0.28,1.148,0.14    c0.39-0.13,0.689-0.43,0.829-0.82l0.03-0.1c0.419-1.22,1.418-2.15,2.677-2.48c1.248-0.32,2.577,0,3.535,0.86    c0.419,0.37,0.979,0.53,1.528,0.46c0.559-0.09,1.039-0.41,1.328-0.89l0.08-0.13c0.659-1.1,1.808-1.83,3.086-1.95    c1.278-0.12,2.547,0.38,3.406,1.34c0.36,0.4,0.889,0.61,1.428,0.55c0.539-0.05,1.019-0.36,1.298-0.83    c0.529-0.91,1.438-1.51,2.487-1.66c1.049-0.14,2.087,0.2,2.846,0.93c0.32,0.31,0.779,0.46,1.218,0.39    c0.449-0.07,0.839-0.34,1.049-0.74l0.14-0.25c0.559-1.02,1.578-1.71,2.727-1.86c1.158-0.14,2.327,0.28,3.116,1.14    c0.39,0.42,0.979,0.61,1.538,0.49c0.559-0.12,1.019-0.53,1.208-1.06c0.459-1.31,1.508-2.21,2.776-2.43    c1.258-0.22,2.557,0.25,3.376,1.24c0.41,0.49,1.059,0.69,1.668,0.51c1.408-0.41,2.916-0.02,3.945,1.03    c1.029,1.04,1.398,2.56,0.959,3.96c-0.19,0.61,0.09,1.27,0.659,1.54C189.657,168.7,190.296,169.69,190.306,170.81z"></path></g><g><path fill="#CCDBB0" d="M180.313,171.975c-0.274,0-0.496-0.222-0.496-0.496c0-0.763-0.619-1.383-1.38-1.383    c-0.761,0-1.381,0.62-1.381,1.383c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-0.763-0.62-1.383-1.381-1.383s-1.381,0.62-1.381,1.383c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496    c0-0.763-0.62-1.383-1.381-1.383c-0.761,0-1.38,0.62-1.38,1.383c0,0.274-0.222,0.496-0.496,0.496    c-0.274,0-0.496-0.222-0.496-0.496c0-1.309,1.064-2.376,2.372-2.376c0.763,0,1.442,0.363,1.876,0.924    c0.434-0.561,1.114-0.924,1.877-0.924s1.442,0.363,1.877,0.924c0.434-0.561,1.114-0.924,1.877-0.924    c1.308,0,2.372,1.066,2.372,2.376C180.808,171.753,180.587,171.975,180.313,171.975z"></path></g><g><g><path fill="#CCDBB0" d="M153.165,174.262c-0.274,0-0.496-0.222-0.496-0.496c0-0.763-0.62-1.383-1.381-1.383     c-0.761,0-1.381,0.62-1.381,1.383c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496     c0-0.763-0.62-1.383-1.381-1.383s-1.381,0.62-1.381,1.383c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496     c0-1.309,1.064-2.376,2.372-2.376c0.763,0,1.442,0.363,1.877,0.924c0.434-0.561,1.114-0.924,1.876-0.924     c1.308,0,2.372,1.066,2.372,2.376C153.66,174.04,153.438,174.262,153.165,174.262z"></path></g></g><g><g><path fill="#CCDBB0" d="M165.326,178.191c-0.274,0-0.496-0.222-0.496-0.496c0-0.762-0.62-1.382-1.381-1.382     s-1.381,0.62-1.381,1.382c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496c0-1.309,1.064-2.375,2.372-2.375     s2.372,1.065,2.372,2.375C165.822,177.969,165.6,178.191,165.326,178.191z"></path></g></g><g><g><path fill="#A1C083" d="M187.959,234.715c1.688,2.005,3.26,7.089,2.492,9.787c-1.065,3.739-6.827,5.926-10.306,5.358     c1.222-4.025-2.151-5.763-1.238-9.896C179.709,236.335,184.268,233.785,187.959,234.715"></path></g><g><g><path fill="#5F5371" d="M187.103,235.216c1.791,2.326,3.552,6.959,2.066,9.811c-1.551,2.975-5.942,4.218-9.024,3.841      c0.319,0.419,0.637,0.838,0.956,1.256c0.732-2.962-0.657-4.768-1.221-7.561c-0.903-4.466,3.735-7.699,7.817-6.891      c1.246,0.247,1.78-1.666,0.527-1.914c-3.688-0.73-7.782,0.869-9.625,4.266c-0.843,1.555-1.013,3.355-0.63,5.067      c0.518,2.32,1.835,4.021,1.221,6.506c-0.169,0.686,0.315,1.178,0.956,1.256c3.838,0.468,8.773-1.303,10.736-4.825      c1.927-3.457,0.176-8.903-2.066-11.814C188.047,233.216,186.324,234.204,187.103,235.216L187.103,235.216z"></path></g></g></g><g><g><path fill="#A1C083" d="M180.057,220.546c1.743,4.168,5.596,3.607,8.126,2.402c3.506-1.67,5.74-8.43,4.605-11.772     c-3.762,1.873-6.197-0.753-10.116,0.833C179.23,213.401,178.531,217.055,180.057,220.546z"></path></g><g><g><path fill="#5F5371" d="M179.201,221.047c1.965,4.137,6.843,4.823,10.432,2.161c3.4-2.521,5.27-8.249,4.111-12.296      c-0.193-0.675-0.874-0.844-1.456-0.593c-3.786,1.633-7.829-1.07-11.48,1.611c-2.87,2.108-2.916,5.828-1.706,8.88      c0.465,1.173,2.383,0.662,1.912-0.528c-1.52-3.834-0.162-7.814,4.531-7.817c2.853-0.002,4.983,0.758,7.745-0.433      c-0.485-0.198-0.971-0.395-1.456-0.593c0.872,3.046-0.432,7.086-2.528,9.381c-2.493,2.729-6.723,2.736-8.391-0.776      C180.365,218.892,178.656,219.898,179.201,221.047z"></path></g></g></g><g><g><path fill="#A1C083" d="M179.259,220.721c-1.201-3.747-1.213-7.374-4.585-9.978c-3.347-2.585-6.644-1.61-9.42,1.477     c0.908,0.727,1.915,1.021,2.687,1.971c1.083,1.334,1.263,3.088,2.498,4.364C172.501,220.684,176.651,219.697,179.259,220.721"></path></g><g><g><path fill="#5F5371" d="M180.215,220.457c-1.161-3.83-1.588-8.007-5.04-10.571c-3.724-2.766-7.634-1.485-10.622,1.632      c-0.472,0.493-0.322,1.188,0.201,1.559c1.728,1.226,2.745,2.25,3.669,4.146c0.574,1.178,1.274,2.232,2.444,2.886      c2.467,1.38,5.518,0.702,8.129,1.568c1.214,0.403,1.734-1.514,0.527-1.914c-2.534-0.841-6.389,0.067-8.382-1.91      c-1.142-1.132-1.353-2.917-2.343-4.163c-0.821-1.033-1.985-1.576-3.043-2.327c0.067,0.52,0.134,1.039,0.201,1.559      c3.066-3.199,7.182-3.56,9.833,0.453c1.47,2.224,1.755,5.103,2.515,7.61C178.673,222.204,180.587,221.685,180.215,220.457      L180.215,220.457z"></path></g></g></g><g><g><path fill="#A1C083" d="M199.67,238.216c-1.802-5.577,5.416-9.502,9.587-5.39c0.933,0.92,1.744,2.026,2.382,3.431     c2.334,5.139,0.066,9.13-4.783,11.8c-0.667-1.401-5.36-6.676-6.638-8.671C199.981,239.016,199.802,238.625,199.67,238.216z"></path></g><g><g><path fill="#5F5371" d="M200.626,237.952c-0.644-2.394,0.437-4.655,2.803-5.53c2.32-0.858,4.463,0.182,5.929,2.01      c1.583,1.975,2.676,4.737,2.018,7.28c-0.661,2.555-2.848,4.235-5.02,5.488c0.452,0.119,0.904,0.237,1.356,0.356      C205.851,244.092,202.067,241.632,200.626,237.952c-0.46-1.176-2.378-0.664-1.912,0.528c1.524,3.894,5.329,6.436,7.287,10.078      c0.255,0.474,0.905,0.617,1.356,0.356c2.897-1.672,5.552-4.047,6.091-7.514c0.548-3.527-1.296-7.563-4.049-9.763      c-4.994-3.992-12.354,0.645-10.686,6.843C199.046,239.712,200.959,239.189,200.626,237.952z"></path></g></g></g><g><path fill="#A1C083" d="M240.978,243.486c-0.399,0-0.774-0.242-0.925-0.637c-0.746-1.949-1.723-3.811-2.826-5.385    c-13.758-19.656-24.66-12.007-34.279-5.258c-5.185,3.637-10.082,7.073-14.682,5.307c-4.669-1.792-8.115-8.496-11.175-21.735    c-0.123-0.534,0.209-1.067,0.742-1.191c0.534-0.125,1.065,0.209,1.189,0.743c2.817,12.191,6.073,18.84,9.954,20.329    c3.617,1.386,7.888-1.61,12.834-5.08c9.866-6.923,22.143-15.535,37.041,5.745c1.193,1.705,2.249,3.715,3.052,5.814    c0.197,0.512-0.059,1.087-0.57,1.282C241.216,243.465,241.096,243.486,240.978,243.486z"></path></g><g><g><path fill="#CCDBB0" d="M224.397,223.853c2.632,1.038,6.11,0.843,8.082-1.941c2.083-2.941-1.976-8.407-2.73-11.513     c-0.859,3.582-5.214,2.345-6.877,4.888C221.378,217.573,223.243,221.792,224.397,223.853"></path></g><g><g><path fill="#5F5371" d="M224.134,224.81c3.371,1.188,8.259,0.568,9.648-3.305c1.369-3.817-2.095-7.878-3.077-11.37      c-0.271-0.964-1.621-0.922-1.912,0c-0.932,2.956-5.418,2.138-6.912,4.91c-1.554,2.884,0.26,6.729,1.66,9.309      c0.609,1.123,2.322,0.122,1.712-1.002c-0.79-1.456-1.518-3.004-1.816-4.647c-0.45-2.478,0.561-3.543,2.731-4.293      c2.158-0.746,3.8-1.414,4.536-3.75c-0.637,0-1.274,0-1.912,0c0.743,2.641,2.368,4.952,3.038,7.617      c1.131,4.505-3.697,5.84-7.17,4.616C223.455,222.471,222.936,224.388,224.134,224.81L224.134,224.81z"></path></g></g></g><g><path fill="#CCDBB0" d="M180.434,221.329c1.463,3.175,0.728,14.885-12.953,4.557C172.506,224.938,175.841,211.6,180.434,221.329z"></path><path fill="#5F5371" d="M176.481,231.067c-2.515,0-5.726-1.466-9.597-4.387c-0.313-0.237-0.458-0.636-0.368-1.019    c0.09-0.383,0.396-0.677,0.781-0.749c1.5-0.283,3.067-2.257,4.449-3.998c1.772-2.232,3.434-4.329,5.577-4.093    c1.5,0.174,2.774,1.471,4.008,4.085c0.001,0.003,0.002,0.006,0.003,0.009c0.91,1.972,1.158,6.823-1.612,9.059    C178.818,230.702,177.736,231.067,176.481,231.067z M169.477,226.104c4.153,2.852,7.319,3.68,9.001,2.323    c1.839-1.486,1.729-5.218,1.058-6.678c-1.163-2.461-2.028-2.909-2.44-2.956c-1.054-0.123-2.504,1.726-3.797,3.356    C172.105,223.651,170.884,225.19,169.477,226.104z"></path></g><g><path fill="#5F5371" d="M184.872,231.056c-0.55,0-1.113-0.111-1.645-0.244c-0.265-0.068-0.426-0.337-0.36-0.603    s0.334-0.426,0.602-0.361c0.941,0.238,1.993,0.397,2.655-0.217c0.011-0.01,0.022-0.024,0.033-0.041    c-0.197-0.072-0.378-0.171-0.528-0.304c-0.317-0.282-0.453-0.686-0.383-1.138c0.024-0.154,0.119-0.289,0.257-0.363    c0.549-0.293,1.1-0.179,1.439,0.298c0.13,0.183,0.222,0.42,0.269,0.677c0.351,0.007,0.698-0.041,0.949-0.11    c0.146-0.04,0.362-0.168,0.572-0.329c-0.265-0.157-0.393-0.367-0.449-0.492c-0.18-0.399-0.088-0.888,0.224-1.189    c0.303-0.293,0.742-0.35,1.149-0.149c0.531,0.264,0.684,0.636,0.714,0.919c0.985-0.269,1.572-0.946,1.605-1.891    c0.01-0.274,0.264-0.484,0.513-0.479c0.273,0.01,0.487,0.239,0.478,0.514c-0.056,1.613-1.196,2.726-2.989,2.941    c-0.459,0.576-1.195,1.015-1.553,1.114c-0.237,0.064-0.739,0.144-1.259,0.144c-0.072,0.235-0.192,0.448-0.365,0.608    C186.235,230.882,185.564,231.056,184.872,231.056z M189.214,227.38c-0.002,0.055,0.053,0.105,0.166,0.131    C189.363,227.462,189.283,227.414,189.214,227.38z"></path></g><g><path fill="#CCDBB0" d="M203.634,231.98c2.753,0.315,3.773-1.049,3.995-2.99c0.232-2.027-2.559-2.859-2.98-5.681    C199.47,225.491,197.856,231.215,203.634,231.98z"></path><path fill="#5F5371" d="M204.372,233.017c-0.272,0-0.556-0.017-0.851-0.051c-0.005,0-0.011-0.001-0.017-0.002    c-3.676-0.487-4.362-2.698-4.486-3.627c-0.348-2.596,1.859-5.515,5.246-6.942c0.283-0.118,0.603-0.101,0.87,0.049    c0.267,0.15,0.449,0.416,0.494,0.718c0.169,1.128,0.82,1.864,1.51,2.641c0.769,0.868,1.641,1.851,1.475,3.299    C208.322,231.65,206.827,233.017,204.372,233.017z M203.755,230.995c2.167,0.241,2.724-0.669,2.889-2.119    c0.062-0.54-0.316-0.995-0.988-1.754c-0.56-0.633-1.221-1.377-1.638-2.393c-2.12,1.229-3.206,3.071-3.035,4.344    C201.167,230.446,202.794,230.866,203.755,230.995z"></path></g><g><path fill="#CCDBB0" d="M176.563,215.576c1.95,4.661,5.814,2.257,7.664-0.117c2.024-2.597-0.67-5.724,2.263-8.595    C182.897,204.204,174.839,209.279,176.563,215.576z"></path><path fill="#5F5371" d="M179.712,219.228c-0.168,0-0.337-0.011-0.505-0.033c-1.066-0.142-2.548-0.82-3.558-3.236    c-0.016-0.039-0.03-0.079-0.042-0.12c-0.91-3.327,0.567-6.892,3.762-9.084c2.682-1.838,5.782-2.116,7.71-0.687    c0.233,0.173,0.379,0.439,0.399,0.73c0.02,0.29-0.088,0.574-0.296,0.777c-1.281,1.254-1.225,2.544-1.159,4.039    c0.061,1.4,0.131,2.986-1.015,4.457C183.833,217.578,181.792,219.228,179.712,219.228z M177.502,215.252    c0.516,1.205,1.178,1.87,1.967,1.975c1.327,0.171,2.986-1.109,3.975-2.379c0.697-0.894,0.653-1.889,0.598-3.148    c-0.058-1.328-0.128-2.92,0.873-4.475c-1.249-0.285-2.919,0.132-4.426,1.167C178.523,209.742,176.714,212.248,177.502,215.252z"></path></g><g><path fill="#CCDBB0" d="M186.581,235.813c1.106,2.73,3.441,2.827,4.551,2.045c2.189-1.543,3.655-5.503,2.83-7.265    C191.927,231.625,185.282,230.624,186.581,235.813z"></path><path fill="#5F5371" d="M189.711,239.276c-0.363,0-0.733-0.052-1.094-0.159c-1.294-0.381-2.344-1.422-2.955-2.931    c-0.017-0.043-0.031-0.087-0.043-0.132c-0.359-1.435-0.223-2.637,0.404-3.576c1.125-1.685,3.492-2.035,5.393-2.316    c0.833-0.123,1.694-0.25,2.098-0.456c0.24-0.121,0.516-0.142,0.771-0.052c0.253,0.087,0.461,0.273,0.575,0.517    c1.053,2.247-0.598,6.694-3.156,8.498C191.137,239.069,190.436,239.276,189.711,239.276z M187.525,235.504    c0.385,0.914,0.955,1.504,1.651,1.71c0.599,0.176,1.12,0.02,1.386-0.167c1.527-1.078,2.636-3.607,2.652-5.175    c-0.457,0.1-0.964,0.174-1.509,0.255c-1.514,0.224-3.399,0.502-4.035,1.455C187.372,234.03,187.324,234.659,187.525,235.504z"></path></g><g><path fill="#A1C083" d="M224.141,223.84c4.14-6.246-3.684-4.507-6.639-6.165C216.93,224.813,221.906,227.371,224.141,223.84z"></path><path fill="#5F5371" d="M221.608,226.409c-0.394,0-0.797-0.066-1.198-0.2c-2.223-0.744-4.29-3.697-3.895-8.615    c0.027-0.337,0.224-0.637,0.521-0.797c0.299-0.158,0.658-0.154,0.951,0.011c0.718,0.402,1.949,0.584,3.138,0.76    c2.081,0.307,4.233,0.625,4.965,2.271c0.518,1.163,0.163,2.606-1.117,4.541C224.139,225.691,222.915,226.409,221.608,226.409z     M218.452,219.092c0.079,3.018,1.321,4.811,2.587,5.234c0.849,0.285,1.677-0.086,2.266-1.018c0.004-0.006,0.008-0.012,0.011-0.017    c1.156-1.744,1.059-2.43,0.964-2.643c-0.289-0.649-2.038-0.908-3.444-1.116C220.028,219.413,219.204,219.292,218.452,219.092z"></path></g><g><path fill="#5F5371" d="M211.459,225.383c-0.057,0-0.115-0.01-0.171-0.03c-0.257-0.095-0.389-0.38-0.294-0.638    c0.2-0.545,0.232-1.085,0.17-1.548c-0.174,0.059-0.346,0.096-0.509,0.112c-0.615,0.053-1.139-0.161-1.372-0.578    c-0.101-0.181-0.285-0.673,0.197-1.309c0.411-0.545,1.002-0.699,1.537-0.406c0.224,0.123,0.428,0.321,0.6,0.574    c0.055-0.098,0.104-0.208,0.145-0.334c0.04-0.122,0.067-0.303,0.076-0.506c-0.478,0.15-0.845,0.053-1.088-0.075    c-0.577-0.304-0.853-1.048-0.616-1.657c0.168-0.433,0.66-0.858,1.493-0.642c0.362,0.095,0.663,0.343,0.87,0.718    c0.22-0.235,0.464-0.539,0.729-0.929c0.155-0.226,0.463-0.283,0.689-0.13c0.226,0.155,0.285,0.463,0.13,0.69    c-0.449,0.658-0.862,1.122-1.235,1.444c0.058,0.547-0.002,1.08-0.105,1.394c-0.147,0.451-0.374,0.803-0.639,1.068    c0.181,0.736,0.168,1.614-0.141,2.456C211.85,225.259,211.661,225.383,211.459,225.383z M210.472,221.834    c-0.046,0-0.107,0.033-0.201,0.157c-0.102,0.136-0.12,0.219-0.118,0.237c0.021,0.02,0.19,0.1,0.484,0.052    c0.05-0.009,0.13-0.026,0.226-0.062c-0.101-0.176-0.213-0.302-0.321-0.362C210.521,221.846,210.499,221.834,210.472,221.834z     M211.2,219.278c-0.066,0-0.122,0.017-0.142,0.069c-0.049,0.126,0.013,0.344,0.154,0.42c0.091,0.047,0.257,0.047,0.489-0.065    c-0.02-0.054-0.043-0.105-0.069-0.151c-0.112-0.206-0.222-0.236-0.257-0.245C211.318,219.291,211.255,219.278,211.2,219.278z"></path></g><g><path fill="#5F5371" d="M225.847,233.196c-0.157,0-0.32-0.006-0.488-0.019c-0.273-0.02-0.477-0.26-0.456-0.533    c0.021-0.272,0.247-0.5,0.532-0.456c1.046,0.076,1.731-0.143,2.177-0.427c-0.277-0.142-0.498-0.33-0.626-0.552    c-0.153-0.268-0.395-0.971,0.68-1.697c0.712-0.48,1.198-0.204,1.375-0.062c0.407,0.328,0.525,0.971,0.313,1.638    c0.43-0.038,0.836-0.179,1.06-0.448c0.246-0.296,0.252-0.747,0.018-1.342c-0.1-0.255,0.025-0.544,0.28-0.644    c0.253-0.103,0.542,0.024,0.643,0.279c0.508,1.29,0.182,2.363-0.872,2.87c-0.503,0.242-1.122,0.324-1.71,0.273    C228.195,232.707,227.236,233.196,225.847,233.196z M228.423,230.227c-0.007,0.01-0.077,0.022-0.203,0.107    c-0.298,0.202-0.374,0.345-0.377,0.379c0.014,0.04,0.159,0.175,0.485,0.276c0.001-0.004,0.003-0.007,0.005-0.011    C228.515,230.597,228.473,230.297,228.423,230.227z"></path></g><g><g><path fill="#867B99" d="M266.27,234.708c-0.052,0-0.105-0.004-0.158-0.013c-0.54-0.086-0.908-0.595-0.822-1.137     c1.493-9.346-2.09-21.963-2.127-22.089c-0.152-0.527,0.152-1.077,0.678-1.229c0.534-0.151,1.076,0.153,1.227,0.678     c0.154,0.534,3.741,13.174,2.179,22.953C267.171,234.36,266.75,234.708,266.27,234.708z"></path></g><g><path fill="#A1C083" d="M267.923,235.154c-0.086,0-0.172-0.011-0.259-0.034c-0.529-0.143-0.841-0.688-0.699-1.217     c2.546-9.447,5.206-17.401,5.232-17.481c0.175-0.52,0.738-0.798,1.256-0.625c0.519,0.174,0.799,0.738,0.624,1.257     c-0.027,0.079-2.669,7.979-5.197,17.366C268.759,234.862,268.359,235.154,267.923,235.154z"></path></g><g><path fill="#A1C083" d="M267.418,233.473c-0.387,0-0.756-0.23-0.915-0.61c-0.351-0.844-3.591-7.636-6.698-11.138     c-0.363-0.41-0.326-1.037,0.083-1.402c0.409-0.363,1.034-0.328,1.4,0.083c3.332,3.757,6.657,10.764,7.044,11.69     c0.211,0.506-0.028,1.088-0.532,1.299C267.676,233.449,267.546,233.473,267.418,233.473z"></path></g></g><g><g><path fill="#A1C083" d="M266.458,259.56c-0.769,0.89-2.017,1.18-3.096,0.72c-0.18-0.07-0.38-0.08-0.549-0.01     c-0.18,0.08-0.32,0.22-0.389,0.39l-0.459,1.11c-0.419,1.02-1.398,1.7-2.497,1.76c-1.069,0.05-2.127-0.54-2.637-1.51     c-0.3-0.57-1.228-0.56-1.518,0l-0.15,0.26c-0.459,0.88-1.408,1.45-2.397,1.39c-0.989-0.04-1.898-0.65-2.297-1.56     c-0.09-0.2-0.27-0.34-0.489-0.37c-0.22-0.03-0.429,0.05-0.569,0.21l-0.729,0.87c-0.629,0.74-1.618,1.08-2.567,0.88     c-0.949-0.2-1.718-0.91-1.997-1.84c-0.07-0.26-0.29-0.44-0.549-0.48c-0.25-0.03-0.509,0.09-0.649,0.31l-0.719,1.16     c-0.539,0.87-1.488,1.4-2.507,1.4c-0.04,0-0.09,0-0.14-0.01c-1.059-0.05-2.017-0.67-2.497-1.63c-0.15-0.3-0.449-0.5-0.789-0.52     c-0.33-0.03-0.659,0.12-0.859,0.4c-0.529,0.75-1.408,1.15-2.287,1.08c-0.889-0.07-1.678-0.61-2.067-1.41     c-0.08-0.17-0.24-0.27-0.419-0.27c-0.2,0.03-0.35,0.09-0.429,0.26c-0.429,0.82-1.258,1.32-2.187,1.32c0,0-0.01,0-0.02,0     c-0.929,0-1.768-0.53-2.177-1.36l-0.28-0.56c-0.12-0.25-0.38-0.42-0.659-0.45c-0.28-0.02-0.549,0.11-0.709,0.34     c-0.619,0.88-1.698,1.33-2.756,1.14c-1.059-0.19-1.928-0.98-2.207-2.02c-0.1-0.39-0.439-0.58-0.759-0.5     c-1.158,0.3-2.357-0.22-2.936-1.27c-0.569-1.04-0.37-2.34,0.499-3.15l0.839-0.78c0.29-0.27,0.399-0.7,0.27-1.08l-0.679-2.11     c-0.35-1.08-0.08-2.25,0.719-3.05c0.789-0.81,1.957-1.11,3.036-0.78l0.949,0.3c0.34,0.1,0.699,0.03,0.979-0.21     c0.27-0.23,0.4-0.57,0.35-0.93l-0.15-1.05c-0.15-1.1,0.31-2.19,1.198-2.85c0.889-0.65,2.057-0.77,3.056-0.31l0.939,0.43     c0.29,0.13,0.629,0.12,0.909-0.02c0.28-0.15,0.489-0.43,0.539-0.74l0.25-1.37c0.18-1,0.839-1.84,1.778-2.24     c0.929-0.4,1.997-0.31,2.846,0.25l1.878,1.23c0.28,0.18,0.629,0.22,0.929,0.11c0.31-0.11,0.549-0.37,0.639-0.68l0.34-1.16     c0.3-1.03,1.129-1.83,2.157-2.09c1.039-0.26,2.147,0.06,2.896,0.82c0.24,0.25,0.579,0.36,0.909,0.31     c0.34-0.06,0.619-0.27,0.769-0.57l0.23-0.47c0.439-0.9,1.298-1.52,2.287-1.66c0.999-0.14,1.997,0.22,2.667,0.97l0.09,0.09     c0.23,0.27,0.599,0.39,0.949,0.33c0.35-0.06,0.639-0.3,0.769-0.63c0.419-1.05,1.368-1.77,2.487-1.89     c1.109-0.12,2.197,0.39,2.816,1.32l0.499,0.74c0.15,0.23,0.4,0.39,0.669,0.44c0.27,0.05,0.559-0.01,0.779-0.17l1.448-1.01     c0.929-0.65,2.137-0.73,3.136-0.19c1.009,0.53,1.628,1.57,1.608,2.7l-0.03,3.16l-0.419,11.38c-0.01,0.2,0.05,0.4,0.15,0.58     l2.227,3.63C267.327,257.4,267.217,258.67,266.458,259.56z"></path></g><g><path fill="#A1C083" d="M343.009,231.83l-2.517,23.93c-0.18,1.73-1.568,3.1-3.296,3.26l-3.785,0.35     c-0.439,0.04-0.839,0.24-1.119,0.58l-1.508,1.77c-0.619,0.71-1.538,1.08-2.477,0.98c-0.949-0.1-1.778-0.65-2.227-1.49     c-0.15-0.28-0.439-0.45-0.759-0.46c-0.31,0.02-0.609,0.16-0.769,0.43c-0.629,1.06-1.738,1.72-2.966,1.77     c-1.218,0.05-2.387-0.52-3.096-1.53l-0.18-0.25c-0.32-0.45-0.839-0.71-1.378-0.67c-0.539,0.03-1.029,0.33-1.298,0.8     c-0.629,1.1-1.798,1.8-3.056,1.81h-0.05c-1.238,0-2.407-0.65-3.056-1.72l-0.22-0.37c-0.3-0.5-0.849-0.81-1.428-0.81     c-0.01,0-0.01,0-0.02,0c-0.579,0.01-1.129,0.33-1.418,0.83l-0.14,0.23c-0.579,1.02-1.698,1.59-2.826,1.59     c-1.168-0.03-2.217-0.69-2.746-1.73c-0.2-0.38-0.589-0.63-1.009-0.65c-0.449-0.03-0.839,0.19-1.069,0.55l-0.1,0.17     c-0.709,1.11-1.977,1.75-3.286,1.68c-1.308-0.07-2.487-0.85-3.066-2.04l-3.056-6.22c-0.36-0.72-0.459-1.56-0.3-2.36l3.376-16.1     l0.969-5.74c0.18-1.07,0.929-1.95,1.967-2.29c1.029-0.33,2.157-0.07,2.936,0.69c0.24,0.24,0.589,0.33,0.909,0.23     c0.32-0.09,0.569-0.36,0.639-0.68l0.29-1.28c0.25-1.15,1.059-2.11,2.147-2.57c1.099-0.45,2.347-0.35,3.346,0.28     c0.439,0.27,0.879,0.3,1.268,0.13c0.389-0.18,0.659-0.53,0.729-0.95c0.21-1.19,1.049-2.16,2.187-2.54     c1.138-0.38,2.397-0.09,3.266,0.74c0.31,0.29,0.729,0.42,1.149,0.34c0.409-0.08,0.759-0.36,0.939-0.74l0.419-0.94     c0.549-1.22,1.758-2,3.086-2c0,0,0.01,0,0.02,0c1.328,0.01,2.537,0.81,3.076,2.04c0.19,0.43,0.589,0.74,1.059,0.82     c0.469,0.07,0.939-0.1,1.258-0.45l0.14-0.16c0.829-0.93,2.167-1.26,3.336-0.82c1.169,0.45,1.947,1.58,1.947,2.83     c0,0.39,0.21,0.74,0.549,0.92c0.35,0.18,0.759,0.16,1.079-0.06c0.969-0.66,2.257-0.71,3.276-0.13     c1.019,0.59,1.628,1.73,1.548,2.91c-0.03,0.38,0.12,0.74,0.389,1c0.28,0.26,0.659,0.39,1.039,0.33l1.758-0.24     c1.119-0.16,2.227,0.21,3.036,0.99C342.73,229.61,343.129,230.71,343.009,231.83z"></path></g><g><path fill="#A1C083" d="M387.332,201.5c-0.02,0.32,0.11,0.63,0.37,0.83c0.669,0.54,1.039,1.37,1.009,2.22     c-0.04,0.86-0.489,1.65-1.198,2.13c-0.21,0.13-0.32,0.35-0.32,0.6c0.01,0.24,0.14,0.46,0.34,0.58     c0.879,0.53,1.428,1.45,1.458,2.48c0.03,1.02-0.449,1.98-1.298,2.56l-0.14,0.1c-0.19,0.13-0.3,0.35-0.29,0.58     c0.01,0.23,0.15,0.44,0.35,0.55c0.829,0.45,1.358,1.32,1.388,2.27c0.01,0.95-0.479,1.85-1.298,2.33l-0.2,0.12     c-0.429,0.26-0.709,0.71-0.749,1.21c-0.05,0.51,0.16,1,0.549,1.32c0.929,0.78,1.388,1.96,1.238,3.16     c-0.15,1.2-0.889,2.23-1.977,2.75l-0.34,0.16c-0.13,0.06-0.23,0.19-0.24,0.34c-0.02,0.14,0.03,0.29,0.15,0.39     c0.699,0.59,0.999,1.51,0.789,2.4c-0.22,0.9-0.899,1.58-1.798,1.8l-3.376,0.81c-0.27,0.06-0.559,0.09-0.849,0.09     c-0.29,0-0.579-0.03-0.859-0.1l-39.569-9.69c-1.109-0.27-2.007-1.03-2.467-2.07l-1.149-2.6c-0.499-1.12-0.33-2.4,0.449-3.35     c0.779-0.95,1.997-1.37,3.196-1.1c0.35,0.08,0.729-0.04,0.969-0.3c0.25-0.27,0.34-0.65,0.23-1c-0.34-1.1-0.04-2.27,0.799-3.06     c0.829-0.8,2.007-1.05,3.096-0.65c0.32,0.11,0.669,0.08,0.959-0.1c0.3-0.17,0.489-0.47,0.539-0.81l0.13-0.98     c0.15-1.12,0.909-2.05,1.977-2.42c1.079-0.37,2.247-0.11,3.056,0.68c0.26,0.25,0.639,0.34,0.979,0.24     c0.35-0.1,0.609-0.38,0.699-0.73l0.23-1.01c0.25-1.08,1.109-1.93,2.187-2.17s2.217,0.16,2.906,1.03     c0.22,0.27,0.569,0.4,0.909,0.32c0.34-0.07,0.619-0.34,0.699-0.68l0.16-0.68c0.28-1.13,1.149-2.03,2.277-2.33     c1.139-0.3,2.337,0.05,3.136,0.9c0.15,0.15,0.38,0.22,0.579,0.17c0.22-0.05,0.39-0.22,0.449-0.43     c0.26-0.94,1.029-1.64,1.987-1.83c0.959-0.19,1.928,0.17,2.537,0.93l1.039,1.32c0.03,0.04,0.08,0.05,0.12,0.03     c0.04-0.01,0.07-0.06,0.07-0.1c-0.05-0.58,0.15-1.15,0.549-1.58c0.399-0.43,0.949-0.67,1.528-0.67c0.26,0,0.459-0.13,0.559-0.33     c0.1-0.2,0.07-0.44-0.07-0.62c-0.549-0.7-0.679-1.64-0.33-2.47c0.35-0.82,1.109-1.39,1.997-1.48c0.17-0.02,0.32-0.13,0.38-0.29     c0.07-0.16,0.04-0.34-0.06-0.47c-0.599-0.76-0.699-1.81-0.25-2.66c0.439-0.86,1.308-1.39,2.317-1.34     c0.19,0.02,0.37-0.07,0.499-0.21c0.12-0.14,0.18-0.33,0.15-0.52l-0.02-0.15c-0.16-1,0.28-2.02,1.129-2.59     c0.849-0.57,1.957-0.6,2.826-0.07c0.21,0.13,0.469,0.13,0.669,0c1.009-0.6,2.317-0.47,3.176,0.33     c0.859,0.8,1.089,2.09,0.559,3.14c-0.2,0.4-0.11,0.89,0.22,1.2l0.1,0.09c0.709,0.65,1.069,1.61,0.959,2.57     c-0.11,0.96-0.679,1.82-1.518,2.29c-0.2,0.12-0.32,0.32-0.34,0.55c-0.01,0.23,0.1,0.44,0.28,0.57     c0.749,0.53,1.178,1.42,1.119,2.33c-0.05,0.92-0.569,1.73-1.378,2.17l-0.429,0.24C387.552,200.89,387.362,201.17,387.332,201.5z"></path></g><g><g><path fill="#A1C083" d="M280.521,239.062c-13.422,1.879-15.422,16.869-7.961,26.433c4.036-1.842,7.704-6.65,9.946-10.611      C284.557,251.259,284.51,241.506,280.521,239.062"></path></g><g><g><path fill="#5F5371" d="M280.258,238.105c-5.995,0.948-10.886,4.774-12.441,10.774c-1.537,5.93,0.254,12.317,3.887,17.117       c0.341,0.451,0.827,0.619,1.356,0.356c5.18-2.573,10.467-8.779,11.473-14.592c0.755-4.368,0.527-10.768-3.511-13.555       c-1.053-0.727-2.046,0.993-1.001,1.714c3.423,2.362,3.25,8.796,2.39,12.354c-1.184,4.893-5.936,10.171-10.351,12.365       c0.452,0.119,0.904,0.237,1.356,0.356c-6.768-8.941-5.258-22.978,7.369-24.975       C282.041,239.821,281.508,237.908,280.258,238.105L280.258,238.105z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M283.657,240.283c-3.966-5.032-6.817-10.511-13.929-9.376c-7.381,1.177-9.307,6.583-11.873,12.779      c4.414-2.358,8.694,0.61,13.111,0.936c3.4,0.251,11.247-1.034,12.476-4.924"></path></g><g><g><path fill="#5F5371" d="M284.358,239.581c-4.152-5.331-7.961-11.095-15.613-9.5c-6.865,1.431-9.418,7.463-11.845,13.34       c-0.367,0.89,0.774,1.439,1.456,1.121c3.661-1.706,7.143,0.143,10.793,0.824c1.911,0.357,3.789,0.313,5.708,0.041       c3.576-0.508,8.101-1.727,9.541-5.446c0.461-1.192-1.455-1.708-1.912-0.528c-1.374,3.548-7.662,4.316-10.91,4.221       c-5.043-0.146-9.224-3.155-14.221-0.826c0.485,0.374,0.971,0.747,1.456,1.121c2.152-5.211,4.33-10.693,10.46-11.954       c6.754-1.389,10.101,4.387,13.685,8.989C283.74,241.991,285.134,240.577,284.358,239.581L284.358,239.581z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M344.671,220.499c9.897,5.041,2.025,23.102-13.945,18.249      C337.493,231.382,334.286,214.444,344.671,220.499z"></path></g><g><g><path fill="#5F5371" d="M344.17,221.356c4.441,2.4,4.766,7.668,2.258,11.663c-3.337,5.316-9.752,6.401-15.439,4.772       c0.146,0.553,0.292,1.106,0.437,1.659c3.095-3.523,4.116-8.139,5.297-12.552c0.493-1.843,0.921-4.148,2.188-5.647       C340.399,219.49,342.454,220.397,344.17,221.356c1.115,0.623,2.116-1.091,1.001-1.714c-4.018-2.246-7.391-1.535-9.152,2.86       c-2.06,5.143-2.188,11.212-5.994,15.544c-0.487,0.555-0.313,1.444,0.437,1.659c6.676,1.912,14.237,0.313,17.902-6.058       c2.814-4.89,2.029-11.184-3.194-14.006C344.048,219.035,343.046,220.749,344.17,221.356z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M349.691,250.215c0.973,3.918-0.303,12.015-3.195,15.222c-4.008,4.444-13.455,3.547-17.879,0.397      c4.419-4.731,0.936-9.428,5.002-14.519C337.19,246.844,345.22,246.42,349.691,250.215"></path></g><g><g><path fill="#5F5371" d="M348.735,250.479c1.004,4.615-0.015,12.527-4.239,15.368c-4.318,2.904-11.255,1.904-15.379-0.87       c0.067,0.52,0.134,1.039,0.201,1.559c1.564-1.825,2.429-3.731,2.755-6.117c0.407-2.984,0.286-5.87,2.259-8.371       c3.409-4.322,10.524-4.409,14.659-1.13c0.99,0.785,2.402-0.61,1.402-1.404c-4.1-3.252-10.118-3.867-14.711-1.216       c-2.39,1.38-4.105,3.672-4.847,6.329c-1.038,3.717-0.198,7.332-2.918,10.505c-0.433,0.505-0.357,1.184,0.201,1.559       c4.853,3.265,12.932,4.16,17.842,0.545c4.689-3.452,5.845-11.966,4.688-17.284       C350.376,248.703,348.464,249.231,348.735,250.479L348.735,250.479z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M289.687,239.397c2.952,2.67,6.362,10,5.759,14.22c-0.835,5.847-9.061,10.324-14.414,10.185      c1.014-6.309-4.42-8.232-3.893-14.641C277.601,243.533,283.94,238.757,289.687,239.397"></path></g><g><g><path fill="#5F5371" d="M288.986,240.099c3.338,3.208,6.881,10.122,5.093,14.786c-1.848,4.821-8.117,7.916-13.047,7.924       c0.33,0.331,0.661,0.662,0.991,0.993c0.272-2.165-0.074-4.124-1.003-6.092c-0.963-2.039-2.373-3.877-2.79-6.141       c-1.196-6.492,5.449-11.632,11.457-11.179c1.273,0.096,1.266-1.89,0-1.985c-5.73-0.431-11.888,3.473-13.296,9.211       c-1.519,6.189,4.398,10.231,3.649,16.186c-0.067,0.533,0.508,0.993,0.991,0.993c5.732-0.01,12.695-3.589,14.879-9.139       c2.137-5.429-1.609-13.198-5.523-16.96C289.467,237.81,288.063,239.212,288.986,240.099L288.986,240.099z"></path></g></g></g><g><g><path fill="#A1C083" d="M378.459,242.302c-4.144,13.115,8.678,21.493,20.674,18.835c0.079-4.502-2.711-9.961-5.351-13.744      C391.365,243.93,382.433,239.716,378.459,242.302"></path></g><g><g><path fill="#5F5371" d="M377.503,242.038c-1.774,6.015-0.414,12.232,4.54,16.298c4.823,3.959,11.358,4.987,17.354,3.758       c0.417-0.086,0.734-0.544,0.728-0.957c-0.087-5.734-3.257-13.099-7.882-16.631c-3.625-2.768-9.879-5.577-14.283-3.061       c-1.108,0.633-0.11,2.349,1.001,1.714c3.762-2.149,9.708,0.85,12.628,3.353c3.768,3.229,6.48,9.756,6.554,14.625       c0.243-0.319,0.485-0.638,0.728-0.957c-11.033,2.262-23.072-5.347-19.454-17.614       C379.777,241.338,377.864,240.814,377.503,242.038L377.503,242.038z"></path></g></g></g><g><g><path fill="#A1C083" d="M353.931,241.218c-13.146,3.996-12.794,19.322-3.82,27.724c3.753-2.481,6.671-7.873,8.293-12.192      C359.889,252.796,358.309,243.037,353.931,241.218"></path></g><g><g><path fill="#5F5371" d="M353.667,240.261c-5.88,1.9-10.186,6.368-10.882,12.648c-0.694,6.26,2.181,12.453,6.625,16.735       c0.295,0.284,0.842,0.409,1.201,0.155c4.691-3.316,8.989-10.111,9.305-15.959c0.24-4.45-0.989-11.327-5.485-13.48       c-1.145-0.548-2.152,1.163-1.001,1.714c3.833,1.835,4.724,7.994,4.503,11.766c-0.298,5.089-4.239,11.358-8.323,14.245       c0.4,0.052,0.801,0.103,1.201,0.155c-8.064-7.77-8.833-22.118,3.382-26.065C355.403,241.785,354.886,239.867,353.667,240.261       L353.667,240.261z"></path></g></g></g><g><g><path fill="#A1C083" d="M375.079,240.979c-3.255,2.384-7.458,9.417-7.291,13.735c0.232,5.983,8.058,11.357,13.47,11.778      c-0.364-6.468,5.316-7.838,5.453-14.355C386.833,246.414,380.94,240.935,375.079,240.979"></path></g><g><g><path fill="#5F5371" d="M374.378,240.277c-4.319,3.368-8.844,10.812-7.258,16.473c1.645,5.872,8.347,10.118,14.139,10.734       c0.525,0.056,1.003-0.5,0.991-0.993c-0.08-3.436,1.738-5.491,3.473-8.21c1.435-2.249,2.236-4.827,1.897-7.511       c-0.764-6.055-6.645-10.609-12.541-10.785c-1.276-0.038-1.275,1.947,0,1.985c6.327,0.188,12.493,6.569,10.104,13.058       c-0.733,1.992-2.198,3.564-3.286,5.352c-1.154,1.897-1.681,3.89-1.629,6.11c0.33-0.331,0.661-0.662,0.991-0.993       c-4.986-0.53-11.392-4.602-12.37-9.862c-0.9-4.84,3.258-11.123,6.891-13.957C376.786,240.897,375.374,239.501,374.378,240.277       L374.378,240.277z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M377.653,244.966c-7.516,0.822-14.513-0.645-20.343,4.915c-5.788,5.52-4.697,12.403,0.594,19.13      c1.62-1.486,2.427-3.346,4.446-4.474c2.832-1.582,6.259-1.214,9.016-3.119C375.963,258.24,375.053,249.675,377.653,244.966"></path></g><g><g><path fill="#5F5371" d="M377.653,243.974c-7.49,0.746-15.542-0.332-21.341,5.504c-6.007,6.045-3.952,13.895,0.736,20.035       c0.382,0.5,1.058,0.695,1.557,0.201c1.147-1.135,2.023-2.584,3.257-3.626c1.501-1.267,3.436-1.602,5.287-2.031       c2.582-0.599,5.02-1.456,6.639-3.674c3.162-4.335,2.324-10.256,4.721-14.916c0.583-1.134-1.127-2.139-1.712-1.002       c-2.313,4.496-1.604,10.22-4.406,14.457c-2.015,3.047-5.736,2.912-8.845,4.01c-2.901,1.025-4.253,3.308-6.343,5.377       c0.519,0.067,1.038,0.134,1.557,0.201c-2.114-2.77-4.076-5.947-4.316-9.517c-0.255-3.797,1.762-7.096,4.693-9.363       c5.265-4.072,12.299-3.052,18.516-3.671C378.91,245.834,378.923,243.847,377.653,243.974L377.653,243.974z"></path></g></g></g><g><g><path fill="#A1C083" d="M266.808,243.906c-7.822,3.451-10.72,10.975-6.002,18.881c3.437-5.786,5.772-5.295,13.861-7.01      C285.803,253.417,282.271,237.084,266.808,243.906z"></path></g><g><g><path fill="#5F5371" d="M266.308,243.049c-3.66,1.702-6.84,4.438-8.159,8.363c-1.364,4.058-0.25,8.274,1.801,11.876       c0.375,0.659,1.329,0.628,1.712,0c1.308-2.147,2.766-3.949,5.198-4.799c2.599-0.908,5.406-1.106,8.07-1.755       c3.281-0.8,6.252-2.879,7.04-6.336c0.66-2.896-0.527-5.946-2.973-7.626C275.19,240.155,270.216,241.391,266.308,243.049       c-1.171,0.497-0.162,2.207,1.001,1.714c3.415-1.449,8.476-2.732,11.426,0.373c1.957,2.059,1.833,5.282-0.018,7.366       c-2.648,2.982-7.473,2.775-11.057,3.69c-3.584,0.915-5.805,2.969-7.709,6.095c0.571,0,1.141,0,1.712,0       c-1.795-3.153-2.822-6.79-1.602-10.347c1.178-3.434,4.062-5.695,7.248-7.177C268.464,244.226,267.459,242.514,266.308,243.049z       "></path></g></g></g><g><path fill="#A1C083" d="M341.025,239.498c5.339,4.289,6.075,17.767-14.406,12.031     C332.073,248.199,334.518,232.746,341.025,239.498z"></path><path fill="#5F5371" d="M335.341,253.921c-2.373,0-5.321-0.409-8.989-1.436c-0.379-0.107-0.661-0.428-0.714-0.82     c-0.054-0.392,0.129-0.777,0.466-0.983c1.809-1.105,3.361-3.916,4.861-6.635c1.941-3.517,3.774-6.84,6.494-7.2     c1.415-0.185,2.799,0.44,4.237,1.916c2.828,2.31,4.673,7.1,2.739,10.871C343.493,251.47,341.147,253.921,335.341,253.921z      M328.735,251.051c7.254,1.714,12.287,0.893,13.936-2.323c1.442-2.811-0.007-6.642-2.265-8.456     c-0.033-0.026-0.064-0.055-0.093-0.085c-0.974-1.01-1.846-1.469-2.594-1.372c-1.728,0.229-3.401,3.261-5.019,6.193     C331.482,247.214,330.233,249.475,328.735,251.051z"></path></g><g><path fill="#A1C083" d="M274.326,242.507c6.663,1.092,13.822,12.314-6.55,17.331     C270.849,254.329,265.466,239.865,274.326,242.507z"></path><path fill="#5F5371" d="M267.777,260.83c-0.305,0-0.598-0.142-0.788-0.391c-0.24-0.314-0.27-0.741-0.077-1.086     c1.017-1.824,0.988-4.991,0.961-8.052c-0.036-3.969-0.07-7.717,2.098-9.351c1.125-0.849,2.623-0.984,4.579-0.414     c3.554,0.613,7.463,3.837,7.628,8.022c0.113,2.868-1.577,8.142-14.163,11.242C267.934,260.82,267.855,260.83,267.777,260.83z      M272.422,243.182c-0.524,0-0.945,0.118-1.259,0.356c-1.369,1.031-1.338,4.445-1.308,7.746c0.022,2.477,0.046,5.018-0.473,7.097     c7.039-2.05,10.954-5.19,10.815-8.743c-0.121-3.062-3.275-5.699-6.03-6.151c-0.042-0.007-0.083-0.016-0.123-0.029     C273.425,243.274,272.884,243.182,272.422,243.182z"></path></g><g><g><path fill="#CCDBB0" d="M358.03,241.642c-6.476-0.421-12.532-1.987-16.502,4.147c-4.12,6.366-1.359,11.485,1.562,17.623      c1.22-4.928,6.356-6.145,9.596-9.255c2.495-2.395,6.851-9.185,4.757-12.751"></path></g><g><g><path fill="#5F5371" d="M358.03,240.649c-5.981-0.425-12.604-1.65-16.753,3.788c-4.872,6.386-2.12,13.03,0.957,19.476       c0.383,0.802,1.587,0.53,1.812-0.237c1.508-5.152,7.883-6.658,10.995-10.72c2.422-3.162,5.254-8.047,3.258-12.05       c-0.57-1.143-2.281-0.139-1.712,1.002c2.013,4.037-2.767,10.253-5.818,12.574c-3.428,2.608-7.326,4.192-8.635,8.667       c0.604-0.079,1.208-0.158,1.812-0.237c-2.846-5.961-5.727-12.606-0.319-18.192c3.706-3.828,9.691-2.42,14.403-2.085       C359.303,242.725,359.297,240.739,358.03,240.649L358.03,240.649z"></path></g></g></g><g><g><path fill="#A1C083" d="M279.521,242.215c-0.648-2.062,0.794-4.192,2.944-4.385c5.302-0.475,10.127-0.828,13.461,4.323      c4.064,6.28,1.341,11.33-1.541,17.385c-1.203-4.862-4.439-8.218-9.088-10.297C283.202,248.305,280.513,245.372,279.521,242.215z      "></path></g><g><g><path fill="#5F5371" d="M280.477,241.951c-0.797-3.702,4.276-3.432,6.668-3.376c2.644,0.062,5.118,0.774,6.939,2.796       c5.012,5.565,2.214,11.867-0.555,17.667c0.604,0.079,1.208,0.158,1.812,0.237c-0.944-3.48-2.841-6.446-5.719-8.635       c-1.358-1.033-2.867-1.647-4.318-2.506C283.018,246.781,281.358,244.422,280.477,241.951c-0.426-1.194-2.342-0.68-1.912,0.528       c1.255,3.519,3.56,6.262,6.886,7.926c3.972,1.987,6.803,5.064,7.978,9.398c0.21,0.775,1.434,1.029,1.812,0.237       c1.789-3.747,3.971-7.769,3.71-12.058c-0.232-3.812-2.367-7.856-5.688-9.849c-4.061-2.437-16.329-3.227-14.698,4.347       C278.834,243.727,280.745,243.199,280.477,241.951z"></path></g></g></g><g><path fill="#A1C083" d="M365.155,238.006c-12.414-8.524-9.161,7.278-12.581,13.175     C366.889,252.551,372.176,242.613,365.155,238.006z"></path><path fill="#5F5371" d="M355.202,252.302c-0.869,0-1.777-0.043-2.723-0.134c-0.337-0.032-0.633-0.234-0.788-0.534     c-0.154-0.3-0.145-0.659,0.024-0.952c0.923-1.593,1.342-4.156,1.745-6.636c0.637-3.912,1.296-7.957,4.117-9.164     c2.007-0.858,4.592-0.128,8.129,2.299c2.997,1.971,4.202,5.064,3.146,8.076C367.567,248.927,362.9,252.302,355.202,252.302z      M354.079,250.291c7.376,0.332,11.833-2.637,12.905-5.692c0.751-2.141-0.136-4.297-2.372-5.764     c-0.006-0.003-0.012-0.007-0.017-0.011c-2.847-1.955-4.947-2.668-6.237-2.117c-1.819,0.779-2.389,4.276-2.94,7.659     C355.081,246.433,354.736,248.553,354.079,250.291z"></path></g><g><g><path fill="#CCDBB0" d="M285.027,233.824c-0.656-1.555-2.133-2.613-3.817-2.688c-2.979-0.132-7.648,0.145-9.686,2.86      c-3.287,4.379,2.648,12.849,3.663,17.599c1.456-5.404,5.89-5.56,8.522-9.351C285.567,239.566,286.453,237.205,285.027,233.824z"></path></g><g><g><path fill="#5F5371" d="M285.883,233.323c-1.64-3.159-4.728-3.414-7.949-3.108c-2.884,0.274-6.19,1.171-7.663,3.925       c-2.95,5.515,2.706,12.482,3.96,17.719c0.236,0.985,1.635,0.903,1.912,0c1.248-4.065,4.888-5.077,7.508-7.963       c2.688-2.961,3.75-6.552,2.332-10.336c-0.444-1.185-2.361-0.672-1.912,0.528c1.734,4.627-1.037,8.167-4.67,10.735       c-2.466,1.743-4.263,3.555-5.17,6.508c0.637,0,1.274,0,1.912,0c-1.066-4.454-3.979-8.372-4.53-12.97       c-0.36-3.007,1.138-4.921,4.039-5.749c2.765-0.789,6.986-1.241,8.519,1.712C284.76,235.459,286.471,234.456,285.883,233.323z"></path></g></g></g><g><g><path fill="#A1C083" d="M364.498,231.675c-0.254-1.692-1.44-3.103-3.075-3.599c-2.892-0.879-7.547-1.78-10.23,0.374      c-4.326,3.474-0.621,13.285-0.815,18.205c2.785-4.941,8.712-1.267,12.247-4.329      C365.122,240.163,365.051,235.354,364.498,231.675z"></path></g><g><g><path fill="#5F5371" d="M365.454,231.411c-0.776-3.486-3.679-4.502-6.881-5.029c-2.991-0.492-6.656-0.454-8.781,2.065       c-4.032,4.779-0.319,12.749-0.405,18.208c-0.016,1.016,1.335,1.309,1.847,0.501c2.632-4.149,8.386-1.078,11.891-3.973       C366.434,240.449,365.983,235.201,365.454,231.411c-0.176-1.26-2.086-0.724-1.912,0.528c0.331,2.37,0.545,4.998-0.191,7.317       c-0.845,2.664-2.86,3.374-5.421,3.49c-3.423,0.155-6.397,0.237-8.408,3.408c0.616,0.167,1.231,0.334,1.847,0.501       c0.072-4.562-1.711-9.036-1.237-13.614c0.325-3.133,2.197-4.846,5.402-4.93c2.916-0.076,7.267,0.497,8.008,3.827       C363.82,233.185,365.732,232.658,365.454,231.411z"></path></g></g></g><g><g><path fill="#A1C083" d="M372.677,233.038c6.271-1.676,11.906-4.392,16.993,0.85c5.279,5.441,3.567,11,1.896,17.59      c-2.155-4.596-7.429-4.788-11.213-7.207c-2.913-1.862-8.506-7.673-7.146-11.579"></path></g><g><g><path fill="#5F5371" d="M372.94,233.995c5.569-1.527,11.73-4.17,16.318,0.909c4.37,4.838,2.801,10.625,1.351,16.31       c0.604-0.079,1.208-0.158,1.812-0.237c-2.215-4.249-6.6-4.917-10.503-6.953c-3.368-1.757-8.92-6.807-7.755-11.068       c0.337-1.234-1.575-1.76-1.912-0.528c-1.192,4.362,2.77,8.792,5.836,11.372c3.853,3.242,10.157,3.448,12.622,8.179       c0.396,0.76,1.606,0.569,1.812-0.237c1.638-6.426,3.099-12.866-1.861-18.242c-5.217-5.654-11.849-3.174-18.246-1.42       C371.184,232.418,371.706,234.333,372.94,233.995L372.94,233.995z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M361.747,239.631c-4.841-7.614,4.401-16.262,12.207-11.749c1.746,1.01,3.383,2.344,4.877,4.191      c5.465,6.756,3.627,13.583-2.569,19.442c-1.536-1.83-10.569-7.874-13.246-10.352      C362.521,240.703,362.102,240.189,361.747,239.631z"></path></g><g><g><path fill="#5F5371" d="M362.603,239.13c-4.127-7.032,4.135-14.064,10.851-10.391c3.775,2.065,7.132,6.181,7.581,10.553       c0.472,4.587-2.367,8.49-5.473,11.521c0.467,0,0.935,0,1.402,0c-1.79-1.99-4.256-3.512-6.396-5.089       C367.915,243.771,364.51,241.88,362.603,239.13c-0.723-1.042-2.442-0.051-1.712,1.002c3.625,5.228,10.465,7.409,14.671,12.085       c0.362,0.402,1.034,0.359,1.402,0c3.741-3.651,6.853-8.444,5.928-13.905c-0.862-5.086-5.094-10.104-9.884-11.979       c-8.411-3.293-16.747,5.909-12.117,13.799C361.537,241.232,363.251,240.235,362.603,239.13z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M369.23,228.403c-0.151-1.759,0.776-3.495,2.519-4.511c2.776-1.619,6.356-2.335,9.845-0.927      c4.985,2.013,3.426,10.78,4.66,14.779c-3.782-3.515-10.504-0.598-14.625-2.426C368.785,234.057,369.494,231.492,369.23,228.403z      "></path></g><g><g><path fill="#5F5371" d="M370.221,228.403c-0.038-3.825,4.707-5.32,7.886-5.19c2.949,0.12,4.958,1.376,5.782,4.196       c1.008,3.448,0.453,7.146,1.408,10.6c0.552-0.322,1.105-0.644,1.657-0.966c-2.691-2.234-5.941-2.199-9.278-2.093       c-1.813,0.058-4.032,0.305-5.687-0.589C369.837,233.198,370.358,230.501,370.221,228.403c-0.083-1.268-2.066-1.278-1.983,0       c0.229,3.512-0.093,6.988,3.968,8.167c4.27,1.24,9.65-1.192,13.346,1.876c0.725,0.602,1.939,0.055,1.657-0.966       c-1.263-4.568,0.396-11.258-3.844-14.609c-4.65-3.675-15.195-1.29-15.127,5.531       C368.251,229.679,370.233,229.682,370.221,228.403z"></path></g></g></g><g><g><path fill="#CCDBB0" d="M281.699,236.354c-0.678-1.953-0.322-4.135,1.03-5.698c2.153-2.49,5.028-3.267,8.707-2.204      c5.507,1.59,6.932,10.184,9.322,14.411c-4.671-3.074-7.985,0.468-12.467-0.618C285.199,241.495,282.889,239.782,281.699,236.354      z"></path></g><g><g><path fill="#5F5371" d="M282.655,236.09c-1.026-3.696,1.769-6.927,5.483-7.097c2.796-0.128,5.078,1.057,6.667,3.303       c2.364,3.343,3.166,7.497,5.098,11.067c0.452-0.453,0.904-0.905,1.356-1.358c-2.942-1.738-5.487-1.43-8.714-0.824       C288.209,241.996,284.292,240.355,282.655,236.09c-0.453-1.18-2.371-0.668-1.912,0.528c1.255,3.268,3.524,5.59,6.96,6.496       c4.33,1.142,8.449-1.821,12.555,0.605c0.875,0.517,1.82-0.501,1.356-1.358c-2.595-4.796-3.495-12.241-9.157-14.592       c-6.003-2.492-13.666,1.816-11.714,8.848C281.084,237.846,282.998,237.324,282.655,236.09z"></path></g></g></g><g><path fill="#CCDBB0" d="M367.386,219.814c-4.226-0.593-5.921,1.975-6.433,5.627c-0.535,3.815,3.704,5.381,4.11,10.692     C373.254,232.028,376.247,221.254,367.386,219.814z"></path><path fill="#5F5371" d="M365.063,237.126c-0.168,0-0.337-0.043-0.489-0.129c-0.287-0.163-0.474-0.458-0.5-0.788     c-0.184-2.407-1.238-3.955-2.257-5.451c-1.064-1.562-2.164-3.178-1.845-5.454c0.855-6.104,4.576-6.889,7.552-6.472     c0.007,0.001,0.015,0.002,0.021,0.003c3.45,0.56,5.686,2.569,6.134,5.508c0.682,4.47-2.908,10.04-8.173,12.678     C365.367,237.091,365.215,237.126,365.063,237.126z M366.23,220.722c-2.49,0-3.829,1.536-4.295,4.857     c-0.213,1.516,0.552,2.639,1.52,4.06c0.866,1.272,1.906,2.798,2.376,4.924c4.203-2.645,6.328-7.038,5.888-9.92     c-0.318-2.089-1.868-3.419-4.482-3.846C366.883,220.747,366.548,220.722,366.23,220.722z"></path></g><g><path fill="#CCDBB0" d="M350.292,237.688c-1.327-4.339-4.895-4.805-6.705-3.755c-3.566,2.069-6.353,7.944-5.325,10.759     C341.832,241.312,351.581,245.824,350.292,237.688z"></path><path fill="#5F5371" d="M338.262,245.685c-0.076,0-0.152-0.009-0.227-0.026c-0.324-0.077-0.59-0.312-0.704-0.626     c-1.212-3.323,1.856-9.694,5.76-11.959c1.226-0.71,2.887-0.8,4.33-0.233c1.778,0.7,3.135,2.318,3.82,4.557     c0.014,0.045,0.024,0.089,0.031,0.136c0.318,2.003,0.051,3.5-0.813,4.577c-1.374,1.713-3.869,1.863-6.282,2.008     c-2.029,0.122-4.127,0.248-5.232,1.295C338.757,245.59,338.513,245.685,338.262,245.685z M345.469,234.454     c-0.572,0-1.064,0.151-1.385,0.337c-2.731,1.585-4.879,5.623-5.04,8.217c1.474-0.659,3.266-0.767,5.014-0.872     c2.073-0.124,4.032-0.242,4.856-1.27c0.479-0.597,0.618-1.591,0.411-2.953c-0.65-2.064-1.786-2.892-2.629-3.225     C346.268,234.521,345.85,234.454,345.469,234.454z"></path></g><g><path fill="#CCDBB0" d="M287.259,227.3c-2.061-3.972-5.607-3.786-7.175-2.444c-3.091,2.645-4.746,8.844-3.247,11.391     C279.698,232.328,289.961,234.962,287.259,227.3z"></path><path fill="#5F5371" d="M276.837,237.239c-0.016,0-0.033,0-0.049-0.001c-0.333-0.016-0.635-0.2-0.804-0.488     c-1.772-3.012,0.069-9.75,3.457-12.649c1.066-0.913,2.659-1.296,4.171-1.004c1.854,0.362,3.462,1.691,4.527,3.744     c0.021,0.041,0.04,0.083,0.055,0.127c0.666,1.89,0.675,3.394,0.026,4.597c-1.03,1.913-3.427,2.506-5.745,3.079     c-1.944,0.481-3.954,0.978-4.837,2.187C277.45,237.089,277.153,237.239,276.837,237.239z M282.592,224.984     c-0.823,0-1.495,0.31-1.864,0.627c-2.358,2.018-3.72,6.295-3.423,8.84c1.312-0.896,3.024-1.319,4.695-1.733     c1.986-0.49,3.862-0.955,4.476-2.094c0.356-0.662,0.314-1.647-0.129-2.928c-0.995-1.88-2.241-2.479-3.115-2.649     C283.011,225.003,282.797,224.984,282.592,224.984z"></path></g><g><g><path fill="#A1C083" d="M357.817,220.976c-3.901-1.847-7.694-0.367-9.662,2.128c-2.882,3.653-4.054,8.506,0.657,13.927      c2.733-7.963,7.249-5.728,10.354-7.502C363.161,227.248,361.559,222.748,357.817,220.976z"></path></g><g><g><path fill="#5F5371" d="M358.081,220.019c-4.775-1.999-9.549-0.044-12.006,4.417c-2.579,4.681-1.205,9.362,2.037,13.296       c0.517,0.627,1.425,0.192,1.657-0.438c1.04-2.831,2.502-5.011,5.542-5.713c1.724-0.398,3.454-0.505,4.941-1.574       c4.103-2.949,1.785-7.929-1.934-9.889c-1.128-0.595-2.131,1.118-1.001,1.714c2.403,1.267,4.688,4.387,1.789,6.522       c-1.273,0.938-2.833,0.966-4.322,1.312c-3.747,0.871-5.648,3.62-6.927,7.099c0.552-0.146,1.104-0.292,1.657-0.438       c-2.667-3.236-3.84-7.041-1.727-10.891c2.059-3.75,5.784-5.173,9.768-3.505C358.729,222.425,359.242,220.505,358.081,220.019z"></path></g></g></g><g><path fill="#CCDBB0" d="M315.123,229.865c0.733-2.996,5.244-4.497,7.944,4.055C320.425,232.165,314.246,233.718,315.123,229.865z     "></path><path fill="#CCDBB0" d="M323.068,234.416c-0.095,0-0.191-0.027-0.274-0.082c-0.891-0.591-2.308-0.777-3.678-0.958     c-1.769-0.232-3.44-0.451-4.195-1.537c-0.378-0.543-0.472-1.245-0.281-2.084c0-0.003,0.001-0.005,0.002-0.008     c0.388-1.587,1.629-2.686,3.088-2.734c1.058-0.039,3.851,0.551,5.81,6.758c0.064,0.201-0.007,0.419-0.174,0.546     C323.278,234.382,323.174,234.416,323.068,234.416z M315.606,229.978c-0.127,0.562-0.085,0.985,0.13,1.293     c0.504,0.726,2.033,0.927,3.51,1.12c1.021,0.134,2.067,0.271,2.972,0.579c-1.197-3.185-2.831-5.06-4.454-4.966     C316.755,228.038,315.888,228.831,315.606,229.978z"></path></g><g><path fill="#CCDBB0" d="M368.779,209.883c-1.599-2.637,0.529-6.893,8.479-2.762C374.152,207.754,370.881,213.229,368.779,209.883     z"></path><path fill="#CCDBB0" d="M370.41,211.455c-0.127,0-0.253-0.011-0.378-0.033c-0.651-0.116-1.214-0.545-1.672-1.274     c-0.002-0.003-0.003-0.005-0.005-0.007c-0.846-1.397-0.745-3.053,0.252-4.12c0.748-0.801,3.11-2.337,8.881,0.661     c0.186,0.097,0.291,0.3,0.262,0.509s-0.186,0.376-0.392,0.418c-1.047,0.213-2.18,1.085-3.275,1.928     C372.805,210.52,371.591,211.455,370.41,211.455z M369.2,209.623c0.307,0.487,0.636,0.756,1.006,0.822     c0.869,0.162,2.091-0.785,3.273-1.695c0.816-0.628,1.651-1.272,2.508-1.695c-3.096-1.402-5.542-1.547-6.656-0.355     C368.641,207.437,368.589,208.611,369.2,209.623z"></path></g><g><path fill="#CCDBB0" d="M240.962,245.123c1.49,1.734,0.452,5.108-5.868,3.055C237.291,247.336,239.017,242.932,240.962,245.123z"></path><path fill="#5F5371" d="M238.52,249.313c-0.923,0-2.096-0.181-3.579-0.663c-0.199-0.065-0.337-0.249-0.343-0.459     c-0.005-0.21,0.122-0.401,0.318-0.476c0.712-0.273,1.424-1.038,2.113-1.779c0.916-0.984,1.781-1.914,2.81-1.914     c0.007,0,0.013,0,0.019,0c0.529,0.006,1.024,0.266,1.473,0.772c0.001,0.002,0.003,0.004,0.005,0.006     c0.828,0.962,0.958,2.249,0.327,3.2C241.347,248.478,240.507,249.313,238.52,249.313z M236.321,248.014     c2.254,0.558,3.905,0.362,4.519-0.565c0.377-0.566,0.273-1.388-0.251-2c-0.258-0.29-0.5-0.432-0.741-0.435     c-0.002,0-0.005,0-0.008,0c-0.597,0-1.353,0.812-2.085,1.598C237.295,247.108,236.824,247.613,236.321,248.014z"></path></g><g><path fill="#CCDBB0" d="M316.77,228.879c1.465,2.713-0.872,6.858-8.607,2.334C311.298,230.737,314.837,225.433,316.77,228.879z"></path><path fill="#5F5371" d="M313.978,233.713c-1.4,0-3.365-0.491-6.065-2.071c-0.182-0.106-0.277-0.315-0.237-0.521     c0.04-0.206,0.205-0.366,0.412-0.397c1.057-0.161,2.231-0.975,3.367-1.762c1.467-1.018,2.86-1.971,4.14-1.681     c0.645,0.149,1.185,0.605,1.606,1.356c0.002,0.003,0.003,0.005,0.004,0.008c0.776,1.436,0.592,3.085-0.456,4.101     C316.341,233.14,315.488,233.713,313.978,233.713z M309.431,231.344c3.022,1.559,5.46,1.822,6.63,0.687     c0.725-0.702,0.835-1.872,0.276-2.913c-0.283-0.502-0.597-0.787-0.963-0.871c-0.86-0.199-2.128,0.678-3.353,1.53     C311.173,230.363,310.308,230.964,309.431,231.344z"></path></g></g><g><g><path fill="#CCDBB0" d="M316.559,242.377c-0.274,0-0.496-0.222-0.496-0.496c0-0.721-0.587-1.309-1.307-1.309     c-0.721,0-1.308,0.587-1.308,1.309c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496     c0-0.721-0.587-1.309-1.307-1.309s-1.307,0.587-1.307,1.309c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496     c0-0.721-0.587-1.309-1.307-1.309c-0.72,0-1.307,0.587-1.307,1.309c0,0.274-0.222,0.496-0.496,0.496     c-0.274,0-0.496-0.222-0.496-0.496c0-1.269,1.031-2.301,2.298-2.301c0.73,0,1.381,0.342,1.802,0.875     c0.421-0.533,1.073-0.875,1.802-0.875s1.381,0.342,1.802,0.875c0.421-0.533,1.074-0.875,1.803-0.875     c1.267,0,2.298,1.032,2.298,2.301C317.055,242.155,316.833,242.377,316.559,242.377z"></path></g></g><g><g><path fill="#CCDBB0" d="M236.219,256.309c-0.274,0-0.496-0.222-0.496-0.496c0-0.721-0.587-1.309-1.307-1.309     c-0.721,0-1.307,0.587-1.307,1.309c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496     c0-0.721-0.586-1.309-1.307-1.309s-1.307,0.587-1.307,1.309c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496     c0-0.721-0.586-1.309-1.307-1.309s-1.307,0.587-1.307,1.309c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496     c0-1.269,1.031-2.301,2.299-2.301c0.73,0,1.381,0.342,1.802,0.875c0.422-0.533,1.073-0.875,1.803-0.875s1.381,0.342,1.802,0.875     c0.422-0.533,1.073-0.875,1.803-0.875c1.267,0,2.298,1.032,2.298,2.301C236.715,256.087,236.493,256.309,236.219,256.309z"></path></g></g><g><path fill="#5F5371" d="M370.456,215.414c-0.27,0-0.608-0.094-0.995-0.398c-0.64-0.501-0.81-1.175-0.455-1.802    c0.178-0.316,0.491-0.597,0.893-0.822c-0.18-0.133-0.395-0.247-0.649-0.334c-0.21-0.072-0.536-0.118-0.892-0.121    c0.258,0.664,0.131,1.16-0.043,1.477c-0.369,0.676-1.251,0.987-1.96,0.696c-0.499-0.203-0.984-0.786-0.711-1.763    c0.119-0.428,0.424-0.783,0.881-1.024c0.053-0.028,0.107-0.054,0.164-0.079c-0.327-0.334-0.765-0.706-1.336-1.11    c-0.224-0.158-0.277-0.467-0.119-0.691c0.157-0.226,0.467-0.279,0.69-0.119c0.863,0.609,1.455,1.159,1.852,1.651    c0.689-0.073,1.382,0.003,1.795,0.144c0.59,0.203,1.037,0.515,1.364,0.874c0.942-0.232,2.074-0.213,3.133,0.196    c0.256,0.099,0.382,0.386,0.285,0.642s-0.382,0.383-0.641,0.285c-0.784-0.303-1.567-0.336-2.221-0.226    c0.104,0.265,0.163,0.529,0.183,0.776c0.06,0.733-0.206,1.352-0.694,1.616C370.862,215.346,370.683,215.414,370.456,215.414z     M370.539,213.178c-0.332,0.156-0.569,0.345-0.672,0.525c-0.05,0.09-0.145,0.258,0.203,0.531c0.216,0.168,0.375,0.209,0.441,0.174    c0.091-0.048,0.206-0.287,0.175-0.66C370.672,213.568,370.625,213.372,370.539,213.178z M367.326,212.066    c-0.122,0.037-0.236,0.081-0.338,0.135c-0.216,0.113-0.343,0.248-0.388,0.413c-0.087,0.312-0.044,0.506,0.13,0.577    c0.216,0.088,0.58-0.001,0.717-0.253C367.55,212.747,367.534,212.451,367.326,212.066z"></path></g><g><g><path fill="#CCDBB0" d="M253.023,252.709c-0.274,0-0.496-0.222-0.496-0.496c0-0.721-0.587-1.309-1.307-1.309     c-0.72,0-1.307,0.587-1.307,1.309c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496     c0-0.721-0.587-1.309-1.307-1.309c-0.721,0-1.308,0.587-1.308,1.309c0,0.274-0.222,0.496-0.496,0.496     c-0.274,0-0.496-0.222-0.496-0.496c0-1.269,1.031-2.301,2.299-2.301c0.73,0,1.381,0.342,1.802,0.875     c0.421-0.533,1.073-0.875,1.802-0.875c1.267,0,2.298,1.032,2.298,2.301C253.519,252.487,253.297,252.709,253.023,252.709z"></path></g></g><g><g><path fill="#CCDBB0" d="M320.787,251.121c-0.274,0-0.496-0.222-0.496-0.496c0-0.721-0.587-1.309-1.307-1.309     c-0.72,0-1.307,0.587-1.307,1.309c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-0.721-0.587-1.309-1.307-1.309     c-0.721,0-1.308,0.587-1.308,1.309c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496     c0-1.269,1.031-2.301,2.299-2.301c0.73,0,1.381,0.342,1.802,0.875c0.421-0.533,1.073-0.875,1.802-0.875     c1.267,0,2.298,1.032,2.298,2.301C321.283,250.899,321.061,251.121,320.787,251.121z"></path></g></g><g><g><path fill="#CCDBB0" d="M359.632,214.747c-0.274,0-0.496-0.222-0.496-0.496c0-0.721-0.587-1.309-1.307-1.309     s-1.307,0.587-1.307,1.309c0,0.274-0.222,0.496-0.496,0.496c-0.274,0-0.496-0.222-0.496-0.496c0-0.721-0.587-1.309-1.307-1.309     c-0.721,0-1.308,0.587-1.308,1.309c0,0.274-0.222,0.496-0.496,0.496s-0.496-0.222-0.496-0.496c0-1.269,1.031-2.301,2.299-2.301     c0.73,0,1.381,0.342,1.802,0.875c0.421-0.533,1.073-0.875,1.802-0.875c1.267,0,2.298,1.032,2.298,2.301     C360.128,214.525,359.906,214.747,359.632,214.747z"></path></g></g></g></svg>
                        </div>
                    </div>
                    <div class="empty-displayTmpl-btn">
                        <a class="btn btn-primary btn-lg" href="{{ route('orders.create') }}">{{ trans('plugins/ecommerce::order.create_new_order') }}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop
